;2D rotation and Scaling (C) Earwax

.model small
.stack 100h
jumps

GLOBAL  ROTATE2D:PROC

.data

plane   db 0001b,0010b,0100b,1000b

alpha   dw 0
x       dw ?
y       dw ?
x1      dw ?
y1      dw ?

centerx dw 160
centery dw 100

scale   dw 20
zoom    label word
;include zoom.inc
z_ofs   dw 0

sintbl  dw         0 ,   1 ,   2 ,   3 ,   4 ,   6 ,   7 ,   8 ,   9 , 10
        dw        11 ,  12 ,  13 ,  15 ,  16 ,  17 ,  18 ,  19 ,  20 , 21
        dw        22 ,  23 ,  24 ,  26 ,  27 ,  28 ,  29 ,  30 ,  31 , 32
        dw        33 ,  34 ,  35 ,  36 ,  37 ,  39 ,  40 ,  41 ,  42 , 43
        dw        44 ,  45 ,  46 ,  47 ,  48 ,  49 ,  50 ,  51 ,  52 , 53
        dw        54 ,  55 ,  56 ,  57 ,  58 ,  59 ,  60 ,  61 ,  62 , 63
        dw        64 ,  65 ,  66 ,  67 ,  68 ,  69 ,  70 ,  71 ,  72 , 73
        dw        74 ,  74 ,  75 ,  76 ,  77 ,  78 ,  79 ,  80 ,  81 , 82
        dw        82 ,  83 ,  84 ,  85 ,  86 ,  87 ,  87 ,  88 ,  89 , 90
        dw        91 ,  91 ,  92 ,  93 ,  94 ,  95 ,  95 ,  96 ,  97 , 97
        dw        98 ,  99 , 100 , 100 , 101 , 102 , 102 , 103 , 104 ,104
        dw       105 , 106 , 106 , 107 , 108 , 108 , 109 , 109 , 110 ,110
        dw       111 , 112 , 112 , 113 , 113 , 114 , 114 , 115 , 115 ,116
        dw       116 , 117 , 117 , 118 , 118 , 118 , 119 , 119 , 120 ,120
        dw       120 , 121 , 121 , 122 , 122 , 122 , 123 , 123 , 123 ,124
        dw       124 , 124 , 124 , 125 , 125 , 125 , 125 , 126 , 126 ,126
        dw       126 , 126 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,128
        dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128
costbl  dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128
        dw       128 , 128 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,126
        dw       126 , 126 , 126 , 126 , 125 , 125 , 125 , 125 , 124 ,124
        dw       124 , 124 , 123 , 123 , 123 , 122 , 122 , 122 , 121 ,121
        dw       120 , 120 , 120 , 119 , 119 , 118 , 118 , 118 , 117 ,117
        dw       116 , 116 , 115 , 115 , 114 , 114 , 113 , 113 , 112 ,112
        dw       111 , 110 , 110 , 109 , 109 , 108 , 108 , 107 , 106 ,106
        dw       105 , 104 , 104 , 103 , 102 , 102 , 101 , 100 , 100 , 99
        dw        98 ,  97 ,  97 ,  96 ,  95 ,  95 ,  94 ,  93 ,  92 , 91
        dw        91 ,  90 ,  89 ,  88 ,  87 ,  87 ,  86 ,  85 ,  84 , 83
        dw        82 ,  82 ,  81 ,  80 ,  79 ,  78 ,  77 ,  76 ,  75 , 74
        dw        74 ,  73 ,  72 ,  71 ,  70 ,  69 ,  68 ,  67 ,  66 , 65
        dw        64 ,  63 ,  62 ,  61 ,  60 ,  59 ,  58 ,  57 ,  56 , 55
        dw        54 ,  53 ,  52 ,  51 ,  50 ,  49 ,  48 ,  47 ,  46 , 45
        dw        44 ,  43 ,  42 ,  41 ,  40 ,  39 ,  37 ,  36 ,  35 , 34
        dw        33 ,  32 ,  31 ,  30 ,  29 ,  28 ,  27 ,  26 ,  24 , 23
        dw        22 ,  21 ,  20 ,  19 ,  18 ,  17 ,  16 ,  15 ,  13 , 12
        dw        11 ,  10 ,   9 ,   8 ,   7 ,   6 ,   4 ,   3 ,   2 ,  1
        dw         0 ,  -1 ,  -2 ,  -3 ,  -4 ,  -6 ,  -7 ,  -8 ,  -9 ,-10
        dw       -11 , -12 , -13 , -15 , -16 , -17 , -18 , -19 , -20 ,-21
        dw       -22 , -23 , -24 , -26 , -27 , -28 , -29 , -30 , -31 ,-32
        dw       -33 , -34 , -35 , -36 , -37 , -39 , -40 , -41 , -42 ,-43
        dw       -44 , -45 , -46 , -47 , -48 , -49 , -50 , -51 , -52 ,-53
        dw       -54 , -55 , -56 , -57 , -58 , -59 , -60 , -61 , -62 ,-63
        dw       -64 , -65 , -66 , -67 , -68 , -69 , -70 , -71 , -72 ,-73
        dw       -74 , -74 , -75 , -76 , -77 , -78 , -79 , -80 , -81 ,-82
        dw       -82 , -83 , -84 , -85 , -86 , -87 , -87 , -88 , -89 ,-90
        dw       -91 , -91 , -92 , -93 , -94 , -95 , -95 , -96 , -97 ,-97
        dw       -98 , -99 ,-100 ,-100 ,-101 ,-102 ,-102 ,-103 ,-104 ,-104
        dw      -105 ,-106 ,-106 ,-107 ,-108 ,-108 ,-109 ,-109 ,-110 ,-110
        dw      -111 ,-112 ,-112 ,-113 ,-113 ,-114 ,-114 ,-115 ,-115 ,-116
        dw      -116 ,-117 ,-117 ,-118 ,-118 ,-118 ,-119 ,-119 ,-120 ,-120
        dw      -120 ,-121 ,-121 ,-122 ,-122 ,-122 ,-123 ,-123 ,-123 ,-124
        dw      -124 ,-124 ,-124 ,-125 ,-125 ,-125 ,-125 ,-126 ,-126 ,-126
        dw      -126 ,-126 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-128
        dw      -128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128
        dw      -128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128
        dw      -128 ,-128 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-126
        dw      -126 ,-126 ,-126 ,-126 ,-125 ,-125 ,-125 ,-125 ,-124 ,-124
        dw      -124 ,-124 ,-123 ,-123 ,-123 ,-122 ,-122 ,-122 ,-121 ,-121
        dw      -120 ,-120 ,-120 ,-119 ,-119 ,-118 ,-118 ,-118 ,-117 ,-117
        dw      -116 ,-116 ,-115 ,-115 ,-114 ,-114 ,-113 ,-113 ,-112 ,-112
        dw      -111 ,-110 ,-110 ,-109 ,-109 ,-108 ,-108 ,-107 ,-106 ,-106
        dw      -105 ,-104 ,-104 ,-103 ,-102 ,-102 ,-101 ,-100 ,-100 ,-99
        dw       -98 , -97 , -97 , -96 , -95 , -95 , -94 , -93 , -92 ,-91
        dw       -91 , -90 , -89 , -88 , -87 , -87 , -86 , -85 , -84 ,-83
        dw       -82 , -82 , -81 , -80 , -79 , -78 , -77 , -76 , -75 ,-74
        dw       -74 , -73 , -72 , -71 , -70 , -69 , -68 , -67 , -66 ,-65
        dw       -64 , -63 , -62 , -61 , -60 , -59 , -58 , -57 , -56 ,-55
        dw       -54 , -53 , -52 , -51 , -50 , -49 , -48 , -47 , -46 ,-45
        dw       -44 , -43 , -42 , -41 , -40 , -39 , -37 , -36 , -35 ,-34
        dw       -33 , -32 , -31 , -30 , -29 , -28 , -27 , -26 , -24 ,-23
        dw       -22 , -21 , -20 , -19 , -18 , -17 , -16 , -15 , -13 ,-12
        dw       -11 , -10 ,  -9 ,  -8 ,  -7 ,  -6 ,  -4 ,  -3 ,  -2 , -1
        dw        0 ,   1 ,   2 ,   3 ,   4 ,   6 ,   7 ,   8 ,   9 , 10
        dw        11 ,  12 ,  13 ,  15 ,  16 ,  17 ,  18 ,  19 ,  20 , 21
        dw        22 ,  23 ,  24 ,  26 ,  27 ,  28 ,  29 ,  30 ,  31 , 32
        dw        33 ,  34 ,  35 ,  36 ,  37 ,  39 ,  40 ,  41 ,  42 , 43
        dw        44 ,  45 ,  46 ,  47 ,  48 ,  49 ,  50 ,  51 ,  52 , 53
        dw        54 ,  55 ,  56 ,  57 ,  58 ,  59 ,  60 ,  61 ,  62 , 63
        dw        64 ,  65 ,  66 ,  67 ,  68 ,  69 ,  70 ,  71 ,  72 , 73
        dw        74 ,  74 ,  75 ,  76 ,  77 ,  78 ,  79 ,  80 ,  81 , 82
        dw        82 ,  83 ,  84 ,  85 ,  86 ,  87 ,  87 ,  88 ,  89 , 90
        dw        91 ,  91 ,  92 ,  93 ,  94 ,  95 ,  95 ,  96 ,  97 , 97
        dw        98 ,  99 , 100 , 100 , 101 , 102 , 102 , 103 , 104 ,104
        dw       105 , 106 , 106 , 107 , 108 , 108 , 109 , 109 , 110 ,110
        dw       111 , 112 , 112 , 113 , 113 , 114 , 114 , 115 , 115 ,116
        dw       116 , 117 , 117 , 118 , 118 , 118 , 119 , 119 , 120 ,120
        dw       120 , 121 , 121 , 122 , 122 , 122 , 123 , 123 , 123 ,124
        dw       124 , 124 , 124 , 125 , 125 , 125 , 125 , 126 , 126 ,126
        dw       126 , 126 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,128
        dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128

palette label byte
include 2drot.pal

current db 768 dup (0)

palf    db 'BULLET.DAT',0
handle  dw ?

picture dw ?

place   dw 0

x_pos   dw 0
y_pos   dw 0

xpage   db 0

.386
.code
        mov     ax,@data
        mov     ds,ax
        mov     ax,4a00h
        mov     bx,1000h
        int     21h
        mov     ax,3d00h
        lea     dx,palf
        int     21h
        mov     bx,ax
        mov     ax,4200h
        mov     cx,9
        mov     dx,0c79eh
        int     21h
        call    rotate2d
        mov     ax,3e00h
        int     21h
        mov     ax,0003h
        int     10h
        mov     ax,4c00h
        int     21h


proc    rotate2d
        push    bx
        mov     handle,bx
        mov     ax,@data
        mov     ds,ax
        mov     ax,0012h
        int     10h
        mov     ax,0013h
        int     10h
        push    0a000h
        pop     es

        mov     cx,30
wait_bit:
        call    vertical
        loop    wait_bit

        mov     ax,4800h
        mov     bx,1000h
        int     21h
        mov     picture,ax

        mov     bx,handle
        push    ds
        mov     ax,picture
        mov     ds,ax
        mov     ax,3f00h
        mov     cx,320*200
        xor     dx,dx
        int     21h
        push    es
        push    ds
        pop     es
        mov     di,64000
        xor     ax,ax
        mov     cx,1535
        rep     stosb
        pop     es
        pop     ds

        mov     ax,picture
        mov     gs,ax

        mov     dx,3c4h
        mov     ax,0604h
        out     dx,ax
        mov     dx,3d4h
        mov     ax,0014h
        out     dx,ax
        mov     ax,0e317h
        out     dx,ax
        mov     ax,109h
        out     dx,ax

        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,768
clear_palette:
        xor     al,al
        out     dx,al
        loop    clear_palette
        
        call    load_normal_full_res

        call    fade_in

        mov     cx,350
wait_for_it:
        mov     dx,3dah    
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        loop    wait_for_it

        call    flash_stuff

        mov     cx,32
loop_01:
        push    cx
        call    draw_picture
        call    flip_page
        add     scale,2
        pop     cx
        loop    loop_01

        mov     cx,32
loop_02:
        push    cx
        call    draw_picture
        call    flip_page
        call    update_angle
        add     scale,2
        pop     cx
        loop    loop_02

        mov     cx,64
loop_03:
        push    cx
        call    draw_picture
        call    flip_page
        call    update_angle
        inc     x_pos
        dec     y_pos
        pop     cx
        loop    loop_03

        mov     cx,64
loop_04:
        push    cx
        call    draw_picture
        call    flip_page
        call    update_angle
        dec     x_pos
        pop     cx
        loop    loop_04

        mov     cx,64
loop_05:
        push    cx
        call    draw_picture
        call    flip_page
        call    update_angle
        dec     x_pos
        inc     y_pos
        pop     cx
        loop    loop_05

        mov     cx,64
loop_06:
        push    cx
        call    draw_picture
        call    flip_page
        call    update_angle
        inc     x_pos
        inc     y_pos
        pop     cx
        loop    loop_06

        mov     cx,64+32
loop_07:
        push    cx
        call    draw_picture
        call    flip_page
        call    update_angle
        dec     y_pos
        pop     cx
        loop    loop_07

        mov     cx,64
fade_loop:
        push    cx
        call    fade_to_white
        call    draw_picture
        call    flip_page
        call    update_angle
        dec     scale
        pop     cx
        loop    fade_loop

        mov     cx,63
fade_out_:
        push    cx
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     ax,cx
        mov     cx,768
f_o_l:
        out     dx,al
        loop    f_o_l
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        pop     cx
        loop    fade_out_

        push    es
        mov     ax,picture
        mov     es,ax
        mov     ax,4900h
        int     21h
        pop     es

        pop     bx
        ret
endp    rotate2d

proc    get_page
        cmp     xpage,1
        jz      page_one
        mov     di,16000
        ret
page_one:
        xor     di,di
        ret
endp    get_page

proc    flip_page
        cmp     xpage,0
        jz      page_two
        mov     xpage,0
        xor     bx,bx
        call    set_offset
        mov     di,16000
;        call    clear_other_page
        jmp     pages_flipped
page_two:
        mov     xpage,1
        mov     bx,16000
        call    set_offset
        xor     di,di
;        call    clear_other_page
pages_flipped:
        ret
clear_other_page:
        mov     dx,3c4h
        mov     ax,0f02h
        out     dx,ax
        mov     cx,8000
        xor     ax,ax
        rep     stosw
        ret
endp    flip_page

proc    set_offset
        pusha
        mov     dx,3d4h
        mov     al,0ch
        mov     ah,bh
        out     dx,ax
        inc     al
        mov     ah,bl
        out     dx,ax
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        popa
        ret
endp    set_offset


proc    flash_stuff
        mov     cx,63
wlik:
        push    cx
        call    fade_to_white
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        pop     cx
        loop    wlik

        mov     dx,3d4h
        mov     ax,709h
        out     dx,ax
        mov     dx,3c4h
        mov     ax,0f02h
        out     dx,ax

        mov     xpage,1
        mov     scale,32
        call    draw_picture
        mov     xpage,0

        mov     cx,10
wait_a_sec:
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        loop    wait_a_sec

        push    es
        mov     ax,ds
        mov     es,ax
        lea     di,current
        mov     al,63
        mov     cx,768
        rep     stosb
        pop     es
        call    fade_in

        ret
endp    flash_stuff

proc    fade_in
        mov     cx,63
fil:
        push    cx
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,768
        lea     si,palette
        lea     di,current
fii:
        mov     al,[di]
        mov     ah,[si]
        cmp     ah,al
        jz      nfi
        ja      addit
        dec     al
        jmp     nfi
addit:
        inc     al
nfi:
        mov     [di],al
        out     dx,al
        inc     si
        inc     di
        loop    fii
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        pop     cx
        loop    fil
        ret
endp    fade_in

proc    fade_to_white
        xor     bl,bl
        mov     cx,256
fade_to_white_stuff:
        push    cx
        mov     dx,3c7h
        mov     al,bl
        out     dx,al
        mov     dx,3c9h
        in      al,dx
        mov     cl,al
        in      al,dx
        mov     ch,al
        in      al,dx
        mov     bh,al
        mov     dx,3c8h
        mov     al,bl
        out     dx,al
        inc     dx
        cmp     cl,63
        jz      rok
        inc     cl
rok:
        cmp     ch,63
        jz      gok
        inc     ch
gok:
        cmp     bh,63
        jz      bok
        inc     bh
bok:
        mov     al,cl
        out     dx,al
        mov     al,ch
        out     dx,al
        mov     al,bh
        out     dx,al
        inc     bl
        pop     cx
        loop    fade_to_white_stuff
        ret
endp    fade_to_white

proc    load_normal_full_res
        pusha
        xor     si,si
        xor     di,di
        xor     bx,bx
        mov     cx,320*200
load_full_res:
        mov     dx,3c4h
        mov     al,2        
        mov     ah,plane[bx]
        out     dx,ax
        mov     al,gs:[si]
        inc     si
        mov     es:[di],al
        inc     bx
        cmp     bx,4
        jz      change_plane_mask
        loop    load_full_res
        jmp     res_done
change_plane_mask:
        xor     bx,bx
        inc     di
        loop    load_full_res
res_done:
        popa
        ret
endp    load_normal_full_res

proc    draw_picture
        pusha
        call    get_page
        mov     si,di
        mov     x,0
        mov     y,0
        mov     cx,50
picture_loop:
        push    cx
        mov     cx,80
draw_loop:
        push    cx
;        mov     ax,y
;        mov     bx,80
;        imul    bx
;        mov     si,ax
;        add     si,x
        push    x y
        sub     y,25
        mov     ax,y_pos
        add     y,ax
        sub     x,40
        mov     ax,x_pos
        add     x,ax
        call    rotate
        pop     y x
        mov     ax,y1
        add     ax,centery
        mov     bx,320
        imul    bx
        mov     di,ax
        add     di,centerx
        add     di,x1
        push    si
        xchg    si,di
        mov     al,gs:[si]
        stosb
        pop     si
        inc     si
        inc     x
        pop     cx
        loop    draw_loop
        mov     x,0
        inc     y
        pop     cx
        loop    picture_loop
        popa
        ret
endp    draw_picture

proc    update_angle
        add     alpha,18
        cmp     alpha,2*720
        jb      alpha_is_cool
        sub     alpha,2*720
alpha_is_cool:
        ret
endp    update_angle

proc    update_scale
        add     z_ofs,4
        cmp     z_ofs,600*2
        jb      zoom_ok
        mov     z_ofs,200*2
zoom_ok:
        mov     bx,z_ofs
        mov     ax,zoom[bx]
        mov     scale,ax
        ret
endp    update_scale

proc    rotate
        pusha
        push    si cx
        mov     cx,scale
        mov     bx,alpha        
        mov     ax,y                    ;x1:=sin(alpha)*y+cos(alpha)*x
        imul    word ptr sintbl[bx]
        idiv    cx
        mov     si,ax
        mov     ax,x
        imul    word ptr costbl[bx]
        idiv    cx
        add     si,ax
        mov     x1,si

        mov     ax,y                    ;y1:=cos(alpha)*y-sin(alpha)*x
        imul    word ptr costbl[bx]
        idiv    cx
        mov     si,ax
        mov     ax,x
        imul    word ptr sintbl[bx]
        idiv    cx
        sub     si,ax
        mov     y1,si
        pop     cx si
        popa
        ret
endp    rotate

proc    vertical
        pusha
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        popa
        ret
endp    vertical
end

