extrn   _vrt_rout:dword, _vrt_timer:dword
extrn   _vrt_palptr:dword, _vrt_pallen:word, _vrt_palindex:byte

extrn   _vrt_init:near, _vrt_uninit:near, _vrt_settimer:near

;
; Set page on next vertical retrace
; In:
;   pagelo - low byte of total page addx
;   pagehi - high byte of total page addx
; Out:
;   AX,DX - ?
;
@vrt_setpage    macro   pagelo, pagehi
        mov dx,3d4h
        mov al,0dh
        mov ah,&pagelo
        out dx,ax
        mov al,0ch
        mov ah,&pagehi
        out dx,ax
endm

;
; Set palette and wait for it to take effect (waits for prev pal to do first)
; In:
;   index - first color to set
;   len - number of colors to set
;   ptr -> RGB color data
;
@vrt_setpal     macro   index, len, ptr
vrt_setpall=$
        cmp _vrt_pallen,0
        jne vrt_setpall
        mov _vrt_palptr,&ptr
        mov _vrt_palindex,&index
        mov _vrt_pallen,&len
vrt_setpall=$
        cmp _vrt_pallen,0
        jne vrt_setpall
endm

;
; Set palette and wait for it to take effect (waits for prev pal to do first)
; In:
;   index - first color to set
;   len - number of colors to set
;   ptr -> RGB color data (label)
;
@vrt_setpalo    macro   index, len, ptr
vrt_setpalol=$
        cmp _vrt_pallen,0
        jne vrt_setpalol
        mov _vrt_palptr,offset &ptr
        mov _vrt_palindex,&index
        mov _vrt_pallen,&len
vrt_setpalol=$
        cmp _vrt_pallen,0
        jne vrt_setpalol
endm

;
; Wait for any palette changes to take effect
;
@vrt_waitpal    macro
vrt_waitpall=$
        cmp _vrt_pallen,0
        jne vrt_waitpall
endm

