 .386P
code32 segment para public use32
       assume cs:code32,ds:code32
       
include 386power.inc

; very simple mouse handling routines
; intended for using the mouse to select game options
; and similar things.
; There is support for only two buttons and simple polled input
; maybe i will add support for interrupt driven input
; but for now i don't see where it fits
; (i prefer mouse polling because this way i reduce mode switches
; between my prot. mode code and the real mode mouse driver)

        public _MouseReset
_MouseReset:
        ; out:
        ;    V86ax == 00000h if mouse not installed
        ;    V86ax == 0FFFFh if mouse installed
        ;             mouse hidden & positioned on center of screen
        ; N.B. if you use a "not standard" mode like mode-x is
        ;      NEVER un-hide the mouse!!!!!
        mov V86eax,0
mousetrap: ; the following code is shared with the other routines       
        push eax
        mov al,33h
        int 33h
        pop eax
        ret
        public _MouseShow
_MouseShow:
        mov V86eax,1
        jmp short mousetrap
        public _MouseHide
_MouseHide:        
        mov V86eax,2
        jmp short mousetrap
        public _MouseRead
_MouseRead:        
        mov V86eax,3 ; poll current mouse buttons & position
        ; OUT:
        ;       V86bx = button status
        ;               bit0 = 1 if LEFT  button pressed
        ;               bit1 = 1 if RIGHT button pressed
        ;       V86cx = column
        ;       V86dx = row
        jmp short mousetrap
        public _MouseSet
_MouseSet:
        mov V86eax,4 ; set mouse pointer position
        ;  IN: V86cx = new column
        ;      V86dx = new row
        ;  N.B. depending on the video mode some mouse drivers
        ;       either TRUNC or ROUND the row/column values received
        jmp short mousetrap
        public _MouseXRange
_MouseXRange:
        mov V86eax,7
        ; IN: V86cx = min column
        ;     V86dx = max column
        jmp short mousetrap        
        public _MouseYRange
_MouseYRange:
        mov V86eax,8
        ; IN: V86cx = min row
        ;     V86dx = max row
        jmp short mousetrap                
        

                
code32 ends        
	   END
