/***************************************************************************
    RMTABS.C        Small file utility for replacing the tab characters with
                    space characters.

    Written by Adam Seychell

 Building example using BCC32.

 bcc32 -c rmtabs.c
 dlink -c rmtabs.obj c0.obj ,,, pal.lib


 Building example using GCC.

 gcc -c -v rmtabs.c
 dlink -c rmtabs.o c0.obj ,,, pal.lib


 Possible building example using WATCOM

 wcc -c rmtabs.c
 dlink -c rmtabs.obj c0.obj ,,, pal.lib

***************************************************************************/
#include <stdio.h>

char usage_mesg[]={ \
"Replces tab characters with spaces\n\
\n\
    Usage:  rmtabs <file> <tab size>\n\
"};

FILE * fptr;
int c,tabsize;

void error(char * msg)
{
fprintf(stderr,msg);
 exit(0);
}

int main(int argc, char * argv[])
{
int position;
int i;

 if (argc != 3 ) error((char*)&usage_mesg);
 tabsize=atoi(argv[2]);
 if (tabsize == 0) error("tab size must be an integer above zero\n");

 fptr=fopen(argv[1],"r");
 if (fptr == 0 ) error("file open error\n");
 position=0;
 for (; ; ) {

     if ( (c=fgetc(fptr)) == EOF) break;
     if (c==9) {
        i=tabsize - (position%tabsize);
        position+=i;
        for ( ; i > 0 ; i--) {
            if ( fputc(' ',stdout) == EOF) error("file output error\n");
        }
     }
     else
     {
        if ( putchar(c) == EOF) error("file output error\n");
        if (c!=13) position++;
     }
     if (c==10) position=0;

}
     fclose(fptr);

return 0;
}
