;****************************************************************************
; Filename: PAL.INC
;  Version:
;   Author: Peter Andersson
;  Created: 1995.03.12
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************

MACRO    PALfunction   FUNC
Global NoLanguage @&FUNC:Near
Global C           FUNC :Near
ENDM     PALfunction


;****************************************************************************
; STARTUP
;****************************************************************************



Global C main:Near
Global dos32version:Dword               ; version of DOS32 (in bcd)
Global dos32system:Byte                 ; system type - RAW,XMS,VCPI or DPMI
Global exesize:Dword                    ; size in bytes
Global exename:Dword                    ; PSZ to executable name and path
Global _psp:Dword                               ; program segment prefix pointer
Global _environ:Dword                   ; environment pointer
Global _envsize:Dword                   ; number of entries in environment table
Global environ:Dword                    ; environment table pointer
Global _zero:Dword                              ; zero pointer
Global _zero_sel:Dword                  ; zero selector
Global _argv:Dword              ; pointer to array of cmd line pointers
Global _argc:Dword;             ; numnber of pointers in command line list

Global DMA_addr:Dword                   ; DMA near pointer address
Global DMA_size:Dword                   ; DMA size in bytes
Global DMA_phys:Dword                   ; DMA physical address

Global DOS_addr:Dword                   ; DOS near pointer address
Global DOS_size:Dword                   ; Size of DOS buffer in bytes
Global DOS_seg:Dword                    ; DOS real buffer ptr segment:offset

Global _environ:Dword                   ; Environment table pointer
Global _envsize:Dword                   ; Environment size in bytes
Global ctrl_break_count:Byte    ; Ctrl+C/Ctrl+Break count varible

;****************************************************************************
; CONIO - console I/O
;****************************************************************************

STDIN  = 0              ; Standard input handle
STDOUT = 1              ; Standard output handle
STDERR = 2              ; Standard error handle

Global C printf:Near
Global C kbhit:Near

;****************************************************************************
; FILEIO - file I/O
;****************************************************************************
Global errno:Dword                              ; System error code

EOF = -1                        ; End of file error constant
NUL = 0                         ;

PALfunction        open         ; Open file
PALfunction        close                ; Close file
PALfunction        unlink               ; Delete file
PALfunction        read                 ; Read data from file
PALfunction        write                ; Write data to file
PALfunction        filelength   ; File length in bytes
PALfunction        lseek                ; Seek new file position
PALfunction        rmdir                ; Removes a directory
PALfunction        chdir                ; Changes to a directory
PALfunction        mkdir                ; Creates a directory
PALfunction        creat                ; Creat a new file
PALfunction        getcwd               ; Gets current working directory
PALfunction        _getdcwd             ; Gets working directory
PALfunction        getcurdir            ; Gets current directory
PALfunction        setdisk              ; Sets current disk
PALfunction        getdisk              ; Gets current disk




O_RDONLY = 0                    ; Read only
O_WRONLY = 1                    ; Write only
O_RDWR   = 2                    ; Read and write
O_APPEND = 4                    ; File pointer will be set to the end of file
O_CREAT  = 8                    ; Creates the file if it doesn't exist
O_TRUNC  = 16                   ; Truncate the file when open
O_EXCL   = 32                   ; Returns an error if file exists (O_CREAT)

SEEK_SET = 0                    ; Seek from file beginning
SEEK_CUR = 1                    ; Seek from current file position
SEEK_END = 2                    ; Seek from end of file

;****************************************************************************
; MATH - math functions
;****************************************************************************
PALfunction        min
PALfunction        max
PALfunction        min3
PALfunction        max3
PALfunction        atoi


;****************************************************************************
; MALLOC - memory allocation
;****************************************************************************
PALfunction        setmem
PALfunction        malloc
PALfunction        free
PALfunction        resize
PALfunction        realloc
PALfunction        calloc
Global C memavail:Near
Global C maxavail:Near


;****************************************************************************
; STRINGS - various string I/O
;****************************************************************************
PALfunction        strcpy
PALfunction        stpcpy
PALfunction        strcat
PALfunction        strchr
PALfunction        strchrn
PALfunction        strcmp
PALfunction        stricmp
PALfunction        strdup
PALfunction        strlen
PALfunction        strupr
PALfunction        strlwr
PALfunction        strncpy
PALfunction        strpbrk
PALfunction        otoa
PALfunction        btoa
PALfunction        xtoa
PALfunction        ltoa
PALfunction        ultoa
PALfunction        btoa
PALfunction        xtoa
PALfunction        otoa
PALfunction        ptos
PALfunction        isdigit
PALfunction        isxdigit
PALfunction        isalpha
PALfunction        islower
PALfunction        isupper
PALfunction        isalnum
PALfunction        isascii
PALfunction        iscntrl
PALfunction        ispunct
PALfunction        isspace
PALfunction        isprint
PALfunction        toupper
PALfunction        tolower
Global C sprintf:Near


;****************************************************************************
; VARIOUS - various functions
;****************************************************************************
Struc   IRQVECT
    Union
farvect Df  ?
    Struc
vectofs Dd  ?
vectseg Dw  ?
    Ends
    Ends
Ends    IRQVECT

PALfunction        _exit
PALfunction        exit
PALfunction        vprintf
PALfunction        atexit
PALfunction        memcpy
PALfunction        memset
PALfunction        memmove              ; move with overlap
PALfunction        getvect
PALfunction        setvect
PALfunction        _getfarptr
PALfunction        MK_FAR
PALfunction        MK_FP
PALfunction        getenv
PALfunction        outp
PALfunction        outpw
PALfunction        inp
PALfunction        inpw
PALfunction        loadlibrary
PALfunction        GetLibrarySize

Global C _cexit:Near
Global C abort:Near



include "pal_new.inc"



