;******************************************************************************
; Filename: GETCWD.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.03.10
;  Updated:
;******************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;******************************************************************************
; Function: long @getcurdir(int drive, char *directory);
;  Comment: Stored the current working directory in *directory
;    Input: Eax, drive number; 0 = default drive, 1 = A, 2 = B, etc.
;			Edx, pointer to buffer to hold directory
;  Returns: 0 if success, -1 if error.
;******************************************************************************
; Function: char* @getcwd(char *buf, long buflen);
;  Comment: Stored the current working directory in buf.
;    Input: Eax, pointer to buffer to hold directory
;           Edx, maximum length of buffer
;  Returns: NUL if an error occured or pointer to buf.
;******************************************************************************
; Function: char* @_getdcwd(int drive, char *buf, long buflen);
;  Comment: Stored the current working directory in buf.
;    Input: Eax, drive number; 0 = default drive, 1 = A, 2 = B, etc.
;			Edx, pointer to buffer to hold directory
;           Ecx, maximum length of buffer
;  Returns: NUL if an error occured or pointer to buf.
;******************************************************************************

		Include STDDEF.INC

		Codeseg

Proc    getcurdir, 2
		Push    Esi
		Mov		Esi,Edx
		Mov		Dl,AL
		Mov     Ah,47h			; call DOS get CWD function
		Int     21h
		Pop		Esi
		Jc @@error
		Clear   Eax
		Ret
@@error:
		Mov	   Eax,-1
		Ret

Endp



Proc    _getdcwd , 3
        Push    Eax             ; save drive number
		TestZ	Edx
		jnz @@Nomalloc
		mov		Eax,Ecx			; allocate a buffer if *buf = NULL
		call	@malloc
		TestZ	Eax
		je      @@memerr
        Mov     Edx,Eax
@@Nomalloc:                         ; Edx -> buffer
        Mov     Eax,[Esp]           ; get drive number
        TestZ   Eax                 ; if drive = 0 then getdisk
        Jnz @@GotDrv
		mov     ah,19h              ; Get disk
		int		21h
        inc     eax
@@GotDrv:
        Movzx   Eax,Al
        Add     Al,'A'-1
        Mov     [Edx],Al              ; insert drive letter
		Mov		[Word Edx+1],'\:'     ; insert letters ":\"
        Mov     [Esp],Edx             ; save buffer ptr
        Add     Edx,3
        Sub     Al,'A'-1
		Call	@getcurdir
		Cmp		Eax,-1
		Je      @@Error
        Pop     Eax
		Ret
@@Error:
		mov     [errno],ENODEV
		Pop		Eax
		Clear	Eax
		Ret
@@memerr:
		mov     [errno],ENOMEM
		Pop	    Eax
		Clear   Eax
		Ret
Endp



Proc    getcwd , 2

		Mov		Ecx,Edx
		Mov		Edx,Eax
		Clear	Eax
		call 	@_getdcwd
		Ret

Endp

		End
