/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <io.h>
#include <sys/fsext.h>
#include <libc/dosio.h>
#include <dos32api.h>

int
_write(int handle, const void* buffer, size_t count)
{
  _dos32_regs r;

  __FSEXT_Function *func = __FSEXT_get_function(handle);
  if (func)
  {
    int rv;
    if (func(__FSEXT_write, &rv, &handle))
      return rv;
  }
  if (count)
  asm ("movb  $0x40,%%ah\n\
    int $0x21\n\
    sbbl %%edx,%%edx"
    : "=a" (r.eax), "=d" (r.flags)
    : "b" (handle), "c" (count), "d" (buffer)
    : "eax","ebx","ecx","edx","cc");
  else {
    r.eax=0x4000;
    r.ebx=handle;
    r.edx= r.ecx = 0;
    r.ds =__dos32_dos_buffer_seg; /* really needed ? */
    __dos32_call_realmode_int(0x21,&r,0);
  }
  if (r.flags & 1)
  {
    errno = __doserr_to_errno(r.eax);
    return -1;
  }
  if ((r.eax == 0) && count)
  {
    errno = ENOSPC;
    return -1;
  }
  return r.eax;
}
