/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
#include <dos32api.h>
#include <sys/cltypes.h>
#include <libc/internal.h>
#include <crt0.h>
#define isflag(a) (_crt0_startup_flags & a)

typedef struct { unsigned char number __attribute__ ((packed));
                 unsigned long offset __attribute__ ((packed)); } intstruct;
_cl_flatptr __primary_screen_address;
_cl_flatptr __secondary_screen_address;
_cl_flatptr __vga_video_mem;
extern intstruct __dos32_new_ints;
_cl_large_farptr __dos32_oldints[256];
char __dos32_cbreak_mode;    /* = exit on ctrl-break */
char __dos32_cbreak_counter;
int  __dos32_system_ints;

void __init_dos32_stuff(void)
{
  intstruct *inttemp=&__dos32_new_ints;
  _cl_large_farptr *storetemp=&__dos32_oldints[0];
  _cl_farptr dummy,newvec;

#define isint(a) (inttemp->number==a)
  
  if (*(char *)__real2flat(0x0449)==7)
  {
    __primary_screen_address=__seg2flat(0xb000U);
    __secondary_screen_address=__seg2flat(0xb800U);
  }
  else
  {
    __primary_screen_address=__seg2flat(0xb800U);
    __secondary_screen_address=__seg2flat(0xb000U);
  }
  __vga_video_mem=__seg2flat(0xa000U);
/********************************************
  install ints & exceptions
*********************************************/
  newvec.selector=__dos32_cs;
  while (!isint(0xffU) &&
         !(isflag(_CRT0_FLAG_NO_EXCEPTION_AT_ALL) && isint(0)) &&
         !(isflag(_CRT0_FLAG_NO_EXCEPTION_8) && isint(8)))
  {
     newvec.offset=inttemp->offset;
     __dos32_get_protect_mode_int_vec(inttemp->number,&dummy);
     __dos32_set_protect_mode_int_vec(inttemp->number,&newvec);
     storetemp->offset=dummy.offset;
     storetemp->selector=dummy.selector;
     inttemp++; storetemp++; __dos32_system_ints++;
  }
}

void __shut_down_dos32_stuff()
{
   _cl_large_farptr *restorevec=&__dos32_oldints[0];
   intstruct *inttemp=&__dos32_new_ints;
   while (__dos32_system_ints--)
   {
     __dos32_set_protect_mode_int_vec(inttemp->number,(_cl_farptr *)&restorevec);
     inttemp++; restorevec++;
   }
}

void __dos32_set_cbreak_mode(char mode)
{
   __dos32_cbreak_mode=mode;
}

int __dos32_cbreak_hit()
{
    return __dos32_cbreak_counter--;
}
