/*
 this file was changed or created for the DOS32 library for DJGPP on 5.5.1997
 new created files are copyright 1997 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include "xconio.h"

int _wscroll = 1;

int directvideo = 1;  /* We ignore this */

unsigned int __conio_ScreenAddress; /* (unsigned int)__seg2flat(0xb800UL);  initialize just in case */
struct text_info __conio_txinfo;
int __conio_ungot_char;
int __conio_char_avail = 0;

int __conio_adapter_type = -1;       /* 1: EGA, 2: VGA/PGA/MCGA, else 0 */
int __conio_font_seg = -1;           /* segment of DOS buffer for 8x10 font */
unsigned __conio_last_mode = 0xffff; /* video mode when before program start */
int __conio_oldattrib =  -1;         /* text attribute before program start */

void     /* this is always dragged in by gpp_conio_init */
__conio__gettextinfo(struct text_info *t)
{
  int row, col;
  
  t->winleft = t->wintop = 1;
  t->winright = t->screenwidth = ScreenCols();
  t->winbottom = t->screenheight = ScreenRows();
  ScreenAttrib = t->attribute = get_screenattrib();
  t->normattr = oldattrib;
  t->currmode = getvideomode();
  ScreenGetCursor(&row, &col);
  t->curx = col+1;
  t->cury = row+1;
#if DBGGTINFO
  printf("left=%2d,right=%2d,top=%2d,bottom=%2d\n",t->winleft,
	 t->winright,t->wintop,t->winbottom);
  printf("scrht=%2d,scrwid=%2d,norm=%2x,mode=%2d,x=%2d,y=%2d\n",
	 t->screenheight, t->screenwidth, t->normattr, t->currmode,
	 t->curx, t->cury);
#endif
}

int
__conio_getvideomode(void)
{
  int mode = ScreenMode();
  /* 
   * in mode C80 we might have loaded a different font
   */
  if (mode == C80)
    if (ScreenRows() > 25)
      mode = C4350;
  return(mode);
}

int
__conio_get_screenattrib(void)
{
  unsigned char a;
  asm("movb $8,%%ah\n\
       movb $0,%%bh\n\
       int  $0x10\n\
       movb %%ah,%b0"
       : "=qm" (a)
       :
       : "eax","ebx");
  return( a & 0x7f); /* strip highest (BLINK) bit */
}

/* Check if we have at least EGA.
   Return 1 if EGA, 2 if VGA/PGA/MCGA, else 0. */
int
__conio_isEGA(void)
{
  unsigned char a,b;
  if (adapter_type == -1)
    {

      /* Get display combination code.  */
      asm("movw $0x1a00,%%ax\n\
           int  $0x10"
          :"=a" (a),"=b"(b)
          :
          :"eax","ebx" );
      if (a == 0x1a)    /* if Int 10h/AX=1A00h supported */
        switch (b)
          {
            case 4:
            case 5:
                adapter_type = 1; /* EGA */
                break;
            case 6:             /* PGA */
            case 7:             /* VGA */
            case 8:             /* VGA */
            case 10:            /* MCGA */
            case 11:            /* MCGA */
            case 12:            /* MCGA */
                adapter_type = 2;
                break;
            default:
                adapter_type = 0;
          }

      else
        {
          /* Int 10h/AX=1A00h not supported.  Try getting EGA info.  */
          asm("movb $0x12,%%ah\n\
               movw $0xff10,%%bx\n\
               int  $0x10\n\
               movb %%bh,%b0"
              : "=qm" (b)
              :
              : "eax","ebx","ecx","edx");
          adapter_type = (b != 0xff);
        }
    }

  return adapter_type;
}

void
gppconio_init(void)
{
  (void)isEGA();    /* sets the global ADAPTER_TYPE */

  if (oldattrib == -1)
    oldattrib = get_screenattrib();
  if (last_mode == 0xffff)
    last_mode = getvideomode();
  _gettextinfo(&txinfo);
  if (txinfo.currmode == 7)	/* MONO */
    ScreenAddress = (unsigned int)__seg2flat(0xb000UL);
  else
    ScreenAddress = (unsigned int)__seg2flat(0xb800UL);

#if 0
  /* Why should gppconio_init() restore OLDATTRIB?  I think it
     shouldn't, because this causes change of colors when all
     user wants is to update TXINFO.  And besides, _gettextinfo()
     above has already set ScreenAttrib.  */
  ScreenAttrib = txinfo.normattr = txinfo.attribute = oldattrib;
#endif
}

__asm__(".section .ctor; .long _gppconio_init; .section .text");
