/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <stdarg.h>
#include <stdio.h>
#include <sys/mono.h>
#include <dos32api.h>

static int initted = 0;

#define TOPROW 5*160
#define BOTROW 20*160
#define LIN(r,c) (0xb0000 + (r)*160 + (c)*2)

static int ofs=0;

void _mono_clear(void)
{
  for (ofs=TOPROW; ofs<BOTROW; ofs += 2)
     *(short *)__real2flat(0xb0000000UL+ofs) = 0x0720;
  ofs = TOPROW;
  initted = 1;
}

void _mono_putc(int ch)
{
  if (!initted)
    _mono_clear();
  if (ofs >= BOTROW)
  {
    int i;
    for (i=TOPROW; i<BOTROW-160; i+=2)
    *(short *)__real2flat(0xb0000000UL+i)=*(short *)__real2flat(0xb0000000UL+i+160);
    for (; i<BOTROW; i+=2) *(short *)__real2flat(0xb0000000UL+i)=0x0720;
    ofs -= 160;
  }
  switch (ch)
  {
  case '\n':
    ofs += 160;
    break;
  case '\r':
    ofs -= ofs % 160;
    break;
  case '\b':
    ofs -= 2;
    break;
  default:
    *(short *)__real2flat(0xb0000000UL+ofs)= 0x0700 | (ch & 0xff);
    ofs += 2;
    break;
  }
}

void _mono_printf(const char *fmt, ...)
{
  int i;
  char buf[1000];
  va_list a = 0;
  va_start(a, fmt);
  vsprintf(buf, fmt, a);
  for (i=0; buf[i]; i++)
    _mono_putc(buf[i]);
  va_end(a);
}
