/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 Charles Sandmann (sandmann@clio.rice.edu)
   setitimer implmentation - used for profiling and alarm
   BUGS: ONLY ONE AT A TIME, first pass code
   This software may be freely distributed, no warranty. */

#include <libc/stubs.h>
#include <sys/time.h>
#include <errno.h>
#include <dos32api.h>
#include <stdlib.h>


static struct itimerval real;

/* not right, should compute from current tic count.  Do later */
int getitimer(int which, struct itimerval *value)
{
  if(which == ITIMER_REAL) {
    *value = real;
    return 0;
  }
  errno = EINVAL;
  return -1;
}

extern void __dos32_timer(void);
extern unsigned __dos32_timer_countdown;
extern _cl_farptr __dos32_old_timer;
char __dos32_timer_on;
int  __dos32_timer_reload;
void *__dos32_timer_fakestack;

static void stop_timer(void)
{
  if(!__dos32_timer_on) return;
  __dos32_timer_countdown = -1;
  __dos32_set_protect_mode_int_vec(8, &__dos32_old_timer);
  __dos32_timer_on = 0;
  free(__dos32_timer_fakestack);
  __dos32_timer_fakestack = 0;
}

static void start_timer(void)
{
  _cl_farptr int8;

  if(__dos32_timer_on) return;
  if (!__dos32_timer_fakestack) __dos32_timer_fakestack=malloc(0x4000);
  if (!__dos32_timer_fakestack) {
    errno = ENOMEM;
    return;
  }
  __dos32_timer_on = 1;
  __dos32_get_protect_mode_int_vec(8, &__dos32_old_timer);
/*
  printf("old timer cs: %04x old timer eip: %08lx\n",__dos32_old_timer.selector,
          __dos32_old_timer.offset);
*/
  int8.selector = __dos32_cs;
  int8.offset = (unsigned) &__dos32_timer;
  __dos32_set_protect_mode_int_vec(8, &int8);
}

int setitimer(int which, struct itimerval *value, struct itimerval *ovalue)
{
  if(ovalue)
    if(getitimer(which,ovalue))
      return -1;	/* errno already set */

  if((value->it_value.tv_sec | value->it_value.tv_usec) == 0) {
    stop_timer();
    return 0;
  }
  
  if(which != ITIMER_REAL) {
    errno = EINVAL;
    return -1;
  }
  if (!__dos32_timer_fakestack) __dos32_timer_fakestack=malloc(0x4000);
  if (!__dos32_timer_fakestack) {
    errno = ENOMEM;
    return -1;
  }

  real = *value;
  
  __dos32_timer_countdown = value->it_value.tv_sec * 18;
  __dos32_timer_countdown += value->it_value.tv_sec / 5;
  __dos32_timer_countdown += (value->it_value.tv_usec + 54944) / 54955;
  
  __dos32_timer_reload = value->it_interval.tv_sec * 18;
  __dos32_timer_reload += value->it_interval.tv_sec / 5;
  __dos32_timer_reload += (value->it_interval.tv_usec + 54944) / 54955;

  start_timer();
  return 0;
}
