#EXETARGET = DOS32
EXECOMPRESS =

.SUFFIXES: .o .i .c .cc .s

GCC = gcc @$(TOP)/../gcc.opt -I. -I- -I$(TOP)/../../../incdos32 $(CFLAGS) -c $<

%.o : %.c
	$(GCC)
%.o : %.cc
	$(GCC)
%.o : %.S
	$(GCC)

%.i : %.c
	$(GCC) -E > $@
%.i : %.cc
	$(GCC) -E > $@
%.i : %.S
	$(GCC) -E > $@

%.ss : %.c
	$(GCC) -S > $@
%.ss : %.cc
	$(GCC) -S > $@

ifeq ($(EXETARGET),DOS32)
LINK = ld $(LDFLAGS) $(filter %.o,$^) $(filter-out %.o,$^) -o $@ -T ${TOP}/../../../libdos32/dos32.lnk
EXE = ${TOP}/../../../bin/stubify.exe $(EXECOMPRESS) $@
else
LINK = ld $(LDFLAGS) $(filter %.o,$^) $(filter-out %.o,$^) -o $@ -T ${TOP}/../../../lib/djgpp.lnk
EXE = ${TOP}/../../../bin/stubify.exe $@
endif

LIB=$(TOP)/../../../libdos32
BIN=$(TOP)/../../../bin
INC=$(TOP)/../../../incdos32
INFO=$(TOP)/../../../info
LIBGO32=$(TOP)/../../../lib
INCGO32=$(TOP)/../../../include

ifeq ($(EXETARGET),DOS32)
C = $(LIB)/crt0.o
L = $(LIB)/libc.a
else
C = $(LIBGO32)/crt0.o
L = $(LIBGO32)/libc.a
endif


OBJS := $(addsuffix .o, $(basename $(SRC)))
EXES := $(addprefix $(BIN)/,$(addsuffix .exe, $(basename $(SRC))))

.PRECIOUS: %.exe %.out %.err

$(BIN)/%.exe : $C %.o $L
	$(LINK)
	$(EXE)

all :: $(OBJS) $(EXTRA_OBJS) makefile.oh
	@rem.com

makefile.oh : makefile
	@echo.exe -o makefile.oh $(addprefix &/,$(OBJS))

clean ::
	-rm -f *.o *.d *.i makefile.oh

DEPS := $(wildcard *.d)
ifneq ($(DEPS),)
include $(DEPS)
endif
