;*****************************************************************************
;            Stub loader for DOS32 executibles.
;
; This stub loader attempts to loads and execute DOS32.EXE.
;  and is searched in the following order.
;
;  1) The directory in which the executible exists ( i.e this stub file )
;  2) Directories entries in the PATH environment varible.
;
; Note: This is the default stub loader use in DLINK.
;*****************************************************************************
; Filename: STUB.ASM
;   Author: Oleg Pliss
;   Version: 1.00
;   Created: 1995.09
;   modified for djasm - r. (nuked macros etc.)
;
;   Note: After linking this program use the EXERID utility to remove
;         wasted header space.
;*****************************************************************************


                .org    0

                .start
; release memory
                mov     ax, ds
		mov	bx, cs
		sub	bx, ax

		mov	ax, sp
		mov	cl, 4
		shr	ax, cl

		add	bx, ax
		inc	bx

                mov     ah, 0x4A
                int     0x21

                mov     es, ds:[0x2C]      ; Load ES with environment segment.

		mov	ax, ds

		push	cs			; Load DS with data segment
		pop	ds

; Fixup Execute Parameter Table.
                mov     [ExecParams+ 0x04 ], ax  ; command tail segment
                mov     [ExecParams+ 0x08 ], ax  ; FCB 1 segment
                mov     [ExecParams+ 0x0C ], ax  ; FCB 2 segment
; Search for path
                cld
		xor	ax, ax
		xor	di, di
		jmp	Entry
Next:
                mov     cx,0xFFFF
                repne
                scasb
Entry:
                mov     si, Path
		mov	cx, 5
                repe
                cmpsb
		jz	Done

		dec	di
		scasb
		jnz	Next

		xor	di, di
Done:


		push	es
		push	di

		push	ds
		pop	es

                mov     di, FileName
		jmp	TryFirst

TryAgain:
		pop	si
		test	si, si
		jz	LoadError	; Error if no DOS32 was found

		pop	ds

;               CopyPath
; ES	- data seg
; DS	- env  seg
; [SI]	- PATH

;                cld
                mov     di, FileName-1
CPNext:
		stosb
CPSkip:
		lodsb
		cmp     al, ';'
                jz      CPDone

		cmp	al, ' '
                jz      CPSkip

		test	al, al
                jnz     CPNext

		xor	si, si
CPDone:


;     AppendBackslash

                dec     di
                mov     al, '\\'
		scasb
		jz	BackslashFound
		stosb
BackslashFound:

		push	ds		; Save DS
		push	si		; Save SI

		push	es
		pop	ds

TryFirst:
;    Append "DOS32.EXE" to file name
                mov     si, DOS32_EXE
		mov     cx, 5
                rep
                movsw

;       Try to run DOS32.EXE
                mov     bx, ExecParams
                mov     dx, FileName
                mov     ax, 0x4B00
                int     0x21

		jc	CheckRetCode

                mov     ah, 0x4D      ; Get return code from DOS32 application
                int     0x21
Exit:
                mov     ah, 0x4C         ; Terminate to DOS
                int     0x21

CheckRetCode:
		cmp	al, 3
                jle     TryAgain
LoadError:
                mov     dx, DOS32_EXE
		mov	ah, 9
                int     0x21

		xor	al, al
		jmp	Exit

Path:
                .db      "PATH="
DOS32_EXE:
                .db      "DOS32.EXE"
                .db      0
                .db      "not found"
                .db      10
                .db      13
                .db      "$"
ExecParams:
                .dw      0               ; childs Environemnt segment
                .dw      0x80
                .dw      0          ; childs command tail seg:ofs
                .dw      0x5C
                .dw      0          ; FCB 1  seg:ofs
                .dw      0x6C
                .dw      0

                .db      0
FileName:
                .db      128 .dup 0     ; 128 chars for file the name.

                .db      128 .dup 0     ; The stack space
                .stack

