#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"

#define RESMAGIC 0x30534552

typedef struct PACKDATATAG {
 U32 packedsize; /* including header */
 U32 unpackersize;
} PACKDATA;

extern U32 cdecl paker(U32 datasize,U8 *from,PACKDATA *to);

typedef struct RESHDRTAG {
 U32 magic;
 U32 size;
 U32 items;
} RESHDR;

typedef struct RESITEMTAG {
 U8 name[22];
 U8 zero;
 U8 flags;
 U32 filepos;
 U32 size;
} RESITEM;

RESHDR rh;
RESITEM *rd;
FILE *rf;

void error(U8 *s)
{
 fprintf(stderr,"fatal error: %s\n",s);
 exit(1);
}

FILE *resopen(U8 *resource)
{
 FILE *f;
 f = fopen(resource,"r+b");
 if (f == NULL)
    {
     printf("Creating resource: %s\n",resource);
     f = fopen(resource,"wb");
     if (f == NULL)
        error("Cannot create resource!");
     rh.magic = RESMAGIC;
     rh.size = sizeof(rh);
     rh.items = 0;
     fwrite(&rh,1,sizeof(rh),f);
     fclose(f);
     f = fopen(resource,"r+b");
    }
 rh.magic = 0;
 fread(&rh,1,sizeof(rh),f);
 if (rh.magic != RESMAGIC)
    {
     fclose(f);
     error("This is not resource file!");
    }
 /* get resource dir */
 if (rh.items == 0)
    rd = NULL;
 else
    {
     rd = malloc(rh.items * sizeof(RESITEM));
     fseek(f,rh.size,SEEK_SET);
     fread(rd,1,rh.items * sizeof(RESITEM),f);
    }
 return f;
}

void ressee(U8 *resource)
{
 S32 i;
 rf = resopen(resource);
 for (i = 0; i < rh.items; i++)
     {
      printf("N:%s POS:%08X LEN:%08X F:%02X\n",
             rd[i].name,
             rd[i].filepos,
             rd[i].size,
             rd[i].flags);
     }
 fclose(rf);
}

void addblock(U8 *data,U32 size,U8 flags,U8 *name)
{
 fseek(rf,rh.size,SEEK_SET);
 fwrite(data,1,size,rf);
 rd = realloc(rd,(rh.items+1) * sizeof(RESITEM));
 strncpy(rd[rh.items].name,name,22);
 rd[rh.items].zero = 0;
 rd[rh.items].flags = flags;
 rd[rh.items].size = size;
 rd[rh.items].filepos = rh.size;
 rh.size += size;
 rh.items++;
}

void resclose(void)
{
 fseek(rf,0,SEEK_SET);
 fwrite(&rh,1,sizeof(rh),rf);
 fseek(rf,rh.size,SEEK_SET);
 fwrite(rd,1,rh.items * sizeof(RESITEM),rf);
 fclose(rf);
}

void resadd(U8 *resource,U8 *name,U8 *filename)
{
 FILE *f;
 U32 fs;
 U8 *data;

 rf = resopen(resource);
 printf("Loading: %s\n",filename);
 f = fopen(filename,"rb");
 if (f == NULL)
    {
     resclose();
     error("Cannot open data file!");
    }
 fseek(f,0,SEEK_END);
 fs = ftell(f);
 fseek(f,0,SEEK_SET);
 data = malloc(fs);
 fread(data,1,fs,f);
 fclose(f);
 addblock(data,fs,0,name);
 free(data);
 resclose();
}

void respak(U8 *resource,U8 *name,U8 *filename)
{
 FILE *f;
 U32 fs;
 U32 ps;
 U8 *data;
 PACKDATA *p;

 rf = resopen(resource);
 printf("Loading: %s\n",filename);
 f = fopen(filename,"rb");
 if (f == NULL)
    {
     resclose();
     error("Cannot open data file!");
    }
 fseek(f,0,SEEK_END);
 fs = ftell(f);
 fseek(f,0,SEEK_SET);
 data = malloc(fs);
 fread(data,1,fs,f);
 fclose(f);
 p = malloc(fs+10000);
 ps = paker(fs,data,p);
 free(data);
 addblock((U8 *)p,ps+8,1,name);
 free(p);
 resclose();
}

U32 main(U32 ARGC,U8 *ARGV[])
{
 U8 command[128];
 U8 resource[128];
 U8 name[128];
 U8 filename[128];

 strcpy(command,ARGV[1]);
 strupr(command);
 strcpy(resource,ARGV[2]);
 strupr(resource);

 if (strcmp(command,"-SEE") ==  0)
    ressee(resource);
 if (strcmp(command,"-ADD") ==  0)
    {
     strcpy(name,ARGV[3]);
     strcpy(filename,ARGV[4]);
     strupr(filename);
     resadd(resource,name,filename);
    }
 if (strcmp(command,"-PAK") ==  0)
    {
     strcpy(name,ARGV[3]);
     strcpy(filename,ARGV[4]);
     strupr(filename);
     respak(resource,name,filename);
    }
 return 0;
}
