;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; module player variables
IFDEF _AMPL
SB_Amplification   EQU _AMPL
ELSE
SB_Amplification   EQU 1
ENDIF
SB_NoteDivs        DD (MaxNote+1) DUP(00H)
SB_Buffer32Bit     DB   16384 DUP(0)
IFDEF SND_FILTER
SB_FilterL         DD   0
SB_FilterR         DD   0
ENDIF

;۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰۰
; module player functions

SpeedComp          MACRO
                   PUSH  EDX
                   MOV   EDX,ECX
                   AND   ECX,0FFFH
                   MOV   EAX,D SB_NoteDivs[ECX*4]
                   SHR   EDX,12
                   MOV   EDX,FineTuneTable[EDX*4]
                   MUL   EDX
                   SHRD  EAX,EDX,24
                   POP   EDX
                   ENDM

SB_AddSample       PROC  NEAR
                   ; ESI - address in core memory
                   ; ECX - length
                   ; AL - volume
                   ; AH - finetune
                   ; EBX - repeat
                   ; EDX - replen
                   PUSHAD
                   MOV   EBP,SampleInfoPtr
                   MOV   DS:[EBP.SI_Volume],AL
                   MOV   DS:[EBP.SI_FineTune],AH
                   MOV   DS:[EBP.SI_RepLen],EDX
                   MOV   EAX,SB_Mem
                   MOV   DS:[EBP.SI_Addr],EAX
                   ADD   EBX,EAX
                   MOV   DS:[EBP.SI_Repeat],EBX
                   CMP   EDX,2
                   JZ    @@NoRepeat
                   LEA   EAX,[EBX+EDX] ; repeat + replen = end of sample :)
                   JMP   @@SaveRep
@@NoRepeat:        ADD   EAX,ECX ; sample end
@@SaveRep:         MOV   DS:[EBP.SI_End],EAX

                   ADD   SampleInfoPtr,(Size SampleInfo)
                   MOV   ECX,EAX
                   SUB   ECX,DS:[EBP.SI_Addr]
                   OR    ECX,ECX
                   JZ    @@Done
                   MOV   EDI,SB_Mem
                   CLD
                   REP   MOVSB
                   XCHG  SB_Mem,EDI
                   MOV   W [EDI],0
@@Done:
                   MOV   EAX,SampleInfoPtr
                   SUB   EAX,(O SamplesInfo)
                   XOR   EDX,EDX
                   MOV   EBX,(Size SampleInfo)
                   DIV   EBX
                   MOV   @@r,EAX
                   POPAD
                   MOV   EAX,@@r
                   RET
@@r                DD   ?
SB_AddSample       ENDP

SB_FreeModule      PROC  NEAR
                   CALL  SB_StopModule
                   MOV   EAX,FirstPattern
                   OR    EAX,EAX
                   JZ    @@druut
                   CALL  free
                   MOV   FirstPattern,0
@@druut:
                   RET
SB_FreeModule      ENDP

SB_Effect0         PROC  NEAR
                   ; Arpeggio
                   ; still not implemeNted
                   RET
SB_Effect0         ENDP

SB_Effect0T        PROC  NEAR
                   MOVZX EAX,CounterHI
                   MOV   CL,ArpeggioTbl[EAX]
                   MOV   EAX,[ESI.CI_Speed]
                   OR    CL,CL
                   JZ    @@ArpDone
                   MOVZX EBX,[ESI.CI_InfoByte]
                   OR    EBX,EBX
                   JZ    @@ArpDone
                   CALL  COMM_NoteFind
                   CMP   CL,2
                   JZ    @@Arp2
                   AND   BL,0FH
                   ADD   EAX,EBX
                   JMP   @@ArpPre
@@Arp2:            SHR   BL,4
                   ADD   EAX,EBX
@@ArpPre:          MOVZX EAX,W NoteTable[EAX*2-2]
@@ArpDone:         MOV   ECX,EAX
                   OR    CH,[ESI.CI_FineTune]
                   SpeedComp
                   MOV   [ESI.CI_AfterDivF],AL
                   SHR   EAX,8
                   MOV   [ESI.CI_AfterDivM],EAX

                   RET
SB_Effect0T        ENDP

SB_Effect1         PROC  NEAR
                   ; Portamento up
                   MOVZX EAX,[ESI.CI_InfoBYTE]
                   MOV   [ESI.CI_PortaSpeed],EAX
                   RET
SB_Effect1         ENDP

SB_Effect1T        PROC  NEAR
                   MOV   ECX,[ESI.CI_Speed]
                   SUB   ECX,[ESI.CI_PortaSpeed]
                   CMP   ECX,MinNote
                   JGE   @@SkipONE
                   MOV   ECX,MinNote
@@SkipONE:         MOV   [ESI.CI_Speed],ECX
                   OR    CH,[ESI.CI_FineTune]
                   SpeedComp
                   MOV   [ESI.CI_AfterDivF],AL
                   SHR   EAX,8
                   MOV   [ESI.CI_AfterDivM],EAX
                   RET
SB_Effect1T        ENDP


SB_Effect2         PROC  NEAR
                   ; Portamento Down
                   MOVZX EAX,[ESI.CI_InfoBYTE]
                   MOV   [ESI.CI_PortaSpeed],EAX
                   RET
SB_Effect2         ENDP

SB_Effect2T        PROC  NEAR
                   MOV   ECX,[ESI.CI_Speed]
                   ADD   ECX,[ESI.CI_PortaSpeed]
                   CMP   ECX,MaxNote
                   JLE   @@SkipONE
                   MOV   ECX,MaxNote
@@SkipONE:         MOV   [ESI.CI_Speed],ECX
                   OR    CH,[ESI.CI_FineTune]
                   SpeedComp
                   MOV   [ESI.CI_AfterDivF],AL
                   SHR   EAX,8
                   MOV   [ESI.CI_AfterDivM],EAX
                   RET
SB_Effect2T        ENDP

SB_Effect3         PROC  NEAR
                   ; Tone Portamento
                   ; slide to note
                   MOVZX EAX,[ESI.CI_InfoByte]
                   OR    EAX,EAX
                   JZ    @@ProcExit
                   MOV   [ESI.CI_PortaSpeed],EAX
@@ProcExit:
                   RET
SB_Effect3         ENDP

SB_Effect3T        PROC  NEAR
                   MOV   ECX,[ESI.CI_Speed]
                   CMP   [ESI.CI_PortaDest],ECX
                   JZ    @@ProcExit
                   JG    @@AddIt
                   SUB   ECX,[ESI.CI_PortaSpeed]
                   CMP   [ESI.CI_PortaDest],ECX
                   JLE   @@Proceed
                   MOV   ECX,[ESI.CI_PortaDest]
                   JMP   @@Proceed

@@AddIt:           ADD   ECX,[ESI.CI_PortaSpeed]
                   CMP   [ESI.CI_PortaDest],ECX
                   JGE   @@Proceed
                   MOV   ECX,[ESI.CI_PortaDest]
@@Proceed:         MOV   [ESI.CI_Speed],ECX
                   OR    CH,[ESI.CI_FineTune]
                   SpeedComp
                   MOV   [ESI.CI_AfterDivF],AL
                   SHR   EAX,8
                   MOV   [ESI.CI_AfterDivM],EAX
@@ProcExit:
                   RET
SB_Effect3T        ENDP

SB_Effect4         PROC  NEAR
                   ; Vibrato
                   MOV   AL,[ESI.CI_InfoBYTE]
                   MOV   AH,AL
                   AND   AL,0FH
                   JZ    @@NoNewDepth
                   MOV   [ESI.CI_VibDepth],AL
@@NoNewDepth:      SHR   AH,4
                   OR    AH,AH
                   JZ    @@NoNewRate
                   SHL   AH,2
                   MOV   [ESI.CI_VibRate],AH
@@NoNewRate:
                   RET
SB_Effect4         ENDP

SB_Effect4T        PROC  NEAR
comment #
warning !
this vibrato uses only sine wave with no retrigger
#
                   MOVZX EBX,[ESI.CI_VibPos]
                   SHR   EBX,2
                   AND   BL,1FH
                   MOVZX EAX,BYTE PTR VibratoTable[EBX]
                   MUL   BYTE PTR [ESI.CI_VibDepth]
                   SHR   EAX,7
                   MOV   ECX,[ESI.CI_Speed]
                   CMP   [ESI.CI_VibPos],0
                   JL    @@VibNeg
                   ADD   ECX,EAX
                   JMP   @@Skip1
@@VibNeg:          SUB   ECX,EAX
@@Skip1:
                   OR    CH,[ESI.CI_FineTune]
                   SpeedComp
                   MOV   [ESI.CI_AfterDivF],AL
                   SHR   EAX,8
                   MOV   [ESI.CI_AfterDivM],EAX

                   MOV   AL,[ESI.CI_VibRate]
                   ADD   [ESI.CI_VibPos],AL

                   RET
SB_Effect4T        ENDP

SB_Effect5         PROC NEAR
                   ; continue Portamento + Volume Slide
                   RET
SB_Effect5         ENDP

SB_Effect5T        PROC  NEAR
                   CALL  SB_Effect3T ; do porta to note
                   JMP   SB_EffectAT ; do volume slide
                   RET
SB_Effect5T        ENDP

SB_Effect6         PROC  NEAR
                   ; Vibrato + Volume SLIDE
                   RET
SB_Effect6         ENDP

SB_Effect6T        PROC  NEAR
                   CALL  SB_Effect4T  ; do vibrato
                   JMP   SB_EffectAT  ; do vol slide
                   RET
SB_Effect6T        ENDP

SB_Effect7         PROC  NEAR
                   ; Tremolo
                   MOV   AL,[ESI.CI_InfoByte]
                   MOV   AH,AL
                   AND   EAX,0F00FH
                   JZ    @@druut
                   OR    AH,AH
                   JZ    @@skip1
                   AND   [ESI.CI_TremoloCmd],00FH
                   OR    [ESI.CI_TremoloCmd],AH
@@skip1:           OR    AL,AL
                   JZ    @@skip2
                   AND   [ESI.CI_TremoloCmd],0F0H
                   OR    [ESI.CI_TremoloCmd],AL
@@skip2:

@@druut:
                   RET
SB_Effect7         ENDP

SB_Effect7T        PROC  NEAR
                   MOVZX EBX,[ESI.CI_TremoloPos]
                   SHR   BL,2
                   AND   BL,1FH
; sine only
                   MOVZX EAX,B VibratoTable[EBX]
                   MOV   AH,[ESI.CI_TremoloCmd]
                   AND   AH,0FH
                   MUL   AH
                   SHR   EAX,6
                   MOV   AH,[ESI.CI_Volume]
                   CMP   [ESI.CI_TremoloPos],0
                   JL    @@TremoloNeg
                   ADD   AH,AL
                   JMP   @@TremoloCheck
@@TremoloNeg:      SUB   AH,AL
@@TremoloCheck:    JAE   @@TremoloSkip
                   XOR   AH,AH
@@TremoloSkip:     CMP   AH,40H
                   JBE   @@TremoloOK
                   MOV   AH,40H
@@TremoloOK:
                   ; now use this volume at AH!
                   MOV   [ESI.CI_MixVolume],AH
                   MOV   AL,[ESI.CI_TremoloCmd]
                   SHR   AL,2
                   AND   AL,3CH
                   ADD   [ESI.CI_TremoloPos],AL
                   RET
SB_Effect7T        ENDP

SB_Effect8         PROC  NEAR
                   MOV   AL,[ESI.CI_InfoBYTE]
                   SHR   AL,4
                   MOV   [ESI.CI_Panning],AL
                   RET
SB_Effect8         ENDP

SB_Effect8T        PROC  NEAR
                   ; ??? NOT USED ??? yeah, not used
                   RET
SB_Effect8T        ENDP

SB_Effect9         PROC  NEAR
                   ; Sample Offset
                   XOR   EAX,EAX
                   MOV   AH,[ESI.CI_InfoBYTE]
                   ADD   EAX,[ESI.CI_Addr]
                   CMP   EAX,[ESI.CI_End]
                   JBE   @@SkipONE
                   MOV   EAX,[ESI.CI_End]
@@SkipONE:         MOV   [ESI.CI_Pos],EAX
                   RET
SB_Effect9         ENDP

SB_EffectA         PROC  NEAR
                   ; Volume Slide
                   RET
SB_EffectA         ENDP

SB_EffectAT        PROC  NEAR
                   MOV   AL,[ESI.CI_InfoBYTE]
                   MOV   AH,AL
                   AND   AL,0FH  ; AL - LO NIBBLE
                   SHR   AH,4    ; AH - HI NIBBLE
                   MOV   CL,[ESI.CI_Volume]
                   ADD   CL,AH
                   CMP   CL,40H
                   JBE   @@SkipONE
                   MOV   CL,40H
@@SkipONE:         SUB   CL,AL
                   JGE   @@SkipTWO
                   XOR   CL,CL
@@SkipTWO:         MOV   [ESI.CI_Volume],CL
                   MOV   [ESI.CI_MixVolume],CL
                   RET
SB_EffectAT        ENDP

SB_EffectB         PROC  NEAR
                   ; Position JUMP
                   ; JUMPS TO First ??? Row OF Pattern At position infobyte

                   MOV   PBreakPos,0
                   MOV   AL,[ESI.CI_InfoBYTE]
                   DEC   AL
                   MOV   Song_Position,AL
                   MOV   PosJumpFlag,TRUE
                   RET
SB_EffectB         ENDP

SB_EffectC         PROC  NEAR
                   ; SET Volume
                   MOV   AL,[ESI.CI_InfoBYTE]
                   CMP   AL,64
                   JA    @@Skip
                   MOV   [ESI.CI_Volume],AL
                   MOV   [ESI.CI_MixVolume],AL
@@Skip:            RET
SB_EffectC         ENDP

SB_EffectD         PROC  NEAR
                   ; Pattern BREAK
                   MOVZX EAX,[ESI.CI_InfoBYTE]
                   MOV   CL,AL
                   SHR   AL,4
                   MOV   AL,Mul10Table[EAX]
                   AND   CL,0FH
                   CMP   CL,9
                   JA    @@ProcExit
                   ADD   AL,CL
                   CMP   AL,63
                   JA    @@ProcExit
                   IMUL  EAX,ModuleChannels
                   SHL   EAX,2
                   MOV   PBreakPos,EAX
                   MOV   PosJumpFlag,TRUE
@@ProcExit:        RET
SB_EffectD         ENDP

SB_EffectE        PROC  NEAR
                   ; a bunch of extended protracker commands
                   ; now supported
                   ; 0 filter
                   ; 1 fineslide up
                   ; 2 fineslide down
                   ; 6 pattern loop
                   ; A fine vol up
                   ; B fine vol down
                   ; E ptn delay

                   MOV   AL,[ESI.CI_InfoBYTE]
                   MOV   AH,AL
                   AND   EAX,0F00FH

                   CMP   AH,10H     ; fineslide up
                   JZ    @@FineSlideUp
                   CMP   AH,20H
                   JZ    @@FineSlideDown
                   CMP   AH,60H
                   JZ    @@LoopPattern
                   CMP   AH,0A0H
                   JZ    @@FineVolUp
                   CMP   AH,0B0H
                   JZ    @@FineVolDown
                   CMP   AH,0E0H
                   JZ    @@PatternDelay
                   RET

@@FineSlideUp:     XOR   AH,AH
                   MOV   ECX,[ESI.CI_Speed]
                   SUB   ECX,EAX
                   CMP   ECX,MinNote
                   JGE   @@fsnoteok
                   MOV   ECX,MinNote
@@fsnoteok:        MOV   [ESI.CI_Speed],ECX
                   OR    CH,[ESI.CI_FineTune]
                   SpeedComp
                   MOV   [ESI.CI_AfterDivF],AL
                   SHR   EAX,8
                   MOV   [ESI.CI_AfterDivM],EAX
                   RET

@@FineSlideDown:   XOR   AH,AH
                   MOV   ECX,[ESI.CI_Speed]
                   ADD   ECX,EAX
                   CMP   ECX,MaxNote
                   JLE   @@fsnoteok
                   MOV   ECX,MaxNote
                   JMP   @@fsnoteok

@@LoopPattern:     CMP   AL,0
                   JZ    @@lpSet
                   CMP   [ESI.CI_LoopCounter],0FFH
                   JNZ   @@lpCont
                   MOV   [ESI.CI_LoopCounter],AL
@@lpCont:          DEC   [ESI.CI_LoopCounter]
                   CMP   [ESI.CI_LoopCounter],0FFH
                   JNZ   @@lpSetJump
                   MOV   [ESI.CI_LoopDivision],0
                   JMP   @@lpDone
@@lpSetJump:       MOV   ECX,[ESI.CI_LoopDivision]
                   MOV   Pattern_OFS,ECX
@@lpDone:          RET

@@lpSet:           MOV   EAX,Pattern_OFS
                   SUB   EAX,16
                   MOV   [ESI.CI_LoopDivision],EAX
                   JMP   @@lpDone

@@FineVolUp:       MOV   CL,[ESI.CI_Volume]
                   ADD   CL,AL
                   CMP   CL,64
                   JBE   @@volslok
                   MOV   CL,64
@@volslok:         MOV   [ESI.CI_Volume],CL
                   MOV   [ESI.CI_MixVolume],CL
                   RET

@@FineVolDown:     MOV   CL,[ESI.CI_Volume]
                   SUB   CL,AL
                   JAE   @@volslok
                   XOR   CL,CL
                   JMP   @@volslok

@@PatternDelay:    MOV   AH,Tempo
                   MUL   AH
                   ADD   CounterHI,AL
                   RET

SB_EffectE         ENDP

SB_EffectF         PROC  NEAR
                   ; Set Speed
                   MOV   AL,[ESI.CI_InfoBYTE]
                   CMP   AL,20H
                   JA    @@SetBPM
                   OR    AL,AL
                   JZ    @@PExit
                   MOV   Tempo,AL
                   MOV   CounterHI,AL
                   JMP   @@PExit
@@SetBPM:          MOVZX ECX,AL
                   MOV   EAX,55125
                   XOR   EDX,EDX
                   DIV   ECX
                   MOV   TickLen,EAX
@@PExit:           RET
SB_EffectF         ENDP

SB_DummyRET:       RET
SB_Effects         DD   O SB_Effect0
                   DD   O SB_Effect1
                   DD   O SB_Effect2
                   DD   O SB_Effect3
                   DD   O SB_Effect4
                   DD   O SB_Effect5
                   DD   O SB_Effect6
                   DD   O SB_Effect7
                   DD   O SB_Effect8
                   DD   O SB_Effect9
                   DD   O SB_EffectA
                   DD   O SB_EffectB
                   DD   O SB_EffectC
                   DD   O SB_EffectD
                   DD   O SB_EffectE
                   DD   O SB_EffectF

SB_EffectsT        DD   O SB_Effect0T
                   DD   O SB_Effect1T
                   DD   O SB_Effect2T
                   DD   O SB_Effect3T
                   DD   O SB_Effect4T
                   DD   O SB_Effect5T
                   DD   O SB_Effect6T
                   DD   O SB_Effect7T
                   DD   O SB_Effect8T
                   DD   O SB_DummyRET
                   DD   O SB_EffectAT
                   DD   O SB_DummyRET
                   DD   O SB_DummyRET
                   DD   O SB_DummyRET
                   DD   O SB_DummyRET
                   DD   O SB_DummyRET

; mix over chunk of bytes
; ESI - pointer to channel info
; ECX - number of samples to mix
; EDI - pointer where to mix
MixOver            PROC  NEAR
                   MOV   EBP,[ESI.CI_Pos]

                   CMP   EBP,[ESI.CI_End]
                   JNZ   @@NoEnd
                   CMP   [ESI.CI_RepLen],2
                   JZ    @@druut

@@NoEnd:
                   XOR   EDX,EDX
                   MOV   DH,[ESI.CI_MixVolume]
                   MOV   BL,[ESI.CI_Fraction]
                   MOV   BH,[ESI.CI_AfterDivF]

@@MixLp:           MOV   DL,DS:[EBP]
                   ; MOVSX EAX, MulTable[EDX*2]
                   DB    00FH,0BFH,004H,055H
MulTable           DD    ? ; pointer to volume table
                   ADD   BL,BH
                   ADC   EBP,[ESI.CI_AfterDivM]
                   ADD   [EDI],EAX
                   ADD   EDI,4
                   CMP   EBP,[ESI.CI_End]
                   JA    @@HeyLoop
@@LoopIt:          DEC   ECX
                   JNZ   @@MixLp
                   JMP   @@SavePos

@@HeyLoop:         CMP   [ESI.CI_RepLen],2
                   JZ    @@NoLoop
                   MOV   EBP,[ESI.CI_Repeat]
                   JMP   @@LoopIt

@@NoLoop:          MOV   EBP,[ESI.CI_End]
@@SavePos:         MOV   [ESI.CI_Pos],EBP
                   MOV   [ESI.CI_Fraction],BL
@@druut:
                   RET
MixOver            ENDP

SB_TickHandler     PROC  NEAR
                   CLD
                   MOV   ECX,TickLen
                   MOV   EDI,O SB_Buffer32Bit
                   MOV   EAX,00008000H
                   REP   STOSD

                   ;CMP   ModPlaying,TRUE
                   ;JNZ   @@NoMix

                   MOV   ESI,O ChannelsInfo
                   MOV   ECX,MixingChannels
@@MixLp:           PUSH  ECX
                   MOV   ECX,TickLen
                   MOV   EDI,O SB_Buffer32Bit
                   CALL  MixOver
                   ADD   ESI,Size ChannelInfo
                   POP   ECX
                   LOOP  @@MixLp

                   CALL  SB_Playbackx

;@@NoMix:
                   MOV   EDI,BufferToMix
                   MOV   ECX,TickLen
                   MOV   ESI,O SB_Buffer32Bit
                   CLR   EAX
IFDEF SND_FILTER
                   MOV   EDX,SB_FilterR
ENDIF
@@CopyLp:          MOV   EAX,[ESI]
IFDEF SND_DOAMP
                   ;MOV  AX,AmpTable[EAX*2]
                   DB    066H,08BH,004H,045H
AmpTable           DD    ?
ENDIF
IFDEF SND_FILTER
                   MOV   EBP,EAX
                   ADD   EAX,EDX
                   MOV   EDX,EBP
                   SHR   EAX,1
ENDIF
                   MOV   [EDI],AH
                   ADD   ESI,4
                   INC   EDI
                   LOOP  @@CopyLp
                   MOV   BufferToMix,0
IFDEF SND_FILTER
                   MOV   SB_FilterR,EDX
ENDIF
                   CMP   ModPlaying,TRUE
                   JNZ   @@druut

                   DEC   CounterHI
                   JZ    SB_InitPattern

                   MOV   ESI,O ChannelsInfo
                   MOV   ECX,ModuleChannels
@@EffectLp:        PUSH  ECX
                   CALL  [ESI.CI_EffectProc]
                   ADD   ESI,Size ChannelInfo
                   POP   ECX
                   LOOP  @@EffectLp
                   JMP   @@druut

SB_InitPattern:    MOV   AL,Tempo
                   MOV   CounterHI,AL
                   CMP   PosJumpFlag,TRUE
                   JZ    @@NextPosition
                   MOV   EBX,ModuleChannels
                   SHL   EBX,6+2
                   CMP   Pattern_OFS,EBX
                   JNZ   @@AnalyzeRow
                   MOV   PBreakPos,0
@@NextPosition:    MOV   EAX,PBreakPos
                   MOV   Pattern_OFS,EAX
                   MOV   AL,Song_Position
                   INC   AL
                   CMP   AL,SongLen
                   JB    @@Skip1
                   XOR   AL,AL
@@Skip1:           MOV   Song_Position,AL
                   MOVZX EAX,AL
                   MOVZX EAX,BYTE PTR SongOrder[EAX]
                   IMUL  EAX,ModuleChannels
                   SHL   EAX,6+2
                   ADD   EAX,FirstPattern
                   MOV   PatternBase,EAX
                   MOV   PosJumpFlag,FALSE

@@AnalyzeRow:      MOV   EDI,Pattern_OFS
                   ADD   EDI,PatternBase
                   MOV   EAX,ModuleChannels
                   SHL   EAX,2
                   ADD   Pattern_OFS,EAX

                   IFDEF DEBUG
                   Say   'SB: '
                   ENDIF

                   MOV   ESI,O ChannelsInfo
                   MOV   ECX,ModuleChannels
@@ChannelLp:       PUSH  ECX
                   MOV   AL,[EDI+1]  ; sample number
                   IFDEF DEBUG
                   CALL  DispAL
                   Say   ' '
                   ENDIF
                   OR    AL,AL
                   JZ    @@Freq
                   DEC   AL
                   MOV   AH,Size SampleInfo
                   MUL   AH
                   MOVZX EAX,AX
                   LEA   EBX,SamplesInfo[EAX]

                   MOV   EAX,[EBX.SI_End]
                   MOV   [ESI.CI_End],EAX
                   MOV   EAX,[EBX.SI_RepLen]
                   MOV   [ESI.CI_RepLen],EAX
                   MOV   EAX,[EBX.SI_Repeat]
                   MOV   [ESI.CI_Repeat],EAX
                   MOV   EAX,[EBX.SI_Addr]
                   MOV   [ESI.CI_Addr],EAX
                   MOV   [ESI.CI_Pos],EAX ; retrigger note
                   MOV   B [ESI.CI_Fraction],0

                   MOV   AL,[EBX.SI_Volume]
                   MOV   [ESI.CI_Volume],AL
                   MOV   [ESI.CI_MixVolume],AL
                   MOV   AL,[EBX.SI_FineTune]
                   SHL   AL,4
                   MOV   [ESI.CI_FineTune],AL

@@Freq:            MOVZX ECX,BYTE PTR [EDI]  ; number of note
                   IFDEF DEBUG
                   PUSHAD
                   LEA   ESI,NoteText[ECX*4]
                   CALL  DisplayNullString
                   MOV   AL,' '
                   CALL  DisplayChar
                   POPAD
                   ENDIF
                   OR    ECX,ECX
                   JZ    @@FeelOrder
                   CMP   BYTE PTR [EDI+2],3 ; chek slide to note
                   JZ    @@SetPorta
                   CMP   BYTE PTR [EDI+2],5 ; chek contine slide
                   JZ    @@SetPorta
                   MOVZX ECX,WORD PTR NoteTable[ECX*2-2]
                   MOV   [ESI.CI_Speed],ECX
                   OR    CH,[ESI.CI_FineTune]
                   SpeedComp
                   MOV   [ESI.CI_AfterDivF],AL
                   SHR   EAX,8
                   MOV   [ESI.CI_AfterDivM],EAX
                   MOV   B [ESI.CI_Fraction],0 ; retrigger note
                   MOV   EAX,[ESI.CI_Addr]
                   MOV   [ESI.CI_Pos],EAX
                   MOV   AL,[ESI.CI_Volume]
                   MOV   [ESI.CI_MixVolume],AL
                   JMP   @@FeelOrder

@@SetPorta:        MOVZX ECX,WORD PTR NoteTable[ECX*2-2]
                   MOV   [ESI.CI_PortaDest],ECX

@@FeelOrder:       MOV   AL,[EDI+3]  ; Info byte
                   MOV   [ESI.CI_InfoByte],AL
                   MOVZX EBX,BYTE PTR [EDI+2]  ; Command byte

                   IFDEF DEBUG
                   MOV   AL,BL
                   CALL  DispAL
                   Say   ' '
                   MOV   AL,[EDI+3]
                   CALL  DispAL
                   Say   ' '
                   ENDIF

                   MOV   EAX,SB_EffectsT[EBX*4]
                   MOV   [ESI.CI_EffectProc],EAX
                   CALL  D SB_Effects[EBX*4]

                   ADD   EDI,4
                   ADD   ESI,Size ChannelInfo
                   POP   ECX
                   LOOP  @@ChannelLp
                   IFDEF DEBUG
                   NewLine
                   ENDIF

@@druut:
                   RET
SB_TickHandler     ENDP

SB_PlayModule      PROC  NEAR
                   MOV   B Tempo,6
                   MOV   B CounterHI,1
                   MOV   B Song_Position,129
                   MOV   TickLen,HERTZ50
                   MOV   PosJumpFlag,FALSE
                   MOV   EAX,ModuleChannels
                   SHL   EAX,6+2
                   MOV   Pattern_OFS,EAX
                   MOV   ESI,O ChannelsInfo
                   MOV   ECX,MixingChannels
@@InitLp:          MOV   [ESI.CI_EffectProc],O SB_DummyRET
                   MOV   [ESI.CI_Volume],0
                   MOV   [ESI.CI_MixVolume],0
                   MOV   [ESI.CI_AfterDivM],0
                   MOV   [ESI.CI_AfterDivF],0
                   ADD   ESI,Size ChannelInfo
                   LOOP  @@InitLp
                   CALL  NEAR PTR SB_InitPattern

                   MOV   ModPlaying,TRUE
                   RET
SB_PlayModule      ENDP

SB_StopModule      PROC  NEAR
                   MOV   ModPlaying,FALSE
                   MOV   ESI,O ChannelsInfo
                   MOV   ECX,MixingChannels
@@InitLp:          MOV   [ESI.CI_MixVolume],0
                   ADD   ESI,Size ChannelInfo
                   LOOP  @@InitLp
                   RET
SB_StopModule      ENDP

; free mem for samples, patterns
SB_FreeMem         PROC  NEAR
                   CALL  SB_StopModule ; it shouldnt, but who knows ?
                   CLI
                   MOV   EDI,O ChannelsInfo
                   MOV   ECX,(Size ChannelInfo)
                   CLD
                   CLR   EAX
                   REP   STOSD
                   STI
                   MOV   EAX,O SamplesInfo
                   MOV   SampleInfoPtr,EAX
                   MOV   EAX,SB_SampleBank
                   MOV   SB_Mem,EAX
                   MOV   EAX,FirstPattern
                   OR    EAX,EAX
                   JZ    @@NoFree
                   CALL  free
@@NoFree:          MOV   FirstPattern,0
                   RET
SB_FreeMem         ENDP

;************************************************************************
; some functions for initialization purposes

MakeNoteDivs       PROC NEAR
                   MOV  EDI,O SB_NoteDivs
                   CLD
                   XOR  EAX,EAX
                   STOSD
                   MOV  EBX,1
                   MOV  ECX,MaxNote
@@Here:            MOV  EAX,DivBase
                   XOR  EDX,EDX
                   DIV  EBX
                   STOSD
                   INC  EBX
                   LOOP @@Here

                   RET
MakeNoteDivs       ENDP

InitBuffers        PROC  NEAR
                   MOV   EAX,3*SB_DMAMax
                   CALL  Lo_Alloc
                   MOV   SB_DMABuffer,EAX

                   IFDEF __DLL
                   PUSH  EAX
                   GetVar EAX,Code32Base
                   MOV   EAX,D [EAX]
                   ADD   EAX,D [ESP]
                   ADD   ESP,4
                   ELSE
                   ADD   EAX,Code32Base
                   ENDIF
                   ADD   EAX,SB_DMAMax-1
                   SHR   EAX,SB_DMAMaxS
                   SHL   EAX,SB_DMAMaxS  ; kick last ten bits :)
                   MOV   EBX,EAX
                   MOV   Buffer0Abs,EAX
                   ADD   EAX,SB_DMAMax
                   MOV   Buffer1Abs,EAX
                   IFDEF __DLL
                   PUSH  EBX
                   GetVar EBX,Code32Base
                   MOV   EBX,D [EBX]
                   SUB   D [ESP],EBX
                   POP   EBX
                   ELSE
                   SUB   EBX,Code32Base
                   ENDIF
                   MOV   Buffer0Offset,EBX
                   ADD   EBX,SB_DMAMax
                   MOV   Buffer1Offset,EBX
                   CALL  COMM_AllocVDS
                   RET
InitBuffers        ENDP

CreateMulTable     PROC  NEAR
                   MOV   EAX,(65*256+1)*2
                   CALL  malloc
                   MOV   MulTable,EAX
                   MOV   ESI,EAX
                   MOV   ECX,65*256+1
                   XOR   EBX,EBX
@@Here:            MOVSX EAX,BL
                   MOVZX EDX,BH
                   IMUL  EDX
                   SHL   EAX,2
                   CDQ
                   IDIV  MixingChannels
                   MOV   [ESI],AX
                   ADD   ESI,2
                   INC   EBX
                   LOOP  @@Here
                   RET
CreateMulTable     ENDP

IFDEF SND_DOAMP
CreateAmpTable     PROC  NEAR
                   MOV   EAX,20000H
                   CALL  malloc
                   MOV   AmpTable,EAX
                   MOV   EDI,EAX
                   MOV   ECX,10000H
                   CLR   EBX
@@lp:              MOV   EAX,EBX
                   SUB   EAX,8000H
                   MOVSX EAX,AX
                   SHL   EAX,SB_Amplification
                   CMP   EAX,32767
                   JLE   @@ok1
                   MOV   EAX,32767
@@ok1:             CMP   EAX,-32768
                   JGE   @@ok2
                   MOV   EAX,-32768
@@ok2:             ADD   EAX,8000H
                   MOV   [EDI],AX
                   ADD   EDI,2
                   INC   EBX
                   LOOP  @@lp
                   RET
CreateAmpTable     ENDP
ENDIF

; in AL - voice number
; EBX - sample number (1...)
; ECX - volume (-1 = default volume)
; EDX - amiga period
SB_PlaySample      PROC  NEAR
                   CLI
                   OR    EBX,EBX
                   JZ    @@druut
                   MOVZX EAX,AL
                   MOV   EDI,Size ChannelInfo
                   IMUL  EDI,EAX
                   ADD   EDI,O ChannelsInfo
                   MOV   ESI,Size SampleInfo
                   DEC   EBX
                   IMUL  ESI,EBX
                   ADD   ESI,O SamplesInfo

                   MOV   [EDI.CI_Speed],EDX
                   MOV   EAX,[ESI.SI_End]
                   MOV   [EDI.CI_End],EAX
                   MOV   EAX,[ESI.SI_RepLen]
                   MOV   [EDI.CI_RepLen],EAX
                   MOV   EAX,[ESI.SI_Repeat]
                   MOV   [EDI.CI_Repeat],EAX
                   MOV   EAX,[ESI.SI_Addr]
                   MOV   [EDI.CI_Addr],EAX
                   MOV   [EDI.CI_Pos],EAX ; retrigger note
                   MOV   B [EDI.CI_Fraction],0

                   MOV   AL,[ESI.SI_Volume]
                   CMP   ECX,-1
                   JZ    @@SkipVol
                   MOV   AL,CL
                   CMP   AL,64
                   JBE   @@SkipVol
                   MOV   AL,64
@@SkipVol:
                   MOV   [EDI.CI_Volume],AL
                   MOV   [EDI.CI_MixVolume],AL
                   MOV   AL,[ESI.CI_FineTune]
                   SHL   AL,4
                   MOV   [EDI.CI_FineTune],AL

                   MOV   ECX,[EDI.CI_Speed]
                   OR    CH,[EDI.CI_FineTune]
                   SpeedComp
                   MOV   [EDI.CI_AfterDivF],AL
                   SHR   EAX,8
                   MOV   [EDI.CI_AfterDivM],EAX

@@druut:           STI
                   RET
SB_PlaySample      ENDP

; AL - channel
; EBX - amiga period
SB_SamplePeriod    PROC  NEAR
                   CLI
                   MOVZX EAX,AL
                   MOV   EDI,Size ChannelInfo
                   IMUL  EDI,EAX
                   ADD   EDI,O ChannelsInfo
                   MOV   ECX,EBX
                   MOV   [EDI.CI_Speed],ECX
                   OR    CH,[EDI.CI_FineTune]
                   SpeedComp
                   MOV   [EDI.CI_AfterDivF],AL
                   SHR   EAX,8
                   MOV   [EDI.CI_AfterDivM],EAX
                   STI
                   RET
SB_SamplePeriod    ENDP

SB_Playbackx       PROC  NEAR
                   CMP   PlaybackON,TRUE
                   JNZ   @@druut
                   CALL  PlaybackCallback
                   MOV   EDI,O SB_Buffer32Bit
                   MOV   ECX,HERTZ50
@@Here:            MOVSX EAX,W [ESI]
                   MOVSX EDX,W [ESI+2]
                   ADD   EAX,EDX
                   SAR   EAX,1
                   ADD   D [EDI],EAX
                   ADD   ESI,4
                   ADD   EDI,4
                   LOOP  @@Here
@@druut:
                   RET
SB_Playbackx       ENDP

SB_PlaybackInit    PROC  NEAR
                   MOV   PlaybackCallback,EAX
                   MOV   TickLen,HERTZ50
                   MOV   PlaybackON,TRUE
                   RET
SB_PlaybackInit    ENDP

SB_PlaybackDone    PROC  NEAR
                   MOV   PlaybackON,FALSE
                   RET
SB_PlaybackDone    ENDP
