comment |
 this is nice exception handler for kernel

Exception #xx definition
Error code: 00000000
IP 00000000:00000000 FLAGS:00000000 CR0:00000000 CR2:00000000 CR3:00000000
EAX: 00000000 EBX: 00000000 ECX: 00000000 EDX: 00000000
ESI: 00000000 EDI: 00000000 EBP: 00000000 ESP: 00000000
#PF CR2 - Code32Base =

|

Exc00Str           DB   '00: Divide Error',0
Exc01Str           DB   '01: Single Step',0
Exc02Str           DB   '02: What ?!',0
Exc03Str           DB   '03: Debug Trap',0
Exc04Str           DB   '04: Overflow',0
Exc05Str           DB   '05: Bound failed!',0
Exc06Str           DB   '06: #UD Bad opcode',0
Exc07Str           DB   '07: #NM No coprocessor!',0
Exc08Str           DB   '08: #DF Double fault',0
Exc09Str           DB   '09: #MP Copro seg',0
Exc0AStr           DB   '0A: #TS Bad TSS',0
Exc0BStr           DB   '0B: #NP No segment',0
Exc0CStr           DB   '0C: #SS Stack seg fault',0
Exc0DStr           DB   '0D: #GP General protection fault',0
Exc0EStr           DB   '0E: #PF Paging fault',0
Exc0FStr           DB   '0F: Whadda hell ?!',0
Exc10Str           DB   '10: #Coprocessor fault',0
Exc11Str           DB   '11: Alignment fault',0

ExcNormal          MACRO N
Exception&N&:      CLI
                   MOV   ExcString,O Exc&N&Str
                   JMP   ExceptionHandler
                   ENDM

ExcErrCode         MACRO N
Exception&N&:      CLI
                   MOV   ExcString,O Exc&N&Str
                   JMP   ExceptionE
                   ENDM

                   ExcNormal  00
                   ExcNormal  01
                   ExcNormal  02
                   ExcNormal  03
                   ExcNormal  04
                   ExcNormal  05
                   ExcNormal  06
                   ExcNormal  07
                   ExcErrCode 08
                   ExcNormal  09
                   ExcErrCode 0A
                   ExcErrCode 0B
                   ExcErrCode 0C
                   ExcErrCode 0D
                   ExcErrCode 0E
                   ExcNormal  0F
                   ExcNormal  10
                   ExcErrCode 11

ExcErrorCode       DD    ?
ExcScript          DB    'DEFV EXCBREAKADR #'
ExcEIP             DD    ?
                   DB    0
                   DB    'ECHO EXCBREAKADR',0,0
ExcCS              DD    ?
ExcESP             DD    ?
ExcFLAGS           DD    ?
ExcString          DD    ?
ExcESI             DD    ?
ExceptionHandler   PROC  NEAR
                   MOV   ExcErrorCode,0
                   JMP   @@ExceptionCommon
ExceptionE:        POP   ExcErrorCode
@@ExceptionCommon: POP   ExcEIP
                   POP   ExcCS
                   POP   ExcFLAGS
                   MOV   ExcESP,ESP
                   MOV   ExcESI,ESI
                   PUSHAD
                   MOV   EAX,3
                   CALL  SetGrMode
                   MOV   CursorPtr,2*160
                   POPAD
                   SayLn 'We have experienced exception!'
                   Say   'Exception #'
                   MOV   ESI,ExcString
                   CALL  DisplayNullString
                   NewLine
                   Say   'Error code:'
                   SayValue ExcErrorCode,12
                   NewLine
                   Say   'IP '
                   SayValue ExcCS,10
                   Say   ':'
                   SayValue ExcEIP,10
                   Say   ' EFLAGS:'
                   SayValue ExcFLAGS,10
                   Say   ' CR0:'
                   SayValue CR0,10
                   Say   ' CR2:'
                   SayValue CR2,10
                   Say   ' CR3:'
                   SayValue CR3,10
                   NewLine
                   Say   'EAX:'
                   SayValue EAX,10
                   Say   ' EBX:'
                   SayValue EBX,10
                   Say   ' ECX:'
                   SayValue ECX,10
                   Say   ' EDX:'
                   SayValue EDX,10
                   NewLine
                   Say   'ESI:'
                   SayValue ExcESI,10
                   Say   ' EDI:'
                   SayValue EDI,10
                   Say   ' EBP:'
                   SayValue EBP,10
                   Say   ' ESP:'
                   SayValue ExcESP,10
                   NewLine
                   Say   ' #PF CR2-Code32Base = '
                   MOV   EAX,CR2
                   SUB   EAX,Code32Base
                   SayValue EAX,10
                   NewLine
                   IFNDEF NoDebug
                   MOV   EAX,O ExcScript
                   CALL  DBG_InitS
@@Here:            JMP   SHORT @@Here
                   ELSE
                   SayLn 'Have a nice DOS.',15
                   JMP   BackToReality
                   ENDIF
ExceptionHandler   ENDP

