KeyTable1          DB  0   ; impossible !
                   DB  1BH ; esc
                   DB  '1234567890-='
                   DB  08  ; backspace
                   DB  09  ; TAB
                   DB  'qwertyuiop[]'
                   DB  13  ; enter
                   DB  0   ; left ctrl
                   DB  'asdfghjkl'
                   DB  3BH ; srednik
                   DB  27H ; apostrof
                   DB  60H ; apostrof w druga strone
                   DB  0   ; left shift
                   DB  '\zxcvbnm,./'
                   DB  0   ; rite shift
                   DB  '*'
                   DB  0   ; alt
                   DB  20H ; spacebar
                   DB  0   ; capslock
                   DB  10 DUP (0) ; function keys
                   DB  0   ; numlock
                   DB  0   ; scroll lock
                   DB  0,0,0 ; home, up, pgup
                   DB  '-' ; keypad -
                   DB  0,0,0 ; left middle rite
                   DB  '+' ; keypad +
                   DB  0,0,0 ; end, dn, pgdn
                   DB  0,0 ; ins, del

                   ; those are keys with shift pressed !
KeyTable2          DB  0   ; again impossible
                   DB  1BH ; ESC
                   DB  '!@#$%^&*()_+'
                   DB  08  ; backspace
                   DB  09  ; TAB
                   DB  'QWERTYUIOP{}'
                   DB  13  ; again enter
                   DB  0   ; left ctrl
                   DB  'ASDFGHJKL:"~'
                   DB  0   ; left shift
                   DB  '|ZXCVBNM<>?'
                   DB  0   ; rite shift
                   DB  0   ; prtscr
                   DB  0   ; alt
                   DB  20H ; spacebar
                   DB  0   ; capslock weird ehh ?
                   DB  10D DUP (0) ; function keys
                   DB  0   ; numlock
                   DB  0   ; scroll lock
                   DB  '789'
                   DB  '-' ; keypad -
                   DB  '456'
                   DB  '+' ; keypad +
                   DB  '123'
                   DB  '0.'

Kbd_ShiftState     DW  0
Kbd_LastScan       DB  0

Kbd_CmdPort        EQU  60H
Kbd_InPort         EQU  60H
                   ; data in buffer are
                   ; ascii code (0 if unknown) byte
                   ; scan code                 byte
                   ; shift bits state          word total - 4
Kbd_Buffer         DB   4*32D DUP(00H)
Kbd_BufferHead     DD   OFFSET Kbd_Buffer
Kbd_BufferTail     DD   OFFSET Kbd_Buffer
Kbd_Skip           DB   0
Kbd_E0             DB   False

Kbd_WaitReady      PROC  NEAR
                   MOV   ECX,20000H
@@Here:            IN    AL,64H
                   TEST  AL,2H
                   LOOPNZ @@Here
                   RET
Kbd_WaitReady      ENDP

Kbd_UpdateShifts   PROC  NEAR
                   CALL  Kbd_WaitReady
                   MOV   AL,0EDH
                   OUT   Kbd_CmdPort,AL
                   Delay 2000H
                   MOV   AX,Kbd_ShiftState
                   SHR   AX,6
                   AND   AL,7
                   OUT   Kbd_CmdPort,AL
                   RET
Kbd_UpdateShifts   ENDP

IncKbdBuffTail     PROC  NEAR
                   PUSH  ESI
                   ADD   ESI,4
                   CMP   ESI,OFFSET Kbd_Buffer+32*4
                   JNZ   @@Skip1
                   MOV   ESI,OFFSET Kbd_Buffer
@@Skip1:           CMP   ESI,Kbd_BufferHead
                   JNZ   @@ProcExit
                   POP   ESI
                   RET
@@ProcExit:        ADD   ESP,4
                   RET
IncKbdBuffTail     ENDP

IncKbdBuffHead     PROC  NEAR
                   ADD   ESI,4
                   CMP   ESI,OFFSET Kbd_Buffer+32*4
                   JNZ   @@Skip1
                   MOV   ESI,OFFSET Kbd_Buffer
@@Skip1:
                   RET
IncKbdBuffHead     ENDP

Kbd_Get            PROC  NEAR
                   PUSH  ESI
@@Here:            MOV   ESI,Kbd_BufferHead
                   CMP   ESI,Kbd_BufferTail
                   JZ    @@Here
                   MOV   EAX,DWORD PTR [ESI]
                   CALL  IncKbdBuffHead
                   MOV   Kbd_BufferHead,ESI
                   POP   ESI
                   RET
Kbd_Get            ENDP

Kbd_Pressed        PROC  NEAR
                   PUSH  ESI
                   MOV   ESI,Kbd_BufferHead
                   CMP   ESI,Kbd_BufferTail
                   POP   ESI
                   RET
Kbd_Pressed        ENDP

Kbd_CalledFrom     DD   ?

Kbd_Handler        PROC  NEAR
                   CLI
                   PushSegs
                   ReLoadSegs
                   PUSHAD
                   MOV   EAX,[ESP+16+8*4]
                   MOV   Kbd_CalledFrom,EAX
                   IN    AL,60H
                   MOV   Kbd_LastScan,AL
                   IN    AL,61H        ; SPECIAL SEQUENCE FOR KEYBOARD
                   MOV   AH,AL         ; FIRST READ SCAN CODE FROM PORT 60H
                   OR    AL,80H        ; AND THEN USE THAT
                   OUT   61H,AL        ;
                   MOV   AL,AH         ; THIS IS A KIND OF ACKNOWLEDGE SIGNAL
                   OUT   61H,AL        ; TO KEYBOARD

                   CMP   Kbd_Skip,0
                   JZ    @@Proceed
                   DEC   Kbd_Skip
                   JMP   @@HandlerExit

@@Proceed:         CMP   Kbd_E0,True
                   JZ    @@CommandE0DoIt

                   MOV   AL,Kbd_LastScan
                   CMP   AL,0E0H
                   JZ    @@CommandE0
                   CMP   AL,0E1H
                   JZ    @@CommandE1
                   CMP   AL,83D
                   JBE   @@OK1
                   TEST  AL,80H
                   JNZ   @@ReleaseCode
                   JMP   @@HandlerExit  ; what else we can do ?
@@ReleaseCode:     AND   AL,7FH
                   MOVZX EBX,AL
                   CMP   BYTE PTR KeyTable1[EBX],0
                   ; check for special key
                   JNZ   @@HandlerExit
                   ; we are interested in releasing of only some keys

                   CMP   AL,29          ; releasing left ctrl
                   JNZ   @@kbr1
                   AND   Kbd_ShiftState,NOT Kbd_LCtrl
                   JMP   @@HandlerExit

@@kbr1:            CMP   AL,42          ; releasing left shift
                   JNZ   @@kbr2
                   AND   Kbd_ShiftState,NOT Kbd_LShift
                   JMP   @@HandlerExit

@@kbr2:            CMP   AL,54          ; releasing rite shift
                   JNZ   @@kbr3
                   AND   Kbd_ShiftState,NOT Kbd_RShift
                   JMP   @@HandlerExit

@@kbr3:            CMP   AL,56          ; releasing left alt
                   JNZ   @@kbr4
                   AND   Kbd_ShiftState,NOT Kbd_LAlt
                   JMP   @@HandlerExit

@@kbr4:
                   ; we are not interested in releasing of other keys
                   JMP   @@HandlerExit
@@OK1:
                   MOV   EBX,0
                   TEST  Kbd_ShiftState,Kbd_LShift+Kbd_RShift
                   JZ    @@Skip1
                   XOR   EBX,(OFFSET KeyTable2)-(OFFSET KeyTable1)
@@Skip1:           CMP   AL,71
                   JB    @@NoNumeric
                   TEST  Kbd_ShiftState,Kbd_NumLock
                   JZ    @@NoNumeric
                   XOR   EBX,(OFFSET KeyTable2)-(OFFSET KeyTable1)
@@NoNumeric:       ADD   EBX,OFFSET KeyTable1
                   MOVZX EAX,AL
                   ADD   EBX,EAX
                   MOV   AL,[EBX]
                   OR    AL,AL
                   JZ    @@SpecialKeys

                   TEST  Kbd_ShiftState,Kbd_LAlt+Kbd_RAlt+Kbd_LCtrl+Kbd_RCtrl
                   JZ    @@OK2
                   ; we dont like such combination of keys
                   XOR   AL,AL
                   JMP   @@Skip2
                   ; but we still want to know about
                   ; such keypresses

@@OK2:             TEST  Kbd_ShiftState,Kbd_CapsLock
                   JZ    @@Skip2
                   CMP   AL,'A'
                   JB    @@Skip2
                   CMP   AL,'Z'
                   JBE   @@FlipCase
                   CMP   AL,'a'
                   JB    @@Skip2
                   CMP   AL,'z'
                   JA    @@Skip2
@@FlipCase:        XOR   AL,20H
@@Skip2:           MOV   ESI,Kbd_BufferTail
                   MOV   AH,Kbd_LastScan
                   MOV   WORD PTR [ESI],AX
                   MOV   AX,Kbd_ShiftState
                   MOV   WORD PTR [ESI+2],AX
                   CALL  IncKbdBuffTail
                   MOV   Kbd_BufferTail,ESI
                   JMP   @@HandlerExit

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; 0 in table !
@@SpecialKeys:     MOV   AL,Kbd_LastScan
                   CMP   AL,58 ; capslock
                   JNZ   @@kbs1
                   XOR   Kbd_ShiftState,Kbd_CapsLock
                   CALL  Kbd_UpdateShifts
                   JMP   @@HandlerExit

@@kbs1:            CMP   AL,69 ; numlock
                   JNZ   @@kbs2
                   XOR   Kbd_ShiftState,Kbd_NumLock
                   CALL  Kbd_UpdateShifts
                   JMP   @@HandlerExit

@@kbs2:            CMP   AL,70 ; scrolllock
                   JNZ   @@kbs3
                   XOR   Kbd_ShiftState,Kbd_ScrollLock
                   CALL  Kbd_UpdateShifts
                   JMP   @@HandlerExit

@@kbs3:            CMP   AL,42 ; left shift
                   JNZ   @@kbs4
                   OR    Kbd_ShiftState,Kbd_LShift
                   JMP   @@HandlerExit

@@kbs4:            CMP   AL,54 ; rite shift
                   JNZ   @@kbs5
                   OR    Kbd_ShiftState,Kbd_RShift
                   JMP   @@HandlerExit

@@kbs5:            CMP   AL,29 ; left ctrl
                   JNZ   @@kbs6
                   OR    Kbd_ShiftState,Kbd_LCtrl
                   JMP   @@HandlerExit

@@kbs6:            CMP   AL,56 ; left alt
                   JNZ   @@kbs7
                   OR    Kbd_ShiftState,Kbd_LAlt
                   JMP   @@HandlerExit

@@kbs7:            XOR   AL,AL
                   JMP   @@Skip2
                   JMP   @@HandlerExit

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
@@CommandE1:       MOV   Kbd_Skip,2
                   JMP   @@HandlerExit
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
@@CommandE0:       MOV   Kbd_E0,True
                   JMP   @@HandlerExit
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
@@CommandE0DoIt:   MOV   Kbd_E0,False
                   MOV   AL,Kbd_LastScan
                   CMP   AL,38H      ; rite alt
                   JNZ   @@kbe1
                   OR    Kbd_ShiftState,Kbd_RAlt
                   JMP   @@HandlerExit

@@kbe1:            CMP   AL,1DH      ; rite ctrl
                   JNZ   @@kbe2
                   OR    Kbd_ShiftState,Kbd_RCtrl
                   JMP   @@HandlerExit

@@kbe2:            CMP   AL,38H+80H  ; rite alt release
                   JNZ   @@kbe3
                   AND   Kbd_ShiftState,NOT Kbd_RAlt
                   JMP   @@HandlerExit

@@kbe3:            CMP   AL,1DH+80H  ; rite ctrl release
                   JNZ   @@kbe4
                   AND   Kbd_ShiftState,NOT Kbd_RCtrl
                   JMP   @@HandlerExit

@@kbe4:            CMP   AL,37H      ; sysrq
                   JNZ   @@kbe5
                   MOV   EAX,Kbd_CalledFrom
                   ;CMP   EAX,O KernelEnd
                   ;JB    @@HandlerExit ; dont allow breakpoints inside kernel !
IFDEF NoDebug
                   MOV   BYTE PTR [EAX],0CCH ; int 3 opcode
ELSE
                   CALL  DBG_SetTrap
ENDIF
                   JMP   @@HandlerExit
@@kbe5:
                   TEST  AL,80H
                   JNZ   @@HandlerExit
                   AND   AL,7FH
                   CMP   AL,83
                   JA    @@HandlerExit
                   MOVZX EAX,AL
                   MOV   AL,KeyTable1[EAX]
                   JMP  @@Skip2  ; it must be one of extended keys !
@@HandlerExit:
                   POPAD
                   PUSH  AX
                   MOV   AL,20H
                   OUT   20H,AL  ; send EOI
                   POP   AX
                   STI
@@PauseWait:       TEST  WORD PTR Kbd_ShiftState,Kbd_ScrollLock
                   JNZ   @@PauseWait
                   PopSegs
                   IRETD
Kbd_Handler        ENDP

