.386P
LOCALS @@
JUMPS

Include Common.Def
Include Krnl386.Def

Code16             SEGMENT PARA PUBLIC USE16
                   ASSUME CS:Code16,DS:Code16,ES:Code32,SS:FreeMemory

Start:
                   MOV   CS:PSPSeg,DS
                   MOV   AX,DS:[2CH]
                   MOV   CS:EnvSeg,AX
                   MOV   AX,CS
                   MOV   DS,AX
                   MOV   ES,Code32Seg
                   MOV   DX,O CopyRite
                   MOV   AH,09H
                   INT   21H

                   CALL  DetectProc
                   CALL  DetectSystem
                   CALL  SetupPointers
                   CALL  SetAllInts
                   CALL  SetRemaps

                   MOV   AL,SystemType
                   MOV   ES:SystemFlag,AL
                   CMP   AL,SystemRAW
                   JZ    RAW_Init
                   CMP   AL,SystemXMS
                   JZ    XMS_Init
                   CMP   AL,SystemVCPI
                   JZ    VCPI_Init
                   CMP   AL,SystemDPMI
                   JZ    DPMI_Init


;
; some cool system variables

comment #
standard for real mode
 CS:Code16
 DS:Code16
 ES:Code32
 SS:_STAK
#

RealESP            DD    ? ; real mode ESP
RealSS             DW    ? ; real mode stack, stored when switching to pmode
Code32Seg          DW    Code32 ; segment of code32, to save on exe header
Code32Abs          DD    ?      ; absolute address of code32
KernelTaskAbs      DD    ?      ; absolute address of kerneltask structure
KernelTaskSeg      DW    ?      ; segment of kernel task structure

Prot_GDT           DF    ?      ; protected mode GDT
Prot_IDT           DF    ?      ; protected mode IDT

Real_GDT           DF    ?      ; real mode GDT
Real_IDT           DF    ?      ; real mode IDT

;
; here program ends, errr not quite

; 16 bit pmode, it seems direct switch from 32bit pmode to real mode fucks up
PreRealMode:
                   ProtectedOff
                   DB    0EAH
                   DW    O c_InReal
                   DW    Code16

c_InReal:          MOV   AX,CS
                   MOV   DS,AX
                   MOV   ES,Code32Seg
                   LSS   ESP,FWORD PTR RealESP

                   LGDT  Real_GDT
                   LIDT  Real_IDT
InReal:
                   JMP   ES:GoRealWhere
v_InReal:
                   MOV   AX,CS
                   MOV   DS,AX
                   MOV   ES,Code32Seg
                   LSS   ESP,FWORD PTR RealESP
                   JMP   InReal

d_InReal:          MOV   AX,CS
                   MOV   GS,AX
                   MOV   FS,AX
                   MOV   ES,Code32Seg
                   JMP   InReal


RealBack2DOS:      CMP   SystemType,SystemVCPI
                   JZ    VCPI_Done
                   CMP   SystemType,SystemXMS
                   JZ    XMS_Done
                   CMP   SystemType,SystemRAW
                   JZ    RAW_Done
CleanUpDone:
                   CALL  RestoreRemaps
                   MOV   AX,4C00H
                   INT   21H

;
;this piece is for calling real mode far procedures
DoRealModeProc     PROC  NEAR
                   MOV   GS,CS:Code32Seg

                   MOV   DS,GS:RI_DS
                   MOV   ES,GS:RI_ES

                   MOV   AX,GS:RI_IP
                   MOV   CS:RMC_Offset,AX
                   MOV   AX,GS:RI_CS
                   MOV   CS:RMC_Seg,AX

                   MOV   AL,GS:RI_IntNo
                   MOV   CS:CI_IntNo,AL  ; that is for calling interrupt
                   MOV   EAX,GS:RI_EAX
                   MOV   EBX,GS:RI_EBX
                   MOV   ECX,GS:RI_ECX
                   MOV   EDX,GS:RI_EDX
                   MOV   ESI,GS:RI_ESI
                   MOV   EDI,GS:RI_EDI
                   MOV   EBP,GS:RI_EBP
                   
                   STI

                   DB    9AH  ; far call
RMC_Offset         DW    ?
RMC_Seg            DW    ?

                   CLI

                   MOV   GS,CS:Code32Seg

                   MOV   GS:RI_DS,DS
                   MOV   GS:RI_ES,ES

                   MOV   GS:RI_EAX,EAX
                   MOV   GS:RI_EBX,EBX
                   MOV   GS:RI_ECX,ECX
                   MOV   GS:RI_EDX,EDX
                   MOV   GS:RI_ESI,ESI
                   MOV   GS:RI_EDI,EDI
                   MOV   GS:RI_EBP,EBP
                   PUSHF
                   POP   GS:RI_Flags

                   MOV   AX,CS
                   MOV   DS,AX
                   MOV   ES,Code32Seg

                   MOV   ES:GoProtWhere,O ReturnFromCall

                   JMP   GoPModeProc
DoRealModeProc     ENDP

CallInterrupt      PROC FAR
                   DB   0CDH
CI_IntNo           DB   ?
                   RET
CallInterrupt      ENDP

Comment #
!SetupPointers
  EXPLANATION  : this procedure sets up all 32 bit pointers that
                  will be used in pmode
  INPUT        :
  OUTPUT       :
  SCREWED REGS :
#
SetupPointers      PROC  NEAR
                   MOV   ES,CS:Code32Seg

; here we calc some magic memory ptrs

                   MOVZX ECX,Code32Seg
                   SHL   ECX,4
                   MOV   Code32Abs,ECX
                   MOV   ES:Code32Base,ECX
                   MOV   EBX,0A0000H
                   SUB   EBX,ECX
                   MOV   ES:SegA000,EBX
                   MOV   EBX,0B8000H
                   SUB   EBX,ECX
                   MOV   ES:SegB800,EBX

; setup low heap
                   MOVZX EAX,W CS:PSPSeg
                   DEC   AX
                   MOV   GS,AX
                   ADD   AX,W GS:[3]
                   SHL   EAX,4  ; eax - absolute of Lo mem end
                   SUB   EAX,ECX
                   MOV   ES:LoHeapEnd,EAX
                   MOV   EAX,FreeMemory
                   SHL   EAX,4
                   ADD   EAX,LARGE O LoMemBase ; skip stak
                   SUB   EAX,ECX
                   MOV   ES:LoHeapOrg,EAX
                   MOV   EAX,ES:Code16Seg
                   SHL   EAX,4
                   MOV   ES:Code16Base,EAX

; setup psp segment base
                   MOVZX EAX,PSPSeg
                   SHL   EAX,4
                   MOV   ES:PSPBase,EAX
; setup environment segment base
                   MOVZX EAX,EnvSeg
                   SHL   EAX,4
                   MOV   ES:EnvBase,EAX

; setup Kernel Task Structure
                   PUSH  ES
                   MOV   EAX,(Size TSS)
                   ADD   EAX,32
                   CALL  GetLowMem
                   ADD   EAX,15
                   AND   EAX,0FFFFFFF0H ; align to 16 bytes
                   MOV   KernelTaskAbs,EAX
                   SHR   EAX,4
                   MOV   KernelTaskSeg,AX
                   MOV   ES,AX
                   XOR   DI,DI
                   XOR   AL,AL
                   CLD
                   MOV   CX,(Size TSS)-1
                   REP   STOSB           ; clear all
                   DEC   AL
                   STOSB                 ; last byte is 0FFH
                   MOV   W ES:[TSS_IOMAPAddr],104D ; addy of iomap
                   POP   ES

; calc all the segment descriptors

                   MOV   EAX,Code32Abs
                   MOV   W ES:[Code32Desc+MD_Base0],AX
                   MOV   W ES:[Data32Desc+MD_Base0],AX
                   SHR   EAX,16
                   MOV   B ES:[Code32Desc+MD_Base16],AL
                   MOV   B ES:[Data32Desc+MD_Base16],AL
                   MOV   B ES:[Code32Desc+MD_Base24],AH
                   MOV   B ES:[Data32Desc+MD_Base24],AH

                   MOV   EAX,KernelTaskAbs
                   MOV   W ES:[KrnlTaskDesc+SD_Base0],AX
                   SHR   EAX,16
                   MOV   B ES:[KrnlTaskDesc+SD_Base16],AL
                   MOV   B ES:[KrnlTaskDesc+SD_Base24],AH

                   MOV   EAX,ES:Code16Base
                   MOV   W ES:[RetRealCode+MD_Base0],AX
                   MOV   W ES:[RetRealData+MD_Base0],AX
                   SHR   EAX,16
                   MOV   B ES:[RetRealCode+MD_Base16],AL
                   MOV   B ES:[RetRealData+MD_Base16],AL
                   MOV   B ES:[RetRealCode+MD_Base24],AH
                   MOV   B ES:[RetRealData+MD_Base24],AH

                   ; initialize Prot_GDT and Prot_IDT
                   MOV   EBX,O GDT
                   ADD   EBX,Code32Abs
                   MOV   D Prot_GDT+2,EBX
                   MOV   W Prot_GDT,10*8-1  ; we have 10 descriptors

                   MOV   EBX,O IDT
                   ADD   EBX,Code32Abs
                   MOV   D Prot_IDT+2,EBX
                   MOV   W Prot_IDT,256*8-1 ; we have 256 intr,
                                                   ; although not all
                                                   ; are used :)
; setup some buffers
; Protected mode stack
                   MOV   EAX,ProtectedStak*8
                   CALL  GetLowMem
                   ADD   EAX,ProtectedStak*8
                   SUB   EAX,Code32Abs
                   AND   AL,11111100B ; make it dword aligned, huh ?
                   MOV   ES:GoProtStack,EAX

; disk i/o buffer
                   MOV   EAX,DiskBufferSize
                   CALL  GetLowMem                 ; get somem mem for it
                   MOV   EBX,EAX
                   SUB   EBX,Code32Abs             ; do Code32 based addy
                   MOV   ES:DiskBuffer,EBX         ; store it
                   MOV   BX,AX
                   AND   BX,0FH                    ; make ofs
                   SHR   EAX,4                     ; make seg
                   SHL   EAX,16
                   MOV   AX,BX                     ; let it be one
                   MOV   ES:DiskBufferReal,EAX     ; store

                   RET
SetupPointers      ENDP

Comment #
!SetupHighHeap
  EXPLANATION  : this procedure sets up high heap variables
  INPUT        : HiBlockAbs, FreeExtMem
  OUTPUT       : HiHeapOrg,HiHeapEnd
  SCREWED REGS :
#
SetupHighHeap      PROC  NEAR
                   MOV   ECX,Code32Abs
                   MOV   ES,Code32Seg
                   MOV   EAX,HiBlockAbs
                   SUB   EAX,ECX
                   MOV   ES:HiHeapOrg,EAX
                   MOVZX EAX,FreeExtMem
                   SHL   EAX,10
                   ADD   EAX,HiBlockAbs
                   SUB   EAX,ECX
                   MOV   ES:HiHeapEnd,EAX
                   RET
SetupHighHeap      ENDP

; interrupt remapper
;

RemapHandler       MACRO IrqNum,IntNum
ReMap_IRQ&IrqNum&: PUSH  BX
                   MOV   BX,IntNum*4
                   JMP   RemapperCode
                   ENDM

RemapHandler 0,08H
RemapHandler 1,09H
RemapHandler 2,0AH
RemapHandler 3,0BH
RemapHandler 4,0CH
RemapHandler 5,0DH
RemapHandler 6,0EH
RemapHandler 7,0FH
RemapHandler 8,70H
RemapHandler 9,71H
RemapHandler A,72H
RemapHandler B,73H
RemapHandler C,74H
RemapHandler D,75H
RemapHandler E,76H
RemapHandler F,77H

RemapperCode       PROC NEAR
                   PUSH EAX
                   PUSH ES
                   MOV  AX,0
                   MOV  ES,AX
                   MOV  EAX,D ES:[BX]
                   MOV  CS:@@JumpAddy,EAX
                   POP  ES
                   POP  EAX
                   POP  BX
                   JMP  @@Here ; fuck da queue
@@Here:
                   DB   0EAH  ; jump far
@@JumpAddy         DD   ?
RemapperCode       ENDP

ReMapAddys         DW   O ReMap_IRQ0
                   DW   O ReMap_IRQ1
                   DW   O ReMap_IRQ2
                   DW   O ReMap_IRQ3
                   DW   O ReMap_IRQ4
                   DW   O ReMap_IRQ5
                   DW   O ReMap_IRQ6
                   DW   O ReMap_IRQ7
                   DW   O ReMap_IRQ8
                   DW   O ReMap_IRQ9
                   DW   O ReMap_IRQA
                   DW   O ReMap_IRQB
                   DW   O ReMap_IRQC
                   DW   O ReMap_IRQD
                   DW   O ReMap_IRQE
                   DW   O ReMap_IRQF

RemapBackup        DD   16 DUP(0)

Comment #
!SetRemaps
  EXPLANATION  : sets up all real mode IRQ redirector ints
  INPUT        :
  OUTPUT       :
  SCREWED REGS :
#
SetRemaps          PROC NEAR
                   CMP  SystemType,SystemDPMI
                   JZ   @@druut
                   XOR  AX,AX
                   MOV  ES,AX
                   MOV  SI,O ReMapAddys
                   MOV  DI,IRQ0Base*4
                   MOV  CX,16
                   MOV  BX,O RemapBackup
                   CLD
@@Here:            LODSW
                   SHL  EAX,16
                   MOV  AX,CS
                   ROL  EAX,16
                   XCHG EAX,D ES:[DI]
                   MOV  D [BX],EAX
                   ADD  DI,4
                   ADD  BX,4
                   LOOP @@Here
                   MOV  ES,Code32Seg
@@druut:           RET
SetRemaps          ENDP

Comment #
!RestoreRemaps
  EXPLANATION  : restore interrupt vectors used by irq remappers
  INPUT        :
  OUTPUT       :
  SCREWED REGS :
#
RestoreRemaps      PROC  NEAR
                   MOV   SI,O RemapBackup
                   MOV   DI,IRQ0Base*4
                   MOV   CX,16
                   CLD
                   XOR   AX,AX
                   MOV   ES,AX
                   PUSH  CS
                   POP   DS
                   REP   MOVSD
                   MOV   ES,Code32Seg
                   RET
RestoreRemaps      ENDP

;
; code to setup all kernel ints

KrnlIntTbl         LABEL DWORD
IFNDEF xTiny
                   DD      O Exception00
                   DD      O Exception01
                   DD      O Exception02
                   DD      O Exception03
                   DD      O Exception04
                   DD      O Exception05
                   DD      O Exception06
                   DD      O Exception07
                   DD      O Exception08
                   DD      O Exception09
                   DD      O Exception0A
                   DD      O Exception0B
                   DD      O Exception0C
                   DD      O Exception0D
                   DD      O Exception0E
                   DD      O Exception0F
                   DD      O Exception10
                   DD      O Exception11
ENDIF
;                   DD      14 DUP(O Reserved)   ; 20H
;                   DD      60H DUP(O NullInt)   ; 80H
                                                  ; available for your use
                   DD      O Forward00            ; here irqs start
                   DD      O Kbd_Handler
                   DD      O Forward02
                   DD      O Forward03
                   DD      O Forward04
                   DD      O Forward05
                   DD      O Forward06
                   DD      O Forward07
                   DD      O Forward08
                   DD      O Forward09
                   DD      O Forward0A
                   DD      O Forward0B
                   DD      O Forward0C
                   DD      O Forward0D
                   DD      O Forward0E
                   DD      O Forward0F

Comment #
!SetAllInts
  EXPLANATION  : sets up all protected mode interrupt handlers
  INPUT        :
  OUTPUT       :
  SCREWED REGS :
#
SetAllInts         PROC NEAR
                   CMP  SystemType,SystemDPMI
                   JZ   @@druut
                   MOV  ES,Code32Seg
                   MOV  EDI,O IDT
                   MOV  SI,O KrnlIntTbl
                   CLD
                   MOV  CX,12H
IFDEF xTiny
@@Here:            MOV  EAX,O Exception ; common exception handler
                   CALL NEAR PTR @@setkint
                   LOOP @@Here
ELSE
@@Here:            LODSD
                   CALL NEAR PTR @@setkint
                   LOOP @@Here
ENDIF

                   MOV  CX,14          ; till int 20h
@@Here2:           MOV  EAX,O Reserved ; intel reserved int
                   CALL NEAR PTR @@setkint
                   LOOP @@Here2

                   MOV  CX,60H          ; till int 80h
@@Here3:           MOV  EAX,O NullInt   ; null int, just iret
                   CALL NEAR PTR @@setkint
                   LOOP @@Here3

                   MOV  CX,10H          ; 16 default irq handlers
@@Here4:           LODSD
                   CALL NEAR PTR @@setkint
                   LOOP @@Here4
                   RET

@@setkint:         MOV  ES:[DI.G_Offs0],AX
                   SHR  EAX,16
                   MOV  ES:[DI.G_Offs16],AX
                   ADD  DI,8
@@druut:
                   RET
SetAllInts         ENDP

;
; callback code

CBOldSP            DW   ?
CBOldSS            DW   ?

CallBackM          MACRO CBNum,IntNum
CallBackVec&CBNum&:
                   CLI
                   PUSHAD
                   MOV  AL,IntNum
                   JMP  CallBackCommon
                   ENDM

CallBackM 0,0
CallBackM 1,1
CallBackM 2,2
CallBackM 3,3
CallBackM 4,4
CallBackM 5,5
CallBackM 6,6
CallBackM 7,7
CallBackM 8,8
CallBackM 9,9
CallBackM A,10
CallBackM B,11
CallBackM C,12
CallBackM D,13
CallBackM E,14
CallBackM F,15

CallBackCommon     PROC  NEAR
                   PUSH  DS
                   PUSH  ES
                   PUSH  FS
                   PUSH  GS

                   PUSH  CS
                   POP   DS
                   MOV   ES,Code32Seg
                   MOV   ES:CallBackNumber,AL
                   MOV   ES:GoProtWhere,O CallBack

                   MOV   CBOldSS,SS
                   MOV   CBOldSP,SP
                   JMP   GoPModeProc

; here we return from protected mode
ReturnFromCB:      MOV   SS,CBOldSS
                   MOV   SP,CBOldSP

                   POP   GS
                   POP   FS
                   POP   ES
                   POP   DS
                   POPAD
                   IRET
CallBackCommon     ENDP

Forwarder          PROC  NEAR
                   XOR   BX,BX
                   MOV   DS,BX
                   MOV   BL,ES:ForwardInt
                   SHL   BX,2
                   PUSHF
                   CALL  D [BX]
                   MOV   AX,CS
                   MOV   DS,AX
                   MOV   ES:GoProtWhere,O ForwardRet
                   JMP   GoPModeProc
Forwarder          ENDP

Comment #
!DetectV86
  EXPLANATION  : checks if processor is in V86 mode
  INPUT        :
  OUTPUT       :
  SCREWED REGS :
#
comment #
DetectV86          PROC  NEAR
                   SMSW  AX
                   TEST  AL,1
                   JNZ   @@AlreadyV86
                   RET
@@AlreadyV86:      MOV   DX,O ErrMsg1
                   JMP   ExitErrMsg
DetectV86          ENDP
#
Comment #
!DetectProc
  EXPLANATION  : checks if processor is 386 or better
  INPUT        :
  OUTPUT       :
  SCREWED REGS :
#
DetectProc         PROC  NEAR
                   PUSHF                     ; store flag register for later
                   PUSHF                     ; save flags
                   POP   BX                  ; store flags in bx
                   AND   BX,0FFFH            ; clear bits 12-15
                   PUSH  BX                  ; store on stack
                   POPF                      ; pop into flags
                   PUSHF                     ; store flags on stack
                   POP   AX                  ; recover flags

                   AND   AX,0F000H           ; if bits 12-15 are set the it is a 8086
                   CMP   AX,0F000H
                   JZ    @@No386Detected     ; this is 8086

                   OR    BX,0F000H           ; try to set flag bits 12-15
                   PUSH  BX                  ; store on stack
                   POPF                      ; load into flags
                   PUSHF                     ; store flags on stack
                   POP   AX                  ; load flags in to ax

                   AND   AX,0F000H           ; if bits 12-15 are clear, it is a 80286
                   JZ    @@No386Detected     ; this is 80286

                                             ; otherwise it must be a 386 or 486...
                   POPF                      ; recover flag register
                   RET

@@No386Detected:   POPF
                   MOV  DX,O ErrMsg0
                   JMP  ExitErrMsg

DetectProc         ENDP


Comment #
!DetectSystem
  EXPLANATION  : detect system type (raw, xms, vcpi, dpmi)
  INPUT        : none
  OUTPUT       : SystemType variable
  SCREWED REGS :
#
DetectSystem       PROC NEAR
@@detectDPMI       MACRO
; detect DPMI
                   MOV  AX,1687H
                   INT  2FH
                   OR   AX,AX
                   JNZ  @@NoDPMI
                   TEST BX,1
                   JZ   @@NoDPMI
                   ADD  B DPMI_VerHi,DH
                   MOV  AL,DL
                   AAM
                   ADD  B DPMI_VerLo,AH
                   ADD  B DPMI_VerLo+1,AL
                   MOV  DPMIPages,SI
                   MOV  W DPMISwitchAddr,DI
                   MOV  W DPMISwitchAddr+2,ES
                   MOV  SystemType,SystemDPMI
                   JMP  @@ProcExit
@@NoDPMI:
                   ENDM

@@detectVCPI       MACRO
; first lets detect VCPI
                   XOR  AX,AX
                   MOV  ES,AX
                   LES  BX,ES:[67H*4]
                   MOV  BX,0AH
                   ; EMMXXXX0
                   ; EMMQXXX0
                   CMP  D ES:[BX],'XMME'
                   JZ   @@VCPICont
                   CMP  D ES:[BX],'QMME' ; quiet ???, emm386 sets it
                                         ; this way when NOEMS selected
                   JNZ  @@NoVCPI
@@VCPICont:
                   CMP  D ES:[BX+4],'0XXX'
                   JNZ  @@NoVCPI
                   ; well, at least we have EMS driver
                   MOV  AX,4300H
                   MOV  BX,1
                   INT  67H ; allocate one EMS page to turn on vcpi
                   OR   AH,AH
                   JNZ  @@NoVCPI
                   MOV  v_DummEMSPage,DX

                   MOV  AX,0DE00H
                   INT  67H
                   OR   AH,AH
                   JNZ  @@NoVCPI   ; well, no vcpi respond

                   ; lets now check if we can survive current irq mappings
                   MOV  AX,0DE0AH ;  get irq mappings
                   INT  67H
                   CMP  BX,8
                   MOV  BH,CL
                   CMP  BX,7008H
                   JZ   @@IRQSOK
                   MOV  DX,O ErrMsg9
                   JMP  ExitErrMsg
@@IRQSOK:
                   MOV  SystemType,SystemVCPI
                   JMP  @@ProcExit
@@NoVCPI:
                   ENDM

                   @@detectVCPI
                   @@detectDPMI
                   ; now check if V86
                   SMSW  AX
                   TEST  AL,1
                   JZ    @@CheckMore
                   ; well, we are in V86 but we are not VCPI nor DPMI
                   MOV   DX,O ErrMsg8
                   JMP   ExitErrMsg
@@CheckMore:
                   MOV   AX,CS
                   MOV   DS,AX
                   MOV   AX,4300H
                   INT   2FH
                   CMP   AL,80H        ; does XMS driver exist
                   JNZ   @@NoXMS
                   MOV   SystemType,SystemXMS
                   JMP   @@ProcExit
@@NoXMS:           MOV   SystemType,SystemRAW
@@ProcExit:
                   RET
DetectSystem       ENDP

Comment #
!GetLowMem
  EXPLANATION  : allocate some low memory from low memory pool
                  using bottom up allocation scheme
                  if allocation is unsuccesfull, then exit to dos
                  !this function should be used only for allocating
                  internal structures during system initialization!
  INPUT        : EAX - bytes requested
  OUTPUT       : EAX - linear, zero based address of allocated memory
  SCREWED REGS : none
#

GetLowMem          PROC  NEAR
                   PUSH  EBX
                   PUSH  ES
                   MOV   ES,Code32Seg
                   MOV   EBX,ES:LoHeapOrg
                   ADD   EAX,EBX
                   CMP   EAX,ES:LoHeapEnd
                   JAE   @@TooBad
                   MOV   ES:LoHeapOrg,EAX
                   MOV   EAX,EBX
                   ADD   EAX,ES:Code32Base
                   POP   ES
                   POP   EBX
                   RET
@@TooBad:          POP   ES
                   POP   EBX
                   MOV   DX,O ErrMsg7
                   JMP   ExitErrMsg
GetLowMem          ENDP

Comment #
!SetPICVectorz
  EXPLANATION  : setup IRQ bases for PIC  0 and 1
                  ripped from tran :)
  INPUT        : BL - base int for PIC0, BH - base int for PIC1
  OUTPUT       :
  SCREWED REGS :
#
SetPICVectorz      PROC  NEAR
                   PUSHFD
                   CLI
                   MOV   AL,11H    ;  BL - LOW VEKTOR BASE #
                   OUT   20H,AL    ;  BH - HIGH VEKTOR BASE #
                   IOWAIT
                   MOV   AL,BL
                   OUT   21H,AL
                   IOWAIT
                   MOV   AL,4H
                   OUT   21H,AL
                   IOWAIT
                   MOV   AL,1H
                   OUT   21H,AL
                   IOWAIT
                   MOV   AL,11H
                   OUT   0A0H,AL
                   IOWAIT
                   MOV   AL,BH
                   OUT   0A1H,AL
                   IOWAIT
                   MOV   AL,2H
                   OUT   0A1H,AL
                   IOWAIT
                   MOV   AL,1H
                   OUT   0A1H,AL
                   POPFD
                   RET
SetPICVectorz      ENDP

;
; RAW mode functions and variables
RAW_EnableA20      DW   O RAW_ATEnableA20
RAW_DisableA20     DW   O RAW_ATDisableA20
RAW_DoDisable      DB   TRUE  ; well, if a20 is already enabled do not disable
                              ; it on exit

RAW_Empty8042      PROC NEAR
                   PUSH CX
                   MOV  CX,0FFFFH
@@wait:            IN   AL,64H     ; wait till 8042 buffer empty
                   TEST AL,2
                   LOOPNZ @@wait
                   POP  CX
                   RET
RAW_Empty8042      ENDP

RAW_TestA20        PROC NEAR
                   XOR  AX,AX
                   MOV  FS,AX
                   DEC  AX
                   MOV  GS,AX
                   MOV  AL,B FS:[0]
                   MOV  AH,AL
                   NOT  AL
                   MOV  B GS:[10H],AL
                   CMP  AH,B FS:[0]
                   MOV  B FS:[0],AH
                   ; ZF = 1 A20 enabled
                   ; ZF = 0 A20 disabled
                   RET
RAW_TestA20        ENDP

RAW_ATEnableA20    PROC NEAR
                   PUSHF
                   CLI
                   CALL RAW_Empty8042
                   JNZ  @@fuckedup ; well, timeout

                   MOV  AL,0D1H
                   OUT  64H,AL
                   CALL RAW_Empty8042
                   JNZ  @@fuckedup ; well, timeout

                   MOV  AL,0DFH    ; enable a20
                   OUT  60H,AL
                   CALL RAW_Empty8042
                   JNZ  @@fuckedup ; well, timeout

                   MOV  AL,0FFH ; ???, himem does it
                                ; 'Send FFh (Pulse Output Port NULL)'
                   OUT  64H,AL
                   CALL RAW_Empty8042
                   JNZ  @@fuckedup ; well, timeout

@@okiedokie:       POPF
                   CLC
                   RET
@@fuckedup:        POPF
                   STC
                   RET
RAW_ATEnableA20    ENDP

RAW_ATDisableA20   PROC NEAR
                   PUSHF
                   CLI

                   CALL RAW_Empty8042
                   JNZ  @@fuckedup ; well, timeout

                   MOV  AL,0D1H
                   OUT  64H,AL
                   CALL RAW_Empty8042
                   JNZ  @@fuckedup ; well, timeout

                   MOV  AL,0DDH    ; disable a20
                   OUT  60H,AL
                   CALL RAW_Empty8042
                   JNZ  @@fuckedup ; well, timeout

                   MOV  AL,0FFH ; ???, himem does it
                                ; 'Send FFh (Pulse Output Port NULL)'
                   OUT  64H,AL
                   CALL RAW_Empty8042
                   JNZ  @@fuckedup ; well, timeout

@@okiedokie:       POPF
                   CLC
                   RET
@@fuckedup:        POPF
                   STC
                   RET
RAW_ATDisableA20   ENDP

RAW_PS2EnableA20   PROC  NEAR
                   PUSHF
                   CLI
                   IN    AL,92H
                   OR    AL,2
                   IOWAIT
                   IOWAIT
                   IOWAIT
                   OUT   92H,AL
                   XOR   CX,CX
@@Wait:            IN    AL,92H
                   TEST  AL,2
                   LOOPZ @@Wait
                   JZ    @@fuckedup
@@okiedokie:       POPF
                   CLC
                   RET
@@fuckedup:        POPF
                   STC
                   RET
RAW_PS2EnableA20   ENDP

RAW_PS2DisableA20  PROC  NEAR
                   PUSHF
                   CLI
                   IN    AL,92H
                   AND   AL,NOT 2
                   IOWAIT
                   IOWAIT
                   IOWAIT
                   OUT   92H,AL
                   XOR   CX,CX
@@Wait:            IN    AL,92H
                   TEST  AL,NOT 2
                   LOOPNZ @@Wait
                   JNZ   @@fuckedup
@@okiedokie:       POPF
                   CLC
                   RET
@@fuckedup:        POPF
                   STC
                   RET
RAW_PS2DisableA20  ENDP

; CF=0 no ps2
; CF=1 ps2
RAW_IsPS2          PROC  NEAR
                   MOV   AH,0C0H ; get system description vector
                   STC
                   INT   15H
                   JC    @@nops2
                   MOV   AL,B ES:[BX+5]
                   TEST  AL,2 ; is it micro channel computer ?
                   JZ    @@nops2
@@ps2:             STC
                   RET
@@nops2:           CLC
                   RET
RAW_IsPS2          ENDP

; CF = 0 no hp vectra
; CF = 1 hp vectra
RAW_IsHP           PROC  NEAR
                   PUSH  ES
                   MOV   AX,0F000H
                   MOV   ES,AX
                   CMP   W ES:[0F8H],'PH'
                   POP   ES
                   JNZ   @@nohp
@@hp:              STC
                   RET
@@nohp:            CLC
                   RET
RAW_IsHP           ENDP

RAW_HPEnableA20    PROC  NEAR
                   PUSHF
                   CLI
                   CALL  RAW_Empty8042
                   JNZ   @@fuckedup

                   REPT  2
                   MOV   AL,0DFH
                   OUT   64H,AL
                   CALL  RAW_Empty8042
                   JNZ   @@fuckedup
                   ENDM
@@okiedokie:       POPF
                   CLC
                   RET
@@fuckedup:        POPF
                   STC
                   RET
RAW_HPEnableA20    ENDP

RAW_HPDisableA20   PROC  NEAR
                   PUSHF
                   CLI
                   CALL  RAW_Empty8042
                   JNZ   @@fuckedup

                   REPT  2
                   MOV   AL,0DDH
                   OUT   64H,AL
                   CALL  RAW_Empty8042
                   JNZ   @@fuckedup
                   ENDM
@@okiedokie:       POPF
                   CLC
                   RET
@@fuckedup:        POPF
                   STC
                   RET
RAW_HPDisableA20   ENDP

RAW_Int15Handler   PROC  NEAR
                   CMP   AH,88H
                   JNZ   @@NotMine
                   XOR   AX,AX
                   IRET
@@NotMine:
                   DB    0EAH ; jump far
RAW_Old15          DD    ?
RAW_Int15Handler   ENDP

RAW_Banner         DB    '  RAW system',0DH,0AH,'$'
RAW_Init           PROC  NEAR
                   MOV   DX,O RAW_Banner
                   MOV   AH,09H
                   INT   21H

                   MOV   RAW_DoDisable,FALSE
                   CALL  RAW_TestA20
                   JZ    @@enok ; A20 is already enabled,
                                ; no need to fuck up with it
                   MOV   RAW_DoDisable,TRUE
                   CALL  RAW_IsHP
                   JNC   @@NotHP
                   MOV   RAW_EnableA20,O RAW_HPEnableA20
                   MOV   RAW_DisableA20,O RAW_HPDisableA20
@@NotHP:           CALL  RAW_IsPS2
                   JNC   @@DoEnable
                   MOV   RAW_EnableA20,O RAW_PS2EnableA20
                   MOV   RAW_DisableA20,O RAW_PS2DisableA20
@@DoEnable:
                   CALL  RAW_EnableA20
                   JNC   @@enok
@@enableerr:       MOV   DX,O ErrMsg3 ; cannot enable A20
                   JMP   ExitErrMsg

@@enok:            CALL  RAW_TestA20
                   JNZ   @@enableerr
                   MOV   AH,88H
                   INT   15H
                   ; now we must make sure that ext mem counts in pages :)
                   AND   AX,1111111111111100B
                   MOV   FreeExtMem,AX
                   OR    AX,AX
                   JNZ   @@memok
                   MOV   DX,O ErrMsg4  ; no ext memory
                   JMP   ExitErrMsg
@@memok:           MOV   HiBlockAbs,100000H   ; ext mem begins at 1 meg

                   XOR   AX,AX
                   MOV   ES,AX
                   MOV   EAX,D ES:[15H*4]
                   MOV   RAW_Old15,EAX

                   MOV   AX,CS
                   SHL   EAX,16
                   MOV   AX,O RAW_Int15Handler
                   MOV   D ES:[15H*4],EAX
                   CALL  common_SetupPaging
                   CALL  SetupHighHeap
                   JMP   common_Init
RAW_Init           ENDP

RAW_Done           PROC  NEAR
                   MOV   BX,7008H
                   CALL  SetPICVectorz
                   STI
                   CMP   RAW_DoDisable,TRUE
                   JNZ   @@DontDisable
                   CALL  RAW_DisableA20

@@DontDisable:     XOR   AX,AX
                   MOV   ES,AX
                   MOV   EAX,RAW_Old15
                   MOV   D ES:[15H*4],EAX
                   JMP   CleanUpDone
RAW_Done           ENDP

;
; XMS mode functions and variables

XMSHandle          DW   ?
XMSControl         DD   ?   ; pointer to xms driver

XMS_DisableA20     PROC NEAR
                   MOV  AH,06H
                   CALL D XMSControl
                   RET
XMS_DisableA20     ENDP

XMS_DeAllocBlok    PROC NEAR
                   MOV  AH,0AH
                   MOV  DX,XMSHandle
                   CALL D XMSControl
                   RET
XMS_DeAllocBlok    ENDP

XMS_UnlockBlok     PROC NEAR
                   MOV  AH,0DH
                   MOV  DX,XMSHandle
                   CALL D XMSControl
                   RET
XMS_UnlockBlok     ENDP

XMS_Banner         DB    '  XMS system',0DH,0AH,'$'
XMS_Init           PROC  NEAR
                   MOV   DX,O XMS_Banner
                   MOV   AH,09H
                   INT   21H

                   MOV   AX,4310H
                   INT   2FH           ; fetch driver address
                   MOV   W [XMSControl],BX
                   MOV   W [XMSControl+2],ES
                   MOV   AH,5H         ; local enable a20
                   CALL  D XMSControl
                   OR    AX,AX
                   JNZ   @@A20Enabled
                   MOV   DX,O ErrMsg3
                   JMP   ExitErrMsg
@@A20Enabled:      MOV   AH,08H        ; query free extended memory
                   CALL  D XMSControl
                   OR    AX,AX
                   JNZ   @@HImemOK
@@MemoryErr:       CALL  XMS_DisableA20
                   MOV   DX,O ErrMsg4
                   JMP   ExitErrMsg
@@HImemOK:         MOV   FreeExtMem,AX
                   MOV   DX,AX
                   MOV   AH,09H        ; alloc hi memory
                   CALL  D XMSControl
                   OR    AX,AX
                   JNZ   @@AllocOK
                   CALL  XMS_DisableA20
                   MOV   DX,O ErrMsg5
                   JMP   ExitErrMsg
@@AllocOK:         MOV   XMSHandle,DX
                   MOV   AH,0CH        ; lock xms block
                   CALL  D XMSControl
                   OR    AX,AX
                   JNZ   @@LockOK
                   CALL  XMS_DeAllocBlok
                   CALL  XMS_DisableA20
                   MOV   DX,O ErrMsg6
                   JMP   ExitErrMsg
@@LockOK:          MOV   W HiBlockAbs,BX
                   MOV   W HiBlockAbs+2,DX
                   ; a20 is enabled and
                   ; extended memory is now allocated, locked
; nice, now we must assure that high heap is page aligned
                   MOV   EAX,HiBlockAbs
                   MOVZX EDX,W FreeExtMem
                   SHL   EDX,10 ; * 1024
                   ADD   EDX,EAX  ; hi block end
                   ADD   EAX,4095
                   AND   EAX,0FFFFF000H
                   MOV   HiBlockAbs,EAX
                   AND   EDX,0FFFFF000H
                   SUB   EDX,EAX
                   SHR   EDX,10
                   MOV   FreeExtMem,DX
                   CALL  common_SetupPaging
                   CALL  SetupHighHeap

common_Init:       CLI
                   MOV   BX,8880H
                   CALL  SetPICVectorz
                   MOV   EAX,O HyperSpace
                   MOV   HyperJumpData,AX
                   MOV   ES,Code32Seg
                   MOV   ES:GoRealProc,O c_GoReal
                   MOV   ES:GoProtWhere,O CommonEntry
                   MOV   GoPModeProc,O c_GoPMode

c_GoPMode:         CLI
                   ;DriveMotorOff
                   MOV   RealESP,ESP
                   MOV   RealSS,SS

                   ; set kernel task as available
                   MOV   AL,B ES:[KrnlTaskDesc+SD_Access]
                   AND   AL,NOT (MASK SDA_Type)
                   OR    AL,DT_Avail_TSS386
                   MOV   B ES:[KrnlTaskDesc+SD_Access],AL

                   SIDT  Real_IDT
                   SGDT  Real_GDT

                   LIDT  Prot_IDT
                   LGDT  Prot_GDT

                   ProtectedOn  ; switch to protected mode

                   DB    0EAH    ; jump to Code32:HyperSpace
HyperJumpData      DW    0,_SelCode32
XMS_Init           ENDP

XMS_Done           PROC NEAR
                   MOV   BX,7008H
                   CALL  SetPICVectorz
                   STI
                   CALL  XMS_UnlockBlok
                   CALL  XMS_DeAllocBlok
                   CALL  XMS_DisableA20
                   JMP   CleanUpDone
XMS_Done           ENDP

common_SetupPaging PROC  NEAR
                   MOV   ES,Code32Seg
                   MOVZX EBX,FreeExtMem ; in kb
                   SHL   EBX,10         ; * 1024
                   ADD   EBX,HiBlockAbs ; mem top
                   SHR   EBX,12         ; number of pages needed
                   MOV   EAX,EBX
                   ADD   EAX,1023
                   SHR   EAX,10         ; number of 4mb pages required by system
                   MOV   EDX,EAX        ; (maxpages)
                   MOV   MaxPages,EAX
                   ADD   EAX,3
                         ; page directory +
                         ; maxpages for system memory +
                         ; extra page (for user like vesa linear framebuffer interface) +
                         ; align
                   SHL   EAX,12         ; mem for pages
                   CALL  GetLowMem
                   ADD   EAX,4095
                   AND   EAX,0FFFFF000H
                   MOV   v_PageDirLinear,EAX
                   MOV   ES:PageDirBase,EAX
                   PUSH  EAX
                   ADD   EAX,4096
                   MOV   ES:Page1stBase,EAX
                   MOV   ECX,EDX
                   SHL   ECX,12   ; allocated pages * 4096
                   ADD   EAX,ECX
                   MOV   ES:PageExtraBase,EAX
                   POP   EAX
                   SHR   EAX,4
                   MOV   v_PageDirSeg,AX
                   MOV   ES,AX ; page dir segment
                   XOR   DI,DI
                   XOR   EAX,EAX
                   MOV   ECX,EDX
                   ADD   ECX,2
                   SHL   ECX,10  ; (maxpages+2) * 1024
                   CLD
                   REP   STOSD   ; clear those pages

                   MOV   ECX,EBX ; number of pages to alloc
                   MOV   EAX,000000000111B ; user,read and write,present
                                           ; linear address 0
                   MOV   DI,4096 ; page 0
                   CLD
                   PUSH  ES
@@AllocNext:       STOSD
                   ADD   EAX,4096
                   TEST  DI,15
                   JNZ   @@algn
                   SUB   DI,16
                   PUSH  AX
                   MOV   AX,ES
                   INC   AX
                   MOV   ES,AX
                   POP   AX
@@algn:
                   LOOP  @@AllocNext
                   MOV   v_AllocatedPages,EBX
                   POP   ES

; now we set up page directory
                   MOV   EAX,v_PageDirLinear
                   AND   EAX,0FFFFF000H
                   OR    EAX,000000000111B
                   MOV   ECX,EDX ; maxpages
                   MOV   DI,0
                   CLD
@@SetUpPD:         ADD   EAX,4096
                   STOSD
                   LOOP  @@SetUpPD

                   MOV   ES,Code32Seg
                   RET
common_SetupPaging ENDP

;
; VCPI mode functions and variables

v_PageDirSeg       DW    ?
; here begins nice structure that will be passed to VCPI for mode switch
v_PageDirLinear    DD    ?  ; linear address of page directory
v_LineOfGDTR       DD    ?  ; linear address of value to put to GDTR
v_LineOfIDTR       DD    ?  ; linear address of value to put to IDTR
                   DW    0  ; selector to put to LDTR
                   DW    SelKernelTask ; selector of kernel task
v_GoProtAddy       DD    O v_HyperSpace
                   DW    _SelCode32
; end of that nice structure

v_AllocatedPages   DD    0
v_MyFirstPage      DW    ?
v_DummEMSPage      DW    0FFFFH
MaxPages           DD    ?

VCPI_Banner        DB    '  VCPI system',0DH,0AH,'$'
VCPI_Init          PROC  NEAR
                   MOV   DX,O VCPI_Banner
                   MOV   AH,09H
                   INT   21H
                   ; this procedure allocates all memory under VCPI
                   ; then goes into protected mode

                   ; check out for ext mem

                   MOV   AX,0DE03H
                   INT   67H       ; get free vcpi pages
                   OR    EDX,EDX
                   JNZ   @@SomeMem
                   MOV   DX,O ErrMsg4
                   JMP   ExitErrMsg
@@SomeMem:
                   ADD   EDX,1024+1023 ; vcpi prog + round up
                   SHR   EDX,10        ; edx is maxpages
                   MOV   MaxPages,EDX
                   MOV   EAX,EDX
                   ADD   EAX,3
                         ; page dir + extra + align
                   SHL   EAX,12
                   ;MOV   EAX,(1+MaxPages+1+1) * 4096
                         ; page directory +
                         ; maxpages for system memory +
                         ; extra page (for user) +
                         ; align
                   CALL  GetLowMem
                   ADD   EAX,4095
                   AND   EAX,0FFFFF000H
                   MOV   v_PageDirLinear,EAX
                   MOV   ES,Code32Seg
                   MOV   ES:PagingOn,True
                   MOV   ES:PageDirBase,EAX
                   PUSH  EAX
                   ADD   EAX,4096
                   MOV   ES:Page1stBase,EAX
                   ;ADD   EAX,MaxPages*4096
                   SHL   EDX,12  ; * 4096
                   ADD   EAX,EDX
                   MOV   ES:PageExtraBase,EAX
                   POP   EAX
                   SHR   EAX,4
                   MOV   v_PageDirSeg,AX
                   MOV   ES,AX
                   XOR   DI,DI
                   XOR   EAX,EAX
                   MOV   CX,W MaxPages
                   ADD   CX,2
                   SHL   CX,10
                   ;MOV   CX,(2+MaxPages)*1024
                   CLD
                   REP   STOSD   ; clean those pages

                   MOV   DI,4096 ; address of 0th page table
                   MOV   DS,CS:Code32Seg
                   MOV   ESI,O VCPICode
                   MOV   AX,0DE01H ; get VCPI interface
                   INT   67H
                   MOV   AX,CS
                   MOV   DS,AX
                   MOV   ES,Code32Seg
                   MOV   D ES:v_HostEntry,EBX
; now we need to allocate some memory
                   MOV   ES,v_PageDirSeg
                   MOV   v_MyFirstPage,DI
                   SUB   DI,4096
                   SHR   DI,2
                   ;MOV   SI,MaxPages*1024
                   MOV   SI,W MaxPages
                   SHL   SI,10
                   SUB   SI,DI
                   MOVZX ESI,SI    ; number of free slots
                   MOV   AX,0DE03H ; get number of free pages
                   INT   67H
                   MOV   ECX,EDX
                   CMP   ECX,ESI
                   JL    @@Skip1
                   MOV   ECX,ESI   ; ECX = Min(Free slots,free pages)
@@Skip1:
                   MOVZX EDI,v_MyFirstPage
                   MOV   EAX,EDI
                   SUB   EAX,4096
                   SHL   EAX,10    ; linear adress of ext mem
                   MOV   HiBlockAbs,EAX
                   MOV   EAX,ECX
; now, lets start allocing mem
                   MOV   v_AllocatedPages,0

                   PUSH  ES
@@AllocNext:       MOV   AX,0DE04H ; allocate page
                   INT   67H
                   OR    AH,AH
                   JNZ   @@liar
                   AND   EDX,0FFFFF000H
                   OR    EDX,000000000111B ; user,read and write,present
                   MOV   ES:[DI],EDX
                   ADD   DI,4
                   TEST  DI,15
                   JNZ   @@algn
                   SUB   DI,16
                   MOV   AX,ES
                   INC   AX
                   MOV   ES,AX
@@algn:
                   INC   v_AllocatedPages
                   LOOP  @@AllocNext

                   JMP   @@okiedokie
@@liarmes          DB    '  VCPI lies about free memory!',0DH,0AH,'$'
@@liar:            MOV   DX,O @@liarmes
                   MOV   AH,09H
                   INT   21H
@@okiedokie:
                   POP   ES
                   MOV   EAX,v_AllocatedPages
                   SHL   EAX,2
                   MOV   FreeExtMem,AX

; now we set up page directory
                   MOV   EAX,v_PageDirLinear
                   AND   EAX,0FFFFF000H
                   OR    EAX,000000000111B
                   MOV   ECX,MaxPages
                   MOV   DI,0
                   CLD
@@SetUpPD:         ADD   EAX,4096
                   STOSD
                   LOOP  @@SetUpPD
                   CALL  SetupHighHeap
; set up pic vectors
                   CLI
                   MOV   BX,8880H
                   CALL  SetPICVectorz
                   MOV   BX,80H
                   MOV   CX,88H
                   MOV   AX,0DE0BH ; VCPI set vector mappings
                   INT   67H

                   MOV   EAX,Code16
                   SHL   EAX,4
                   MOV   EBX,EAX
                   ADD   EAX,LARGE O Prot_GDT
                   MOV   v_LineOfGDTR,EAX
                   ADD   EBX,LARGE O Prot_IDT
                   MOV   v_LineOfIDTR,EBX
                   MOV   ES,Code32Seg
                   MOV   ES:GoRealProc,O v_GoReal
                   MOV   ES:GoProtWhere,O CommonEntry
                   MOV   GoPModeProc,O v_GoPMode

v_GoPMode:         CLI
                   MOV   RealESP,ESP
                   MOV   RealSS,SS
                   MOV   AX,0DE0CH ; VCPI switch to pmode
                   MOV   ESI,Code16
                   SHL   ESI,4
                   ADD   ESI,LARGE O v_PageDirLinear
                   INT   67H
VCPI_Init          ENDP

VCPI_Done          PROC  NEAR
                   ; this procedure cleans up all stuff, that was allocated
                   ; for vcpi
                   MOV   BX,7008H
                   CALL  SetPICVectorz
                   MOV   BX,08H
                   MOV   CX,70H
                   MOV   AX,0DE0BH ; VCPI set vector mappings
                   INT   67H
                   STI
; now we release all memory pages
                   MOV   ES,v_PageDirSeg
                   MOV   SI,v_MyFirstPage
                   MOV   ECX,v_AllocatedPages

@@NextPage:        MOV   AX,0DE05H ; free page
                   MOV   EDX,ES:[SI]
                   AND   EDX,0FFFFF000H
                   INT   67H
                   ADD   SI,4
                   LOOP  @@NextPage

; now set free that dummy ems page
                   MOV   DX,v_DummEMSPage
                   MOV   AX,4500H
                   INT   67H

                   JMP   CleanUpDone
VCPI_Done          ENDP

;
; DPMI mode functions and variables
DPMIPages          DW    ?
DPMIPSPSel         DW    ?
DPMIMemInfo        DD    12 DUP(0)
DPMIMemHandle      DD    ?
DPMIKbdH           DF    ?

DPMI_Exit          PROC  NEAR
                   MOV   W @@dr._vd_EAX,0900H
                   MOV   W @@dr._vd_EDX,DX
                   MOV   @@dr._vd_DS,Code16

                   MOV   AX,300H
                   MOV   BX,021H
                   CLR   CX
                   MOV   DI,O @@dr
                   INT   31H ; simulate real mode int 21

                   MOV   AX,4C01H
                   INT   21H
@@dr               DPMIREGS <>
DPMI_Exit          ENDP


DPMI_Banner        DB    '  DPMI v'
DPMI_VerHi         DB    '0.'
DPMI_VerLo         DB    '00 system'
                   DB    0DH,0AH,'$'

DPMI_Init          PROC  NEAR
                   MOV   AH,9
                   MOV   DX,O DPMI_Banner
                   INT   21H

                   MOVZX EAX,DPMIPages
                   SHL   EAX,4 ; * 16
                   ADD   EAX,64
                   CALL  GetLowMem ; get memory for dpmi host

                   SHR   EAX,4
                   MOV   ES,AX
                   MOV   AX,1 ; 32 bit app

                   DB    09AH ; CALL FAR
DPMISwitchAddr     DD    ?
; now we are in 16 bit protected mode
                   MOV   DX,O ErrMsg2
                   JC    ExitErrMsg

                   MOV   DPMIPSPSel,ES
                   MOV   DS:dSelRetRealCode,CS
                   MOV   DS:dSelRetRealData,DS
                   MOV   RealSS,SS
                   MOV   RealESP,ESP

                   PUSH  DS
                   POP   ES
                   MOV   DX,O ErrMsgA

                   MOV   AX,3 ; get selector increment
                   INT   31H
                   MOV   BX,AX ; sel increment

                   CLR   AX   ; alloc descriptors
                   MOV   CX,3
                   INT   31H
                   JC    DPMI_Exit

                   MOVZX EAX,AX
                   MOV   DS:SelCode32,EAX
                   ADD   AX,BX
                   MOV   DS:SelData32,EAX
                   ADD   AX,BX
                   MOV   DS:SelZero,EAX

                   MOV   AX,CS
                   LAR   AX,AX
                   AND   AX,6000H
                   OR    DS:Code32Desc+4,AX ; set priviledge level
                   OR    DS:Data32Desc+4,AX
                   OR    DS:ZeroDesc+4,AX

                   MOV   EBX,DS:SelCode32
                   MOV   EDI,O DS:Code32Desc
                   MOV   AX,0CH
                   INT   31H
                   JC    DPMI_Exit

                   MOV   EBX,DS:SelData32
                   MOV   EDI,O DS:Data32Desc
                   MOV   AX,0CH
                   INT   31H
                   JC    DPMI_Exit

                   MOV   EBX,DS:SelZero
                   MOV   EDI,O DS:ZeroDesc
                   MOV   AX,0CH
                   INT   31H
                   JC    DPMI_Exit

                   MOV   AX,500H
                   MOV   EDI,O DPMIMemInfo
                   INT   31H

                   MOV   DX,O ErrMsg4
                   MOV   EAX,DPMIMemInfo+4
                   CMP   EAX,-1
                   JZ    @@damn
                   SHL   EAX,10
                   MOV   DPMIMemInfo,EAX
                   ;SHR   DPMIMemInfo,1
@@damn:            AND   DPMIMemInfo,0FFFFF000H
                   JMP   @@AllocInit
@@AllocLp:         SUB   DPMIMemInfo,4096
                   JL    DPMI_Exit
@@AllocInit:       MOV   AX,0501H
                   MOV   CX,W DPMIMemInfo
                   MOV   BX,W DPMIMemInfo+2
                   INT   31H
                   JC    @@AllocLp
                   MOV   W DPMIMemHandle,DI
                   MOV   W DPMIMemHandle+2,SI
                   MOV   W HiBlockAbs,CX
                   MOV   W HiBlockAbs+2,BX
comment #
; lock memory
                   MOV   AX,600H ; lock
                   INT   31H
                   MOV   DX,O ErrMsg6
                   JC    DPMI_Exit
#
; set up high heap
                   MOV   EAX,HiBlockAbs
                   SUB   EAX,Code32Abs
                   MOV   DS:HiHeapOrg,EAX
                   ADD   EAX,DPMIMemInfo
                   MOV   DS:HiHeapEnd,EAX
; paging under dpmi is on
                   MOV   DS:PagingOn,True
; IRQ stuff
                   MOV   AX,400H ; get DPMI version
                   INT   31H
                   ; DH - master PIC
                   ; DL - slave PIC
                   MOV   EBX,O DS:IRQMap
                   MOV   ECX,8
@@SetIRQMap:       MOV   DS:[BX],DH
                   MOV   DS:[BX+8],DL
                   INC   BX
                   ADD   DX,0101H
                   LOOP  @@SetIRQMap

                   CLI
; setup keyboard IRQ

                   MOV   BL,DS:IRQMap[1]
                   MOV   EAX,204H
                   INT   31H
                   MOV   D DPMIKbdH,EDX
                   MOV   W DPMIKbdH+2,CX

                   MOV   BL,DS:IRQMap[1]
                   MOV   EDX,O Kbd_Handler
                   MOV   ECX,DS:SelCode32
                   MOV   EAX,205H
                   INT   31H

                   MOV   DS:GoRealProc,O d_GoReal
                   MOV   GS,W DS:SelZero
                   MOV   AX,W DS:SelData32
                   MOV   SS,AX
                   MOV   ESP,DS:GoProtStack
                   MOV   ES,AX
                   MOV   FS,AX
                   PUSH  DS:SelCode32
                   PUSH  O CommonEntry
                   MOV   DS,AX
                   DB    066H,0CBH ; ret far

DPMI_Init          ENDP

DPMI_Done          PROC  NEAR
                   LSS   ESP,FWORD PTR RealESP
                   MOV   ES,DPMIPSPSel

; restore IRQ1 handler
                   MOV   BL,DS:IRQMap[1]
                   MOV   EDX,D DPMIKbdH
                   MOV   CX,W DPMIKbdH+2
                   MOV   EAX,205H
                   INT   31H
; free descriptors
comment #
                   MOV   EAX,1
                   MOV   EBX,SelCode32
                   INT   31H

                   MOV   EAX,1
                   MOV   EBX,SelData32
                   INT   31H

                   MOV   EAX,1
                   MOV   EBX,SelZero
                   INT   31H
#
; free memory
                   MOV   EAX,502H
                   MOV   DI,W DPMIMemHandle
                   MOV   SI,W DPMIMemHandle+2
                   INT   31H
                   STI

                   MOV   AX,4C00H
                   INT   21H
DPMI_Done          ENDP

;
; some common functions and data

ExitErrMsg:        MOV  AX,CS
                   MOV  DS,AX
                   MOV  AH,09H
                   INT  21H
ExitErr:           MOV  AX,4C01H
                   INT  21H

ErrMsg0            DB   'KRNL000: No 386 processor detected!',0DH,0AH,'$'
ErrMsg1            DB   'KRNL001: System is already in V86 mode!',0DH,0AH,'$'
ErrMsg2            DB   'KRNL002: DPMI mode switch failed!',0DH,0AH,'$'
ErrMsg3            DB   'KRNL003: Cannot enable A20 address line!',0DH,0AH,'$'
ErrMsg4            DB   'KRNL004: No extended memory found!',0DH,0AH,'$'
ErrMsg5            DB   'KRNL005: Cannot allocate extended memory!',0DH,0AH,'$'
ErrMsg6            DB   'KRNL006: Cannot lock extended memory block!',0DH,0AH,'$'
ErrMsg7            DB   'KRNL007: Not enough low memory for internal structures!',0DH,0AH,'$'
ErrMsg8            DB   'KRNL008: System in V86 mode and VCPI not detected!',0DH,0AH,'$'
ErrMsg9            DB   'KRNL009: Incompatible VCPI IRQ mappings!',0DH,0AH,'$'
ErrMsgA            DB   'KRNL010: DPMI descriptor set failed!',0DH,0AH,'$'
CopyRite           DB   'KRNL386 v1.30 by Technomancer 1994-97',0DH,0AH,'$'

PSPSeg             DW   ?
EnvSeg             DW   ?
FreeExtMem         DW   ?
HiBlockAbs         DD   ?
SystemType         DB   0
GoPModeProc        DW   O c_GoPMode

Code16             ENDS

;
; segment for 32 bit code
;

Code32             SEGMENT PARA PUBLIC USE32 'CODE'
                   ASSUME CS:Code32,DS:Code32,SS:Code32
LARGESTACK
Include Krnl386.Inc
                   ORG 0
NullPointer        DB   'Null' ; just to check if we didnt try to assign null
                               ; pointer
;
; Global Descriptor Table for protected mode

GDT                DD   0,0 ; dummy descriptor

                   ; descriptor for code   8
Code32Desc         DW       0FFFFH,0
                   DB       0
                   MDAccess <1,0,,MD_Code_RunRD,1>
                   MDS16    <1,1,,0,0FH>
                   DB       0

                   ; descriptor for data, same as for code, only other type
                   ; 16 = 10h
Data32Desc         DW       0FFFFH,0
                   DB       0
                   MDAccess <1,0,,MD_Data_RW,1>
                   MDS16    <1,1,,0,0FH>
                   DB       0

                   ; descriptor for 0000:0000
                   ; 24 = 18h
ZeroDesc           DW       0FFFFH,0
                   DB       0
                   MDAccess <1,0,,MD_Data_RW,1>
                   MDS16    <1,1,,0,0FH>
                   DB       0

                   ; descriptor for our TASK
                   ; 32 = 20h
KrnlTaskDesc       DW       SIZE TSS -1,0
                   DB       0
                   SDAccess <1,0,,DT_Avail_TSS386>
                   SDS16    <0,,1,0>
                   DB       0

RetRealCode        DW       0FFFFH,0
                   DB       0
                   MDAccess <1,0,,MD_Code_RunRD,1>
                   MDS16    <0,0,,0,0>
                   DB       0

RetRealData        DW       0FFFFH,0
                   DB       0
                   MDAccess <1,0,,MD_Data_RW,1>
                   MDS16    <0,0,,0,0>
                   DB       0

VCPICode           DQ       0,0,0 ; VCPI code descriptor
                                  ; two  extra vcpi descriptors

;
; Interrupt Descriptor Table for protected mode
IDT                DW      KernelInts DUP(0,_SelCode32,08F00H,0)
                           ; trap gates
                   
;
; important system variables for 32 bit code

Code32Base         DD    ?  ; zero based
Code16Base         DD    ?  ; zero based
                   DW    0  ; to save on shifting code16
Code16Seg          DD    Code16
SelCode32          DD    _SelCode32
SelData32          DD    _SelData32
SelZero            DD    _SelZero
dSelRetRealCode    DW    ?
dSelRetRealData    DW    ?

PSPBase            DD    ?  ; zero based
EnvBase            DD    ?  ; zero based
GoProtWhere        DD    ?  ; where to jump after switching to protected mode
GoRealWhere        DD    ?  ; where to jump after switching to real mode

GoRealProc         DD    O c_GoReal
                         ; procedure that switches to real/v86 mode

GoProtStack        DD    ?
                            ; points to stack top

SegA000            DD    ?  ; Code32 based
SegB800            DD    ?  ; Code32 based

DiskBuffer         DD   ?   ; DiskBufferSize DUP(00H)
DiskBufferReal     DD   ?

IRQMap             DB    IRQ0Base
                   DB    IRQ0Base+1
                   DB    IRQ0Base+2
                   DB    IRQ0Base+3
                   DB    IRQ0Base+4
                   DB    IRQ0Base+5
                   DB    IRQ0Base+6
                   DB    IRQ0Base+7
                   DB    IRQ0Base+8
                   DB    IRQ0Base+9
                   DB    IRQ0Base+10
                   DB    IRQ0Base+11
                   DB    IRQ0Base+12
                   DB    IRQ0Base+13
                   DB    IRQ0Base+14
                   DB    IRQ0Base+15

HEXTable           DB    '0123456789ABCDEF'
CursorPtr          DD    0
TextAttr           DB    07H

SystemFlag         DB    SystemRAW
PagingOn           DB    False
PageDirBase        DD    ?
Page1stBase        DD    ?
PageExtraBase      DD    ?

OrgIRQMask         DW    ?  ; masks we need to restore when terminating
                            ; program

ExitErrMsgP:       PUSH  ESI
                   MOV   EAX,3
                   CALL  SetGrMode
                   POP   ESI
                   CALL  DisplayNullString
                   JMP   BackToReality

_errmsg            MACRO errcode,errtx
                   LOCAL temp
temp               DB    0DH,0AH
                   DB    errtx
                   DB    0DH,0AH,0
errcode:           MOV   ESI,O temp
                   JMP   ExitErrMsgP
                   ENDM

HyperSpace         PROC  NEAR
                   ; 32 bit code begins here
                   MOV   AX,W CS:SelData32
                   MOV   DS,AX
                   MOV   ES,AX
                   MOV   SS,AX
                   MOV   FS,AX
                   MOV   GS,W SelZero
                   MOV   ESP,GoProtStack

                   MOV   AX,SelKernelTask
                   LTR   AX
                   CMP   PagingOn,TRUE
                   JNZ   @@SkipPaging
                   MOV   EAX,PageDirBase
                   MOV   CR3,EAX
                   MOV   EAX,CR0
                   OR    EAX,80000000H ; set paging bit
                   MOV   CR0,EAX
                   JMP   SHORT @@SkipPaging
@@SkipPaging:
                   JMP   D GoProtWhere
HyperSpace         ENDP

v_HyperSpace       PROC  NEAR
; this is pmode entry for VCPI
                   MOV   AX,W CS:SelData32
                   MOV   DS,AX
                   MOV   ES,AX
                   MOV   SS,AX
                   MOV   FS,AX
                   MOV   GS,W SelZero
                   MOV   ESP,GoProtStack

                   JMP   D GoProtWhere
v_HyperSpace       ENDP

CommonEntry:       CALL  GetIRQMasks
                   MOV   OrgIRQMask,AX
                   STI
                   CALL  Lo_Init
                   CALL  Hi_Init

                   MOV   BX,GS:[450H]  ; set our cursor ptr
                   MOVZX EAX,BH
                   MOV   EDX,160D
                   MUL   EDX
                   MOVZX EBX,BL
                   LEA   EAX,[EAX+EBX*2]
                   MOV   CursorPtr,EAX

                   CALL  DspMemState
                   CALL  Main

BackToReality:     CLI
                   MOV   AX,OrgIRQMask
                   CALL  SetIRQMasks
                   CALL  ValidateBIOSCurs
                   MOV   EAX,D Code16Seg-2
                   MOV   AX,O RealBack2DOS
                   MOV   GoRealWhere,EAX
                   JMP   GoRealProc

c_GoReal           PROC  NEAR
                   CLI
                   CMP   PagingOn,TRUE
                   JNZ   @@SkipPaging
                   MOV   EAX,CR0
                   AND   EAX,7FFFFFFFH ; turn paging off
                   MOV   CR0,EAX
                   JMP   SHORT @@SkipPaging ; flush queue
@@SkipPaging:
                   MOV   GoProtStack,ESP
                   MOV   AX,SelRetRealData
                   MOV   DS,AX
                   MOV   ES,AX
                   MOV   SS,AX
                   MOV   FS,AX
                   MOV   GS,AX
                   DB    0EAH            ; jump to Code16:PreRealMode
                   DW    O PreRealMode
                   DW    0
                   DW    SelRetRealCode
c_GoReal           ENDP

comment #
         28 (DWORD) GS value
         24 (DWORD) FS value
         20 (DWORD) DS value
         1C (DWORD) ES value
         18 (DWORD) SS value
         14 (DWORD) ESP value
         10 (DWORD) reserved for EFLAGS value
         0C (DWORD) CS value
         08 (DWORD) EIP value
SS:ESP-> 00 (DWORD) return address from FAR call to USE32 segment
#

v_GoReal           PROC  NEAR
                   CLI
                   MOV   GoProtStack,ESP
                   MOV   EAX,Code16Seg
                   MOV   EBX,EAX
                   SHL   EBX,4
                   PUSH  EAX ; GS
                   PUSH  EAX ; FS
                   PUSH  EAX ; DS
                   PUSH  EAX ; ES
                   MOV   ECX,O RealSS
                   MOVZX EDX,W GS:[EBX+ECX]
                   PUSH  EDX ; SS
                   MOV   ECX,O RealESP
                   MOV   EDX,D GS:[EBX+ECX]
                   PUSH  EDX ; ESP
                   PUSHFD
                   PUSH  EAX ; CS
                   MOV   EAX,O v_InReal
                   PUSH  EAX ; EIP
                   MOV   AX,W SelZero
                   MOV   DS,AX
                   MOV   AX,0DE0CH
                   JMP   CallVCPIHost
v_GoReal           ENDP

d_GoReal           PROC  NEAR
                   CLI
                   MOV   GoProtStack,ESP
                   MOV   AX,dSelRetRealCode
                   MOV   @@sel,AX
                   MOV   AX,dSelRetRealData
                   MOV   DS,AX
                   MOV   ES,AX
                   MOV   GS,AX
                   MOV   FS,AX
                   JMP   SHORT @@jump
@@jump:            DB    066H
                   DB    0EAH ; jump far, 16 bit
                   DW    DPMI_Done
@@sel              DW    ?
d_GoReal           ENDP

DspMemState        PROC  NEAR
                   MOV   ESI,O @@LoComm
                   CALL  DisplayNullString
                   CALL  Lo_MaxAvail
                   SHR   EAX,10
                   CALL  DisplayEAXDec
                   MOV   ESI,O @@KB
                   CALL  DisplayNullString

                   MOV   ESI,O @@HiComm
                   CALL  DisplayNullString
                   CALL  Hi_MaxAvail
                   SHR   EAX,10
                   CALL  DisplayEAXDec
                   MOV   ESI,O @@KB
                   CALL  DisplayNullString
                   RET
@@LoComm           DB    '  Lo heap : ',00
@@HiComm           DB    '  Hi heap : ',00
@@KB               DB    ' KB',0DH,0AH,00
DspMemState        ENDP


Comment #
!SetPagingOn
  EXPLANATION  : Setup DR3 and set paging bit
                  if paging was already enabled then it does nothing
                  paging is always enabled under vcpi
                  you dont have to worry about reenabling paging
                  after call to real mode function
  INPUT        : none
  OUTPUT       : none
  SCREWED REGS : none
#
SetPagingOn        PROC  NEAR
                   PUSHAD
                   CMP   PagingOn,TRUE
                   JZ    @@SkipPaging
                   MOV   PagingOn,TRUE
                   MOV   EAX,PageDirBase
                   MOV   CR3,EAX
                   MOV   EAX,CR0
                   OR    EAX,80000000H ; set paging bit
                   MOV   CR0,EAX
                   JMP   SHORT @@SkipPaging ; flush queue
@@SkipPaging:      POPAD
                   RET
SetPagingOn        ENDP

RI_IntNo           DB   ?

Align 4
RI_ LABEL DPMIREGS ; global structure for dpmi registers
RI_EDI             LABEL DWORD
RI_DI              DW    0
                   DW    0
RI_ESI             LABEL DWORD
RI_SI              DW    0
                   DW    0
RI_EBP             LABEL DWORD
RI_BP              DW    0
                   DW    0
RI_RESERVED        DD    0
RI_EBX             LABEL DWORD
RI_BX              LABEL WORD
RI_BL              DB    0
RI_BH              DB    0
                   DW    0
RI_EDX             LABEL DWORD
RI_DX              LABEL WORD
RI_DL              DB    0
RI_DH              DB    0
                   DW    0
RI_ECX             LABEL DWORD
RI_CX              LABEL WORD
RI_CL              DB    0
RI_CH              DB    0
                   DW    0
RI_EAX             LABEL DWORD
RI_AX              LABEL WORD
RI_AL              DB    0
RI_AH              DB    0
                   DW    0
RI_Flags           DW    0
RI_ES              DW    0
RI_DS              DW    0
RI_FS              DW    0
RI_GS              DW    0
RI_IP              DW    0
RI_CS              DW    0
RI_SP              DW    0
RI_SS              DW    0


IFDEF xTiny
; extra tiny extender code
; minimal exception handler
Exception          PROC  NEAR
                   MOV   AL,3
                   CALL  SetGrMode
                   MOV   CursorPtr,2*160
                   MOV   ESI,O @@exct
                   CALL  DisplayNullString
                   JMP   BackToReality
@@exct             DB    'exception!',0DH,0AH,0
Exception          ENDP

ELSE
; standard exception handler

Include Exceptio.Inc

ENDIF

Reserved:          IRETD

NullInt:           IRETD

Include Keyboard.Inc

Pic0IRQ:           PUSH AX
                   MOV  AL,20H
                   OUT  20H,AL
                   POP  AX
                   IRETD

Pic1IRQ:           PUSH AX
                   MOV  AL,20H
                   OUT  0A0H,AL
                   OUT  020H,AL
                   POP  AX
                   IRETD

Comment #
!CallInt
  EXPLANATION  : call specified interrupt
  INPUT        : regs and RI_ (dont forget to set RI_ segregs before)
  OUTPUT       : regs RI_, read segs from RI_
  SCREWED REGS : who knows
#
dCallInt           PROC  NEAR
                   MOV   RI_._vd_EAX,EAX
                   MOV   RI_._vd_EBX,EBX
                   MOV   RI_._vd_ECX,ECX
                   MOV   RI_._vd_EDX,EDX
                   MOV   RI_._vd_ESI,ESI
                   MOV   RI_._vd_EDI,EDI
                   MOV   RI_._vd_EBP,EBP
                   POP   EBX ; return address
                   XCHG  EBX,[ESP]
                   MOVZX EBX,BL
                   MOV   EAX,300H
                   CLR   ECX  ; bytes to copy from stack
                   MOV   EDI,O RI_
                   INT   31H

                   MOV   AH,B RI_._vd_Flags
                   SAHF
                   
                   MOV   EAX,RI_._vd_EAX
                   MOV   EBX,RI_._vd_EBX
                   MOV   ECX,RI_._vd_ECX
                   MOV   EDX,RI_._vd_EDX
                   MOV   ESI,RI_._vd_ESI
                   MOV   EDI,RI_._vd_EDI
                   MOV   EBP,RI_._vd_EBP
                   
                   RET
dCallInt           ENDP

CallInt            PROC  NEAR
                   CMP   SystemFlag,SystemDPMI
                   JZ    dCallInt
                   MOV   RI_EAX,EAX
                   MOV   RI_EBX,EBX
                   MOV   RI_ECX,ECX
                   MOV   RI_EDX,EDX
                   MOV   RI_ESI,ESI
                   MOV   RI_EDI,EDI
                   MOV   RI_EBP,EBP
                   POP   EBX       ; ret addr
                   XCHG  EBX,[ESP] ; intno
                   MOV   RI_IntNo,BL
                   MOV   EAX,D Code16Seg-2
                   MOV   AX,O CallInterrupt
                   MOV   D RI_IP,EAX
                   CALL  CallRealMode
                   MOV   AH,B RI_Flags
                   SAHF
                   MOV   EAX,RI_EAX
                   MOV   EBX,RI_EBX
                   MOV   ECX,RI_ECX
                   MOV   EDX,RI_EDX
                   MOV   ESI,RI_ESI
                   MOV   EDI,RI_EDI
                   MOV   EBP,RI_EBP
                   RET
CallInt            ENDP

Comment #
!SetGrMode
  EXPLANATION  : calls INT 10H, set video mode (AH=0)
  INPUT        : AL - desired mode
  OUTPUT       : none
  SCREWED REGS : none
#
SetGrMode          PROC  NEAR
                   PUSHAD
                   XOR   AH,AH
                   PUSH  10H
                   CALL  CallInt
                   POPAD
@@ProcExit:
                   RET
SetGrMode          ENDP

Comment #
!CallRealMode
  EXPLANATION  : this procedure calls real mode procedure, with far ret
  INPUT        : RI_ data fields
  OUTPUT       : RI_ data fields
  SCREWED REGS : all excepts segments and ss:esp
#
dCallRealMode      PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDI

                   MOV   EAX,301H
                   CLR   EBX
                   CLR   ECX
                   MOV   EDI,O RI_
                   INT   31H

                   POP   EDI
                   POP   ECX
                   POP   EBX
                   POP   EAX

                   STI
                   RET
dCallRealMode      ENDP

CallRealMode       PROC  NEAR
                   CLI
                   CALL  ValidateBIOSCurs
                   CMP   SystemFlag,SystemDPMI
                   JZ    dCallRealMode

                   PUSH  EAX
                   MOV   EAX,D Code16Seg-2
                   MOV   AX,O DoRealModeProc
                   MOV   GoRealWhere,EAX
                   POP   EAX
                   JMP   GoRealProc

; here real mode call returns
ReturnFromCall:    STI
                   RET
CallRealMode       ENDP

Comment #
!CallInt21
  EXPLANATION  : call int 21 in real mode
  INPUT        : RI_ registers
  OUTPUT       : RI_ registers
  SCREWED REGS :
#

dCallInt21         PROC  NEAR
                   CALL  ValidateBIOSCurs
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDI

                   MOV   RI_SS,0
                   MOV   RI_SP,0 ; let dpmi provide its own stack!

                   MOV   EAX,300H
                   MOV   EBX,21H
                   CLR   ECX  ; bytes to copy from stack = 0
                   MOV   EDI,O RI_

                   INT   31H

                   POP   EDI
                   POP   ECX
                   POP   EBX
                   POP   EAX
                   RET
dCallInt21         ENDP

CallInt21          PROC  NEAR
                   CMP   SystemFlag,SystemDPMI
                   JZ    dCallInt21
                   MOV   RI_IntNo,21H
                   PUSH  EAX
                   MOV   EAX,D Code16Seg-2
                   MOV   AX,O CallInterrupt
                   MOV   D RI_IP,EAX
                   POP   EAX
                   JMP   CallRealMode
CallInt21          ENDP

CBNewVecs          DW    O CallBackVec0
                   DW    O CallBackVec1
                   DW    O CallBackVec2
                   DW    O CallBackVec3
                   DW    O CallBackVec4
                   DW    O CallBackVec5
                   DW    O CallBackVec6
                   DW    O CallBackVec7
                   DW    O CallBackVec8
                   DW    O CallBackVec9
                   DW    O CallBackVecA
                   DW    O CallBackVecB
                   DW    O CallBackVecC
                   DW    O CallBackVecD
                   DW    O CallBackVecE
                   DW    O CallBackVecF
CBOldVecs          DD    16D DUP(0)

CallBackNumber     DB    ?

CallBack           PROC  NEAR
                   ; 32bit callback code
                   PUSHFD
                   PUSH  SelCode32
                   PUSH  O @@ReturnCB

                   MOVZX EAX,CallBackNumber
                   MOV   AL,IRQMap[EAX]
                   CALL  GetIntVec
                   PUSH  EBX
                   PUSH  EAX
                   RETF
@@ReturnCB:
                   MOV   EAX,D Code16Seg-2
                   MOV   AX,O ReturnFromCB
                   MOV   GoRealWhere,EAX
                   JMP   GoRealProc
CallBack           ENDP

;---------------- DPMI callbacks -------------------------------------------
; every callback has his data area, original interrupt handler
DCB                STRUC
DCB_Data           DD   ?
DCB_RMHandle       DD   ?
DCB                ENDS

DCallBackN         MACRO N
DCallBack&N&:      MOV   BL,CS:IRQMap[N]
                   JMP   DCallBackCommon
                   ENDM
DCallBackN 0
DCallBackN 1
DCallBackN 2
DCallBackN 3
DCallBackN 4
DCallBackN 5
DCallBackN 6
DCallBackN 7
DCallBackN 8
DCallBackN 9
DCallBackN 10
DCallBackN 11
DCallBackN 12
DCallBackN 13
DCallBackN 14
DCallBackN 15

DCallBackCommon    PROC  NEAR
comment |
                   CLI
                   MOV   DS,W CS:SelData32
                   MOV   ES,W SelData32
                   MOV   FS,W SelData32
                   MOV   GS,W SelZero
; display stack frame
                   Say   'ESP:'
                   MOV   EAX,ESP
                   SayValue EAX
                   NewLine
                   Say   'Stack[0]:'
                   MOV   EAX,[ESP]
                   SayValue EAX
                   NewLine
                   Say   'Stack[4]:'
                   MOV   EAX,[ESP+4]
                   SayValue EAX
                   NewLine
                   Say   'Stack[8]:'
                   MOV   EAX,[ESP+8]
                   SayValue EAX
                   NewLine
                   JMP   $
|
                   CLD
                   LODSW
                   MOV   ES:[EDI._vd_IP],AX
                   LODSW
                   MOV   ES:[EDI._vd_CS],AX
                   LODSW
                   MOV   ES:[EDI._vd_Flags],AX
                   ADD   ES:[EDI._vd_SP],6

                   MOV   EAX,204H
                   INT   31H       ; get irq vector
                   MOVZX ECX,CX
                   PUSH  ECX       ; selector
                   PUSH  EDX       ; address
                   RETF
DCallBackCommon    ENDP

DCallBackRtns      DD   DCallBack0,DCallBack1,DCallBack2,DCallBack3
                   DD   DCallBack4,DCallBack5,DCallBack6,DCallBack7
                   DD   DCallBack8,DCallBack9,DCallBack10,DCallBack11
                   DD   DCallBack12,DCallBack13,DCallBack14,DCallBack15

DCallBackData      DB   16 * (SIZE DCB) DUP(0)

dEnableCallBack    PROC  NEAR
                   PUSHAD
                   MOVZX EBP,BL          ; EBP - irq callback number
                   MOVZX EBX,IRQMap[EBP] ; EBX - int number
                   MOV   EAX,50
                   CALL  Lo_Alloc
                   MOV   D DCallBackData[EBP*8],EAX
                   MOV   EDI,EAX         ; EDI - structure address
                   ; ES should be data32
                   MOV   EAX,200H
                   INT   31H     ; get rm interrupt vector
                   SHL   ECX,16
                   MOV   CX,DX
                   MOV   D DCallBackData[EBP*8+4],ECX  ; OLD RM VECTOR
; alloc callback
                   MOV   ESI,DCallBackRtns[EBP*4]
                   MOV   AX,CS
                   MOV   DS,AX
                   MOV   EAX,303H
                   INT   31H     ; alloc callback
                                 ; CX:DX - real mode callback
                   MOV   DS,W CS:SelData32
                   MOV   EAX,201H
                   INT   31H     ; set real mode interrupt
                   POPAD
                   RET
dEnableCallBack    ENDP

dDisableCallBack   PROC  NEAR
                   PUSHAD
                   MOVZX EBP,BL          ; EBP - irq callback number
                   MOVZX EBX,IRQMap[EBP] ; EBX - int number

                   MOV   EAX,200H
                   INT   31H ; get current vector

                   PUSH  ECX
                   PUSH  EDX

                   MOVZX EDX,W DCallBackData[EBP*8+4] ; OLD RM VECTOR ofs
                   MOVZX ECX,W DCallBackData[EBP*8+4+2] ; OLD RM VECTOR seg
                   MOV   EAX,201H
                   INT   31H ; set rm int vector

                   POP   EDX
                   POP   ECX

                   MOV   EAX,304H
                   INT   31H ; free callback

                   MOV   EAX,D DCallBackData[EBP*8] ; structure
                   MOV   ECX,50
                   CALL  Lo_Free ; free structure
                   POPAD
                   RET
dDisableCallBack   ENDP

Comment #
!EnableCallBack
  Explanation  : sets real mode interrupt vector so when given irq
                  happens in real mode is redirected to protected mode
  Expects      : BL - IRQ number (0..0F)
  Returns      : nothing
  Screwed regs : EAX
#
EnableCallBack     PROC  NEAR
                   CMP   SystemFlag,SystemDPMI
                   JZ    dEnableCallBack
                   MOVZX EBX,BL
                   PUSH  EBX
                   MOV   EAX,D Code16Seg-2
                   MOV   AX,CBNewVecs[EBX*2]
                   MOV   BL,IRQMap[EBX]
                   XCHG  GS:[EBX*4],EAX
                   POP   EBX
                   MOV   CBOldVecs[EBX*4],EAX
                   RET
EnableCallBack     ENDP

Comment #
!DisableCallBack
  Explanation  : sets real mode int vector so when given irq happens
                  in real mode it is handled by real mode routine
  Expects      : BL - IRQ number (0..0F)
  Returns      : nothing
  Screwed regs : EAX,ESI
#
DisableCallBack    PROC  NEAR
                   CMP   SystemFlag,SystemDPMI
                   JZ    dDisableCallBack
                   MOVZX EBX,BL
                   MOV   EAX,CBOldVecs[EBX*4]
                   MOV   BL,IRQMap[EBX]
                   MOV   GS:[EBX*4],EAX
                   RET
DisableCallBack    ENDP

; forward is a little creature that will forward irq that happened in
; protected mode to their real mode handler
; look ma! network still works !

ForwardInt         DB    ?

Forward            MACRO N,plus
Forward&N&:        CLI
                   PUSHAD
                   MOV   AL,plus
                   JMP   ForwardCommon
                   ENDM

Forward 00,08H
Forward 01,09H
Forward 02,0AH
Forward 03,0BH
Forward 04,0CH
Forward 05,0DH
Forward 06,0EH
Forward 07,0FH
Forward 08,70H
Forward 09,71H
Forward 0A,72H
Forward 0B,73H
Forward 0C,74H
Forward 0D,75H
Forward 0E,76H
Forward 0F,77H

ForwardCommon      PROC  NEAR
                   MOV   ForwardInt,AL
                   MOV   EAX,D Code16Seg-2
                   MOV   AX,O Forwarder
                   MOV   GoRealWhere,EAX
                   JMP   GoRealProc
ForwardRet:
                   POPAD
                   IRETD
ForwardCommon      ENDP

Comment #
!GetIntVec
  EXPLANATION  : gives address of interrupt vector
  INPUT        : AL - number of int vector
  OUTPUT       : EAX - address of int vector
                  EBX - selector of old vector
  SCREWED REGS : EAX,EBX
#
dGetIntVec         PROC  NEAR
                   PUSH  ECX
                   PUSH  EDX
                   MOV   BL,AL
                   MOV   EAX,204H
                   INT   31H
                   MOV   EAX,EDX
                   MOVZX EBX,CX
                   POP   EDX
                   POP   ECX
                   RET
dGetIntVec         ENDP

GetIntVec          PROC  NEAR
                   CMP   SystemFlag,SystemDPMI
                   JZ    dGetIntVec
                   MOVZX EBX,AL
                   SHL   EBX,3
                   ADD   EBX,O IDT
                   MOV   AX,[EBX.G_Offs16]
                   SHL   EAX,16
                   MOV   AX,[EBX.G_Offs0]
                   MOV   BX,CS
                   MOVZX EBX,BX
                   RET
GetIntVec          ENDP

Comment #
!SetIntVec
  EXPLANATION  : sets new address of interrupt vector
  INPUT        : BL - number of int vector,
                  EAX - new vector
                  CX - new vector segment
  OUTPUT       : none
  SCREWED REGS : none
#
dSetIntVec         PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   MOV   EDX,EAX
                   MOV   EAX,205H
                   INT   31H
                   POP   EDX
                   POP   EAX
                   RET
dSetIntVec         ENDP

SetIntVec          PROC  NEAR
                   CMP   SystemFlag,SystemDPMI
                   JZ    dSetIntVec
                   PUSH  EAX
                   PUSH  EBX
                   MOVZX EBX,BL
                   SHL   EBX,3
                   ADD   EBX,O IDT
                   PUSHFD
                   CLI
                   MOV   [EBX.G_Offs0],AX
                   SHR   EAX,16
                   MOV   [EBX.G_Offs16],AX
                   POPFD
                   POP   EBX
                   POP   EAX
                   RET
SetIntVec          ENDP

Comment #
!SetIRQMasks
  Explanation  : sets PIC0 and PIC1 IRQ mask registers
  Expects      : AL - PIC0 mask
                  AH - PIC1 mask
  Returns      : nothing
  Screwed regs : none
#
SetIRQMasks        PROC NEAR
                   PUSH AX
                   OUT  PIC0_IMR,AL
                   MOV  AL,AH
                   OUT  PIC1_IMR,AL
                   POP  AX
                   RET
SetIRQMasks        ENDP

Comment #
!GetIRQMask
  Explanation  : reads PIC0 and PIC1 IRQ mask registers
  Expects      : nothing
  Returns      : AL - PIC0 mask
                  AH - PIC1 mask
  Screwed regs : AX
#
GetIRQMasks        PROC NEAR
                   IN   AL,PIC1_IMR
                   MOV  AH,AL
                   IN   AL,PIC0_IMR
                   RET
GetIRQMasks        ENDP

Comment #
!CallVCPIHost
  EXPLANATION  : this procedure calls VCPI service from
                  protected mode program
                  not for use for untrained personnel
  INPUT        :
  OUTPUT       :
  SCREWED REGS :
#
CallVCPIHost       PROC  NEAR
                   DB    09AH
v_HostEntry        DD    ?
                   DW    SelVCPICode
                   RET
CallVCPIHost       ENDP

Include Mem.Inc
Include File.Inc

IFNDEF xTiny
; we dont need it in extra tiny mode
Include DllSys.Inc
Include Packer.Inc
Include Res.Inc

Comment #
!DOSDisplayString
  EXPLANATION  : displays string using dos fn 09h
  INPUT        : edx - ptr to $ terminated string
  OUTPUT       : cf,eax
  SCREWED REGS :
#
DOSDisplayString   PROC NEAR
                   PUSHAD
                   MOV  ESI,EDX
                   MOV  EDI,O DiskBuffer
                   CLD
@@NextByte:        LODSB
                   STOSB
                   CMP  AL,'$'
                   JNZ  @@NextByte
                   MOV  RI_AH,09H
                   MOV  RI_EDX,O DiskBuffer
                   MOV  RI_DS,Code32
                   CALL CallInt21
                   MOV  AH,B RI_Flags
                   SAHF
                   POPAD
                   MOVZX EAX,RI_AX
                   RET
DOSDisplayString   ENDP
ENDIF ; xTiny

;
; miscellaneous raw character io functions

;
;!DisplayEAX
;  EXPLANATION  : displays on screen EAX in hex
;  INPUT        :
;  OUTPUT       :
;  SCREWED REGS :
;
DisplayEAX         PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   MOV   EDX,EAX
                   CLD
                   REPT  8
                   ROL   EDX,4
                   MOVZX EAX,DL
                   AND   AL,0FH
                   MOV   AL,B [EAX+O HEXTable]
                   CALL  DisplayChar
                   ENDM
                   POP   EDX
                   POP   EAX
                   RET
DisplayEAX         ENDP

;
;!DisplayEAXDec
;  EXPLANATION  : display eax in decimal, signed format
;  INPUT        : EAX
;  OUTPUT       : something on screen
;  SCREWED REGS : none
;
DisplayEAXDec      PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  EDX
                   PUSH  ESI

                   MOV   ESI,O @@DOBuffE
                   CMP   EAX,0
                   PUSHFD
                   JGE   @@SkipSign
                   NEG   EAX
@@SkipSign:        MOV   EBX,10
@@CharLoop:        XOR   EDX,EDX
                   DIV   EBX
                   ADD   DL,'0'
                   DEC   ESI
                   MOV   [ESI],DL
                   OR    EAX,EAX
                   JNZ   @@CharLoop
                   POPFD
                   JGE   @@Positive
                   DEC   ESI
                   MOV   B [ESI],'-'
@@Positive:        CALL  DisplayNullString

                   POP   ESI
                   POP   EDX
                   POP   EBX
                   POP   EAX
                   RET
                   DB    20D DUP(00H)
@@DOBuffE          DB    0
DisplayEAXDec      ENDP

;
;!EAXToHex
;  EXPLANATION  : converts EAX to hex string at EDI, null terminated
;  INPUT        : EAX
;  OUTPUT       : string at edi
;  SCREWED REGS : none
;
EAXToHex           PROC  NEAR
                   PUSH  EAX
                   PUSH  EDX
                   PUSH  EDI
                   MOV   EDX,EAX
                   CLD
                   REPT  8
                   ROL   EDX,4
                   MOVZX EAX,DL
                   AND   AL,0FH
                   MOV   AL,B [EAX+O HEXTable]
                   STOSB
                   ENDM
                   MOV   B [EDI],0
                   POP   EDI
                   POP   EDX
                   POP   EAX
                   RET
EAXToHex           ENDP

;
;!ValidateBIOSCurs
;  EXPLANATION  : sets bios cursor position variable to match CursorPtr
;  INPUT        :
;  OUTPUT       :
;  SCREWED REGS :
;
ValidateBIOSCurs   PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  EDX
                   MOV   EAX,CursorPtr
                   MOV   EBX,160D
                   XOR   EDX,EDX
                   IDIV  EBX
                   SHR   EDX,1
                   MOV   DH,AL
                   MOV   W GS:[450H],DX
                   POP   EDX
                   POP   EBX
                   POP   EAX
                   RET
ValidateBIOSCurs   ENDP

;
;!DisplayCursor
;  EXPLANATION  : updates position of cursor on screen
;  INPUT        : none
;  OUTPUT       : none
;  SCREWED REGS : none
;
DisplayCursor      PROC NEAR
                   PUSH EAX
                   PUSH EBX
                   PUSH EDX
                   MOV  EBX,CursorPtr
                   SHR  EBX,1
                   MOV  DX,3D4H
                   MOV  AL,14
                   MOV  AH,BH
                   OUT  DX,AX
                   INC  AL
                   MOV  AH,BL
                   OUT  DX,AX
                   POP  EDX
                   POP  EBX
                   POP  EAX
                   RET
DisplayCursor      ENDP

;
;!DisplayChar
;  EXPLANATION  : displays character from al on screen
;  INPUT        : AL
;  OUTPUT       : none
;  SCREWED REGS : none
;
DisplayChar        PROC  NEAR
                   PUSH  EAX
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  ESI
                   PUSH  EDI

                   MOV   EDI,CursorPtr
                   MOV   EBX,SegB800
                   MOV   AH,TextAttr

                   CMP   AL,0DH
                   JNZ   @@Skp1
                   ; Carriage return
                   MOV   EAX,EDI
                   MOV   EBX,160D
                   XOR   EDX,EDX
                   DIV   EBX
                   MUL   EBX
                   MOV   EDI,EAX
                   JMP   @@SkipDisplay

@@Skp1:            CMP   AL,0AH
                   JNZ   @@Skp2
                   ; Line feed
                   ADD   EDI,160D
                   JMP   @@SkipDisplay
@@Skp2:
                   MOV   [EDI+EBX],AX
                   ADD   EDI,2
@@SkipDisplay:
                   CMP   EDI,160*25
                   JB    @@ProcEnd

                   ; scroll up one line
                   PUSH  EDI
                   MOV   EDI,SegB800
                   LEA   ESI,[EDI+160]
                   MOV   ECX,24*160/4
                   CLD
                   REP   MOVSD
                   MOV   EAX,07200720H
                   MOV   ECX,160/4
                   REP   STOSD
                   POP   EDI
                   SUB   EDI,160D
@@ProcEnd:         MOV   CursorPtr,EDI
                   CALL  DisplayCursor
                   POP   EDI
                   POP   ESI
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   POP   EAX
                   RET
DisplayChar        ENDP

;
;!DisplayECXSpaces
;  EXPLANATION  : puts ecx spaces to screen
;  INPUT        : ECX
;  OUTPUT       : none
;  SCREWED REGS : none
;
DisplayECXSpaces   PROC NEAR
                   PUSH  EAX
                   PUSH  ECX
                   MOV   AL,' '
@@Here:            CALL  DisplayChar
                   LOOP  @@Here
                   POP   ECX
                   POP   EAX
DisplayECXSpaces   ENDP

;
;!DisplayNullString
;  EXPLANATION  : displays NULL terminated string from ESI
;  INPUT        : string at esi
;  OUTPUT       : none
;  SCREWED REGS : none
;
DisplayNullString  PROC  NEAR
                   PUSH  EAX
                   PUSH  ESI
                   CLD
@@Here:            LODSB
                   OR    AL,AL
                   JZ    @@ProcExit
                   CALL  DisplayChar
                   JMP   @@Here
@@ProcExit:        POP   ESI
                   POP   EAX
                   RET
DisplayNullString  ENDP

;
;!NextLine
;  EXPLANATION  : writes CR,LF to screen
;  INPUT        :
;  OUTPUT       :
;  SCREWED REGS :
;
NextLine           PROC  NEAR
                   PUSH  EAX
                   MOV   AL,CR
                   CALL  DisplayChar
                   MOV   AL,LF
                   CALL  DisplayChar
                   POP   EAX
                   RET
NextLine           ENDP

;
;!KlearTextScreen
;  EXPLANATION  : clears text screen at b800h
;  INPUT        :
;  OUTPUT       :
;  SCREWED REGS :
;
KlearTextScreen    PROC  NEAR
                   PUSH  EAX
                   PUSH  ECX
                   PUSH  EDI
                   MOV   ECX,2000
                   MOV   AH,TextAttr
                   MOV   AL,' '
                   MOV   EDI,SegB800
                   CLD
                   REP   STOSW
                   MOV   CursorPtr,0
                   CALL  DisplayCursor
                   POP   EDI
                   POP   ECX
                   POP   EAX
                   RET
KlearTextScreen    ENDP

Comment #
!SineGen
  EXPLANATION  : returns sinus of given angle wit 20 bit precision
  INPUT        : EAX - angle
                  EBX - full angle
  OUTPUT       : EAX - sinus of angle
  SCREWED REGS : none
#
Pi20               EQU 3294198 ; Pi (20 bit fraction)
SineGen            PROC  NEAR
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
                   PUSH  ESI
                   PUSH  EDI
                   CDQ
                   IDIV  EBX             ; modulo
                   MOV   EAX,EDX
                   SHR   EBX,1
                   CMP   EAX,EBX
                   PUSHFD
                   JB    @@NoSub
                   SUB   EAX,EBX
@@NoSub:           PUSH  EBX
                   SHR   EBX,1
                   CMP   EAX,EBX
                   JBE   @@GoodQuart
                   ADD   EBX,EBX
                   SUB   EAX,EBX
                   NEG   EAX
@@GoodQuart:
                   POP   EBX
                   MOV   EDX,Pi20
                   IMUL  EDX
                   IDIV  EBX
                   MOV   ESI,EAX
                   IMUL  EAX
                   SHRD  EAX,EDX,20
                   XCHG  EAX,ESI         ; ESI - x^2
                   MOV   EDI,6           ; to divide (3!)
                   MOV   ECX,3
                   MOV   EBX,EAX         ; result
@@MnLp:
                   NEG   EAX
                   IMUL  ESI
                   SHRD  EAX,EDX,20
                   SAR   EDX,20
                   PUSH  EAX
                   IDIV  EDI
                   OR    EAX,EAX
                   JZ    @@Done
                   ADD   EBX,EAX
                   POP   EAX
                   INC   ECX
                   IMUL  EDI,ECX
                   INC   ECX
                   IMUL  EDI,ECX
                   JMP   @@MnLp

@@Done:            POP   EAX
                   MOV   EAX,EBX
                   POPFD
                   JB    @@NoNeg
                   NEG   EAX
@@NoNeg:           POP   EDI
                   POP   ESI
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   RET
SineGen            ENDP

;
;!Random
;  EXPLANATION  : gives back random value from range RndLo - RndHi
;  INPUT        : none
;  OUTPUT       : AX
;  SCREWED REGS : AX
;
Random             PROC  NEAR
                   PUSH  BX
                   PUSH  DX
                   MOV   BX,RandSeed
                   ADD   BX,9248H
                   ROR   BX,3
                   MOV   RandSeed,BX
                   MOV   AX,RndHi
                   SUB   AX,RndLo
                   MUL   BX
                   MOV   AX,DX
                   ADD   AX,RndLo
                   POP   DX
                   POP   BX
                   RET
Random             ENDP

;
;!RandomAbs
;  EXPLANATION  : gives back random value from range 0..FFFF
;  INPUT        : none
;  OUTPUT       : AX
;  SCREWED REGS : AX
;
RandomAbs          PROC  NEAR
                   MOV   AX,RandSeed
                   ADD   AX,9248H
                   ROR   AX,3
                   MOV   RandSeed,AX
                   RET
RandomAbs          ENDP

RandSeed           DW    0
RndLo              DW    0
RndHi              DW    0FFFFH

IFDEF NoDebug
; if no debug then do not load debugger code!
DBG_Init:
DBG_InitS:
DBG_SetTrap:
DBG_Trap:
                   RET
DBG_InDebug        DB   False
ELSE
Include Debug.Asm
ENDIF

; it looks kinda weird but this way we do not bother about linking and stuff

KernelEnd          LABEL BYTE
                   ; this label points to end of all kernel functions
                   ; it is used bu debugger to determine if given function
                   ; is part of kernel or not
                   ; then debugger can advise to you is you should/shouldnt call
                   ; this function
                   ; beware! it is not healthy to trace into functions that
                   ; perform real mode calls !

Code32             ENDS

FreeMemory         SEGMENT PARA USE16 STACK 'STACK'
IFDEF xTiny
                   DB RealStak*8 DUP(0)
ELSE
                   DB RealStak DUP('RealStak')
ENDIF
                       ;0123456789ABCDEF
                   DB  'LoMemory base ! '
LoMemBase          LABEL BYTE 
FreeMemory         ENDS
End Start
