; Analogue 1995
; SYSTEM 64 - DOS protected mode extender v1.210 - release version
; coded by Simm
;-------------------------------------------------------------------------------
; This protected mode extender is prettymuch what I used in Circuit.
;
locals
.386p

RSTACK_SIZE     equ 8192
PSTACK_SIZE	equ 8192

HEAP_LIMIT      equ 8388608

SD_RCODE	equ 008h
SD_PCODE	equ 010h
SD_RSTACK	equ 018h
SD_PSTACK	equ 020h
SD_DATA 	equ 028h
SD_ALIAS	equ 030h
SD_ZERO 	equ 038h
SD_TASK 	equ 040h
SD_VCPI 	equ 048h

ST_RAW		equ 0
ST_XMS		equ 1
ST_VCPI 	equ 2

TIMER_LO        equ 054h                        ; 2100Hz
TIMER_HI        equ 002h

ifdef USE_DEBUG
PSTACK_DEBUG	equ 1024
endif
;
extrn main:near
extrn datafile:byte

public stub,exit,panic,set_exit,heap_avail,heap_alloc,heap_alloc4,heap_mark
public heap_release,heap_reset,set_irq,get_irq,int_rm

public sys_type,psp,data_base,page_base,vid_base

public rm_ax,rm_bx,rm_cx,rm_dx,rm_bp,rm_si,rm_di,rm_ds,rm_es,rm_data
public rm_al,rm_ah,rm_bl,rm_bh,rm_cl,rm_ch,rm_dl,rm_dh,rm_flags
;
setup_irq	macro master,slave

		mov al,011h			; set IRQ0..IRQ7 to master
		out 020h,al
		jmp $ + 2
		mov al,master
		out 021h,al
		jmp $ + 2
		mov al,004h
		out 021h,al
		jmp $ + 2
		mov al,001h
		out 021h,al
		jmp $ + 2

		mov al,011h			; set IRQ8..IRQF to slave
		out 0A0h,al
		jmp $ + 2
		mov al,slave
		out 0A1h,al
		jmp $ + 2
		mov al,002h
		out 0A1h,al
		jmp $ + 2
		mov al,001h
		out 0A1h,al
		jmp $ + 2

		endm
;
rcode		segment public use16
rcode		ends
pcode		segment public use32
pcode		ends
data		segment public use32
data		ends
top		segment stack use32 'stack'
top		ends
;
data		segment public use32


start_message   db ".SYSTEM 64 v1.211 hardware maintenance service",13,10
		db "by Desmond Germans (Simm / Analogue) - 1995",13,10,13,10
		db '$'

end_message     db 13,10,".SYSTEM 64 v1.211 hardware maintenance service",13,10
		db "edge, art, technology, analogue.",13,10,'$'

r_init_message	db ".S64: initializing raw protected mode...",13,10,'$'
x_init_message	db ".S64: initializing XMS protected mode...",13,10,'$'
v_init_message	db ".S64: initializing VCPI protected mode...",13,10,'$'

data_message	db ".S64: loading ROM data file...",13,10,'$'

run_message     db ".S64: running user program...",13,10,13,10,'$'

error_386	db ".S64: 80386 or better required$"
error_v86	db ".S64: system is running in V86 mode$"
error_dpmi	db ".S64: system is running under a DPMI server$"
error_a20	db ".S64: cannot enable A20 gate$"
error_mem	db ".S64: not enough base memory$"
error_win	db ".S64: system is running under Microsoft Windows$"
error_data	db ".S64: error loading ROM data file$"
error_panic     db ".S64: THIS CODE SUCKS !!!!!$"

x_error_mem	db ".S64: error allocating XMS memory$"

error_00	db ".S64: [00] divide fault$"
error_01	db ".S64: [01] debugger fault/trap$"
error_02	db ".S64: [02] NMI interrupt$"
error_03	db ".S64: [03] breakpoint trap$"
error_04	db ".S64: [04] overflow trap$"
error_05	db ".S64: [05] array bound violation fault$"
error_06	db ".S64: [06] invalid opcode fault$"
error_07	db ".S64: [07] coprocessor not available fault$"
error_08	db ".S64: [08] double fault abort$"
error_09	db ".S64: [09] coprocessor segment overrun abort$"
error_0A	db ".S64: [0A] invalid TSS fault$"
error_0B	db ".S64: [0B] segment not present fault$"
error_0C	db ".S64: [0C] stack fault$"
error_0D	db ".S64: [0D] general protection fault$"
error_0E	db ".S64: [0E] page fault$"
error_0F        db ".S64: [0F] unknown fault 0F$"
error_10	db ".S64: [10] coprocessor error fault$"
error_11	db ".S64: [11] alignment check fault$"
error_exc       db ".S64: [??] unknown exception$"
error_irq1	db ".S64: [KB] keyboard break fault$"

perror_mem	db ".S64: heap overflow$"

gdt		dw 0,0,0,0
gdt_rcode	dw 0FFFFh,0,09A00h,00000h
gdt_pcode	dw 0FFFFh,0,09A00h,000CFh
gdt_rstack	dw 0FFFFh,0,09200h,00000h
gdt_pstack	dw 0FFFFh,0,09200h,000CFh
gdt_data	dw 0FFFFh,0,09200h,000CFh
gdt_alias	dw 0FFFFh,0,09200h,000CFh
gdt_zero	dw 0FFFFh,0,09200h,000CFh
gdt_task	dw 0FFFFh,0,08900h,00000h
gdt_vcpi	dw 0,0,0,0
		dw 0,0,0,0
		dw 0,0,0,0

idt		dw small offset handler_00,SD_PCODE,08F00h,0
		dw small offset handler_01,SD_PCODE,08F00h,0
		dw small offset handler_02,SD_PCODE,08F00h,0
		dw small offset handler_03,SD_PCODE,08F00h,0
		dw small offset handler_04,SD_PCODE,08F00h,0
		dw small offset handler_05,SD_PCODE,08F00h,0
		dw small offset handler_06,SD_PCODE,08F00h,0
		dw small offset handler_07,SD_PCODE,08F00h,0
		dw small offset handler_08,SD_PCODE,08F00h,0
		dw small offset handler_09,SD_PCODE,08F00h,0
		dw small offset handler_0A,SD_PCODE,08F00h,0
		dw small offset handler_0B,SD_PCODE,08F00h,0
		dw small offset handler_0C,SD_PCODE,08F00h,0
		dw small offset handler_0D,SD_PCODE,08F00h,0
		dw small offset handler_0E,SD_PCODE,08F00h,0
		dw small offset handler_0F,SD_PCODE,08F00h,0

		dw small offset handler_10,SD_PCODE,08F00h,0
		dw small offset handler_11,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0
		dw small offset handler_exc,SD_PCODE,08F00h,0

idt_irq         dw small offset handler_irq0,SD_PCODE,08E00h,0
		dw small offset handler_irq1,SD_PCODE,08E00h,0
		dw small offset handler_irq2,SD_PCODE,08E00h,0
		dw small offset handler_irq3,SD_PCODE,08E00h,0
		dw small offset handler_irq4,SD_PCODE,08E00h,0
		dw small offset handler_irq5,SD_PCODE,08E00h,0
		dw small offset handler_irq6,SD_PCODE,08E00h,0
		dw small offset handler_irq7,SD_PCODE,08E00h,0
		dw small offset handler_irq8,SD_PCODE,08E00h,0
		dw small offset handler_irq9,SD_PCODE,08E00h,0
		dw small offset handler_irq10,SD_PCODE,08E00h,0
		dw small offset handler_irq11,SD_PCODE,08E00h,0
		dw small offset handler_irq12,SD_PCODE,08E00h,0
		dw small offset handler_irq13,SD_PCODE,08E00h,0
		dw small offset handler_irq14,SD_PCODE,08E00h,0
		dw small offset handler_irq15,SD_PCODE,08E00h,0

gdtr		dw 0005Fh,small offset gdt,0
pidtr		dw 0017Fh,small offset idt,0
ridtr		dw 003FFh,0,0

sys_type	dd 0
psp		dd 0

heap_base	dd 0
heap_top	dd 0
heap_ptr	dd 0

real_base	dd 0
real_top	dd 0

rdone		dw 0
rpanic		dw 0
rm2pm		dw 0
pm2rm		dd 0
rm_dest 	dw 0
pm_dest 	dd 0
exception	dd offset exit
pexit		dd offset stub

parm1           dd 0
parm2           dd 0
parm3           dd 0

pm_ss		dw 0
pm_esp		dd 0
rm_int		db 0

rm_data 	dw 0
rm_pic          dw 0
pm_pic          dw 0

rm_ax		label word
rm_al		db 0
rm_ah		db 0
rm_bx		label word
rm_bl		db 0
rm_bh		db 0
rm_cx		label word
rm_cl		db 0
rm_ch		db 0
rm_dx		label word
rm_dl		db 0
rm_dh		db 0
rm_bp		dw 0
rm_si		dw 0
rm_di		dw 0
rm_ds		dw 0
rm_es		dw 0
rm_flags        dw 0

exc_message	dw 0FFFFh

;Ŀ
; XMS DATA								       
;
xms_call	dd 0
xms_handle	dw 0

;Ŀ
; VCPI DATA								       
;
vcpi_cr3	dd 0
vcpi_gdtrr	dd offset gdtr
vcpi_idtrr	dd offset pidtr
vcpi_ldt	dw 0
vcpi_task	dw SD_TASK
vcpi_jump	dd offset v_prm2pm
		dw SD_PCODE

vcpi_dir_seg	dw 0
vcpi_page_base	dw 0
vcpi_page_top	dw 0

vcpi_call	dd 0
		dw SD_VCPI

ifdef USE_DEBUG
;Ŀ
; DEBUG64 DATA 							       
;
saved_ss	dw 0
saved_esp	dd 0

debug_eax       dd 0
debug_ebx	dd 0
debug_ecx	dd 0
debug_edx	dd 0
debug_esi	dd 0
debug_edi	dd 0
debug_esp	dd 0
debug_ebp	dd 0
debug_eip	dd 0
debug_eflags	dd 0
debug_result	dd 0

debug_page      dd 0

debug_irq       dd 0

debug_copy	dd 0
debug_data	dd 0
debug_break	dd 0

debug_proc_seg	dw 0
debug_proc_ofs	dw 0

saved_eflags	dd 0
debug_state	db 0

debugger	db "DEBUG64.EXE",0
comm_tail	db 0,13
info_block	dw 0
		dw small offset comm_tail,0
		dw 0005Ch,0
		dw 0006Ch,0

old_int65	dd 0
old_int66	dd 0

palette         db 256 dup(0,0,0)
endif

data_handle	dw 0
data_size	dd 0
data_base	dd 0

data_esp	dd 0
data_ss 	dw 0

data_source	dd 0

page_base	dd 0
vid_base	dd 0
vesa_base       dd 0
data_seg        dw 0

vid_mode        db 0


data		ends
;
rcode		segment public use16
		assume cs:rcode,ds:data,es:data,fs:data,gs:data,ss:top


dos_panic:	mov ah,009h
		int 021h
dos_exit:	mov ax,04C01h
		int 021h
;-------------------------------------------------------------------------------
check_386	proc near

		pushf
		xor ah,ah
		push ax
		popf
		pushf
		pop ax
		and ah,0F0h
		cmp ah,0F0h
		jz @@no_386
		mov ah,0F0h
		push ax
		popf
		pushf
		pop ax
		and ah,0F0h
		jz @@no_386
		popf
		ret

@@no_386:	mov dx,small offset error_386
		jmp dos_panic

check_386	endp
;-------------------------------------------------------------------------------
check_win	proc near

		mov ax,04680h
		int 02Fh
		cmp ax,0
		jz @@windows
		mov ax,01600h
		int 02Fh
		test al,07Fh
		jnz @@windows
		ret

@@windows:	mov dx,small offset error_win
		jmp dos_panic

check_win	endp
;-------------------------------------------------------------------------------
check_dpmi	proc near

		mov ax,01687h
		int 02Fh
		cmp ax,0
		jz @@dpmi
		ret

@@dpmi: 	mov dx,small offset error_dpmi
		jmp dos_panic

check_dpmi	endp
;-------------------------------------------------------------------------------
v_check 	proc near

		xor ax,ax
		mov es,ax
		cmp dword ptr es:[4 * 067h],0
		jz @@no_vcpi
		mov ax,0DE00h
		int 067h
		cmp ax,0
		jz @@vcpi
@@no_vcpi:	clc
		ret

@@vcpi: 	stc
		ret

v_check 	endp
;-------------------------------------------------------------------------------
x_check 	proc near

		mov ax,04300h
		int 02Fh
		cmp al,080h
		jz @@xms
		clc
		ret

@@xms:		stc
		ret

x_check 	endp
;-------------------------------------------------------------------------------
check_v86	proc near

		smsw ax
		test al,1
		jnz @@v86
		ret

@@v86:		mov dx,small offset error_v86
		jmp dos_panic

check_v86	endp
;-------------------------------------------------------------------------------
copy_data	proc near

		mov word ptr [data_size],ax
		mov word ptr [data_size + 2],0
		mov [data_esp],esp
		mov [data_ss],ss
		mov [pm_dest],offset pcopy_data
		jmp [rm2pm]
rcopy_data:	mov ss,[data_ss]
		mov esp,[data_esp]
		mov eax,[data_size]
		add [heap_base],eax
		ret

copy_data	endp
;-------------------------------------------------------------------------------
questions       proc near                       ; ask questions

                mov [parm1],00220h              ; CHANGE FOR FINAL VERSION !!!
                ret

questions       endp
;-------------------------------------------------------------------------------
rinit:		mov ax,data			; setup data segment
		mov ds,ax
		mov [rm_data],ax
		mov esp,RSTACK_SIZE

		mov ax,es			; setup psp pointer
		movzx eax,ax
		shl eax,4
		mov [psp],eax
		mov eax,large data
		shl eax,4
		sub [psp],eax

		mov dx,small offset start_message ; fancy message
		mov ah,009h
		int 021h

		call check_386			; check for atleast 386
		call check_win			; check for MS Windows
		call check_dpmi 		; check for other DPMI server

ifdef USE_DEBUG
                mov eax,large top + (RSTACK_SIZE + PSTACK_SIZE + PSTACK_DEBUG) / 16 + 2048
else
                mov eax,large top + (RSTACK_SIZE + PSTACK_SIZE) / 16 + 2048
endif
		shl eax,4
		add eax,000000FFFh
		and eax,0FFFFF000h
		cmp eax,0000A0000h
		mov dx,small offset error_mem
		jge dos_panic
		mov [real_base],eax
		mov [real_top],0000A0000h

		mov ah,04Ah			; shrink DOS memory
		mov ebx,[real_base]
		shr ebx,4
ifdef USE_DEBUG
		add bx,(RSTACK_SIZE + PSTACK_SIZE + PSTACK_DEBUG) / 16 + 256 + (HEAP_LIMIT / 16384)
else
		add bx,(RSTACK_SIZE + PSTACK_SIZE) / 16 + 256 + (HEAP_LIMIT / 16384)
endif
		mov [data_seg],bx
		add bx,2048
		mov cx,es
		sub bx,cx
		int 021h

ifdef USE_DEBUG
		mov ax,03565h			; setup DEBUG64 services
		int 021h
		mov word ptr [old_int65],bx
		mov word ptr [old_int65 + 2],es
		push ds
		mov ax,01234h
		mov ds,ax
		mov dx,05678h
		mov ax,02565h
		int 021h
		pop ds
		mov ax,03566h
		int 021h
		mov word ptr [old_int66],bx
		mov word ptr [old_int66 + 2],es
		mov ax,02566h
		push ds
		push cs
		pop ds
		mov dx,offset debug_int
		int 021h
		pop ds
endif
		mov eax,large rcode		; setup GDT
		shl eax,4
		or dword ptr [gdt_rcode + 2],eax

		mov eax,large pcode
		shl eax,4
		or dword ptr [gdt_pcode + 2],eax
		or dword ptr [gdt_alias + 2],eax

		mov eax,large top
		shl eax,4
		or dword ptr [gdt_rstack + 2],eax

		mov eax,large top + RSTACK_SIZE / 16
		shl eax,4
		or dword ptr [gdt_pstack + 2],eax

		mov eax,large data
		shl eax,4
		or dword ptr [gdt_data + 2],eax
		add dword ptr [gdtr + 2],eax
		add dword ptr [pidtr + 2],eax

		call v_check			; VCPI available?
		jc v_rinit			; start it

		call check_v86			; check for other V86 host

		call x_check			; XMS available?
		jc x_rinit			; start it

		jmp r_rinit			; start raw initialization
;...............................................................................
rstart:         in al,0A1h                      ; initialize PM PIC to RM PIC
                mov ah,al
                in al,021h
                mov [pm_pic],ax

                mov eax,[heap_base]             ; setup mode13 page
		mov [page_base],eax
                add eax,256 * 1024
		mov [heap_base],eax

		cmp byte ptr [datafile],0       ; load datafile?
		jz no_datafile

		mov dx,small offset data_message ; fancy message
		mov ah,009h
		int 021h

		mov eax,[heap_base]
		mov [data_base],eax

		movzx eax,[data_seg]
		shl eax,4
		mov ebx,large data
		shl ebx,4
		sub eax,ebx
		mov [data_source],eax

		mov ax,03D00h			; open datafile
		mov dx,small offset datafile
		int 021h
		mov dx,small offset error_data
		jnc no_open_error
		jmp [rpanic]
no_open_error:	mov [data_handle],ax

next_block:	mov bx,[data_handle]		; read blocks from datafile
		mov cx,08000h
		push ds
		mov ds,[data_seg]
		mov dx,0
		mov ax,03F00h
		int 021h
		pop ds
		mov dx,small offset error_data
		jnc no_read_error
		jmp [rpanic]
no_read_error:	cmp ax,08000h
		jb last_block
		call copy_data
		jmp next_block
last_block:	call copy_data

		mov ax,03E00h			; close datafile
		mov bx,[data_handle]
		int 021h

no_datafile:    mov eax,[heap_base]             ; initialize heap
		mov [heap_ptr],eax

		mov dx,small offset run_message ; fancy message
		mov ah,009h
		int 021h

                call questions                  ; ask questions

                mov eax,0A000h                  ; for testing only
                mov ebx,large data
                shl ebx,4
                sub eax,ebx
                mov [vid_base],eax

ifdef USE_DEBUG
		pushfd				; start debugger
		pop eax
		and eax,0FFFFBF00h
		mov [debug_eflags],eax		; strip irritating flags
		mov eax,0
		mov [debug_eax],eax
		mov [debug_ebx],eax
		mov [debug_ecx],eax
		mov [debug_edx],eax
		mov [debug_esi],eax
		mov [debug_edi],eax
		mov [debug_esp],PSTACK_SIZE
		mov [debug_ebp],eax
		mov [debug_eip],offset main

		mov word ptr [info_block + 4],data
		mov word ptr [info_block + 8],ax
		mov word ptr [info_block + 12],ax
		mov ax,data
		mov es,ax
		mov ax,04B00h
		mov dx,small offset debugger
		mov bx,small offset info_block
		int 021h
		mov ax,04D00h
		int 021h
		cmp al,0FFh
		jz dos_exit

		jmp [rdone]
else
                mov ax,00013h                   ; switch to 320x200x256
                int 010h

		mov [pm_dest],offset pre_main	; jump to protected mode
		jmp [rm2pm]
endif
;...............................................................................
rstop:
ifdef USE_DEBUG
		mov ax,data
		mov ds,ax
		mov ax,02566h			; restore old ints 65 and 66
		push ds
		lds dx,[old_int66]
		int 021h
		pop ds
		mov ax,02565h
		push ds
		lds dx,[old_int65]
		int 021h
		pop ds
endif
		mov ax,00003h			; clear the screen
		int 010h

		mov bp,04CFFh			; print exception message
		mov dx,[exc_message]
		cmp dx,0FFFFh
		jnz exc_print
		mov dx,small offset end_message
		mov bp,04C00h
exc_print:	mov ah,009h
		int 021h

		mov ax,bp			; exit to DOS
		int 021h

;Ŀ
; RAW REAL MODE INIT & DONE						       
;
r_enable_a20	proc near

		cli
		call @@enable_a20o1
		jnz @@enable_a20end
		mov al,0d1h
		out 64h,al
		call @@enable_a20o1
		jnz @@enable_a20end
		mov al,0dfh
		out 60h,al
@@enable_a20o1: mov ecx,20000h
@@enable_a20o1l:jmp $ + 2
		in al,64h
		test al,2
		loopnz @@enable_a20o1l
@@enable_a20end:sti
		ret

r_enable_a20	endp
;-------------------------------------------------------------------------------
r_rinit 	proc near

		mov dx,small offset r_init_message ; fancy message
		mov ah,009h
		int 021h

		mov [sys_type],ST_RAW		; set system type byte

		mov [rm2pm],offset r_rrm2pm	; setup RM to PM switch
		mov [pm2rm],offset r_ppm2rm	; setup PM to RM switch
		mov [rdone],offset r_rdone	; setup done routine
		mov [rpanic],offset dos_panic	; setup panic routine

		call r_enable_a20		; enable A20 gate

		mov ah,088h			; setup heap base and top
		int 015h
		movzx eax,ax
		shl eax,10
		mov [heap_base],000100000h
		mov [heap_top],eax
		mov eax,large data
		shl eax,4
		add [heap_base],eax
		add [heap_top],eax

		pushfd				; strip irritating flags
		pop eax
		and eax,0FFFFBF00h
		push eax
		popfd

		jmp rstart

r_rinit 	endp
;-------------------------------------------------------------------------------
r_rdone 	proc near

		jmp rstop			; jump to common exit

r_rdone 	endp

;Ŀ
; RAW REAL MODE SWITCH ROUTINES					       
;
r_rrm2pm	proc near

		cli				; turn off interrupts

                in al,0A1h                      ; save real mode PIC masks
                mov ah,al
                in al,021h
                mov [rm_pic],ax

		lgdt fword ptr [gdtr]		; load GDT register
		lidt fword ptr [pidtr]		; load IDT register

		mov eax,cr0			; switch to protected mode
		or al,1
		mov cr0,eax
		db 0EAh
		dw small offset r_prm2pm,SD_PCODE

r_rrm2pm	endp
;-------------------------------------------------------------------------------
r_rpm2rm	proc near

		mov eax,cr0			; switch to real mode
		and al,0FEh
		mov cr0,eax
		db 0EAh
		dw $ + 4,rcode
;...............................................................................
		lidt fword ptr [ridtr]		; load IDT register

		mov ax,data			; setup selectors
		mov ds,ax
		mov es,ax
		mov fs,ax
		mov gs,ax
		mov ax,top
		mov ss,ax
		mov esp,RSTACK_SIZE

		mov eax,0			; setup registers
		mov ebx,eax
		mov ecx,eax
		mov edx,eax
		mov esi,eax
		mov edi,eax
		mov ebp,eax

                mov ax,[rm_pic]                 ; restore real mode PIC masks
                out 021h,al
                mov al,ah
                out 0A1h,al

		sti				; turn interrupts back on

		jmp [rm_dest]

r_rpm2rm	endp

;Ŀ
; XMS REAL MODE INIT & DONE						       
;
x_panic:	push dx 			; unlock and deallocate XMS
		mov dx,[xms_handle]
		mov ah,00Dh
		call [xms_call]
		mov ah,00Ah
		call [xms_call]
		pop dx

		jmp dos_panic			; jump to common panic routine
;-------------------------------------------------------------------------------
x_rinit 	proc near

		mov dx,small offset x_init_message ; fancy message
		mov ah,009h
		int 021h

		mov [sys_type],ST_XMS		; set system type byte

		mov [rm2pm],offset x_rrm2pm	; setup RM to PM switch
		mov [pm2rm],offset x_ppm2rm	; setup PM to RM switch
		mov [rdone],offset x_rdone	; setup done routine
		mov [rpanic],offset x_panic	; setup panic routine

		mov ax,04310h			; get XMS call address
		int 02Fh
		mov word ptr [xms_call],bx
		mov word ptr [xms_call + 2],es

		mov ah,005h			; enable A20 gate
		call [xms_call]
		cmp ax,0
		mov dx,small offset error_a20
		jz dos_panic

		mov ah,008h			; get amount of free XMS
		call [xms_call]
		movzx ebp,ax
		shl ebp,10

		mov ax,dx			; allocate all available XMS
		mov ah,009h
		call [xms_call]
		mov [xms_handle],dx
		cmp ax,0
		mov dx,small offset x_error_mem
		jz dos_panic

		mov ah,00Ch			; lock allocated XMS
		mov dx,[xms_handle]
		call [xms_call]
		cmp ax,0
		jnz @@mem_locked
		mov dx,small offset x_error_mem
		jmp x_panic

@@mem_locked:	shl edx,16			; setup heap base and top
		mov dx,bx
		mov [heap_base],edx
		add edx,ebp
		mov [heap_top],edx
		mov eax,large data
		shl eax,4
		add [heap_base],eax
		add [heap_top],eax

		pushfd				; strip irritating flags
		pop eax
		and eax,0FFFFBF00h
		push eax
		popfd

		jmp rstart

x_rinit 	endp
;-------------------------------------------------------------------------------
x_rdone 	proc near

		mov dx,[xms_handle]		; unlock and deallocate XMS
		mov ah,00Dh
		call [xms_call]
		mov ah,00Ah
		call [xms_call]

		jmp rstop			; jump to common exit

x_rdone 	endp

;Ŀ
; XMS REAL MODE SWITCH ROUTINES					       
;
x_rrm2pm	proc near

		cli				; turn off interrupts

                in al,0A1h                      ; save real mode PIC masks
                mov ah,al
                in al,021h
                mov [rm_pic],ax

		lgdt fword ptr [gdtr]		; load GDT register
		lidt fword ptr [pidtr]		; load IDT register

		mov eax,cr0			; switch to protected mode
		or al,1
		mov cr0,eax
		db 0EAh
		dw small offset r_prm2pm,SD_PCODE

x_rrm2pm	endp
;-------------------------------------------------------------------------------
x_rpm2rm	proc near

		mov eax,cr0			; switch to real mode
		and al,0FEh
		mov cr0,eax
		db 0EAh
		dw $ + 4,rcode
;...............................................................................
		lidt fword ptr [ridtr]		; load IDT register

		mov ax,data			; setup selectors
		mov ds,ax
		mov es,ax
		mov fs,ax
		mov gs,ax
		mov ax,top
		mov ss,ax
		mov esp,RSTACK_SIZE

		mov eax,0			; setup registers
		mov ebx,eax
		mov ecx,eax
		mov edx,eax
		mov esi,eax
		mov edi,eax
		mov ebp,eax

                mov ax,[rm_pic]                 ; restore real mode PIC masks
                out 021h,al
                mov al,ah
                out 0A1h,al

		sti				; turn interrupts back on

		jmp [rm_dest]

x_rpm2rm	endp

;Ŀ
; VCPI REAL MODE INIT & DONE						       
;
v_panic 	proc near

		push dx
		mov es,[vcpi_dir_seg]		; deallocate pages
		mov si,[vcpi_page_base]
		mov cx,[vcpi_page_top]
		sub cx,si
		jbe @@no_dealloc
		shr cx,2
@@next_page:	mov edx,es:[si]
		and edx,0FFFFF000h
		mov ax,0DE05h
		int 067h
		add si,4
		dec cx
		jnz @@next_page

@@no_dealloc:	pop dx				; jump to common panic routine
		jmp dos_panic

v_panic 	endp
;-------------------------------------------------------------------------------
v_rinit 	proc near

		mov dx,small offset v_init_message
		mov ah,009h
		int 021h

		mov [sys_type],ST_VCPI		; set system type byte

		mov [rm2pm],offset v_rrm2pm	; setup RM to PM switch
		mov [pm2rm],offset v_ppm2rm	; setup PM to RM switch
		mov [rdone],offset v_rdone	; setup done routine
		mov [rpanic],offset v_panic	; setup panic routine

		mov eax,large data		; adjust switch GDTR and IDTR
		shl eax,4
		add [vcpi_gdtrr],eax
		add [vcpi_idtrr],eax

		mov eax,[real_base]		; setup page dir. & tables seg.
		shr eax,4
		mov es,ax
		mov [vcpi_dir_seg],ax

		mov eax,[real_base]		; allocate page directory
		add eax,4096
		cmp eax,[real_top]
		mov dx,small offset error_mem
		ja dos_panic
		mov [real_base],eax

		mov eax,[real_base]		; allocate page tables
		add eax,HEAP_LIMIT / 1024
		cmp eax,[real_top]
		mov dx,small offset error_mem
		ja dos_panic
		mov [real_base],eax

		mov di,0			; clear page dir. & tables
                mov cx,1024 + (HEAP_LIMIT / 4096)
		mov eax,0
		repz stosd

		mov di,4096			; get current page tables
		mov esi,offset gdt_vcpi
		mov ax,0DE01h
		int 067h
		mov [vcpi_call],ebx		; (and VCPI PM call address)

		movzx eax,di			; setup heap base
		sub eax,4096
		shl eax,10
		mov [heap_base],eax

		mov [vcpi_page_base],di 	; allocate new pages
@@next_page:	mov ax,0DE04h
		int 067h
		cmp ah,0
		jnz @@last_page
		and edx,0FFFFF000h
		or edx,000000007h
		mov es:[di],edx
		add di,4
		cmp di,4096 + (HEAP_LIMIT / 1024)
		jb @@next_page
@@last_page:	mov [vcpi_page_top],di

		movzx ecx,di			; setup heap top
		sub ecx,4096
		shl ecx,10
		mov [heap_top],ecx
		mov eax,large data
		shl eax,4
		add [heap_base],eax
		add [heap_top],eax

		movzx ebx,[vcpi_dir_seg]	; setup page dir. address (CR3)
		shr ebx,8
		mov eax,es:[ebx * 4 + 4096]
		mov [vcpi_cr3],eax

		mov di,0			; setup page directory
@@next_table:	inc ebx
		mov eax,es:[ebx * 4 + 4096]
		and eax,0FFFFF000h
		or eax,000000007h
		stosd
		cmp di,(HEAP_LIMIT / 1048576)
		jb @@next_table

		jmp rstart

v_rinit 	endp
;-------------------------------------------------------------------------------
v_rdone 	proc near

		mov es,[vcpi_dir_seg]		; deallocate pages
		mov si,[vcpi_page_base]
		mov cx,[vcpi_page_top]
		sub cx,si
		jbe @@no_dealloc
		shr cx,2
@@next_page:	mov edx,es:[si]
		and edx,0FFFFF000h
		mov ax,0DE05h
		int 067h
		add si,4
		dec cx
		jnz @@next_page

@@no_dealloc:	jmp rstop			; jump to common exit

v_rdone 	endp

;Ŀ
; VCPI REAL MODE SWITCH ROUTINES					       
;
v_rrm2pm	proc near

                in al,0A1h                      ; save real mode PIC masks
                mov ah,al
                in al,021h
                mov [rm_pic],ax

		mov esi,offset vcpi_cr3 	; switch to protected mode
		mov eax,large data
		shl eax,4
		add esi,eax
		mov ax,0DE0Ch
		int 067h

v_rrm2pm	endp
;-------------------------------------------------------------------------------
v_rpm2rm	proc near

		mov ax,data			; setup selectors
		mov ds,ax
		mov es,ax
		mov fs,ax
		mov gs,ax
		mov ax,top
		mov ss,ax
		mov esp,RSTACK_SIZE

		mov eax,0			; setup registers
		mov ebx,eax
		mov ecx,eax
		mov edx,eax
		mov esi,eax
		mov edi,eax
		mov ebp,eax

                mov ax,[rm_pic]                 ; restore real mode PIC masks
                out 021h,al
                mov al,ah
                out 0A1h,al

		sti				; turn interrupts back on

		jmp [rm_dest]

v_rpm2rm	endp

;Ŀ
; REALMODE INTERRUPT SUPPORT						       
;
rint		proc near

                cli
		mov al,[rm_int]
		mov byte ptr cs:[@@do_int + 1],al
                push [rm_flags]
                popf
		mov ax,[rm_ax]
		mov bx,[rm_bx]
		mov cx,[rm_cx]
		mov dx,[rm_dx]
		mov bp,[rm_bp]
		mov si,[rm_si]
		mov di,[rm_di]
		mov ds,[rm_ds]
		mov es,[rm_es]
@@do_int:	db 0CDh,0
		mov [rm_ax],ax
		mov [rm_bx],bx
		mov [rm_cx],cx
		mov [rm_dx],dx
		mov [rm_bp],bp
		mov [rm_si],si
		mov [rm_di],di
		mov [rm_ds],ds
		mov [rm_es],es
                pushf
                pop [rm_flags]
                mov [pm_dest],offset pint
		jmp [rm2pm]

rint		endp

ifdef USE_DEBUG
;Ŀ
; DEBUG64 SERVICE INTERRUPT						       
;
debug_int	proc near

		push si
		push di
		push bp
		push ds
		push ax
		mov ax,data
		mov ds,ax
		pop ax

		cmp ah,000h
		jnz @@no_init

		; AH=00: initialize debug facilities
		;     in: ES:DI = pointer to debug structure
		;     out: -

		mov [debug_proc_seg],es
		mov [debug_proc_ofs],di

		push di 			; clear debug structure
		mov eax,0
                mov ecx,18 + 256 + 256 + 256
		repz stosd
		pop di

		mov eax,0			; get copy buffer address
		mov ax,es
		shl eax,4
		movzx edi,di
                add edi,18 * 4
		add edi,eax
		mov eax,0
		mov ax,ds
		shl eax,4
		sub edi,eax
		mov [debug_copy],edi

		jmp @@fill_struct

@@no_init:	cmp ah,001h
		jnz @@no_refresh

		; AH=01: refresh debug structure
		;     in: -
		;     out: -

@@fill_struct:	mov es,[debug_proc_seg] 	; load debug structure pointer
		mov di,[debug_proc_ofs]

		mov eax,[debug_eax]		; store registers
		stosd
		mov eax,[debug_ebx]
		stosd
		mov eax,[debug_ecx]
		stosd
		mov eax,[debug_edx]
		stosd
		mov eax,[debug_esi]
		stosd
		mov eax,[debug_edi]
		stosd
		mov eax,[debug_esp]
		stosd
		mov eax,[debug_ebp]
		stosd
		mov eax,[debug_eip]
		stosd
		mov eax,[debug_eflags]
		stosd
		mov eax,[debug_result]
		stosd
		mov eax,[sys_type]
		stosd
		mov eax,[heap_base]
		stosd
		mov eax,[heap_top]
		stosd
		mov eax,[heap_ptr]
		stosd
		mov eax,[data_base]
		stosd
                mov eax,dword ptr [debug_irq]
                stosd
                mov [debug_irq],0

		mov eax,es:[di] 		; get data window pointer
		mov [debug_data],eax

		mov [saved_ss],ss		; copy code, data & stack
		mov [saved_esp],esp
		mov [pm_dest],offset pd64_refresh
		jmp [rm2pm]
rd64_refresh:	mov ss,[saved_ss]
		mov esp,[saved_esp]

		jmp @@end_debug

@@no_refresh:	cmp ah,002h
		jnz @@no_trace

		; AH=02: instruction trace
		;     in: -
		;     out: -

		mov [saved_ss],ss		; trace one instruction
		mov [saved_esp],esp
		mov [pm_dest],offset pd64_trace
		jmp [rm2pm]
rd64_trace:	mov ss,[saved_ss]
		mov esp,[saved_esp]

		jmp @@fill_struct

@@no_trace:	cmp ah,003h
		jnz @@no_goto

		; AH=03: goto address
		;     in: BXCX = address in pcode to set breakpoint
		;     out: -

		mov word ptr [debug_break],cx	; save breakpoint address
		mov word ptr [debug_break + 2],bx
		mov eax,large pcode
		shl eax,4
		add [debug_break],eax
		mov [saved_ss],ss
		mov [saved_esp],esp
		mov [pm_dest],offset pd64_goto
		jmp [rm2pm]
rd64_goto:	mov ss,[saved_ss]
		mov esp,[saved_esp]
		jmp @@fill_struct

@@no_goto:	cmp ah,004h
		jnz @@no_run

		; AH=04: run
		;     in: -
		;     out: -

		mov [saved_ss],ss
		mov [saved_esp],esp
		mov [pm_dest],offset pd64_run
		jmp [rm2pm]
rd64_run:	mov ss,[saved_ss]
		mov esp,[saved_esp]
		jmp @@fill_struct

@@no_run:	cmp ah,005h
		jnz @@no_show

		; AH=05: show VGA screen
		;     in: -
		;     out: -

                mov word ptr [debug_page],cx
		mov [saved_ss],ss
		mov [saved_esp],esp
		mov [pm_dest],offset pd64_show
		jmp [rm2pm]
rd64_show:	mov ss,[saved_ss]
		mov esp,[saved_esp]
		jmp @@end_debug
@@no_show:

@@end_debug:	pop ds
		pop bp
		pop di
		pop si
		iret

debug_int	endp
endif


rcode		ends
;
pcode		segment public use32
		assume cs:pcode,ds:data,es:data,fs:data,gs:pcode,ss:top


;Ŀ
; EXCEPTION HANDLERS							       
;
handler_00	proc near

		mov [exc_message],small offset error_00
ifdef USE_DEBUG
		mov [debug_result],0
endif
		jmp [exception]

handler_00	endp
;-------------------------------------------------------------------------------
handler_01	proc near

		mov [exc_message],small offset error_01
ifdef USE_DEBUG
		mov [debug_result],1
endif
		jmp [exception]

handler_01	endp
;-------------------------------------------------------------------------------
handler_02	proc near

		mov [exc_message],small offset error_02
ifdef USE_DEBUG
		mov [debug_result],2
endif
		jmp [exception]

handler_02	endp
;-------------------------------------------------------------------------------
handler_03	proc near

		mov [exc_message],small offset error_03
ifdef USE_DEBUG
		mov [debug_result],3
endif
		jmp [exception]

handler_03	endp
;-------------------------------------------------------------------------------
handler_04	proc near

		mov [exc_message],small offset error_04
ifdef USE_DEBUG
		mov [debug_result],4
endif
		jmp [exception]

handler_04	endp
;-------------------------------------------------------------------------------
handler_05	proc near

		mov [exc_message],small offset error_05
ifdef USE_DEBUG
		mov [debug_result],5
endif
		jmp [exception]

handler_05	endp
;-------------------------------------------------------------------------------
handler_06	proc near

		mov [exc_message],small offset error_06
ifdef USE_DEBUG
		mov [debug_result],6
endif
		jmp [exception]

handler_06	endp
;-------------------------------------------------------------------------------
handler_07	proc near

		mov [exc_message],small offset error_07
ifdef USE_DEBUG
		mov [debug_result],7
endif
		jmp [exception]

handler_07	endp
;-------------------------------------------------------------------------------
handler_08	proc near

		mov [exc_message],small offset error_08
ifdef USE_DEBUG
		mov [debug_result],8
endif
		jmp [exception]

handler_08	endp
;-------------------------------------------------------------------------------
handler_09	proc near

		mov [exc_message],small offset error_09
ifdef USE_DEBUG
		mov [debug_result],9
endif
		jmp [exception]

handler_09	endp
;-------------------------------------------------------------------------------
handler_0A	proc near

		mov [exc_message],small offset error_0A
ifdef USE_DEBUG
		mov [debug_result],10
endif
		jmp [exception]

handler_0A	endp
;-------------------------------------------------------------------------------
handler_0B	proc near

		mov [exc_message],small offset error_0B
ifdef USE_DEBUG
		mov [debug_result],11
endif
		jmp [exception]

handler_0B	endp
;-------------------------------------------------------------------------------
handler_0C	proc near

		mov [exc_message],small offset error_0C
ifdef USE_DEBUG
		mov [debug_result],12
endif
		jmp [exception]

handler_0C	endp
;-------------------------------------------------------------------------------
handler_0D	proc near

		mov [exc_message],small offset error_0D
ifdef USE_DEBUG
		mov [debug_result],13
endif
		jmp [exception]

handler_0D	endp
;-------------------------------------------------------------------------------
handler_0E	proc near

                add esp,4
		mov [exc_message],small offset error_0E
ifdef USE_DEBUG
		mov [debug_result],14
endif
		jmp [exception]

handler_0E	endp
;-------------------------------------------------------------------------------
handler_0F	proc near

		mov [exc_message],small offset error_0F
ifdef USE_DEBUG
		mov [debug_result],15
endif
		jmp [exception]

handler_0F	endp
;-------------------------------------------------------------------------------
handler_10	proc near

		mov [exc_message],small offset error_10
ifdef USE_DEBUG
		mov [debug_result],16
endif
		jmp [exception]

handler_10	endp
;-------------------------------------------------------------------------------
handler_11	proc near

		mov [exc_message],small offset error_11
ifdef USE_DEBUG
		mov [debug_result],17
endif
		jmp [exception]

handler_11	endp
;-------------------------------------------------------------------------------
handler_exc	proc near

		mov [exc_message],small offset error_exc
ifdef USE_DEBUG
		mov [debug_result],35
endif
		jmp [exception]

handler_exc	endp

;Ŀ
; IRQ HANDLERS 							       
;
handler_irq0    proc near

ifdef USE_DEBUG
                or [debug_irq],1
endif
		push eax
		mov al,020h
		out 020h,al
		pop eax
		iretd
                jmp handler_irq0

handler_irq0    endp
;-------------------------------------------------------------------------------
handler_irq2    proc near

ifdef USE_DEBUG
                or [debug_irq],4
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq2

handler_irq2    endp
;-------------------------------------------------------------------------------
handler_irq3    proc near

ifdef USE_DEBUG
                or [debug_irq],8
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq3

handler_irq3    endp
;-------------------------------------------------------------------------------
handler_irq4    proc near

ifdef USE_DEBUG
                or [debug_irq],16
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq4

handler_irq4    endp
;-------------------------------------------------------------------------------
handler_irq5    proc near

ifdef USE_DEBUG
                or [debug_irq],32
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq5

handler_irq5    endp
;-------------------------------------------------------------------------------
handler_irq6    proc near

ifdef USE_DEBUG
                or [debug_irq],64
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq6

handler_irq6    endp
;-------------------------------------------------------------------------------
handler_irq7    proc near

ifdef USE_DEBUG
                or [debug_irq],128
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq7

handler_irq7    endp
;-------------------------------------------------------------------------------
handler_irq8    proc near

ifdef USE_DEBUG
                or [debug_irq],256
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq8

handler_irq8    endp
;-------------------------------------------------------------------------------
handler_irq9    proc near

ifdef USE_DEBUG
                or [debug_irq],512
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq9

handler_irq9    endp
;-------------------------------------------------------------------------------
handler_irq10   proc near

ifdef USE_DEBUG
                or [debug_irq],1024
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq10

handler_irq10   endp
;-------------------------------------------------------------------------------
handler_irq11   proc near

ifdef USE_DEBUG
                or [debug_irq],2048
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq11

handler_irq11   endp
;-------------------------------------------------------------------------------
handler_irq12   proc near

ifdef USE_DEBUG
                or [debug_irq],4096
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq12

handler_irq12   endp
;-------------------------------------------------------------------------------
handler_irq13   proc near

ifdef USE_DEBUG
                or [debug_irq],8192
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq13

handler_irq13   endp
;-------------------------------------------------------------------------------
handler_irq14   proc near

ifdef USE_DEBUG
                or [debug_irq],16384
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq14

handler_irq14   endp
;-------------------------------------------------------------------------------
handler_irq15   proc near

ifdef USE_DEBUG
                or [debug_irq],32768
endif
                push eax
                mov al,020h
                out 020h,al
                pop eax
                iretd
                jmp handler_irq15

handler_irq15   endp
;-------------------------------------------------------------------------------
handler_irq1	proc near

ifdef USE_DEBUG
                or [debug_irq],2
endif
		push eax
		push ebx
		in al,060h
		mov bl,al
		in al,061h
		mov ah,al
		mov al,080h
		out 061h,al
		mov al,ah
		out 061h,al
		mov al,020h
		out 020h,al
		test bl,080h
		pop ebx
		pop eax
		jnz break_key
@@no_click:     mov [exc_message],small offset error_irq1
ifdef USE_DEBUG
		mov [debug_result],33
endif
		jmp [exception]
		jmp handler_irq1

break_key:	iretd
		jmp handler_irq1

handler_irq1	endp

;Ŀ
; RAW PROTECTED MODE SWITCH ROUTINES					       
;
r_prm2pm	proc near

		mov ax,SD_DATA			; setup selectors
		mov ds,ax
		mov es,ax
		mov fs,ax
		mov ax,SD_ALIAS
		mov gs,ax
		mov ax,SD_PSTACK
		mov ss,ax
ifdef USE_DEBUG
		mov esp,PSTACK_SIZE + PSTACK_DEBUG
else
		mov esp,PSTACK_SIZE
endif
		setup_irq 020h,028h		; reroute IRQ numbers

		mov al,036h			; set timer to 50 Hz
		out 043h,al
                mov al,TIMER_LO
		out 040h,al
                mov al,TIMER_HI
		out 040h,al

                mov eax,0
                mov ebx,eax
		mov ecx,eax
                mov edx,eax
                mov esi,eax
                mov edi,eax
                mov ebp,eax

                mov ax,[pm_pic]                 ; restore protected mode PIC
                out 021h,al
                mov al,ah
                out 0A1h,al

		jmp [pm_dest]

r_prm2pm	endp
;-------------------------------------------------------------------------------
r_ppm2rm	proc near

		cli				; turn off interrupts

                in al,0A1h                      ; save protected mode PIC
                mov ah,al
                in al,021h
                mov [pm_pic],ax

		mov al,036h			; reset timer to 18.2 Hz
		out 043h,al
		mov al,0
		out 040h,al
		out 040h,al

		setup_irq 008h,070h		; reroute IRQ numbers

		db 0EAh
		dw small offset r_rpm2rm,0,SD_RCODE

r_ppm2rm	endp

;Ŀ
; XMS PROTECTED MODE SWITCH ROUTINES					       
;
x_prm2pm	proc near

		mov ax,SD_DATA			; setup selectors
		mov ds,ax
		mov es,ax
		mov fs,ax
		mov ax,SD_ALIAS
		mov gs,ax
		mov ax,SD_PSTACK
		mov ss,ax
ifdef USE_DEBUG
		mov esp,PSTACK_SIZE + PSTACK_DEBUG
else
		mov esp,PSTACK_SIZE
endif
		setup_irq 020h,028h		; reroute IRQ numbers

		mov al,036h			; set timer to 50 Hz
		out 043h,al
                mov al,TIMER_LO
		out 040h,al
                mov al,TIMER_HI
		out 040h,al

                mov eax,0
                mov ebx,eax
                mov ecx,eax
                mov edx,eax
                mov esi,eax
                mov edi,eax
                mov ebp,eax

                mov ax,[pm_pic]                 ; restore protected mode PIC
                out 021h,al
                mov al,ah
                out 0A1h,al

		jmp [pm_dest]

x_prm2pm	endp
;-------------------------------------------------------------------------------
x_ppm2rm	proc near

		cli				; turn off interrupts

                in al,0A1h                      ; save protected mode PIC
                mov ah,al
                in al,021h
                mov [pm_pic],ax

		mov al,036h			; reset timer to 18.2 Hz
		out 043h,al
		mov al,0
		out 040h,al
		out 040h,al

		setup_irq 008h,070h		; reroute IRQ numbers

		db 0EAh
		dw small offset x_rpm2rm,0,SD_RCODE

x_ppm2rm	endp

;Ŀ
; VCPI PROTECTED MODE SWITCH ROUTINES					       
;
v_prm2pm	proc near

		mov ax,SD_DATA			; setup selectors
		mov ds,ax
		mov es,ax
		mov fs,ax
		mov ax,SD_ALIAS
		mov gs,ax
		mov ax,SD_PSTACK
		mov ss,ax
ifdef USE_DEBUG
		mov esp,PSTACK_SIZE + PSTACK_DEBUG
else
		mov esp,PSTACK_SIZE
endif
		setup_irq 020h,028h		; reroute IRQ numbers

		mov al,036h			; set timer to 50 Hz
		out 043h,al
                mov al,TIMER_LO
		out 040h,al
                mov al,TIMER_HI
		out 040h,al

                mov eax,0
                mov ebx,eax
                mov ecx,eax
                mov edx,eax
                mov esi,eax
                mov edi,eax
                mov ebp,eax

                mov ax,[pm_pic]                 ; restore protected mode PIC
                out 021h,al
                mov al,ah
                out 0A1h,al

		jmp [pm_dest]

v_prm2pm	endp
;-------------------------------------------------------------------------------
v_ppm2rm	proc near

		cli				; turn off interrupts

                in al,0A1h                      ; save protected mode PIC
                mov ah,al
                in al,021h
                mov [pm_pic],ax

		mov al,036h			; reset timer to 18.2 Hz
		out 043h,al
		mov al,0
		out 040h,al
		out 040h,al

		setup_irq 008h,070h		; reroute IRQ numbers

		mov eax,0
                mov ebx,eax
                mov ecx,eax
                mov edx,eax
                mov esi,eax
                mov edi,eax
                mov ebp,eax

                push large data
                push large data
		push large data
		push large data
		push large top
		push large RSTACK_SIZE
		pushfd
		push large rcode
		push large offset v_rpm2rm
		mov ax,SD_ZERO
		mov ds,ax
		mov ax,0DE0Ch
		call fword ptr es:[vcpi_call]

v_ppm2rm	endp

;Ŀ
; MAIN PROGRAM INITIALIZING						       
;
pre_main	proc near

                mov eax,0                       ; clear all pages
                mov edi,[page_base]
                mov ecx,131072
                repz stosd

		sti
		jmp main

pre_main	endp

;Ŀ
; CODE STUB								       
;
stub:		ret

;Ŀ
; exit: EXIT TO DOS							       
;
exit		proc near

ifdef USE_DEBUG
		cmp [debug_state],1
		jnz @@really_quit
		mov [debug_result],34
		jmp [exception]
@@really_quit:	mov [exc_message],0FFFFh
else
		call [pexit]
endif
		push [rdone]
		pop [rm_dest]
		jmp [pm2rm]

exit		endp

;Ŀ
; set_exit: SET CUSTOM CLEANUP AND EXIT ROUTINE			       
;
set_exit	proc near

		mov [pexit],eax
		ret

set_exit	endp

;Ŀ
; panic: PANIC BACK TO DOS WITH ERROR MESSAGE				       
;
panic		proc near

		mov [exc_message],ax
ifdef USE_DEBUG
		mov [debug_result],36
endif
		jmp [exception]

panic		endp

;Ŀ
; heap_avail: GET AMOUNT OF FREE HEAP					       
;
heap_avail	proc near

		mov eax,[heap_top]
		sub eax,[heap_ptr]
		ret

heap_avail	endp

;Ŀ
; heap_alloc: ALLOCATE HEAP BLOCK					       
;
heap_alloc	proc near

		mov ebx,[heap_ptr]
		add ebx,eax
		cmp ebx,[heap_top]
		ja @@error
		xchg eax,[heap_ptr]
		add [heap_ptr],eax
		ret

@@error:	mov eax,offset perror_mem
		jmp panic

heap_alloc	endp

;Ŀ
; heap_alloc4: ALLOCATE DWORD ALIGNED HEAP BLOCK                              
;
heap_alloc4     proc near

                test [heap_ptr],3
                jz @@aligned
                add [heap_ptr],3
                and [heap_ptr],0FFFFFFFCh
@@aligned:      call heap_alloc
                ret

heap_alloc4     endp

;Ŀ
; heap_mark: MARK CURRENT HEAP STATUS					       
;
heap_mark	proc near

		mov eax,[heap_ptr]
		ret

heap_mark	endp

;Ŀ
; heap_release: RELEASE CURRENT HEAP STATUS				       
;
heap_release	proc near

		mov [heap_ptr],eax
		ret

heap_release	endp

;Ŀ
; heap_reset: RESET HEAP						       
;
heap_reset	proc near

		mov eax,[heap_base]
		mov [heap_ptr],eax
		ret

heap_reset	endp

;Ŀ
; set_irq: SET CUSTOM IRQ HANDLER					       
;
set_irq 	proc near

		cli
		movzx ebx,bl
		mov word ptr [idt_irq + ebx * 8],ax
		shr eax,16
		mov word ptr [idt_irq + ebx * 8 + 6],ax
		sti
		ret

set_irq 	endp

;Ŀ
; get_irq: GET IRQ HANDLER						       
;
get_irq 	proc near

		movzx ebx,bl
		mov ax,word ptr [idt_irq + ebx * 8 + 6]
		shl eax,16
		mov ax,word ptr [idt_irq + ebx * 8]
		ret

get_irq 	endp

;Ŀ
; enable_irq: ENABLE IRQ SIGNAL                                               
;
enable_irq      proc near

                mov cl,bl
                mov ax,1
                shl ax,cl
                not ax
                and ax,[pm_pic]
                out 021h,al
                mov al,ah
                out 0A1h,al
                ret

enable_irq      endp

;Ŀ
; disable_irq: DISABLE IRQ SIGNAL                                             
;
disable_irq     proc near

                mov cl,bl
                mov ax,1
                shl ax,cl
                or ax,[pm_pic]
                out 021h,al
                mov al,ah
                out 0A1h,al
                ret

disable_irq     endp

;Ŀ
; int_rm: CALL REALMODE INTERRUPT					       
;
int_rm		proc near

		mov [pm_ss],ss
		mov [pm_esp],esp
		mov [rm_int],al
		mov [rm_dest],offset rint
		jmp [pm2rm]
pint:		mov ss,[pm_ss]
		mov esp,[pm_esp]
                sti
		ret

int_rm		endp

;Ŀ
; set_color: SET VGA DAC REGISTER                                             
;
set_color       proc near

ifdef USE_DEBUG
                push ebx
                mov ebx,0
                mov bl,al
                add ebx,ebx
                add bl,al
                adc bh,0
                add ebx,offset palette
                shr eax,8
                mov [ebx],al
                shr eax,8
                mov [ebx + 1],al
                shr eax,8
                mov [ebx + 2],al
                pop ebx
else
                mov dx,003C8h
                out dx,al
                inc dx
                shr eax,8
                out dx,al
                shr eax,8
                out dx,al
                shr eax,8
                out dx,al
endif
                ret

set_color       endp

;Ŀ
; set_palette: SET ALL VGA DAC REGISTERS                                      
;
set_palette     proc near

ifdef USE_DEBUG
                push esi
                push edi
                mov edi,offset palette
                mov ecx,768 / 4
                repz movsd
                pop edi
                pop esi
else
                mov al,0
                mov dx,003C8h
                out dx,al
                mov ecx,256
                inc dx
@@next_color:   mov al,[esi]
                out dx,al
                mov al,[esi + 1]
                out dx,al
                mov al,[esi + 2]
                out dx,al
                add esi,3
                dec ecx
                jnz @@next_color
endif
                ret

set_palette     endp


ifdef USE_DEBUG
;Ŀ
; DEBUG64 PROTECTED MODE SUPPORT ROUTINES				       
;
pd64_refresh	proc near

		mov edi,[debug_copy]
		mov esi,[debug_eip]
		push ds
		push gs
		pop ds
		mov ecx,256
		repz movsd
		pop ds

		mov esi,[debug_esp]
		push ds
		push ss
		pop ds
		mov ecx,256
		repz movsd
		pop ds

		mov esi,[debug_data]
		mov ecx,256
		repz movsd

                mov [rm_dest],offset rd64_refresh
		jmp [pm2rm]

pd64_refresh	endp
;-------------------------------------------------------------------------------
pd64_trace	proc near

		mov [exception],offset pd64_trace_exc

		mov eax,[debug_eax]
		mov ebx,[debug_ebx]
		mov ecx,[debug_ecx]
		mov edx,[debug_edx]
		mov esi,[debug_esi]
		mov edi,[debug_edi]
		mov esp,[debug_esp]
		mov ebp,[debug_ebp]

		or [debug_eflags],000000100h

		push [debug_eflags]
		push cs
		push [debug_eip]
		mov [debug_state],1
		sti

		iretd

pd64_trace_exc: cli
		mov [debug_state],0
		pop [debug_eip]
		pop [debug_eflags]
		pop [debug_eflags]

		and [debug_eflags],0FFFFFEFFh

		mov [debug_eax],eax
		mov [debug_ebx],ebx
		mov [debug_ecx],ecx
		mov [debug_edx],edx
		mov [debug_esi],esi
		mov [debug_edi],edi
		mov [debug_ebp],ebp
		mov [debug_esp],esp

		cmp [debug_result],1
		jnz @@not_debug
		mov [debug_result],000000020h

@@not_debug:	mov [exc_message],0FFFFh
		mov [exception],offset exit

		mov [rm_dest],offset rd64_trace
		jmp [pm2rm]

pd64_trace	endp
;-------------------------------------------------------------------------------
pd64_goto	proc near

		mov [exception],offset pd64_goto_exc

		mov eax,[debug_break]
		mov dr0,eax
		mov eax,000000002h
		mov dr7,eax

		mov eax,[debug_eax]
		mov ebx,[debug_ebx]
		mov ecx,[debug_ecx]
		mov edx,[debug_edx]
		mov esi,[debug_esi]
		mov edi,[debug_edi]
		mov esp,[debug_esp]
		mov ebp,[debug_ebp]

		push [debug_eflags]
		push cs
		push [debug_eip]
		mov [debug_state],1
		sti

		iretd

pd64_goto_exc:	cli
		mov [debug_state],0
		pop [debug_eip]
		pop [debug_eflags]
		pop [debug_eflags]

		mov [debug_eax],eax
		mov [debug_ebx],ebx
		mov [debug_ecx],ecx
		mov [debug_edx],edx
		mov [debug_esi],esi
		mov [debug_edi],edi
		mov [debug_esp],esp
		mov [debug_ebp],ebp

		cmp [debug_result],001h
		jnz @@not_debug
		mov [debug_result],020h

@@not_debug:	mov eax,0
		mov dr7,eax

		mov [exc_message],0FFFFh
		mov [exception],offset exit

		mov [rm_dest],offset rd64_goto
		jmp [pm2rm]

pd64_goto	endp
;-------------------------------------------------------------------------------
pd64_run	proc near

		mov [exception],offset pd64_run_exc

		mov eax,[debug_eax]
		mov ebx,[debug_ebx]
		mov ecx,[debug_ecx]
		mov edx,[debug_edx]
		mov esi,[debug_esi]
		mov edi,[debug_edi]
		mov esp,[debug_esp]
		mov ebp,[debug_ebp]

		push [debug_eflags]
		push cs
		push [debug_eip]
		mov [debug_state],1
		sti

		iretd

pd64_run_exc:	cli
		mov [debug_state],0
		pop [debug_eip]
		pop [debug_eflags]
		pop [debug_eflags]

		mov [debug_eax],eax
		mov [debug_ebx],ebx
		mov [debug_ecx],ecx
		mov [debug_edx],edx
		mov [debug_esi],esi
		mov [debug_edi],edi
		mov [debug_esp],esp
		mov [debug_ebp],ebp

		mov [exc_message],0FFFFh
		mov [exception],offset exit

		mov [rm_dest],offset rd64_run
		jmp [pm2rm]

pd64_run	endp
;-------------------------------------------------------------------------------
pd64_show	proc near

                mov esi,offset palette
                mov al,0
                mov dx,003C8h
                out dx,al
                mov ecx,256
                inc dx
@@next_color:   mov al,[esi]
                out dx,al
                mov al,[esi + 1]
                out dx,al
                mov al,[esi + 2]
                out dx,al
                add esi,3
                dec ecx
                jnz @@next_color

		mov esi,[page_base]
		mov edi,[vid_base]
		mov ecx,16000
		repz movsd

                mov [rm_dest],offset rd64_show
		jmp [pm2rm]

pd64_show	endp
endif

;Ŀ
; DATAFILE LOADER PROTECTED MODE SUPPORT ROUTINE			       
;
pcopy_data	proc near

		mov esi,[data_source]
		mov edi,[heap_base]
		mov ecx,[data_size]
		repz movsb
		mov [rm_dest],offset rcopy_data
		jmp [pm2rm]

pcopy_data	endp


pcode		ends
;
top		segment stack use32 'stack'


ifdef USE_DEBUG
		db RSTACK_SIZE + PSTACK_SIZE + PSTACK_DEBUG dup(0)
else
		db RSTACK_SIZE + PSTACK_SIZE dup(0)
endif


top		ends
;
                end rinit
