#include "..\wshell\xidsw.h"

u8  *pCFB;
u8  *YAddrTab[480];

void SetMode(u8 Mode);
#pragma aux SetMode = \
  "xor ah,ah" \
  "int 10h"\
  parm [al] \
  modify [eax];


u8 GetCH(void);
#pragma aux GetCH = \
  "mov ah,8h" \
  "int 21h" \
  modify [eax];


void  Init_YAddrTab(void)
  {
  register s32  i;
  register u8   *p;
  register u8   **pp;

  for (
      i = 480, p = pCFB, pp = YAddrTab;
      i > 0;
      i --, p += 320, pp ++)
    *pp = p;
  }


void  FlushCFB(void)
  {
  register u32  *p1, *p2;
  register s32  i;

  p1 = (u32 *)pCFB;
  p2 = (u32 *)(0x000A0000 - Code32Addr);

  for (i=320*200/4; i>0; *p2++=*p1++, i--);
  }


void  ClearCFB(void)
  {
  register u32 *p;
  register s32  i;
  for (i=320*200/4, p=(u32 *)pCFB; i>0; *p++=0, i--);
  }


void  PutPixel(u16 x, u16 y, u8 c)
  {
  if (x>320 || y>200) return;
  *(YAddrTab[y]+x)=c;
  }


void  C_Entry(void)
  {
  // allocate color frame buffer
  pCFB = (u8 *)malloc(320*200);

  // clear color frame buffer
  ClearCFB();

  // initialize Y table offsets
  Init_YAddrTab();

  // set mode 13h
  SetMode(0x13);

  // draw pattern to CFB
  {
  u32  x;

  for (x = 0; x < 320; x ++)
    PutPixel(x,sin(x*2*3.14159/320)*50+100,15);
  }

  // flush frame buffer
  FlushCFB();

  // get key
  GetCH();


  // release color frame buffer
  free(pCFB);

  SetMode(0x03);
  }
