
;ͻ;
; File functions                                                            ;
;ͼ;


;*****************************************************************************;
Code32 SEGMENT
  ASSUME CS:Code32, DS:Code32, SS:Code32

DiskBufferSeg dw DiskBuffer           ; segment of disk buffer

FileOpenErrorMSG db 'File Open Error.$'

fHandle dd 0                          ; generic file handle

;Ŀ;
; Open a file for Read and Write                                            ;
; Entry: EDX - Offset of ASCIIZ filename                                    ;
; Exit : EAX - File handle                                                  ;
;;
FileOpen:
  push edx
  call AddrEDXtoRM
  mov ax,3D02h
  rint 21h
  jnc @@NoError
    mov edx,o FileOpenErrorMSG
    jmp ErrorExit32
  @@NoError:
  pop edx
  ret


;Ŀ;
; Create a file and open for write                                          ;
; Entry: EDX - Offset of ASCIIZ filename                                    ;
; Exit : EAX - File handle                                                  ;
;;
FileCreate:
  push ecx edx
  call AddrEDXtoRM
  mov ah,3Ch
  mov cx,20h
  rint 21h
  pop edx ecx
  ret


;Ŀ;
; Close a currently opened file                                             ;
; Entry: EBX - File handle                                                  ;
;;
FileClose:
  mov ah,3Eh
  rint 21h
  ret


;Ŀ;
; Return the size of a currently open file                                  ;
; Entry: EBX - File handle                                                  ;
; Exit : EAX - Size of file                                                 ;
;;
FileSize:
  pushad
  mov ax,4201h
  xor ecx,ecx
  xor edx,edx
  rint 21h
  push edx eax
  mov ax,4202h
  xor edx,edx
  rint 21h
  mov esi,edx
  shl esi,16
  mov si,ax
  pop edx ecx
  mov ax,4200h
  rint 21h
  mov [esp+28],esi    ; return in EAX
  popad
  ret


;Ŀ;
; Read a block from a file                                                  ;
; Entry: EDX - Offset of data buffer                                        ;
;      : ECX - Size of buffer                                               ;
;      : EBX - File handle                                                  ;
;;
FileRead:
  pushad

  push m DiskBufferSeg
  pop m rm_DS

  mov edi,edx
  mov ebp,ecx

  ReadLoop:
    xor edx,edx
    mov ecx,ebp
    cmp ecx,DISKBUFFER_SIZE
    jbe @@10
      mov ecx,DISKBUFFER_SIZE
    @@10:

    mov ah,3Fh
    rint 21h

    sub ebp,ecx
    movzx esi,m DiskBufferSeg
    shl esi,4
    sub esi,m Code32addr
    rep movsb
    test ebp,ebp
    jnz ReadLoop

  popad

  ret


;Ŀ;
; Write a block to file                                                     ;
; Entry: EDX - Offset of data buffer                                        ;
;      : ECX - Size of buffer                                               ;
;      : EBX - File handle                                                  ;
;;
FileWrite:
  pushad

  push m DiskBufferSeg
  pop m rm_DS

  mov esi,edx
  mov ebp,ecx

  WriteLoop:
    mov ecx,ebp
    cmp ecx,DISKBUFFER_SIZE
    jbe @@10
      mov ecx,DISKBUFFER_SIZE
    @@10:

    sub ebp,ecx
    movzx edi,m DiskBufferSeg
    shl edi,4
    sub edi,m Code32addr
    push ecx
    rep movsb
    pop ecx

    xor edx,edx
    mov ah,40h
    rint 21h

    test ebp,ebp
    jnz WriteLoop

  popad

  ret


;*****************************************************************************;
Code32 ENDS


;*****************************************************************************;
  ; Disk Buffer segment
DiskBuffer   SEGMENT
  db DISKBUFFER_SIZE dup (?)
DiskBuffer   ENDS
