// Warning : this file contains code! (if you are using Watcom C)

#include <stddef.h>

#ifndef __QLIB_H__
#define __QLIB_H__

extern void getint(byte v);         /*ax:edx == seg:off     */
extern void getrmint(byte v);       /*ax:dx  == seg:off     */
extern sbyte setint(byte v,word s,dword off);
extern sbyte setrmint(byte v,word s,word off);
extern void alloc_callback(dword off,dword regs);   // ret: cx:dx = real mode loc.  //regs=&callstruct
  #define CB_RETF 0
  #define CB_IRET 1
extern void free_callback(word seg,word off);  // in: seg:off=real mode loc.  */
extern void _iret(dword regs); // used to end a callback PROC (iret stack frame)
extern void _retf(dword regs); // used to end a callback PROC (retf stack frame)
extern dword alloc_phys(dword loc,dword siz);
extern dword free_phys(dword loc);
extern byte lock_ram(dword off,dword siz);
extern byte unlock_ram(dword off,dword siz);
extern byte lock_all(byte uselockonly);  //returns amount locked
extern void uninitall(void);   //uninit everything thru atexit
extern void setmode50(void);

extern void irq_enable(byte a);
extern void irq_disable(byte a);

 //see pack.txt for explaination of everything below
extern sbyte pack_init(word siz1,word packs); //a special file IO sub-system
extern sbyte pack_uninit(void);               //free buffers and disable the sub-system
extern word pack_open(byte *strg);            //allows reading of WAD type files
extern word pack_open_hdr(byte *strg,byte *hdr);  //Same but with header already loaded
extern sbyte pack_close(word);    //closes a packed file opened with pack_open() or pack_open_hdr()

extern byte _os_typ;                /* see os.txt */
extern byte _os_ver_major;
extern byte _os_ver_minor;
extern byte _dos_ver_major;
extern byte _dos_ver_minor;
extern word _dosXver;        //DOS extender version (binary value)
extern byte _dosXtyp;        //DOS extender type (0=PMODEW 1=DOS/4GW 2=DOS32)
  #define DOSX_PMODEW 0
  #define DOSX_DOS4GW 1
  #define DOSX_DOS32 2   //not implemented any more
extern word errno;        //last error code
extern word selcode;         /*selectors*/
extern word seldata;
extern word selzero;
extern dword _environ;       /*linear addr to enviroment*/
extern dword _psp;           //linear addr to your PSP
extern dword _dta;           //linear addr to your DTA (it's not in your PSP)
extern dword _base;          //always 0
extern byte _fpu;          /* flag : 1=80387 or better present  0=otherwise */
extern byte _8087;         /* for WATCOM compatibility */
extern byte _argstr;    /* ;129 dup (?) */
extern byte ** _argv;
extern byte _argc;
extern byte _pmmode;        //1=RAW 2=XMS 4=VCPI 8=DPMI
  #define SRV_DPMI 3
  #define SRV_VCPI 2
  #define SRV_XMS 1
  #define SRV_RAW 0
extern dword _filename;     //same as _argv[0]
extern word _ds_;         //these are loaded when certain INTs are called
extern word _es_;         // INT 10h,33h
extern word _8kbufferseg;  //RMODE seg     //free to use as you like
extern dword _8kbuffer;    //linear addr
extern byte _processor;    /* processor type : 3=386 4=486 5=586 */

  // not used much - If I do I'll try and use ANSI C error codes

extern void NULLPROC(void);

//this is used with DPMI funcs #30x  (callbacks and calling RMODE)
struct callstruct {   //50 bytes  (32h)
  dword edi;     //0
  dword esi;     //4
  dword ebp;     //8
  dword res;     //reserved
  dword ebx;     //0ch
  dword edx;     //10h
  dword ecx;     //14h
  dword eax;     //18h
  dword flg;     //20h flags
  dword es;      //22h segments (NOT selectors)
  dword ds;      //24h "
  dword fs;      //26h "
  dword gs;      //28h "
  dword ip;      //2ah ignored in some calls
  dword cs;      //2ch "
  dword sp;      //2eh must be 0 to use system stacks
  dword ss;      //30h "
};

struct dma_s {
  dword siz;
  dword off;
  word sel;
  word id;
  dword phys;
  word dmach;
};  

// NOTE : these func auto take advantage of VDS
// see DMA.TXT for explaintion of usage
extern dword dma_alloc64(struct dma_s *);    /*==ERROR if not avail  */
extern dword dma_alloc128(struct dma_s *);   /*==ERROR if not avail  */
extern dword dma_free(struct dma_s *);

#endif

