; OS detection V1.01

; NEW v1.01 - added support for DesqView (Dec 17/96)
; NEW v1.02 - change to _os_typ, _os_ver_major, _os_ver_minor
;             added _dos_ver_major, _dos_ver_minor
;sets _os to the following
; included by c0?.asm

;os_typ's are
include os.inc  ;holds equs

.code
os_detect proc private
  mov ax,160ah  ;get Win version
  int 2fh
  cmp ax,0
  jnz dos16
windoze_found:
  mov _os_typ,OS_WIN
  mov _os_ver_major,bh
  mov _os_ver_minor,bl

  .if bh>3
    mov _os_typ,OS_WIN95   ; Win 95/NT 4.0
  .endif
  .if bl>11
    mov _os_typ,OS_WINNT   ; Win NT 3.x
  .endif
  jmp getDOSver
dos16:
  mov     ax,2B01h   ;detect Desqview
  mov     cx,4445h
  mov     dx,5351h
  int     21h
  cmp     al,0FFh
  jz      noDV
  mov _os_typ,OS_DV    ;Desqview detected!
  mov _os_ver_major,0
  mov _os_ver_minor,0  ;BUG! : what is the version?
  jmp getDOSver
noDV:
  mov _os_typ,OS_DOS    ; DOS detected!

getDOSver:
  mov ax,3000h
  int 21h
  mov _dos_ver_major,al
  mov _dos_ver_minor,ah
  .if _os_typ == OS_DOS
    mov _os_ver_major,al
    mov _os_ver_minor,ah
  .endif
  ret

os_detect endp

