{}
{  FFFF OOOO N  N TTTT   EEEE DDD  I TTTT OOOO RRRR    COPYWRONG (C)  1994  }
{  F    O  O NN N  T     EEE  D  D I  T   O  O R  R    BY MARCIN JASKOWIAK  }
{  FFFF O  O N NN  T     E    D  D I  T   O  O RRR     AKA PARADiSE         }
{  F    OOOO N  N  T     EEEE DDD  I  T   OOOO R  R    VERSION 1.0          }
{}
PROGRAM TED;

USES CRT,DOS,GIF;
{}
CONST
 HEADER  : ARRAY [1..20] OF BYTE =(254,84,69,68,254,57,52,254,80,65,
                                   82,65,68,105,83,69,254,00,00,07);
 ENTER   = 00013;
 ESC     = 00027;
 F1      = 15104;
 F2      = 15360;
 F3      = 15616;
 F4      = 15872;
 F5      = 16128;
 F6      = 16384;
 F7      = 16640;
 F8      = 16896;
 F9      = 17152;
 F10     = 17408;
 ALTF1   = 26624;
 ALTF2   = 26880;
 ALTF3   = 27136;
 ALTF4   = 27392;
 ALTF5   = 27648;
 ALTF6   = 27904;
 ALTF7   = 28160;
 ALTF8   = 28416;
 ALTF9   = 28672;
 ALTF10  = 28928;
 HOMEK   = 18176;
 UPK     = 18432;
 PGUPK   = 18688;
 LEFTK   = 19200;
 RIGHTK  = 19712;
 ENDK    = 20224;
 DOWNK   = 20480;
 PGDNK   = 20736;
 INSK    = 20992;
 DELK    = 21248;
 CTRLK   = 29440;
 CTRRK   = 29696;
 CTRUK   = 18688;
 CTRDK   = 20736;
 ALTX    = 11520;
TYPE
 MOUSESHAPE     = ARRAY [1..100,1..100] OF BYTE;
 TSCREEN        = ARRAY [0..63999] OF BYTE;
 PSCREEN        = ^TSCREEN;
CONST
 MMY     : WORD = 20;
 MMX     : WORD = 20;
 Q       = 255;
VAR
 FONT           : ARRAY [0..255,0..15] OF BYTE;
 MOUSE          : BOOLEAN;
 KEY            : WORD;
 QUIT,MOUSEHIDE : BOOLEAN;
 XCHAR,YCHAR    : BYTE;
 POSX,POSY,X,Y  : WORD;
 MX,MY,MB,OX,OY : WORD;
 LASTCH         : CHAR;
 BACKM,MOUSEC   : MOUSESHAPE;
 TEMP           : ARRAY [1..10000] OF BYTE;
 PALETTE        : ARRAY [0..255,1..3] OF BYTE;
 BITMAP         : PSCREEN;
 S,N            : STRING;
 CHARS          : ARRAY [' '..']'] OF POINTER;
 CHARSDATA      : ARRAY [' '..']',1..3] OF BYTE;
{}
PROCEDURE INITVGA; ASSEMBLER; { INITIALIZE VGA CARD MODE 13H }
ASM
 MOV AX,0013H
 INT 10H
END;
{}
PROCEDURE CLOSEVGA; ASSEMBLER; { CLOSE VGA MODE AND SET TEXT }
ASM
 MOV AX,0003H
 INT 10H
END;
{}
FUNCTION ISMOUSE: BOOLEAN; { CHECK IF MOUSE ACTIVE }
VAR IS: WORD;
BEGIN
 ASM
  XOR AX,AX
  INT 33H
  MOV IS,AX
 END;
 IF IS=0 THEN ISMOUSE:=FALSE
 ELSE ISMOUSE:=TRUE;
END;
{}
PROCEDURE MOUSEPOS(VAR X,Y,BUTTON: WORD); { RETURN MOUSE POS AND BUTTON STAT }
VAR R: REGISTERS;
BEGIN
 R.AX:=3;
 INTR($33,R);
 X:=R.CX;
 Y:=R.DX;
 IF R.BX=4 THEN BUTTON:=3 ELSE BUTTON:=R.BX;
 X:=X DIV 2;
END;
{}
PROCEDURE SETCOLOR(NR,R,G,B: BYTE); ASSEMBLER; { SET RGB VAL TO COLOR NR }
ASM
 MOV DX,3C8H
 MOV AL,NR
 OUT DX,AL
 INC DX
 MOV AL,R
 OUT DX,AL
 MOV AL,G
 OUT DX,AL
 MOV AL,B
 OUT DX,AL
END;
{}
FUNCTION GETKEY: WORD; { RETURN PRESSED KEY }
VAR CH: CHAR;
BEGIN
 CH:=READKEY;
 IF ORD(CH)=0 THEN GETKEY:=WORD(ORD(READKEY)) SHL 8
              ELSE GETKEY:=ORD(CH);
 LASTCH:=CH;
END;
{}
PROCEDURE PUTPIX(X,Y : INTEGER; C: BYTE); ASSEMBLER; { PLOT PIXEL AT (X,Y) }
ASM
 MOV   AX, 0A000H
 MOV   ES, AX
 MOV   AX, 320
 MUL   Y
 ADD   AX, X
 MOV   DI, AX
 MOV   AL, C
 STOSB
END;
{}
FUNCTION GETPIX(X,Y : INTEGER): BYTE; ASSEMBLER; { GET A PIXEL FROM (X,Y) }
ASM
 MOV   AX, 0A000H
 MOV   ES, AX
 MOV   AX, 320
 MUL   Y
 ADD   AX, X
 MOV   DI, AX
 LODSB
END;
{}
PROCEDURE PUTPIX2(X,Y: INTEGER; C: BYTE); { MEMORY PUT PIXEL PROC }
BEGIN
 MEM[$A000:Y*320+X]:=C;
END;
{}
PROCEDURE RECTANGLE(X1,Y1,X2,Y2: INTEGER; C: BYTE); { DRAW A RECTANGLE }
VAR Z: INTEGER;
BEGIN
 FOR Z:=X1 TO X2 DO
 BEGIN
  PUTPIX(Z,Y1,C);
  PUTPIX(Z,Y2,C);
 END;
 FOR Z:=Y1 TO Y2 DO
 BEGIN
  PUTPIX2(X1,Z,C);
  PUTPIX2(X2,Z,C);
 END;
END;
{}
PROCEDURE RECTANGLE2(X1,Y1,X2,Y2: INTEGER; C: BYTE); { DRAW A RECTANGLE #2 }
VAR Z: INTEGER;
BEGIN
 FOR Z:=X1 TO X2 DO
 IF ODD(Z) THEN BEGIN
  PUTPIX(Z,Y1,C);
  PUTPIX(Z,Y2,C);
 END;
 FOR Z:=Y1 TO Y2 DO
 IF ODD(Z) THEN BEGIN
  PUTPIX2(X1,Z,C);
  PUTPIX2(X2,Z,C);
 END;
END;
{}
PROCEDURE LOADFONT;
VAR FONTFILE: FILE;
    CHNUM: BYTE;
    CRAP: ARRAY[0..15] OF BYTE;
PROCEDURE ROMFONT;
VAR F8X8OFS,F8X8SEG: WORD;
BEGIN
 ASM
  PUSH BP
  MOV  AH,11H
  MOV  AL,30H
  MOV  BH,06H
  INT  10H
  MOV  AX,BP
  POP  BP
  MOV  F8X8OFS,AX
  MOV  F8X8SEG,ES
 END;
 MOVE(MEM[F8X8SEG:F8X8OFS],FONT,256*16)
END;
BEGIN
 ASSIGN(FONTFILE,'TED.FNT');
 {$I-}
 RESET(FONTFILE,1);
 IF IORESULT<>0 THEN ROMFONT
 ELSE
 FOR CHNUM:=0 TO 255 DO
 BEGIN
  BLOCKREAD(FONTFILE,FONT[CHNUM,0],16);
  BLOCKREAD(FONTFILE,CRAP,16);
 END;
 {$I+}
END;
{}
PROCEDURE WRITEXY(TEKST: STRING; X,Y: INTEGER; C: BYTE); { PRINT TEXT AT X,Y }
VAR TX,TY: WORD; IZ: BYTE;
BEGIN
 FOR IZ:=1 TO LENGTH(TEKST) DO
 FOR TY:=0 TO 15 DO
 FOR TX:=0 TO 7 DO
  IF FONT[ORD(TEKST[IZ]),TY] AND ($80 SHR TX)<>0 THEN
  PUTPIX(X+TX+(IZ-1)*10,Y+TY,C);
END;
{}
PROCEDURE BAR(X1,Y1,X2,Y2: INTEGER; COLOR: BYTE); ASSEMBLER; { BAR BY WELTI }
VAR I,H,ENDE : INTEGER;
ASM
 MOV   AX, X2
 CMP   AX, X1
 JAE   @L1
 XCHG  X1, AX
 XCHG  X2, AX
 XCHG  X1, AX
 @L1:
 MOV   AX, Y2
 CMP   AX, Y1
 JAE   @L2
 XCHG  Y1, AX
 XCHG  Y2, AX
 XCHG  Y1, AX
 @L2:
 MOV   AX, X2
 MOV   ENDE, AX
 MOV   CX, Y2
 SUB   CX, Y1
 INC   CX
 MOV   AX, 0A000H
 MOV   ES, AX
 MOV   AX, 320
 MUL   Y1
 ADD   AX, X1
 MOV   DI, AX
 MOV   DX, X2
 SUB   DX, X1
 INC   DX
 MOV   AH, COLOR
 MOV   AL, COLOR
 @FORSCHLEIFE:
 MOV  BX, X1
 CMP  DX, 1
 JE   @WHILE2
 @WHILE1:
 STOSW
 ADD   BX, 2
 CMP   BX, ENDE
 JB @WHILE1
 MOV  H, DX
 AND  H, 1
 CMP  H, 1
 JNE  @GERADE
 @WHILE2:
 STOSB
 @GERADE:
 ADD   DI, 320
 SUB   DI, DX
 LOOP @FORSCHLEIFE
END;
{}
PROCEDURE PUTMOUSE(X,Y: INTEGER; MC: MOUSESHAPE); { DRAW MOUSE CURSOR }
VAR TX,TY: INTEGER;
BEGIN
 FOR TY:=1 TO MMY DO
  FOR TX:=1 TO MMX DO
  BEGIN
   MEM[$A000:(Y+TY-1)*320+X+TX-1]:=MC[TY,TX];
  END;
END;
{}
PROCEDURE GETMOUSE(X,Y: INTEGER; VAR MC: MOUSESHAPE); { GET MOUSE CURSOR }
VAR TX,TY: INTEGER;
BEGIN
 FOR TY:=1 TO MMY DO
  FOR TX:=1 TO MMX DO
  BEGIN
   MC[TY,TX]:=MEM[$A000:(Y+TY-1)*320+X+TX-1];
  END;
END;
{}
PROCEDURE SETUPMOUSE; { INITIALIZE VGA MOUSE }
BEGIN
 MOUSEHIDE:=FALSE;
 MOUSEPOS(OX,OY,MB);
 GETMOUSE(OX,OY,BACKM);
 MOUSEPOS(MX,MY,MB);
 RECTANGLE(MX,MY,MX+XCHAR,MY+YCHAR,255);
END;
{}
PROCEDURE RELEASEMOUSE; { FREE VGA MOUSE }
BEGIN
END;
{}
PROCEDURE SHOWMOUSE; { MAKE MOUSE VISIBLE }
BEGIN
 IF MOUSEHIDE=FALSE THEN EXIT;
 MOUSEHIDE:=FALSE;
 MOUSEPOS(OX,OY,MB);
 GETMOUSE(OX,OY,BACKM);
 MX:=OX; MY:=OY;
 RECTANGLE(MX,MY,MX+XCHAR,MY+YCHAR,255);
 DELAY(100);
END;
{}
PROCEDURE HIDEMOUSE; { MAKE MOUSE INVISIBLE }
BEGIN
 IF MOUSEHIDE THEN EXIT;
 MOUSEHIDE:=TRUE;
 PUTMOUSE(OX,OY,BACKM);
 DELAY(100);
END;
{}
PROCEDURE MOUSEACTION; { FULL MOUSE MOVE PROCEDURE }
BEGIN
 MB:=0; MOUSEPOS(MX,MY,MB);
 IF MOUSEHIDE=FALSE THEN
 IF (MX<>OX) OR (MY<>OY) THEN
 BEGIN
  PUTMOUSE(OX,OY,BACKM);
  GETMOUSE(MX,MY,BACKM);
  RECTANGLE(MX,MY,MX+XCHAR,MY+YCHAR,255);
 END;
 OX:=MX; OY:=MY;
END;
{}
FUNCTION CHECK(X1,Y1,X2,Y2: INTEGER): BOOLEAN; { CHECK MOUSE COLLIDE }
BEGIN
 IF (MX>X2) OR (MX<X1) OR (MY<Y1) OR (MY>Y2) THEN CHECK:=FALSE
 ELSE CHECK:=TRUE;
END;
{}
PROCEDURE TRUESHOW; ASSEMBLER; { SHOW A CORE MOUSE CURSOR }
ASM
 MOV AX,1
 INT 33H
END;
{}
PROCEDURE TRUEHIDE; ASSEMBLER; { HIDE A CORE MOUSE CURSOR }
ASM
 MOV AX,2
 INT 33H
END;
{}
PROCEDURE CREATEVIRTUAL; { CREATE VIRTUAL SCREEN IN MEMORY }
BEGIN
 GETMEM(BITMAP,64000);
 FILLCHAR(BITMAP^,64000,0);
END;
{}
PROCEDURE RELEASEVIRTUAL; { REMOVE VIRTUAL SCREEN IN MEMORY }
BEGIN
 FREEMEM(BITMAP,64000);
END;
{}
PROCEDURE COPYVIRTUAL; { COPY SCREEN TO ADDRESS 0A000:0 }
BEGIN
 MOVE(BITMAP^,MEM[$A000:0],64000);
END;
{}
PROCEDURE READCEL(NAME: STRING); { LOAD CEL FROM .CEL AND PALETTE FROM .COL }
VAR F: FILE; NR: BYTE;
BEGIN
 ASSIGN(F,NAME+'.CEL');
 {$I-} RESET(F,1); NR:=IORESULT; {$I+}
 IF NR>0 THEN EXIT;
 SEEK(F,800);
 BLOCKREAD(F,BITMAP^,64000);
 CLOSE(F);
 ASSIGN(F,NAME+'.COL');
 {$I-} RESET(F,1); NR:=IORESULT; {$I+}
 IF NR=0 THEN
 BEGIN
  BLOCKREAD(F,PALETTE,768);
  CLOSE(F);
  FOR NR:=0 TO 255 DO SETCOLOR(NR,PALETTE[NR,1],PALETTE[NR,2],PALETTE[NR,3]);
 END;
END;
{}
VAR PAL: ARRAY [0..767] OF BYTE;
FUNCTION NEXTPIXEL: INTEGER; FAR;
BEGIN
 INC(X);
 IF X> 64000 THEN NEXTPIXEL:= -1 ELSE NEXTPIXEL := BITMAP^[X-1];
END;
PROCEDURE DUMMY(VAR LINE; X,Y:INTEGER); FAR;
BEGIN
 MOVE(LINE,BITMAP^[X*320],Y);
END;
PROCEDURE READGIF(NAME: STRING);
VAR NR: BYTE;
BEGIN
 X := 0;
 Y := 0;
 GifInPixelProc := NEXTPIXEL;
 GifOutLineProc := DUMMY;
 LOADGIF(NAME+'.GIF');
 MOVE(GIFPALETTE,PALETTE,768);
 FOR NR:=0 TO 255 DO SETCOLOR(NR,PALETTE[NR,1],PALETTE[NR,2],PALETTE[NR,3]);
END;
{}
PROCEDURE READBMP(NAME: STRING); { LOAD BMP TO MEMORY ( VIRTUAL ) }
VAR B4: ARRAY [1..4] OF BYTE; NR: BYTE; F: FILE; II: INTEGER;
BEGIN
 ASSIGN(F,NAME+'.BMP');
 {$I-} RESET(F,1); NR:=IORESULT; {$I+ }
 IF NR>0 THEN EXIT;
 SEEK(F,54);
 FOR NR:=0 TO 255 DO
 BEGIN
  BLOCKREAD(F,B4,4);
  PALETTE[NR,1]:=B4[3] SHR 2;
  PALETTE[NR,2]:=B4[2] SHR 2;
  PALETTE[NR,3]:=B4[1] SHR 2;
 END;
 FOR II:=199 DOWNTO 0 DO
 BEGIN
  BLOCKREAD(F,BITMAP^[II*320],320);
 END;
 CLOSE(F);
 FOR NR:=0 TO 255 DO SETCOLOR(NR,PALETTE[NR,1],PALETTE[NR,2],PALETTE[NR,3]);
END;
{}
PROCEDURE INSERTCHAR(CH: CHAR; WSPX,WSPY: INTEGER); { INSERT CHAR TO TABLE }
VAR SIZE: WORD; II: INTEGER;
BEGIN
 SIZE:=XCHAR*YCHAR;
 IF CHARS[CH]=NIL THEN GETMEM(CHARS[CH],SIZE) ELSE
 BEGIN FREEMEM(CHARS[CH],SIZEOF(CHARS[CH]^)); GETMEM(CHARS[CH],SIZE); END;
 FOR II:=WSPY TO WSPY+YCHAR-1 DO
 MOVE(BITMAP^[II*320+WSPX],MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(II-WSPY)*XCHAR],XCHAR);
 CHARSDATA[CH,1]:=XCHAR;
 CHARSDATA[CH,2]:=YCHAR;
 CHARSDATA[CH,3]:=1;
END;
{}
PROCEDURE SAVECHARSET(NAME: STRING); { SAVE EDITED FONTS }
VAR F: FILE; CH: CHAR;
BEGIN
 ASSIGN(F,NAME+'.TED');
 REWRITE(F,1);
 BLOCKWRITE(F,HEADER,20);
 FOR CH:=' ' TO ']' DO
 BEGIN
  IF CHARSDATA[CH,3]>0 THEN
  BEGIN
   BLOCKWRITE(F,CH,1);
   BLOCKWRITE(F,CHARSDATA[CH,1],1);
   BLOCKWRITE(F,CHARSDATA[CH,2],1);
   BLOCKWRITE(F,CHARS[CH]^,CHARSDATA[CH,1]*CHARSDATA[CH,2]);
  END;
 END;
 CLOSE(F);
END;
{}
PROCEDURE SAVECHARSETUP(NAME: STRING); { SAVE EDITED FONTS WITH UPDATE }
VAR F,FF: FILE; CH: CHAR; TMP: ARRAY [1..20] OF BYTE; TMPP: ARRAY [' '..']',1..3] OF BYTE;
BEGIN
 ASSIGN(FF,NAME+'.TE$');
 REWRITE(FF,1);
 ASSIGN(F,NAME+'.TED');
 RESET(F,1);
 BLOCKREAD(F,TMP,20);
 BLOCKWRITE(FF,TMP,20);
 FILLCHAR(TMPP,SIZEOF(TMPP),0);
 WHILE NOT(EOF(F)) DO
 BEGIN
  BLOCKREAD(F,CH,1);
  BLOCKREAD(F,TMPP[CH,1],1);
  BLOCKREAD(F,TMPP[CH,2],1);
  BLOCKREAD(F,TEMP,TMPP[CH,1]*TMPP[CH,2]);
  TMPP[CH,3]:=1;
  BLOCKWRITE(FF,CH,1);
  IF CHARSDATA[CH,3]=1 THEN
  BEGIN
   BLOCKWRITE(FF,CHARSDATA[CH,1],1);
   BLOCKWRITE(FF,CHARSDATA[CH,2],1);
   BLOCKWRITE(FF,CHARS[CH]^,CHARSDATA[CH,1]*CHARSDATA[CH,2]);
  END ELSE
  BEGIN
   BLOCKWRITE(FF,TMPP[CH,1],1);
   BLOCKWRITE(FF,TMPP[CH,2],1);
   BLOCKWRITE(FF,TEMP,TMPP[CH,1]*TMPP[CH,2]);
  END;
 END;
 FOR CH:=' ' TO ']' DO
 BEGIN
  IF (TMPP[CH,3]=0) AND (CHARSDATA[CH,3]=1) THEN
  BEGIN
   BLOCKWRITE(FF,CH,1);
   BLOCKWRITE(FF,CHARSDATA[CH,1],1);
   BLOCKWRITE(FF,CHARSDATA[CH,2],1);
   BLOCKWRITE(FF,CHARS[CH]^,CHARSDATA[CH,1]*CHARSDATA[CH,2]);
  END;
 END;
 CLOSE(FF);
 ERASE(F);
 ASSIGN(FF,NAME+'.TE$');
 RENAME(FF,NAME+'.TED');
END;
{}
VAR TMPIC : PSCREEN;
PROCEDURE SAVETMP; { CREATE TEMP SCREEN }
BEGIN
 GETMEM(TMPIC,64000);
 MOVE(MEM[$A000:0],TMPIC^,64000);
END;
{}
PROCEDURE RESTORETMP; { FREE TEMP SCREEN }
BEGIN
 MOVE(TMPIC^,MEM[$A000:0],64000);
 FREEMEM(TMPIC,64000);
END;
{}
PROCEDURE INSERTPROC(CH: CHAR); { INSERT CHAR INTO CHARSET }
VAR TX,TY,NR,I: BYTE;  ZZ: CHAR; OKI: BOOLEAN;
BEGIN
 IF NOT(CH IN [' '..']']) THEN EXIT;
 HIDEMOUSE;
 SAVETMP;
 FILLCHAR(MEM[$A000:0],64000,0);
 FOR I:=1 TO 20 DO SETCOLOR(231+I,0,0,10+(I*2)-1);
 SETCOLOR(230,35,40,44);
 FOR I:=0 TO 19 DO
  FILLCHAR(MEM[$A000:I*320],320,232+I);
 WRITEXY('ADD CHAR '+CH+' TO FONT? (Y/N) ',5,2,230);
 RECTANGLE2(50,60,50+XCHAR+1,60+YCHAR+1,230);
 FOR TY := 1 TO YCHAR DO
 FOR TX := 1 TO XCHAR DO
  MEM[$A000:(60+TY)*320+50+TX]:=BITMAP^[(MY+TY-1)*320+MX+TX-1];
 STR(XCHAR,S);
 STR(YCHAR,N);
 S:='X  - '+S;
 N:='Y  - '+N;
 WRITEXY(S,200,50,230);
 WRITEXY(N,200,70,230);
 STR(ORD(CH),N);
 S:='NR - '+N;
 WRITEXY(S,200,90,230);
 DELAY(100);
 ZZ:=UPCASE(READKEY);
 CASE ZZ OF
  'Y' : OKI:=TRUE
  ELSE OKI:=FALSE;
 END;
 RESTORETMP;
 FOR NR:=0 TO 255 DO SETCOLOR(NR,PALETTE[NR,1],PALETTE[NR,2],PALETTE[NR,3]);
 IF OKI THEN INSERTCHAR(CH,MX,MY);
 SHOWMOUSE;
END;
{}
PROCEDURE SAVEMENU; { SAVE FONT FILE TO DISK }
VAR NR: BYTE; I: INTEGER; NAME: STRING; CH,WW: CHAR; F: FILE;
LABEL LONGJUMP;
BEGIN
 HIDEMOUSE;
 SAVETMP;
 FILLCHAR(MEM[$A000:0],64000,0);
 DELAY(100);
 FOR I:=1 TO 20 DO SETCOLOR(231+I,0,0,10+(I*2)-1);
 SETCOLOR(230,35,40,44);
 FOR I:=0 TO 19 DO
  FILLCHAR(MEM[$A000:I*320],320,232+I);
 WRITEXY('SAVE FONT',115,2,230);
 SETCOLOR(255,255,255,0);
 WRITEXY('SELECT: (320x200x256)',10,40,255);
 WRITEXY(' 1 - SAVE TED&PAL',10,60,255);
 WRITEXY(' 2 - UPDATE TED FILE',10,80,255);
 WRITEXY(' 0 - ABORT ',10,100,255);
 WW:=UPCASE(READKEY);
 IF WW='0' THEN GOTO LONGJUMP;
 IF NOT(WW IN ['1','2']) THEN WW:='1';
 WRITEXY('ENTER NAME (NO EXTENSION)',20,120,255);
 GOTOXY(13,18); READLN(NAME);
 WRITEXY('ARE YOU SURE?',30,160,255);
 CH:=UPCASE(READKEY);
 IF CH='Y' THEN
 BEGIN
  CASE WW OF
   '1': BEGIN
         ASSIGN(F,NAME+'.PAL');
         REWRITE(F,1);
         BLOCKWRITE(F,PALETTE,768);
         CLOSE(F);
         SAVECHARSET(NAME);
        END;
   '2': BEGIN
         SAVECHARSETUP(NAME);
        END;
  END;
  WRITEXY('SAVED...',80,180,255);
  DELAY(500);
 END;
LONGJUMP:
 RESTORETMP;
 FOR NR:=0 TO 255 DO SETCOLOR(NR,PALETTE[NR,1],PALETTE[NR,2],PALETTE[NR,3]);
 SHOWMOUSE;
END;
{}
PROCEDURE LOADMENU; { LOAD GFX FILE 320X200X256 FROM DISK TO MEMORY }
VAR NR: BYTE; I: INTEGER; CH: CHAR; NAME: STRING;
LABEL LONGJUMP;
BEGIN
 HIDEMOUSE;
 SAVETMP;
 FILLCHAR(MEM[$A000:0],64000,0);
 DELAY(100);
 FOR I:=1 TO 20 DO SETCOLOR(231+I,0,0,10+(I*2)-1);
 SETCOLOR(230,35,40,44);
 FOR I:=0 TO 19 DO
  FILLCHAR(MEM[$A000:I*320],320,232+I);
 WRITEXY('LOAD GFX',110,2,230);
 SETCOLOR(255,255,255,0);
 WRITEXY('SELECT: (320x200x256)',10,40,255);
 WRITEXY(' 1 - LOAD GIF ',10,60,255);
 WRITEXY(' 2 - LOAD CEL & COL ',10,80,255);
 WRITEXY(' 3 - LOAD BMP ',10,100,255);
 WRITEXY(' 0 - ABORT ',10,120,255);
 CH:=UPCASE(READKEY);
 IF (CH IN ['1','2','3']) THEN
 BEGIN
  WRITEXY('ENTER NAME (NO EXTENSION)',10,150,255);
  GOTOXY(8,23);
  READLN(NAME);
  RESTORETMP;
  FOR NR:=0 TO 255 DO SETCOLOR(NR,PALETTE[NR,1],PALETTE[NR,2],PALETTE[NR,3]);
  CASE CH OF
   '1': READGIF(NAME);
   '2': READCEL(NAME);
   '3': READBMP(NAME);
  END;
  MOVE(BITMAP^,MEM[$A000:0],64000);
  SHOWMOUSE;
  GOTO LONGJUMP;
 END;
 RESTORETMP;
 FOR NR:=0 TO 255 DO SETCOLOR(NR,PALETTE[NR,1],PALETTE[NR,2],PALETTE[NR,3]);
 SHOWMOUSE;
LONGJUMP:
END;
{}
PROCEDURE HELP; { HELP!!! }
VAR NR: BYTE; I: INTEGER;
BEGIN
 HIDEMOUSE;
 SAVETMP;
 FILLCHAR(MEM[$A000:0],64000,0);
 DELAY(100);
 FOR I:= 0 TO 63 DO SETCOLOR(190+I,I,0,0);
 FOR I:= 0 TO 63 DO
 FILLCHAR(MEM[$A000:(I+1)*320*3],960,190+I);
 SETCOLOR(255,30,30,30);
 SETCOLOR(254,0,255,0);
 WRITEXY('A FEW HOURS OF CODE',65,20,255);
 WRITEXY('TED - FONT EDITOR V1.0',50,10,254);
 WRITEXY('CODED BY PARADiSE ''94',54,27,254);
 WRITEXY('HOT KEYS:',10,60,255);
 WRITEXY('F1- HELP      F2- SAVE FONT',10,80,255);
 WRITEXY('F3- LOAD GFX  F4- LIGHT MOUSE',10,100,255);
 WRITEXY('ALTX- EXIT',10,120,255);
 WRITEXY('',10,140,255);
 WRITEXY('IF U HAVE AND IDEAS CALL ME :',10,160,255);
 WRITEXY('LIKSAY@BACHUS.UMCS.LUBLIN.PL',20,180,254);
 READKEY;
 RESTORETMP;
 FOR NR:=0 TO 255 DO SETCOLOR(NR,PALETTE[NR,1],PALETTE[NR,2],PALETTE[NR,3]);
 SHOWMOUSE;
END;
{}




BEGIN  { MAIN PROGRAM }
 MOUSE:=ISMOUSE;
 INITVGA;
 LOADFONT;
 QUIT:=FALSE;
 XCHAR:=19; YCHAR:=19;
 MMX:=XCHAR+2; MMY:=YCHAR+2;
 CREATEVIRTUAL;
 READGIF('TITLE');
 COPYVIRTUAL;
 READKEY;
 FILLCHAR(MEM[$A000:0],64000,0);
 FILLCHAR(BITMAP^,64000,0);
 SETCOLOR(255,255,255,255);
 WRITEXY('PRESS F3 TO LOAD GFX',50,50,255);
 DELAY(1000);
 SETUPMOUSE;
 REPEAT
  KEY:=0;
  WHILE KEYPRESSED DO
  BEGIN
   KEY:=GETKEY;
   CASE KEY OF
    LEFTK : BEGIN { - X }
             PUTMOUSE(MX,MY,BACKM);
             DEC(XCHAR);
             DEC(MMX);
             GETMOUSE(MX,MY,BACKM);
             RECTANGLE(MX,MY,MX+XCHAR,MY+YCHAR,255);
            END;
    RIGHTK: BEGIN { + X }
             PUTMOUSE(MX,MY,BACKM);
             INC(XCHAR);
             INC(MMX);
             GETMOUSE(MX,MY,BACKM);
             RECTANGLE(MX,MY,MX+XCHAR,MY+YCHAR,255);
            END;
    UPK   : BEGIN { - Y }
             PUTMOUSE(MX,MY,BACKM);
             DEC(YCHAR);
             DEC(MMY);
             GETMOUSE(MX,MY,BACKM);
             RECTANGLE(MX,MY,MX+XCHAR,MY+YCHAR,255);
            END;
    DOWNK : BEGIN { + Y }
             PUTMOUSE(MX,MY,BACKM);
             INC(YCHAR);
             INC(MMY);
             GETMOUSE(MX,MY,BACKM);
             RECTANGLE(MX,MY,MX+XCHAR,MY+YCHAR,255);
            END;
    F1    : HELP;
    F2    : SAVEMENU;
    F3    : LOADMENU;
    F4    : SETCOLOR(255,255,255,255);
    ALTX  : QUIT := TRUE;
    ELSE INSERTPROC(LASTCH);
   END;
   SETCOLOR(255,255,255,255);
  END;
  MOUSEACTION;
 UNTIL QUIT;

 RELEASEVIRTUAL;
 CLOSEVGA;
END.
