PROGRAM TED_EDITOR;
USES CRT,DOS;

CONST
 HEADER  : ARRAY [1..20] OF BYTE =(254,84,69,68,254,57,52,254,80,65,
                                   82,65,68,105,83,69,254,00,00,07);
VAR
 FONT           : ARRAY [0..255,0..15] OF BYTE;
 PALETTE,TMPP   : ARRAY [0..255,1..3] OF BYTE;
 CHARS          : ARRAY [' '..']'] OF POINTER;
 CHARSDATA      : ARRAY [' '..']',1..3] OF BYTE;
 F              : FILE;
 B              : BYTE;
 X,Y,I          : INTEGER;
 CH,K           : CHAR;
 ZOOMER         : BYTE;
 WSPX,WSPY      : INTEGER;
 EXT,LIGHT      : BOOLEAN;
 COLOR          : BYTE;
 NAME           : STRING;

{}
PROCEDURE INITVGA; ASSEMBLER; { INITIALIZE VGA CARD MODE 13H }
ASM
 MOV AX,0013H
 INT 10H
END;
{}
PROCEDURE CLOSEVGA; ASSEMBLER; { CLOSE VGA MODE AND SET TEXT }
ASM
 MOV AX,0003H
 INT 10H
END;
{}
PROCEDURE SETCOLOR(NR,R,G,B: BYTE); ASSEMBLER; { SET RGB VAL TO COLOR NR }
ASM
 MOV DX,3C8H
 MOV AL,NR
 OUT DX,AL
 INC DX
 MOV AL,R
 OUT DX,AL
 MOV AL,G
 OUT DX,AL
 MOV AL,B
 OUT DX,AL
END;
{}
PROCEDURE PUTPIX(X,Y : INTEGER; C: BYTE); ASSEMBLER; { PLOT PIXEL AT (X,Y) }
ASM
 MOV   AX, 0A000H
 MOV   ES, AX
 MOV   AX, 320
 MUL   Y
 ADD   AX, X
 MOV   DI, AX
 MOV   AL, C
 STOSB
END;
{}
FUNCTION GETPIX(X,Y : INTEGER): BYTE; ASSEMBLER; { GET A PIXEL FROM (X,Y) }
ASM
 MOV   AX, 0A000H
 MOV   ES, AX
 MOV   AX, 320
 MUL   Y
 ADD   AX, X
 MOV   DI, AX
 LODSB
END;
{}
PROCEDURE RECTANGLE(X1,Y1,X2,Y2: INTEGER; C: BYTE); { DRAW A RECTANGLE }
VAR Z: INTEGER;
BEGIN
 FOR Z:=X1 TO X2 DO
 BEGIN
  PUTPIX(Z,Y1,C);
  PUTPIX(Z,Y2,C);
 END;
 FOR Z:=Y1 TO Y2 DO
 BEGIN
  PUTPIX(X1,Z,C);
  PUTPIX(X2,Z,C);
 END;
END;
{}
PROCEDURE RECTANGLE2(X1,Y1,X2,Y2: INTEGER; C: BYTE); { DRAW A RECTANGLE #2 }
VAR Z: INTEGER;
BEGIN
 FOR Z:=X1 TO X2 DO
 IF ODD(Z) THEN BEGIN
  PUTPIX(Z,Y1,C);
  PUTPIX(Z,Y2,C);
 END;
 FOR Z:=Y1 TO Y2 DO
 IF ODD(Z) THEN BEGIN
  PUTPIX(X1,Z,C);
  PUTPIX(X2,Z,C);
 END;
END;
{}
PROCEDURE BAR(X1,Y1,X2,Y2: INTEGER; C: BYTE); { DRAW A FILLED BAR }
VAR X,Y: INTEGER;
BEGIN
 FOR Y:=Y1 TO Y2 DO
 FOR X:=X1 TO X2 DO
 PUTPIX(X,Y,C);
END;
{}
PROCEDURE ROMFONT;
VAR F8X8OFS,F8X8SEG: WORD;
BEGIN
 ASM
  PUSH BP
  MOV  AH,11H
  MOV  AL,30H
  MOV  BH,06H
  INT  10H
  MOV  AX,BP
  POP  BP
  MOV  F8X8OFS,AX
  MOV  F8X8SEG,ES
 END;
 MOVE(MEM[F8X8SEG:F8X8OFS],FONT,256*16)
END;
{}
PROCEDURE WRITEXY(TEKST: STRING; X,Y: INTEGER; C: BYTE); { PRINT TEXT AT X,Y }
VAR TX,TY: WORD; IZ: BYTE;
BEGIN
 FOR IZ:=1 TO LENGTH(TEKST) DO
 FOR TY:=0 TO 15 DO
 FOR TX:=0 TO 7 DO
  IF FONT[ORD(TEKST[IZ]),TY] AND ($80 SHR TX)<>0 THEN
  PUTPIX(X+TX+(IZ-1)*10,Y+TY,C);
END;
{}
PROCEDURE LOADPAL(NAME: STRING); { LOAD .PAL FILE AND SET PALETTE }
BEGIN
 ASSIGN(F,NAME+'.PAL');
 RESET(F,1);
 BLOCKREAD(F,PALETTE,768);
 CLOSE(F);
 FOR B:=0 TO 255 DO SETCOLOR(B,PALETTE[B,1],PALETTE[B,2],PALETTE[B,3]);
END;
{}
PROCEDURE LOADTED(NAME: STRING); { LOAD .TED FILE TO MEMORY }
VAR TX,TY: BYTE; CH: CHAR;
BEGIN
 ASSIGN(F,NAME+'.TED');
 RESET(F,1);
 SEEK(F,20);
 WHILE NOT(EOF(F)) DO
 BEGIN
  BLOCKREAD(F,CH,1);
  BLOCKREAD(F,TX,1);
  BLOCKREAD(F,TY,1);
  GETMEM(CHARS[CH],TX*TY);
  CHARSDATA[CH,1]:=TX; CHARSDATA[CH,2]:=TY; CHARSDATA[CH,3]:=1;
  BLOCKREAD(F,CHARS[CH]^,TX*TY);
 END;
 CLOSE(F);
END;
{}
PROCEDURE DONETED; { DEALLOCATE FONT MEMORY }
VAR CH: CHAR;
BEGIN
 FOR CH:=' ' TO ']' DO
 BEGIN
  IF CHARSDATA[CH,3]=1 THEN
  BEGIN
   FREEMEM(CHARS[CH],CHARSDATA[CH,1]*CHARSDATA[CH,2]);
   CHARSDATA[CH,3]:=0;
  END;
 END;
END;
{}
PROCEDURE BIGCHAR(X,Y: INTEGER; CH: CHAR; ZOOM: BYTE);
VAR AX,AY: INTEGER;
BEGIN
 IF CHARSDATA[CH,3]<>1 THEN EXIT;
 FOR AY:=0 TO CHARSDATA[CH,2]-1 DO
 FOR AX:=0 TO CHARSDATA[CH,1]-1 DO
 BEGIN
  BAR(X+AX*ZOOM,Y+AY*ZOOM,X+AX*ZOOM+ZOOM,Y+AY*ZOOM+ZOOM,MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+AY*CHARSDATA[CH,1]+AX]);
 END;
END;
{}
PROCEDURE SAVECHARSET(NAME: STRING); { SAVE EDITED FONTS }
VAR F: FILE; CH: CHAR;
BEGIN
 ASSIGN(F,NAME+'.TED');
 REWRITE(F,1);
 BLOCKWRITE(F,HEADER,20);
 FOR CH:=' ' TO ']' DO
 BEGIN
  IF CHARSDATA[CH,3]>0 THEN
  BEGIN
   BLOCKWRITE(F,CH,1);
   BLOCKWRITE(F,CHARSDATA[CH,1],1);
   BLOCKWRITE(F,CHARSDATA[CH,2],1);
   BLOCKWRITE(F,CHARS[CH]^,CHARSDATA[CH,1]*CHARSDATA[CH,2]);
  END;
 END;
 CLOSE(F);
END;
{}
PROCEDURE CHARDOWN(CH: CHAR);
VAR LN: ARRAY[1..100] OF BYTE; Y: INTEGER;
BEGIN
 MOVE(MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(CHARSDATA[CH,2]-1)*CHARSDATA[CH,1]],LN,CHARSDATA[CH,1]);
 FOR Y:=CHARSDATA[CH,2] DOWNTO 1 DO
 MOVE(MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-2)*CHARSDATA[CH,1]],
      MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]],CHARSDATA[CH,1]);
 MOVE(LN,MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)],CHARSDATA[CH,1]);
END;
{}
PROCEDURE CHARUP(CH: CHAR);
VAR LN: ARRAY[1..100] OF BYTE; Y: INTEGER;
BEGIN
 MOVE(MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)],LN,CHARSDATA[CH,1]);
 FOR Y:=1 TO CHARSDATA[CH,2]-1 DO
 MOVE(MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y)*CHARSDATA[CH,1]],
      MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]],CHARSDATA[CH,1]);
 MOVE(LN,MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(CHARSDATA[CH,2]-1)*CHARSDATA[CH,1]],CHARSDATA[CH,1]);
END;
{}
PROCEDURE CHARLEFT(CH: CHAR);
VAR LN: ARRAY[1..100] OF BYTE; Y: INTEGER;
BEGIN
 FOR Y:=1 TO CHARSDATA[CH,2] DO LN[Y]:=MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]];
 FOR Y:=1 TO CHARSDATA[CH,2] DO
 MOVE(MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]+1],
      MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]],CHARSDATA[CH,1]-1);
 FOR Y:=1 TO CHARSDATA[CH,2] DO MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]+CHARSDATA[CH,1]-1]:=LN[Y];
END;
{}
PROCEDURE CHARRIGHT(CH: CHAR); { DONT WORK, NOW!!! }
VAR LN: ARRAY[1..100] OF BYTE; Y: INTEGER;
BEGIN
 FOR Y:=1 TO CHARSDATA[CH,2] DO LN[Y]:=MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]+CHARSDATA[CH,1]-1];
 FOR Y:=1 TO CHARSDATA[CH,2] DO
 MOVE(MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]],
      MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]+1],CHARSDATA[CH,1]-1);
 FOR Y:=1 TO CHARSDATA[CH,2] DO MEM[SEG(CHARS[CH]^):OFS(CHARS[CH]^)+(Y-1)*CHARSDATA[CH,1]]:=LN[Y];
END;
{}
PROCEDURE SETFPAL;
VAR B: BYTE;
BEGIN
 FOR B:=0 TO 255 DO SETCOLOR(B,PALETTE[B,1],PALETTE[B,2],PALETTE[B,3]);
END;
{}
PROCEDURE LIGHTON;
BEGIN
 LIGHT:=TRUE;
 MOVE(PALETTE,TMPP,768);
 FILLCHAR(PALETTE,768,255);
 FILLCHAR(PALETTE,3,0);
 SETFPAL;
 SETCOLOR(255,255,0,0);
END;
{}
PROCEDURE LIGHTOFF;
BEGIN
 LIGHT:=FALSE;
 MOVE(TMPP,PALETTE,768);
 SETFPAL;
 SETCOLOR(255,255,255,255);
END;
{}






BEGIN
 CLRSCR;
 WRITELN;
 WRITELN(' TED FONT FILE EDITOR - CORRECTOR  (c) 94 PARADiSE ');
 WRITELN;
 IF PARAMCOUNT=0 THEN
 BEGIN
  WRITELN(' USAGE: TEDEDIT.EXE <FONTNAME> ');
  WRITELN(' EXAMPLE: TEDEDIT FONT001 ');
  WRITELN;
  HALT;
 END;
 WRITELN(' HOT KEYS: ESC - EXIT           PGUP/PGDN - NEXT/PREV CHAR ');
 WRITELN('            HOME - SELECT CHAR   F1/F2 - NEXT/PREV COLOR');
 WRITELN('            F3/F4 - NEXT/PREV 10 COLORS ');
 WRITELN('            INSERT/DEC - PUT/ERASE COLOR');
 WRITELN('            F5/F6 - SCROLL UP/DN F7/F8 - SCROLL LEFT/RIGHT');
 WRITELN('            F9 - LIGHT COLORS');
 WRITELN;
 WRITELN(' PRESS ANY KEY TO EDIT FILE "',PARAMSTR(1),'.TED" ...');
 WRITELN;
 READKEY;
 NAME:=PARAMSTR(1);
 INITVGA;
 ROMFONT;
 LOADPAL(NAME);
 LOADTED(NAME);
 SETCOLOR(255,255,255,255);
 WRITEXY('FONT EDIT-CORRECT  (C) PARADiSE',0,0,255);
 K:='A';
 COLOR:=1;
 ZOOMER:=3;
 RECTANGLE(9,39,11+CHARSDATA[CH,1]*ZOOMER,41+CHARSDATA[CH,2]*ZOOMER,255);
 BIGCHAR(10,40,CH,ZOOMER);
 WSPX:=1; WSPY:=1;
 EXT:=FALSE;
 LIGHT:=FALSE;
 IF (CHARSDATA[K,3]=1) THEN
 BEGIN
  RECTANGLE(9,39,11+CHARSDATA[K,1]*ZOOMER,41+CHARSDATA[K,2]*ZOOMER,255);
  BIGCHAR(10,40,K,ZOOMER);
 END;
 RECTANGLE2(10+(WSPX-1)*ZOOMER,40+(WSPY-1)*ZOOMER,10+WSPX*ZOOMER,40+WSPY*ZOOMER,255);
 REPEAT
  CH:=READKEY;
  IF CH=#0 THEN
  BEGIN
   EXT:=TRUE;
   CH:=READKEY;
  END;
  IF CH='+' THEN INC(ZOOMER);
  IF CH='-' THEN DEC(ZOOMER);
  IF EXT THEN
  BEGIN
  CASE ORD(CH) OF
   73: K:=CHR(ORD(K)-1);
   81: K:=CHR(ORD(K)+1);
   71: K:=UPCASE(READKEY);
   82: MEM[SEG(CHARS[K]^):OFS(CHARS[K]^)+(WSPY-1)*CHARSDATA[K,1]+WSPX-1]:=COLOR;
   83: MEM[SEG(CHARS[K]^):OFS(CHARS[K]^)+(WSPY-1)*CHARSDATA[K,1]+WSPX-1]:=0;
   31: BEGIN SAVECHARSET(NAME); SOUND(10000); DELAY(100); NOSOUND; END;
   59: DEC(COLOR);
   60: INC(COLOR);
   61: DEC(COLOR,10);
   62: INC(COLOR,10);
   63: CHARUP(K);
   64: CHARDOWN(K);
   65: CHARLEFT(K);
   66: CHARRIGHT(K);
   67: IF LIGHT THEN LIGHTOFF ELSE LIGHTON;
  END;
  CASE LO(ORD(CH)) OF
   72: IF WSPY>1 THEN DEC(WSPY);
   80: IF WSPY<CHARSDATA[CH,2] THEN INC(WSPY);
   75: IF WSPX>1 THEN DEC(WSPX);
   77: IF WSPX<CHARSDATA[CH,1] THEN INC(WSPX);
  END;
  EXT:=FALSE;
  END;
  IF (CHARSDATA[K,3]=1) THEN
  BEGIN
   RECTANGLE(9,39,11+CHARSDATA[K,1]*ZOOMER,41+CHARSDATA[K,2]*ZOOMER,255);
   BIGCHAR(10,40,K,ZOOMER);
  END;
  RECTANGLE2(10+(WSPX-1)*ZOOMER,40+(WSPY-1)*ZOOMER,10+WSPX*ZOOMER,40+WSPY*ZOOMER,255);
 UNTIL (CH=#27); { ESC }

 DONETED;
 CLOSEVGA;
END.