#include <allegro.h>

#define BANNER "RasterView by TBD/FeR - view BMP, LBM, PCX & TGA in raster mode\n"
#define BANNER_END "RasterView by TBD/FeR (tbd@usa.net) - (c) 1997 FeR  http://www.sorostm.ro/nhv/"

void main ( int argc, char *argv[] )
{
   BITMAP *bmp_resized, *bmp_original, *bmp_raster ;
   PALETTE bmp_pal;
   int x,y;

   if (argc < 2)
   {
    printf(BANNER);
    printf("Usage: rv filename \n");
    exit(1);
   }

   allegro_init();
   install_keyboard();

   bmp_original = load_bitmap ( argv[1], bmp_pal );
   if (bmp_original == NULL)
   {
    printf(BANNER);
    printf(" ERROR - Unknown format or file not found \n");
    exit(1);
   }

   set_gfx_mode (GFX_MODEX, 320, 600, 0, 0);
   bmp_resized	= create_bitmap ( 320, 200 );
   bmp_raster	= create_bitmap ( 320, 600 );
   clear ( bmp_resized ); clear( bmp_raster );

   stretch_blit(bmp_original,bmp_resized,0,0,bmp_original->w,bmp_original->h,
					 0,0,bmp_resized->w,bmp_resized->h);
				   /* resize the picture to fit in 320x200 */
   set_pallete(bmp_pal);

   for (y=0; y < 200; y++)
    for (x=0; x < 320; x++)
     bmp_raster->line[y * 3][x] = bmp_resized->line[y][x];

   blit(bmp_raster, screen, 0, 0, 0, 0, bmp_raster->w, bmp_raster->h);
   readkey();
   set_gfx_mode(GFX_TEXT,0,0,0,0);
   printf(BANNER_END);
}