#include <termios.h>
#include <unistd.h>

struct termios termios_old, termios_new;

void
tty_cleanup()
{
    tcsetattr(0, TCSANOW, &termios_old);
}

void
tty_init()
{
    tcgetattr(0, &termios_old);
 
    termios_new = termios_old;
    termios_new.c_lflag &= ~ICANON;
    termios_new.c_lflag &= ~ECHO;
    termios_new.c_lflag &= ~ISIG;
    termios_new.c_cc[VMIN] = 0;
    termios_new.c_cc[VTIME] = 0;

    tcsetattr(0, TCSANOW, &termios_new);
}
