#include <stdlib.h>

#include <bcm_host.h>
#include <EGL/egl.h>

#include "vc.h"

NativeWindowType
vc_init(uint32_t *width, uint32_t *height)
{
    VC_RECT_T dst_rect, src_rect;
    DISPMANX_DISPLAY_HANDLE_T dispman_display;
    DISPMANX_UPDATE_HANDLE_T dispman_update;
    DISPMANX_ELEMENT_HANDLE_T dispman_element;

    static EGL_DISPMANX_WINDOW_T native_window;

    bcm_host_init();

    if(!(*width || *height))
        if(-1 == graphics_get_display_size(0, width, height))
            err(EXIT_FAILURE, "graphics_get_display_size");

    dst_rect.x = 0;
    dst_rect.y = 0;
    dst_rect.width = *width;
    dst_rect.height = *height;

    src_rect.x = 0;
    src_rect.y = 0;
    src_rect.width = *width << 16;
    src_rect.height = *height << 16;

    dispman_display = vc_dispmanx_display_open(0);
    dispman_update = vc_dispmanx_update_start(0);
    dispman_element = vc_dispmanx_element_add(dispman_update, dispman_display, 0, &dst_rect, 0, &src_rect, DISPMANX_PROTECTION_NONE, 0, 0, 0);

    native_window.element = dispman_element;
    native_window.width = *width;
    native_window.height = *height;

    vc_dispmanx_update_submit_sync(dispman_update);

    return &native_window;
}
