#!/usr/bin/tcc -run -lgd

#include <stdio.h>

/* this requires the libgd development package */
#include "gdhelper.h"

int main( int argc, char *argv[] )
{
   gdImagePtr src, dest;

   if( argc == 3 )
   {
      src = gdLoadImg( argv[1] );
      if( (src->sx == 32) && (src->sy == 32) )
      {
         gdSaveImgBin( src, argv[2] );
         gdImageDestroy( src );
         return 0;
      }
      else
      {
         fprintf( stderr, "image size needs to be 32x32\n" );
         return 10;
      }
   }

   if( argc != 4 )
   {
      fprintf( stderr, "usage: %s <infile> <outfile1> (<outfile2>)\n", argv[0] );
      return 1;
   }

   src = gdLoadImg( argv[1] );
   if( ((src->sx == 32) && (src->sy == 64)) ||
       ((src->sx == 64) && (src->sy == 32)) )
   {
      dest = gdImageCreate( 32, 32 );
      gdImagePaletteCopy( dest, src );

      gdImageCopy( dest, src, 0, 0, 0, 0, 32, 32 );
      gdSaveImgBin( dest, argv[2] );

      if( src->sx == 64 )
      {
         gdImageCopy( dest, src, 0, 0, 32, 0, 32, 32 );
         gdSaveImgBin( dest, argv[3] );
      }
      else
      {
         gdImageCopy( dest, src, 0, 0, 0, 32, 32, 32 );
         gdSaveImgBin( dest, argv[3] );
      }
   }
   else
   {
      fprintf( stderr, "image size needs to be 32x64 or 64x32\n" );
      return 10;
   }
   gdImageDestroy( src );

   return 0;
}
