C	SIMPLE DRAWING PROGRAM USING THE NEW GRAPHICS PACKAGE
C
C		STAND ALONE VERSION
C		USES REAL MODE, LIGHT PEN ATTENTIONS ONLY
C
C	ORIGINALLY BY DIGITAL EQUIPMENT CORP.
C
C	REWRITTEN TO INCLUDE ARC GENERATOR AND IGNORE
C	SPURIOUS LIGHTPEN HITS AS WELL AS CLEANED UP
C	BY R. B. BARTLEIN -- MARCH, 1978.
C
	COMMON/DFILE/IBUF(8096)
	COMMON/PDATA/NPRIM(209),NVPRIM(209),NDEF,NHID
	REAL SF(4)
	LOGICAL*1 FILE1(16),FILE2(16),USED(5)
	DATA SF/.33333333333,.5,2.,3./
	DATA USED/48,0,0,37,0/
	DATA SIZE/8096./, XGRD/30./, YGRD/40./
	DATA PI/3.1415926536/, YTOP/900./, SM/50./
	DATA IWARN/15/, MARGIN/10/, LINETP/1/
	DATA NDEF/0/, NHID/0/, ISAC/0/, ISHOW/0/
	DO 10 I=1,209
	NVPRIM(I)=0
10	NPRIM(I)=0
C
C	SET UP MENU AREAS
C
	CALL INIT(8096)
	CALL SUBP(1000)
	CALL OFF(1000)
	CALL SUBP(1001)
	CALL MENU(,YTOP,-SM,2010,'DRAW','MOVE','COMBINE','SCALE',
     X  'COPY','ERASE','MODIFY','HIDE','SEEK')
	CALL MENU(,YTOP-9.*SM,-SM,2019,'SEEK & COPY','ROTATE','SAVE',
     X  'RECALL','COMPRESS','GRID ON ','PLOT',' ','EXIT')
	CALL ESUB
	CALL SUBP(1002)
	CALL SUBP(1020)
	CALL APNT(850.,570.,1,-4,-1,1)
	CALL VECT(150.,0.)
	CALL ESUB(1020)
	CALL SUBP(1021)
	CALL APNT(850.,520.,1,-4,-1,2)
	CALL VECT(150.,0.)
	CALL ESUB(1021)
	CALL SUBP(1022)
	CALL APNT(850.,470.,1,-4,-1,3)
	CALL VECT(150.,0.)
	CALL ESUB(1022)
	CALL SUBP(1023)
	CALL APNT(850.,420.,1,-4,-1,4)
	CALL VECT(150.,0.)
	CALL ESUB(1023)
	CALL MENU(,350.,-SM,1024,'ENTER TEXT','POSITION','LINE',
     X	'ARC (CENTER)','CLOSE','        DONE')
	CALL ESUB
	CALL MENU(,100.,0.,1003,'        DONE')
	CALL SUBP(1004)
	CALL MENU(,300.,-SM,1030,'1/3','1/2','2 X','3 X')
	CALL ESUB
	CALL SUBP(1005)
	CALL MENU(,300.,-SM,1040,'ERASE LINE','SPLIT LINE',
     X  'MOVE CORNER','SHOW ALL','        DONE')
	CALL ESUB
	CALL SUBP(1006)
	CALL MENU(,300.,-SM,1050,'90 CW','180','90 CCW')
	CALL ESUB
	CALL SUBP(1007)
	CALL MENU(,300.,-SM,1060,'RADIUS',
     X	'END ARC')
	CALL ESUB(1007)
	CALL SUBP(2006)
	CALL AREA(2)
	CALL APNT(0.,0.,,-4)
	CALL TEXT('     ')
	CALL RPNT(1.,1.,,-4,-1)
	CALL ESUB(2006)
	CALL MAKOBJ(NSKIP)
	CALL SUBP(NSKIP)
	CALL OFF(NSKIP)
	CALL APNT(850.,100.,1,-4,-1)
	CALL TEXT('        DONE')
	CALL ESUB(NSKIP)
	NVPRIM(NSKIP)=-1
	NPRIM(NSKIP)=1
	CALL DPTR(ISTRT)
C
C	MAIN LOOP -- WAIT FOR MENU HIT AND BRANCH TO SERVICE IT
C
100	DO 110 I=1002,1007
110	CALL OFF(I)
	CALL OFF(NSKIP)
	CALL ON(1001)
	CALL ON(1000)
	CALL DPTR(I)
	CALL POINTR(2,2006,2)
	I=(SIZE-I)/SIZE*100.
	CALL FLASH(2,IWARN-I)
	USED(3)=I-I/10*10+48
	USED(2)=I/10+48
	CALL CHANGT(2,USED)
	CALL MENUH(IT,2010,2027)
	CALL OFF(1001)
	GOTO (1100,1600,1700,1800,1900,2000,2100,2200,2300,2600,2700,
     X  2400,2500,4000,3000,3500,4000,5000),IT
C
C	DRAW A NEW OBJECT
C
1100	IF(I.LT.MARGIN)GOTO 4000
	CALL ON(1002)
	CALL MAKOBJ(NOBJ)
	CALL SUBP(NOBJ)
	CALL APNT(500.,500.,1,-4,-1)
	CALL POINTR(2,NOBJ)
	LINETP=1
	XX=500.
	YY=500.
1110	CALL ATTACH(2)
	CALL TRAK(XX,YY)
	ISAC=0
1111	CALL MENUH(IT,1020,1029)
	CALL GRID(XGRD,YGRD)
	CALL TRAKXY(XX,YY)
	CALL ERAS
	CALL GET(2,X,Y)
	IF(ABS(X).GE.XGRD.OR.ABS(Y).GE.YGRD.OR.NPRIM(NOBJ).EQ.0)
     X  GOTO 1115
	IF(IT.LE.4) GO TO 1200
	IF(II.GT.0) NVPRIM(NOBJ)=NVPRIM(NOBJ)-1
	II=-4
	IF(IT.EQ.7) II=4
	IF(II.GT.0) NVPRIM(NOBJ)=NVPRIM(NOBJ)+1
	CALL INTENS(2,II)
	CALL LINTYP(2,LINETP)
	ISAC=1
	GO TO (1200,1200,1200,1200,1240,1110,1110,1150,1170,1180), IT
C
1115	II=-4
	GOTO (1200,1200,1200,1200,1240,1140,1120,1140,1170,1180),IT
1120	II=4
	NVPRIM(NOBJ)=NVPRIM(NOBJ)+1
1140	NPRIM(NOBJ)=NPRIM(NOBJ)+1
	CALL LVECT(0.,0.,,II,,LINETP)
	CALL ADVANC(2)
	IF(IT.NE.8) GOTO 1110
C
C	GENERATE A CIRCLE OR ARC
C
1150	CALL OFF(1002)
	CALL ON(1007)
	CALL LINTYP(2,4)
	CALL INTENS(2,1)
	X0=XX
	Y0=YY
	X1=0.0
	Y1=0.0
1151	CALL ATTACH(2)
	CALL TRAK(X0,Y0)
	CALL MENUH(IT,1060,1061)
	CALL GRID(XGRD,YGRD)
	CALL TRAKXY(X0,Y0)
	CALL ERAS
	CALL GET(2,X,Y)
	X=X*YGRD/XGRD
	GO TO (1153,1154), IT
1153	X1=X
	Y1=Y
	GO TO 1151
1154	X2=X
	Y2=Y
	IF(X1.NE.0.0 .OR. Y1.NE.0.0) GO TO 1155
	X1=X2
	Y1=Y2
1155	Y0=SQRT(X1*X1+Y1*Y1)
	X0=Y0*XGRD/YGRD
	IF (Y0.GE.XGRD) GO TO 1156
	CALL LINTYP(2,LINETP)
	CALL INTENS(2,-4)
	GO TO 1159
1156	ANGS=ATAN2(Y1,X1)
	ANGE=ATAN2(Y2,X2)
	IF(ANGS.GE.ANGE) ANGE=ANGE+2*PI
	NSTEP=AMAX1((ANGE-ANGS)*9/PI*AMAX1(SQRT(Y0)/10.0,0.8),3.0)
	ANGI=(ANGE-ANGS)/NSTEP
	X1=X1*XGRD/YGRD
	CALL INTENS(2,-4)
	CALL CHANGE(2,X1,Y1)
	DO 1158 I=1,NSTEP
	ANGS=ANGS+ANGI
	X=X0*COS(ANGS)
	Y=Y0*SIN(ANGS)
	CALL LVECT(X-X1,Y-Y1,1,4,,LINETP)
	X1=X
	Y1=Y
1158	CONTINUE
	CALL LVECT(0.,0.,,-4)
	CALL ADVANC(2,NSTEP+1)
	NVPRIM(NOBJ)=NVPRIM(NOBJ)+NSTEP
	NPRIM(NOBJ)=NPRIM(NOBJ)+NSTEP+1
	XX=XX+X1
	YY=YY+Y1
1159	CALL OFF(1007)
	CALL ON(1002)
	GO TO 1110
C
C	'CLOSE' OR SIMPLY TERMINATE AN OBJECT
C
1170	II=4
1180	CALL POINTR(3,NOBJ)
	CALL GET(3,X0,Y0)
	X=X0-XX
	Y=Y0-YY
	IF(ABS(X).LT.XGRD.AND.ABS(Y).LT.YGRD)GOTO 1185
	IF(ISAC.EQ.0) CALL LVECT(X,Y,,II,,LINETP)
	IF(ISAC.EQ.1) CALL CHANGE(2,X,Y)
	IF(ISAC.EQ.1) CALL INTENS(2,II)
	IF(II.GT.0) NVPRIM(NOBJ)=NVPRIM(NOBJ)+1
	IF(ISAC.EQ.0) NPRIM(NOBJ)=NPRIM(NOBJ)+1
1185	ISAC=0
	CALL ESUB
	IF(NVPRIM(NOBJ).EQ.0)GOTO 1190
	NDEF=NDEF+1
	GOTO 100
1190	CALL ERAS(NOBJ)
	NPRIM(NOBJ)=0
	GOTO 100
C
C	CHANGE LINE TYPES
C
1200	LINETP=IT
	GO TO 1110
C
C	ALLOW TEXT TO BE ENTERED
C
1240	CALL TTW(0,'ENTER TEXT: ',-1)
	CALL KBS(32,FILE1,I)
	IF (I.EQ.0) GO TO 1110
	FILE1(I+1)=0
	CALL TEXT(FILE1)
	CALL LVECT(-14.0*FLOAT(I),0.,1,-4,-1,LINETP)
	CALL ADVANC(2,2)
	NPRIM(NOBJ)=NPRIM(NOBJ)+2
	NVPRIM(NOBJ)=NVPRIM(NOBJ)+1
	II=-4
	GO TO 1110
C
C	MOVE AN OBJECT
C
1600	IF(NDEF.EQ.0)GOTO 100
	CALL ON(NSKIP)
	CALL PICKOB(IT,2)
	IF(IT.EQ.NSKIP) GO TO 100
	CALL OFF(NSKIP)
	CALL ON(1003)
	CALL POINTR(2,IT)
	CALL GET(2,XX,YY)
	CALL ATTACH(2)
	CALL TRAK(XX,YY)
	CALL MENUH(IT,1003,1003)
	CALL GRID(XGRD,YGRD)
	CALL ERAS
	GOTO 100
C
C	COMBINE TWO OBJECTS
C
1700	IF(I.LT.MARGIN)GOTO 4000
	IF(NDEF.LT.2)GOTO 100
	CALL ON(NSKIP)
	CALL PICKOB(IT,2)
	IF(IT.EQ.NSKIP) GO TO 100
1710	CALL PICKOB(IT2,3)
	IF(IT2.EQ.NSKIP) GO TO 100
	IF(IT2.EQ.IT)GOTO 1710
	CALL MAKOBJ(NOBJ)
	CALL SUBP(NOBJ)
	CALL COPY(,IT)
	CALL GET(2,X1,Y1)
	CALL GET(3,X2,Y2)
	CALL LVECT(X2-X1,Y2-Y1,,-4)
	CALL OFF(IT2)
	CALL ERASP(3)
	CALL COPY(,IT2)
	CALL LVECT(X1-X2,Y1-Y2,,-4)
	CALL ESUB
	NPRIM(NOBJ)=NPRIM(IT)+NPRIM(IT2)+2
	NVPRIM(NOBJ)=NVPRIM(IT)+NVPRIM(IT2)
	NDEF=NDEF-1
	CALL ERAS(IT)
	CALL ERAS(IT2)
	NPRIM(IT)=0
	NPRIM(IT2)=0
	NVPRIM(IT)=0
	NVPRIM(IT2)=0
	GOTO 100
C
C	SCALE AN OBJECT
C
1800	IF(NDEF.EQ.0)GOTO 100
	CALL ON(1004)
	CALL MENUH(IT2,1030,1033)
	CALL OFF(1004)
	CALL ON(NSKIP)
	CALL PICKOB(IT,2)
	IF(IT.EQ.NSKIP) GO TO 100
	CALL OFF(IT)
	XX=0.
	YY=0.
	DO 1830 I=1,NPRIM(IT)
	CALL ADVANC(2)
	CALL GET(2,X,Y)
	CALL CHANGE(2,X*SF(IT2),Y*SF(IT2))
	CALL GET(2,X,Y)
	XX=XX+X
1830	YY=YY+Y
1840	CALL GET(2,X,Y)
	CALL CHANGE(2,X-XX,Y-YY)
	CALL ON(IT)
	GOTO 100
C
C	COPY AN OBJECT
C
1900	IF(I.LT.MARGIN)GOTO 4000
	IF(NDEF.EQ.0)GOTO 100
	CALL ON(NSKIP)
	CALL PICKOB(IT,2)
	IF(IT.EQ.NSKIP) GO TO 100
	CALL OFF(NSKIP)
	CALL ON(1003)
1910	CALL MAKOBJ(NOBJ)
	CALL COPY(NOBJ,IT)
	CALL POINTR(2,NOBJ)
	CALL GET(2,X,Y)
	CALL ATTACH(2)
	CALL TRAK(X,Y)
	CALL MENUH(IT2,1003,1003)
	CALL GRID(XGRD,YGRD)
	CALL ERAS
	NDEF=NDEF+1
	NPRIM(NOBJ)=NPRIM(IT)
	NVPRIM(NOBJ)=NVPRIM(IT)
	IF(ISAC.EQ.0)GOTO 100
	ISAC=0
	GOTO 2210
C
C	ERASE AN OBJECT
C
2000	IF(NDEF.EQ.0)GOTO 100
	CALL ON(NSKIP)
	CALL PICKOB(IT,2)
	IF(IT.EQ.NSKIP) GO TO 100
	CALL ERAS(IT)
	NDEF=NDEF-1
	NVPRIM(IT)=0
	NPRIM(IT)=0
	GOTO 100
C
C	MODIFY AN OBJECT
C
2100	IF(NDEF.EQ.0)GOTO 100
	CALL ON(1005)
	CALL MENUH(IT2,1040,1044)
2105	IF(IT2.EQ.5)GOTO 100
2110	CALL WAITLP(IT,IP,1,209)
	CALL POINTR(5,IT,IP)
	GOTO (2120,2140,2130,2170),IT2
C
C	ERASE A LINE
C
2120	CALL INTENS(5,-10)
	NVPRIM(IT)=NVPRIM(IT)-1
	IF(NVPRIM(IT).GT.0)GOTO 2100
	CALL ERAS(IT)
	NPRIM(IT)=0
	NDEF=NDEF-1
	GOTO 2100
C
C	MOVE A CORNER
C
2130	IF(IP.NE.NPRIM(IT)+1)GOTO 2150
	CALL POINTR(4,IT)
	CALL ATTACH(4)
	CALL POINTR(6,IT,2)
	GOTO 2155
C
C	SPLIT A LINE
C
2140	CALL GET(5,X,Y)
	CALL OFF(1000)
	CALL CHANGE(5,X/2.,Y/2.)
	CALL POINTR(2,IT,IP+1)
	CALL INSERT(2)
	CALL LVECT(X/2.,Y/2.)
	CALL INSERT
	CALL ON(1000)
	NPRIM(IT)=NPRIM(IT)+1
	NVPRIM(IT)=NVPRIM(IT)+1
2150	CALL POINTR(6,IT,IP+1)
2155	CALL ATTACH(5)
	CALL ATTACH(6,-1)
	CALL POINTR(2,IT)
	CALL GET(2,X,Y)
	DO 2160 I=1,IP-1
	CALL ADVANC(2)
	CALL GET(2,XX,YY)
	X=X+XX
2160	Y=Y+YY
	CALL TRAK(X,Y)
	CALL MENUH(IT2,1040,1044)
	CALL GRID(XGRD,YGRD)
	CALL ERAS
	GOTO 2105
C
C	SHOW ALL LINES
C
2170	CALL POINTR(5,IT)
	DO 2180 I=1,NPRIM(IT)
	CALL ADVANC(5)
2180	CALL INTENS(5)
	NVPRIM(IT)=NPRIM(IT)
	GOTO 2100
C
C	HIDE AN OBJECT
C
2200	IF(NDEF.EQ.0)GOTO 100
	CALL ON(NSKIP)
	CALL  PICKOB(IT,2)
	IF(IT.EQ.NSKIP) GO TO 100
2210	CALL OFF(IT)
	NVPRIM(IT)=-NVPRIM(IT)
	NDEF=NDEF-1
	NHID=NHID+1
	GOTO 100
C
C	SEEK AN OBJECT
C
2300	IF(NHID.EQ.0)GOTO 100
2305	DO 2310 I=1,209
	IF(NVPRIM(I).LT.0)CALL ON(I)
2310	IF(NVPRIM(I).GT.0)CALL OFF(I)
	CALL PICKOB(IT,2)
	IF(IT.EQ.NSKIP) ISAC=0
	IF(IT.EQ.NSKIP) GO TO 2315
	NVPRIM(IT)=-NVPRIM(IT)
	NDEF=NDEF+1
	NHID=NHID-1
2315	DO 2320 I=1,209
	IF(NVPRIM(I).LT.0)CALL OFF(I)
2320	IF(NVPRIM(I).GT.0)CALL ON(I)
	IF(ISAC)1910,100,1910
C
C	SAVE THE DISPLAY
C
2400	CALL INFILE(I,FILE1,FILE2)
	IF (I.EQ.0) GO TO 100
	CALL STOP
	CALL ASSIGN(2,FILE2)
	DEFINE FILE 2(2,256,U,INDX)
	WRITE(2'1)(NPRIM(I),I=1,256)
	WRITE(2'2)(NPRIM(I),I=257,420),(J,J=421,512)
	CALL CLOSE(2)
	CALL SAVE(FILE1)
	CALL LPEN(IH,IT)
	GOTO 100
C
C	RECALL A DISPLAY FILE
C
2500	CALL INFILE(I,FILE1,FILE2)
	IF (I.EQ.0) GO TO 100
	CALL STOP
	CALL ASSIGN(2,FILE2)
	DEFINE FILE 2(2,256,U,INDX)
	READ(2'1)(NPRIM(I),I=1,256)
	READ(2'2)(NPRIM(I),I=257,420),(K,I=421,512)
	CALL CLOSE(2)
	CALL INIT
	CALL RSTR(FILE1)
	CALL LPEN(IH,IT)
	GOTO 100
C
C	SEEK AND COPY
C
2600	IF(I.LT.MARGIN)GOTO 4000
	IF(NHID.EQ.0)GOTO 100
	CALL ON(1003)
	ISAC=1
	GOTO 2305
C
C	ROTATE
C
2700	IF(NDEF.EQ.0)GOTO 100
	CALL ON(1006)
	CALL MENUH(IT2,1050,1052)
	CALL OFF(1006)
	CALL ON(NSKIP)
	CALL PICKOB(IT,2)
	IF(IT.EQ.NSKIP) GO TO 100
	CALL OFF(IT)
	XX=XGRD/YGRD
	YY=YGRD/XGRD
	DO 2750 I=1,NPRIM(IT)
	CALL ADVANC(2)
	CALL GET(2,X,Y)
	GOTO(2710,2720,2730),IT2
2710	CALL CHANGE(2,Y*XX,-X*YY)
	GOTO 2750
2720	CALL CHANGE(2,-X,-Y)
	GOTO 2750
2730	CALL CHANGE(2,-Y*XX,X*YY)
2750	CONTINUE
	CALL ON(IT)
	GOTO 100
C
C	TURN ON OR OFF THE GRID PATTERN USED TO ALIGN CORNERS
C
3000	CALL POINTR(2,2024)
	IF (ISHOW.EQ.1) GO TO 3400
	IP = XGRD
	CALL SUBP(2005)
	CALL APNT(0.0,0.0,-1,1,-1)
	CALL SUBP(7000)
	DO 3200 I=IP,1024,IP
	CALL RPNT(XGRD,0.0)
3200	CONTINUE
	CALL ESUB(7000)
	IP = YGRD
	DO 3300 I=IP,1024,IP
	CALL APNT(0.0,FLOAT(I))
	CALL SUBP(7000+I/IP,7000)
3300	CONTINUE
	CALL ESUB(2005)
	ISHOW = 1
	CALL CHANGT(2,'GRID OFF')
	GO TO 100
3400	ISHOW = 0
	CALL ERAS(2005)
	CALL CHANGT(2,'GRID ON ')
	GO TO 100
C
C	PLOT THE SCREEN
C
3500	CALL DPTR(I)
	CALL DPLOT(ISTRT,I)
	GOTO 100
C
4000	CALL CMPRS
	GOTO 100
5000	CALL FREE
	STOP
	END

	SUBROUTINE MENUH(IT,M1,M2)
C
C	WAIT FOR MENU HIT
C
100	CALL WAITLP(IT,IP,M1,M2)
	CALL POINTR(10,IT)
	CALL FLASH(10,1)
	CALL WAIT(3000)
	CALL LPEN(IH,IX)
	CALL FLASH(10,-1)
	IT=IT+1-M1
	RETURN
	END

	SUBROUTINE PICKOB(IT,IS)
C
C	PICK AN OBJECT
C
	COMMON/DFILE/IBUF(8096)
	COMMON/PDATA/NPRIM(209),NVPRIM(209),NDEF,NHID
	IP=-1
100	CALL WAITLP(IT,IP,1,209)
	CALL POINTR(IS,IT)
	CALL FLASH(IS,1)
	CALL WAIT(3000)
	CALL FLASH(IS,-1)
	RETURN
	END

	SUBROUTINE INFILE(N,FILE1,FILE2)
C
C	INPUT A FILE NAME
C
	LOGICAL*1 FILE1(16),FILE2(16),DSP(5),DAT(5)
	DATA DSP,DAT/'.','D','S','P',0,'.','D','A','T',0/
1	CALL TTW(0,'FILENAME : ',-1)
	CALL KBS(16,FILE1,N)
	IF(N.EQ.0) RETURN
	DO 100 I=1,N
100	FILE2(I)=FILE1(I)
	DO 200 I=1,5
	FILE1(I+N)=DSP(I)
200	FILE2(I+N)=DAT(I)
	RETURN
	END

	SUBROUTINE MAKOBJ(NOBJ)
	COMMON/DFILE/IBUF(9096)
	COMMON/PDATA/NPRIM(209),NVPRIM(209),NDEF,NHID
	DO 100 NOBJ=1,209
	IF(NVPRIM(NOBJ).EQ.0)RETURN
100	CONTINUE
	STOP
	END

	SUBROUTINE WAITLP(IT,IP,IT1,IT2)
	CALL POINTR(10,2006,1)
	IN=-4
	LT=-99
100	CALL INTENS(10,IN)
	IT=LT
	IF (IP.NE.-1) IP=LP
	KOUNT=0
110	CALL LPEN(IH,LT,,,LP)
	IF(IH.EQ.0 .AND. KOUNT.LT.2)GOTO 110
	IF(LT.GE.IT1 .AND. LT.LE.IT2) GOTO 120
	IF(KOUNT.LT.2) GOTO 110
	GOTO 130
120	IF(IT.NE.LT) GOTO 100
	IF(IP.NE.-1 .AND. IP.NE.LP) GO TO 100
	IF(KOUNT.NE.1) GOTO 130
	IF(IP.EQ.-1) LP=1
	IN=4
	IF(IP.EQ.-1) IN=-4
	CALL POINTR(10,LT,LP)
	CALL INTENS(10,IN*2)
130	KOUNT=KOUNT+1
	IF(KOUNT.LT.100) GOTO 110
	CALL LPEN(IH,LT)
	CALL INTENS(10,IN)
	RETURN
	END


	SUBROUTINE DPLOT(ISTART,IEND)
C	PROGRAM TO DUMP CONTENTS OF A DISPLAY FILE
	COMMON/DFILE/ IBUF(10)
	COMMON/PLOTTR/LASTX,LASTY
	DIMENSION INSTR(13)
	LOGICAL*1 ILINE(40),ICHR(2),TSCAL(9)
	INTEGER PLTON(3),PLTOFF(3),PLTRST(3),PLTPON(3),PLTPOF(3)
	INTEGER PLTGIN(3),PLTPAD,OINSTR,US,GS,BELL
	INTEGER TWIDTH
	EQUIVALENCE (ICHAR,ICHR)
C
	DATA INSTR/"173400,"162000,"160000,"164000,"170000,
     C		   "174000,"120000,"124000,"110000,"104000,
     C		   "100000,"114000,"130000/
C
C	PLOTTER CONTROL CHARACTERS
	DATA PLTON/"33,'A','E'/, PLTOFF/"33,'A','F'/
	DATA PLTRST/"33,'A','N'/, PLTPON/"33,'A','K'/
	DATA PLTPOF/"33,'A','L'/, PLTGIN/"33,'A','M'/
	DATA PLTPAD/"200/,US/'_'/,GS/"35/,BELL/"7/
	DATA TSCAL/"33,'A','I','5','6',' ','7','8',"177/
	DATA TWIDTH/14/
C
	IMODE = 1
	ISTART=IADDR(IBUF(ISTART))
	IEND=IADDR(IBUF(IEND))
C	INITIALIZE PLOTTER - TURN ON
	DO 112 I=1,3
	CALL OUTT(PLTON(I))
112	CONTINUE
C
C	RESET PLOTTER
	DO 114 I=1,3
	CALL OUTT(PLTRST(I))
114	CONTINUE
C	INITIALIZE FLAGS
	IFLAG=0
	MODE=0
	DINSTR=0
	OINSTR=0
	INTENS=0
	I=ISTART
	NEW=1
120	CONTINUE
	IF(IPEEK(I).LT.0) GOTO 900
125	IF(DINSTR.NE.0) GOTO 129
	WRITE(5,126) IPEEK(I),I
126	FORMAT(' ERROR IN DECODING DISPLAY FILE:',O6,2X,O6)
	RETURN
C	FIGURE WHICH INSTRUCTION IT IS
129	GOTO(130,125,200,250,300,350,125,125,500,125,600,650,125),DINSTR
C	DHALT - IGNORE THIS DATA WORD
130	IF(IPEEK(I).EQ.0) IFLAG=IFLAG+1
	IF(IPEEK(I).NE.0) IFLAG=0
C	   IF THIS IS THE SECOND TIME AROUND THEN RETURN TO CALLING PROG
	IF(IFLAG.GE.2) RETURN
	NEW=0
	I=I+1
	GOTO 1000
C
C	DJMPA
C
200	I=IPEEK(I)
	NEW=0
	OINSTR=0
C
C	DNOP WAS PREVIOUS INSTRUCTION; INTERPRET UNDER OLD INSTRUCTION
C
250	NEW=0
	IF(OINSTR.EQ.0) GOTO 260
	GOTO(130,125,200,250,300,350,125,125,500,125,600,650,125),OINSTR
260	I=I+1
	GOTO 1000
C
C	LOAD STATUS REG A - SAME ACTION AS PREVIOUS INSTRUCTION=DNOP
300	GOTO 250
C
C	LOAD STATUS REGISTER B - SAME AS ABOVE
350	GOTO 250
C
C	NOW FOR THE IMPORTANT STUFF - LVECT
C
500	NEW=0
	IX=IPEEK(I)
	I=I+1
	IY=IPEEK(I)
	I=I+1
C	NOW PLOT THIS VECTOR
C	SEE IF THIS IS THE FIRST LVECT
	IF(MODE.NE.0) GOTO 510
C	IF SO, SEND A GS TO PUT US IN VECTOR DRAWING STATE
	CALL OUTT(GS)
C	SEE IF WE SHOULD ACTUALLY DRAW THIS VECTOR RATHER THAN JUST MOVE
	IF((IX.AND."040000).NE.0) CALL OUTT(BELL)
	MODE=1
	GOTO 520
C
C	SEE IF WE SHOULD HAVE PEN DOWN OR NOT
510	IF((IX.AND."040000).EQ.0) CALL OUTT(GS)
520	CONTINUE
C	COMPUTE COORDINATES
	ITX=IX.AND."001777
	ITY=IY.AND."001777
	IF((IX.AND."020000).NE.0) ITX=0-ITX
	IF((IY.AND."020000).NE.0) ITY=0-ITY
	CALL PLOT(ITX,ITY)
	DO 530 J=1,8
	CALL OUTT(PLTPAD)
530	CONTINUE
	GOTO 1000
C
C	TEXT
C
C	FIRST RESET THE PLOTTER
600	IF(NEW.EQ.0.OR.NEW.EQ.-1) GOTO 630
	NEW=-1
C	FIRST RE-POSITION PEN ABOVE STARTING POINT
	CALL OUTT(GS)
	CALL PLOT(0,2)
C	 NOW RESET THE PLOTTER
	DO 610 J=1,3
610	CALL OUTT(PLTRST(J))
C	NOW SET UP THE PROPER SCALING
	DO 620 J=1,9
620	CALL OUTT(TSCAL(J))
C
C	NOW SEND THE CHARACTERS
630	K=IPEEK(I).AND."177
	K1=IPEEK(I)/256
	CALL OUTT(K)
	CALL OUTT(K1)
	J=0
	IF(K.NE.0) J=1
	IF(K1.NE.0) J=J+1
	I=I+1
	IWORD=0
C	INCREASE X-POSITION SO IF WE DRAW ANY VECTORS WE WILL THINK
C	THAT WE ARE IN CORRECT LOCATION
	LASTX=LASTX+TWIDTH*J
	DO 640 J=1,65
	CALL OUTT(PLTPAD)
640	CONTINUE
	GOTO 1000
C
C	APNT
C
650	IX=IPEEK(I)
	I=I+1
	IY=IPEEK(I)
	I=I+1
	ITX=(IX.AND."1777)
	ITY=(IY.AND."1777)
	MODE=0
	IF((IX.AND."040000).NE.0) MODE=1
	CALL APLOT(ITX,ITY,MODE)
	DO 660 J=1,10
	CALL OUTT(PLTPAD)
660	CONTINUE
	GOTO 1000
C
C	COMES HERE IF WE GOT AN INSTRUCTION
900	CONTINUE
C	SEE IF PREVIOUS INSTRUCTION WAS 'TEXT'
C	IF SO, THEN REPOSITION PEN DOWN A LINE
	IF(NEW.NE.-1) GOTO 905
	CALL OUTT(GS)
	CALL PLOT(0,-2)
905	CONTINUE
	DO 910 J=1,13
	IVAL=IPEEK(I)
	IF(J.GE.5) IVAL=IVAL.AND."174000
	IF(IVAL.EQ.INSTR(J)) GOTO 920
910	CONTINUE
915	FORMAT(' ERRONEOUS INSTRUCTION:',O6)
	WRITE(5,915) IPEEK(I)
	RETURN
920	OINSTR=DINSTR
	DINSTR=J
C	PICK UP INTENSITY FROM SET GRAPHIC MODE INSTRUCTION
	IF((IVAL.AND."002000).NE.0.AND.J.GE.5)
     C		INTENS=(IPEEK(I).AND."001600)/"200
	I=I+1
	MODE=0
	NEW=1
1000	CONTINUE
	IF(I.LE.IEND) GOTO 120
	RETURN
	END


	SUBROUTINE PLOT(IX,IY)
	COMMON/PLOTTR/LASTX,LASTY
	LASTX=(LASTX+IX)
	LASTY=(LASTY+IY)
	LASTXX=LASTX
	LASTYY=LASTY
	IF(LASTX.GT."1777) LASTXX="1777
	IF(LASTY.GT."1777) LASTYY="1777
	IF(LASTX.LT.0) LASTXX=0
	IF(LASTY.LT.0) LASTYY=0
C	SCALE Y DIMENSION PROPERLY SO IT WILL FIT ON PLOTTER
C	TRIED 3124., BUT DIDN'T SEEM TO WORK PROPERLY
	LASTYY=FLOAT(LASTYY)*(2731./4096.)
C	FIRST CHAR OUTPUT = HIY
	ICHAR="040+(LASTYY/"40)
	CALL OUTT(ICHAR)
C	XLOY - IGNORE
	CALL OUTT("177)
C	LOY
	ICHAR="140+(LASTYY.AND."37)
	CALL OUTT(ICHAR)
C	NOW FOR X - HIX
	ICHAR="040+(LASTXX/"40)
	CALL OUTT(ICHAR)
C	LOX
	ICHAR="100+(LASTXX.AND."37)
	CALL OUTT(ICHAR)
	RETURN
	END



	SUBROUTINE APLOT(IX,IY,INTENS)
	COMMON/PLOTTR/LASTX,LASTY
	INTEGER GS,BELL
	DATA GS/"35/,BELL/"7/
C	SET UP NEW LASTX AND LASTY
	LASTX=IX.AND."1777
	LASTY=IY.AND."1777
C	GET INTO GRAPHIC MODE WITHOUT (BELL) TO DRAW AN INVISIBLE LINE
	CALL OUTT(GS)
C	NOW LET PLOT DO ALL THE WORK
	CALL PLOT(0,0)
C	SEE IF WE SHOULD DROP THE PEN AND MAKE A DOT
	IF(INTENS.EQ.0) CALL OUTT(GS)
	CALL PLOT(0,0)
	RETURN
	END


	SUBROUTINE OUTT(ICHAR)
1	J=IOUTT1(ICHAR)
	IF(J.NE.0) GOTO 1
	RETURN
	END


	FUNCTION IOUTT1(INPUT) 

C	IDLBFO IS ADDRESS OF OUTPUT DL11-W BUFFER 
C	IDLCSR IS STATUS REGISTER ADDRESS 
	DATA IDLBFO/"176506/   
	DATA IDLCSR/"176504/   
	DATA IDLSET/"000000/   
	DATA JOUT/2*0/ 
	DATA ITST/0/   
C   
C	SEE IF THIS IS FIRST TIME THROUGH 
	IF(ITST.EQ.1) GOTO 5   
	ITST=1 
C   
C	INITIALIZE REGISTER   
	CALL IPOKE(IDLCSR,IDLSET)  
C   
C	CHECK IF USER WANTS A 'BREAK' SENT TO THE DEVICE  
 5	IF(INPUT.GE.0) GOTO 10   
C	YES - SET DEVICE REGISTER BIT 0 - BREAK   
	CALL IPOKE(IDLCSR,1)   
	IOUTT1=0   
	ITST=0 
	RETURN 
C   
C	CHECK IF OUTPUT(PRINTER) IS READY FOR ANOTHER CHARACTER   
 10	J=IPEEK(IDLCSR).AND."200
	IF(J.NE.0) GOTO 15 
C	NOT READY - RETURN 1 STATUS   
	IOUTT1=1   
	RETURN 
C   
C	OUTPUT DEVICE(PRINTER) IS READY FOR A CHARACTER - SHIP IT 
15	CALL IPOKE(IDLBFO,INPUT) 
	IOUTT1=0   
	RETURN 
	END
 