
C	DEPTH-CHARGE PROGRAM "SEAWAR"
C
C	WRITTEN BY MICHAEL LAMPI  9/20/78
C	LAST UPDATE 28-APRIL-79
C
	COMMON /DFILE/IBUF(3000)
	INTEGER SXLOC(6),SYLOC(6),SXVEL(6),SYVEL(6)
	INTEGER YDCLOC(6),XDCLOC(6),YDCVEL(6),IHIT(6)
	INTEGER YSMLOC(6),XSMLOC(6),YSMVEL(6),ISMHIT(6)
	INTEGER XSMVEL(6)
	INTEGER YLOC,XLOC,SINK,YINIT,DX,ODX,SXL
	INTEGER YLOC12,YLOC20,YLOC63
	INTEGER YDC,YSM,XDC,SIGN,YDCV
	DIMENSION SHPRA(8),SHPRB(14),SHPRC(20),SHPRD(6),SHPRE(6)
	DIMENSION SUB1RA(20),SUB1RB(10)
	DIMENSION SUB2RA(22),SUB2RB(6)
	DIMENSION ISCMIN(10)

	DATA ISCMIN/300,600,900,1200,1500,1800,2100,2400,2700,3000/
	DATA IHSCOR/0/
	DATA IHITNO/0/
	DATA SUB2RB/-4.,6., -6.,0., 0.,-6./
	DATA SUB2RA/0.,7., 5.,0., 0.,-14., -5.,0., 0.,7., 15.,-5.,
     C		    40.,0., 5.,5., -5.,5., -45.,0., -10.,-5./
	DATA SHPRA/0.,-10., 55.,0., 8.,10., -63.,0./
	DATA SHPRB/0.,5., -5.,0., 0.,1., 5.,0., 2.,2., 5.,0., 0.,-8./
	DATA SHPRC/0.,10., 25.,0., 10.,-10., 0.,8., 5.,0., 2.,-2.,
     C             5.,0., 0.,1., -5.,0., 0.,-5./
	DATA SHPRD/0.,7., 10.,0., 5.,-7./
	DATA SHPRE/0.,5., 3.,0., 3.,-5./

	DATA YDCLOC/6*0/,XDCLOC/6*0/,YDCVEL/6*0/,IHIT/6*0/
	DATA SXLOC/6*0/
	DATA SYLOC/700,600,500,350,225,100/
	DATA SXVEL/-10,-8,-6,-4,-2,-1/
	DATA SYVEL/6*0/
	DATA YSMLOC,XSMLOC,YSMVEL/18*0/
	DATA ISMHIT/6*0/
	DATA IRAN1,IRAN2/0,0/
	DATA YINIT/800/,IGNORE/-1/,SINK/-3/
	DATA SUB1RA/0.,4., 3.,0., 0.,-4., 60.,0., -10.,-6., -45.,0.,
     C		    -5.,3., 0.,-3., -3.,0., 0.,6./
	DATA SUB1RB/0.,4., 4.,0., 0.,4., 8.,0., 0.,-8./
	DATA IBELL/7/,IHITNO/0/
C
C	INITIALIZE THE VT-11
C
	CALL INIT(3000)
C	DRAW SHIP
	CALL SUBP(1)
C	CALL OFF(1)
	CALL APNT(500.,800.,,-4)
	CALL SUBP(2)
	CALL OFF(2)
	CALL SVECT(63.,0.)
	CALL SVECT(0.,-10.)
	CALL SVECT(-55.,0.)
	CALL SVECT(-8.,10.)
C	FINISHED DRAWING HULL - NOW FOR SUPERSTRUCTURE
	CALL RPNT(8.,0.,,-4)
	CALL SVECT(0.,5.)
	CALL SVECT(-5.,0.)
	CALL SVECT(0.,1.)
	CALL SVECT(5.,0.)
	CALL SVECT(2.,2.)
	CALL SVECT(5.,0.)
	CALL SVECT(0.,-8.)
	CALL SVECT(10.,10.)
	CALL SVECT(25.,0.)
	CALL SVECT(0.,-10.)
	CALL RPNT(2.,0.,,-4)
	CALL SVECT(0.,8.)
	CALL SVECT(5.,0.)
	CALL SVECT(2.,-2.)
	CALL SVECT(5.,0.)
	CALL SVECT(0.,-1.)
	CALL SVECT(-5.,0.)
	CALL SVECT(0.,-5.)
C	FINISHED WITH BOTH DECK GUNS & 1ST LEVEL
	CALL RPNT(-14.,10.,,-4)
	CALL SVECT(0.,7.)
	CALL SVECT(-10.,0.)
	CALL SVECT(-5.,-7.)
	CALL RPNT(7.,7.,,-4)
	CALL SVECT(3.,5.)
	CALL SVECT(3.,0.)
	CALL SVECT(0.,-5.)
	CALL ESUB
C	NOW FOR THE REVERSE OF THE SHIP
	CALL SUBP(3)
	CALL OFF(3)
	DO 1 I=1,7,2
1	CALL SVECT(SHPRA(I),SHPRA(I+1))
C	DONE WITH HULL - NOW SUPERSTRUCTURE
	CALL RPNT(4.,0.,,-4)
	DO 2 I=1,13,2
2	CALL SVECT(SHPRB(I),SHPRB(I+1))
C	DONE WITH REAR DECK GUN
	CALL RPNT(2.,0.,,-4)
	DO 3 I=1,19,2
3	CALL SVECT(SHPRC(I),SHPRC(I+1))
	CALL RPNT(-36.,8.,,-4)
	DO 4 I=1,5,2
4	CALL SVECT(SHPRD(I),SHPRD(I+1))
	CALL RPNT(-12.,7.,,-4)
C	DRAW SMOKESTACK
	DO 5 I=1,5,2
5	CALL SVECT(SHPRE(I),SHPRE(I+1))
	CALL ESUB
	CALL ESUB
C
C	NOW FOR THE WAVES
C
	CALL SUBP(4)
	CALL OFF(4)
	CALL APNT(0.,778.,,-4)
	CALL TEXT(-1,']]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
     C]]]]]]]]]]]]]]]]]]]]]]')
	CALL ESUB
C
C	NOW FOR THE TITLE
C
	CALL SUBP(5)
	CALL APNT(350.,970.,,-6)
	CALL TEXT(-2,'SUBMARINE WAR SIMULATION')
C
C	NOW FOR SUBMARINE 1
C
	CALL SUBP(11)
	CALL APNT(SXLOC(1),SYLOC(1),,-4)
	CALL RPNT(-32.,0.,,-4)
	CALL SUBP(12)
	CALL OFF(12)
	CALL SVECT(60.,0.)
	CALL SVECT(0.,4.)
	CALL SVECT(3.,0.)
	CALL SVECT(0.,-10.)
	CALL SVECT(-3.,0.)
	CALL SVECT(0.,3.)
	CALL SVECT(-5.,-3.)
	CALL SVECT(-45.,0.)
	CALL SVECT(-10.,6.)
	CALL RPNT(20.,0.,,-4)
C	NOW FOR THE CONNING TOWER
	CALL SVECT(0.,8.)
	CALL SVECT(8.,0.)
	CALL SVECT(0.,-4.)
	CALL SVECT(4.,0.)
	CALL SVECT(0.,-4.)
	CALL RPNT(-5.,8.,,-4)
	CALL SVECT(0.,4.)
	CALL RPNT(-2.,2.,,-4)
	CALL SVECT(0.,-6.)
	CALL RPNT(-2.,0.,,-4)
	CALL SVECT(0.,3.)
	CALL ESUB
	CALL SUBP(13)
	CALL OFF(13)
	DO 990 I=1,19,2
990	CALL SVECT(SUB1RA(I),SUB1RA(I+1))
	CALL RPNT(31.,0.,,-4)
	DO 991 I=1,9,2
991	CALL SVECT(SUB1RB(I),SUB1RB(I+1))
	CALL RPNT(-7.,8.,,-4)
	CALL SVECT(0.,4.)
	CALL RPNT(2.,2.,,-4)
	CALL SVECT(0.,-6.)
	CALL RPNT(2.,0.,,-4)
	CALL SVECT(0.,4.)
	CALL ESUB
	CALL ESUB
C
C	NOW FOR A DUPLICATE SUBMARINE
C
	CALL SUBP(14)
	CALL APNT(SXLOC(2),SYLOC(2),,-4)
	CALL RPNT(-32.,0.,,-4)
	CALL COPY(15,12)
	CALL OFF(15)
	CALL COPY(16,13)
	CALL OFF(16)
	CALL ESUB
C	NOW FOR A THIRD SUBMARINE OF TYPE 1
	CALL SUBP(17)
	CALL APNT(SXLOC(3),SYLOC(3),,-4)
	CALL RPNT(-32.,0.,,-4)
	CALL COPY(18,12)
	CALL OFF(18)
	CALL COPY(19,13)
	CALL OFF(19)
	CALL ESUB
C
C	NOW FOR SUBMARINE 2
C
	CALL SUBP(20)
	CALL APNT(SXLOC(4),SYLOC(4),,-4)
C	REPOSITION THE STARTING POINT SO SUBS CAN GO OFF THE LEFT SIDE
	CALL RPNT(-32.,0.,,-4)
	CALL SUBP(21)
	CALL OFF(21)
	CALL SVECT(5.,5.)
	CALL SVECT(48.,0.)
	CALL SVECT(10.,-5.)
	CALL SVECT(0.,7.)
	CALL SVECT(-5.,0.)
	CALL SVECT(0.,-14.)
	CALL SVECT(5.,0.)
	CALL SVECT(0.,7.)
	CALL SVECT(-15.,-5.)
	CALL SVECT(-43.,0.)
	CALL SVECT(-5.,5.)
C	DONE WITH DRAWING HULL - NOW FOR CONNING TOWER
	CALL RPNT(20.,5.,,-4)
	CALL SVECT(4.,6.)
	CALL SVECT(6.,0.)
	CALL SVECT(0.,-6.)
	CALL ESUB
	CALL SUBP(22)
	CALL OFF(22)
	DO 985 I=1,21,2
985	CALL SVECT(SUB2RA(I),SUB2RA(I+1))
	CALL RPNT(40.,5.,,-4)
	DO 986 I=1,5,2
986	CALL SVECT(SUB2RB(I),SUB2RB(I+1))
	CALL ESUB
	CALL ESUB

C	NOW FOR A DUPLICATE OF SUBMARINE 2
	CALL SUBP(23)
	CALL APNT(SXLOC(5),SYLOC(5),,-4)
	CALL RPNT(-32.,0.,,-4)
	CALL COPY(24,21)
	CALL OFF(24)
	CALL COPY(25,22)
	CALL OFF(25)
	CALL ESUB

C	NOW FOR A THIRD SUBMARINE OF TYPE 2
	CALL SUBP(26)
	CALL APNT(SXLOC(6),SYLOC(6),,-4)
	CALL RPNT(-32.,0.,,-4)
	CALL COPY(27,21)
	CALL OFF(27)
	CALL COPY(28,22)
	CALL OFF(28)
	CALL ESUB
C
C	NOW DEFINE THE NUMBER OF DEPTH CHARGES LEFT
C
	CALL APNT(320.,900.,,-5)
	CALL SUBP(41)
	CALL TEXT(-1,'_')
	CALL RPNT(63.,0.,,-5)
	CALL ESUB
	CALL COPY(42,41)
	CALL COPY(43,41)
	CALL COPY(44,41)
	CALL COPY(45,41)
	CALL COPY(46,41)
C
C	NOW DEFINE THE DEPTH CHARGES
C
	CALL SUBP(51)
	CALL OFF(51)
	CALL APNT(0.,0.,,5)
	CALL SUBP(52)
	CALL OFF(52)
	CALL RPNT(-7.,-8.,,-8)
	CALL TEXT('*')
	CALL ESUB
	CALL ESUB
C
C	MAKE 5 COPIES
C
	DO 980 I=53,61,2
	CALL SUBP(I)
	CALL OFF(I)
	CALL APNT(0.,0.,,5)
	CALL COPY(I+1,52)
	CALL OFF(I+1)
980	CALL ESUB
C
C	DONE WITH DEPTH CHARGE EXPLOSIONS AND DEFINITIONS
C	NOW DEFINE THE SCORE
C
	CALL SUBP(70)
	CALL OFF(70)
	CALL APNT(50.,860.,,-4)
	CALL TEXT('SCORE: ')
	CALL TEXT('0000')
	CALL RPNT(0.,0.,,0,-1)
	CALL ESUB
C
C	DEFINE HIGHEST SCORE BOX
C
	CALL SUBP(71)
	CALL OFF(71)
	CALL APNT(825.,960.,,-4)
	CALL TEXT('HIGHEST')
	CALL APNT(780.,930.,,-4)
	CALL TEXT('SCORE: ')
	CALL TEXT('0000')
	CALL APNT(780.,900.,,-4)
	CALL TEXT('SUBS:   ')
	CALL TEXT('000')
	CALL ESUB
C
C	DEFINE WHERE THE NUMBER OF ENEMY HITS IS PLACED
C
	CALL SUBP(100)
	CALL OFF(100)
	CALL APNT(50.,900.,,-4)
	CALL TEXT(' HITS:  ')
	CALL TEXT('000')
	CALL ESUB

C
C	NOW DEFINE THE DISPLAY FOR NUMBER OF SUBMARINES SUNK
C
	CALL SUBP(150)
	CALL OFF(150)
	CALL APNT(50.,925.,,-4)
	CALL TEXT(' SUBS:  ')
	CALL TEXT('000')
	CALL ESUB

C
C	NOW DEFINE THE SUBMARINE MISSILES
C
	CALL SUBP(81)
	CALL OFF(81)
	CALL APNT(0.,0.,,5)
	CALL SVECT(0.,-10.)
	CALL SUBP(82)
	CALL OFF(82)
	CALL RPNT(-7.,-8.,,-8)
	CALL TEXT('*')
	CALL ESUB
	CALL OFF(82)
	CALL ESUB
C
C	NOW MAKE 5 COPIES
C
	DO 999 I=83,91,2
	CALL SUBP(I)
	CALL OFF(I)
	CALL APNT(0.,0.)
	CALL SVECT(0.,-10.)
	CALL COPY(I+1,82)
	CALL OFF(I+1)
999	CALL ESUB
C
C	DEFINE THE ENDING MESSAGE
C
	CALL SUBP(200)
	CALL OFF(200)
	CALL APNT(430.,400.,,-8)
	CALL TEXT(-2,'GAME OVER')
	CALL RPNT(0.,0.,,-1,-1)
	CALL ESUB
C
C	NOW DEFINE THE ELAPSED TIME INDICATOR
C
	CALL SUBP(201)
	CALL OFF(201)
	CALL APNT(50.,950.,,-5)
	CALL TEXT(' TIME:  ')
	CALL TEXT('000')
	CALL ESUB
	CALL ON(201)
C
C	NOW DEFINE THE OVERTIME MESSAGE
C
	CALL SUBP(202)
	CALL OFF(202)
	CALL APNT(350.,490.,,-8,1)
	CALL TEXT(-2,'* * *  OVERTIME  * * *')
	CALL RPNT(0.,0.,,0,-1)
	CALL ESUB
C
C	NOW DEFINE THE RESPONSE FOR HOT-SHOT PLAYERS
C
	CALL SUBP(999)
	CALL OFF(999)
	CALL APNT(390.,650.,,-8,1)
	CALL TEXT(-2,'* * *  TILT  * * *')
	CALL RPNT(0.,0.,,0,-1)
	CALL ESUB
C
C	NOW READ PREVIOUS HIGH SCORE FROM THE DISC
C
1202	OPEN(UNIT=7,NAME='SEAWAR.DAT',TYPE='UNKNOWN')
	READ(7,1104,ERR=1200,END=1200) IHSCOR,IMSUNK
	REWIND 7
	GOTO 1201
1200	CLOSE(UNIT=7,DISP='DELETE')
	OPEN(UNIT=7,NAME='SEAWAR.DAT',TYPE='NEW')
	WRITE(7,1104) IHSCOR,IMSUNK
	ENDFILE 7
	CLOSE(UNIT=7)
	GOTO 1202
1201	CONTINUE
	CALL POINTR(20,71,5)
	CALL I5DIG(IHSCOR)
	CALL ADVANC(20,3)
	CALL I3DIG(IMSUNK)
C
C	NOW DEFINE THE POINTERS
C
	CALL POINTR(1,1,1)
	CALL POINTR(2,11,1)
	CALL POINTR(3,14,1)
	CALL POINTR(4,17,1)
	CALL POINTR(5,20,1)
	CALL POINTR(6,23,1)
	CALL POINTR(7,26,1)
	DO 9 I=1,6
9	CALL POINTR(I+7,49+I*2,1)
	DO 8 I=1,6
8	CALL POINTR(I+13,79+I*2,1)
C
C	NOW TURN ON THE PICTURES
C
	CALL ON(2)
C
C	GET A RANDOM NUMBER SEED FROM THE JOYSTICK
C
C	CALL JOYSTK(IRAN1,IRAN2,IBUTT)
	IRAN1=IATOD(0,0)
	IRAN2=IATOD(1,0)
	IOBUTT=0
C
1999	CALL ON(4)
	CALL ON(70)
	CALL ON(71)
	CALL ON(100)
	CALL ON(150)
	CALL OFF(999)
	CALL OFF(202)
	DO 1998 I=1,6
	YDCLOC(I)=0
	ISMHIT(I)=0
	YSMLOC(I)=0
	IHIT(I)=0
	YDCLOC(I)=0
	SXLOC(I)=0
	CALL ON(40+I)
	CALL OFF(I+80)
	CALL OFF(I+86)
	CALL OFF(I+50)
	CALL OFF(I+56)
	CALL OFF(I*3+9)
	CALL OFF(I*3+10)
	CALL OFF(200)
1998	CONTINUE
	CALL SCORE(0)
	CALL POINTR(20,70,3)
	CALL FLASH(20,-1)
C	INITIALIZE HIT COUNT DISPLAY
	CALL POINTR(20,100,3)
	CALL I3DIG(0)
C	INITIALIZE SUB COUNT DISPLAY
	CALL POINTR(20,150,3)
	CALL I3DIG(0)

	IHITNO=0
	ISUNK=0
	ILENG=121
	ODX=0
	XLOC=500
	YLOC=800
C	RE-POSITION THE SHIP
	CALL CHANGE(1,FLOAT(XLOC),FLOAT(YLOC))
	ISCORE=0
	IOVTIM=1
	ICHARG=6
	LTIME=0
C	  SET THE AR11 CLOCK & START THE GAME
C	  5 = 100 HZ RATE
C	  100 = DIVIDE BY 100
C	  1 = REPEATED INTERVALS
	CALL CLKSET(5,1,100)

C	  CHECK IF CLOCK HAS TICKED A SECOND
10	IF(ICLKRD(1).EQ.0) GOTO 11
	LTIME=LTIME+1
	ITIME=ILENG-LTIME
	CALL POINTR(20,201,3)
	CALL I3DIG(ITIME)
	IF(ITIME.GT.0) GOTO 11
C
C	SEE IF WE SHOULD LET HIM GO INTO OVERTIME
C
	IF(ISCORE.LT.ISCMIN(IOVTIM)) GOTO 1000
	CALL ON(202)
	CALL POINTR(20,70,3)
	CALL FLASH(20)
	CALL POINTR(20,201,3)
	IF(IOVTIM.GE.10) GOTO 9999
C	  RESET 'TIME'
	LTIME=0
	IOVTIM=IOVTIM+1
C	  WAIT A SECOND FOR FLASH TO GO AWHILE
13	IF(ICLKRD(1).EQ.0) GOTO 13
	CALL I3DIG(60)
	CALL OFF(202)
C
C	SHOULD WE IGNORE THE JOYSTICK FOR A WHILE?
C
11	IF(IGNORE.EQ.-1) GOTO 15
	IGNORE=IGNORE-1
	IF(IGNORE.EQ.-1) GOTO 12
	YLOC=YLOC+SINK
	GOTO 23
12	YLOC=YINIT
	GOTO 23
C15	CALL JOYSTK(IX,IY,IBUTT)
15	IX=1023-IATOD(1,0)
	IF(IATOD(2,0).GT.100) GOTO 18
C	  BUTTON IS PRESSED - SEE IF IT'S BEING HELD DOWN
	IF(IOBUTT.EQ.0) GOTO 17
C	  YES - BEING HELD DOWN - RETURN A ZERO
	IBUTT=0
	GOTO 19
C	  NOT BEING HELD DOWN - SET IBUTT TO 1
17	IBUTT=1
	IOBUTT=1
	GOTO 19
C	  BUTTON UN-PRESSED - RESET IOBUTT
18	IOBUTT=0
	IBUTT=0
19	DX=IX/52-9
	IF(DX)20,40,30
20	IF(ODX.LT.0) GOTO 22
	CALL OFF(3)
	CALL ON(2)
22	XLOC=XLOC+DX
	ODX=DX
	IF(XLOC.LT.0) XLOC=0
	IF(XLOC.GT.940) XLOC=940
23	CALL CHANGE(1,FLOAT(XLOC),FLOAT(YLOC))
	GOTO 40
30	IF(ODX.GT.0) GOTO 22
	CALL OFF(2)
	CALL ON(3)
	GOTO 22
C
C	HANDLE SUBMARINE MOVEMENT
C
40	ISTART=0
	IF(RAN(IRAN1,IRAN2).LT.0.05) ISTART=1
	DO 70 I=1,6
C	  COMPUTE A FEW 'CONSTANT' VARIABLES TO INCREASE EFFICIENCY
	SXL=SXLOC(I)
	JJ=I*3+9
	IF(SXL.NE.0) GOTO 50
C	SEE IF WE SHOULD START THIS SUB MOVING
	IF(ISTART.EQ.0) GOTO 70
	IF(RAN(IRAN1,IRAN2).LT.0.9+.016*FLOAT(I)) GOTO 70
C	ISTART=0
C	YES - START THIS MOVING
	IF(RAN(IRAN1,IRAN2).LT.0.5) SXVEL(I)=-SXVEL(I)
	IF(SXVEL(I).GT.0) GOTO 41
	SXL=1024
	CALL CHANGE(I+1,1024.,FLOAT(SYLOC(I)))
	CALL ON(JJ)
	GOTO 50
41	SXL=0
	CALL CHANGE(I+1,0.,FLOAT(SYLOC(I)))
	CALL OFF(JJ)
	CALL ON(JJ+1)
C	MOVE THE SUB
50	SXL=SXL+SXVEL(I)
	IF(SXL.GT.0.AND.SXL.LE.1024) GOTO 65
C
C	SUB HAS HIT THE EDGE - REMOVE IT
C
	CALL OFF(JJ)
	CALL OFF(JJ+1)
	SXLOC(I)=0
	GOTO 70
65	SXLOC(I)=SXL
	CALL CHANGE(I+1,FLOAT(SXL),FLOAT(SYLOC(I)))
C
C	CHECK IF WE SHOULD FIRE A MISSILE
C
	IF(RAN(IRAN1,IRAN2).GT.0.05) GOTO 70
	DO 67 J=1,6
	IF(YSMLOC(J).EQ.0) GOTO 68
67	CONTINUE
	GOTO 70
68	XSMLOC(J)=SXL
	YSMLOC(J)=SYLOC(I)+5
	YSMVEL(J)=8+I*(I/3)+I-6
C	CALCULATE NUMBER OF INCREMENTS
	DX=XLOC-XSMLOC(J)
	DY=FLOAT(YLOC-YSMLOC(J))/FLOAT(YSMVEL(J))
C	COMPUTE PROPER X VELOCITY
	XSMVEL(J)=FLOAT(DX)/DY
C	NOW FUDGE IT SO THE TOP SUBS ARE LESS ACCURATE
	IF(I.LT.4) XSMVEL(J)=XSMVEL(J)+(RAN(IRAN1,IRAN2)*
     C			     FLOAT((4-I)*4*SIGN(-DX)))
	CALL CHANGE(J+13,FLOAT(XSMLOC(J)),FLOAT(YSMLOC(J)))
	CALL ON(79+J*2)
70	CONTINUE
C
C	NOW MOVE DEPTH CHARGES(IF ANY)
C
	DO 120 I=1,6
	YDC=YDCLOC(I)
	IF(YDC.EQ.0) GOTO 120
	JJ=I*2
	IF(IHIT(I).EQ.0) GOTO 103
C	REMOVE OLD DEPTH CHARGE EXPLOSIONS
	CALL OFF(JJ+49)
	CALL OFF(JJ+50)
	YDCLOC(I)=0
	IHIT(I)=0
	GOTO 120
C	CHECK IF THIS DEPTH CHARGE IS IN MOTION
103	IF(YDC.LT.30) GOTO 120
	YDCV=YDCVEL(I)
	YDC=YDC+YDCV
	XDC=XDCLOC(I)
	YDCLOC(I)=YDC
	CALL CHANGE(I+7,FLOAT(XDC),FLOAT(YDC))
	IF(YDCV.LT.-6) GOTO 107
	YDCVEL(I)=YDCV-2
C	CHECK FOR BOTTOM
107	IF(YDC.GE.30) GOTO 109
	IHIT(I)=1
	CALL ON(JJ+50)
	ICHARG=ICHARG+1
	CALL ON(40+I)
	GOTO 120
C
C	CHECK FOR A HIT
109	DO 110 J=1,6
	IY=SYLOC(J)
	IF(YDC.GT.IY+10) GOTO 120
	IF(YDC.LT.IY-10) GOTO 110
	IX=SXLOC(J)
	IF(XDC.LT.IX-32) GOTO 110
	IF(XDC.GT.IX+31) GOTO 110
C	A HIT!
	CALL ON(JJ+50)
	WRITE(5,108) IBELL
108	FORMAT($,1X,30A1)
	ISUNK=ISUNK+1
	SXLOC(J)=0
	CALL OFF(J*3+9+ISGN(SXVEL(J)))
	YDCLOC(I)=20
	ISCORE=ISCORE+J*10+J/2*5
	CALL SCORE(ISCORE)
	ICHARG=ICHARG+1
	CALL ON(40+I)
C	NOW DISPLAY UPDATED SUBMARINE COUNT
	CALL POINTR(20,150,3)
	CALL I3DIG(ISUNK)
	IHIT(I)=1
	GOTO 120
110	CONTINUE
120	CONTINUE
C
C	NOW MOVE THE SUBMARINE MISSILES
C
C	  FIRST COMPUTE A FEW 'CONSTANTS'
	YLOC12=YLOC-12
	YLOC20=YLOC+20
	XLOC63=XLOC+63
	DO 150 I=1,6
	J=I*2
	YSM=YSMLOC(I)
	IF(YSM.EQ.0) GOTO 150
	IF(ISMHIT(I).EQ.0) GOTO 125
C	TURN OFF MISSILE EXPLOSIONS
	CALL OFF(80+J)
	ISMHIT(I)=0
	CALL OFF(79+J)
	YSMLOC(I)=0
	GOTO 150
125	YSM=YSM+YSMVEL(I)
	XSM=XSMLOC(I)+XSMVEL(I)
	CALL CHANGE(I+13,FLOAT(XSM),FLOAT(YSM))
C	CHECK FOR A HIT ON THE SHIP
	IF(YSM.LT.YLOC-12) GOTO 140
	IF(YSM.GT.YLOC+20) GOTO 130
	IF(XSM.LT.XLOC) GOTO 140
	IF(XSM.GT.XLOC+63) GOTO 140
C
C	A HIT ON THE SHIP!
C
	CALL ON(80+J)
	IHITNO=IHITNO+1
	CALL POINTR(20,100,3)
	CALL I3DIG(IHITNO)
	ISCORE=ISCORE/2
	CALL SCORE(ISCORE)
	WRITE(5,108) (IBELL,J=1,10)
	IGNORE=10
	ISMHIT(I)=1
	GOTO 140
130	IF(YSM.LT.720) GOTO 140
135	CALL ON(80+J)
	ISMHIT(I)=1
140	YSMLOC(I)=YSM
	XSMLOC(I)=XSM
150	CONTINUE
C
C	NOW CHECK FOR DROPPING DEPTH CHARGES
C
	IF(IBUTT.EQ.0) GOTO 10
	IF(ICHARG.EQ.0) GOTO 10
	ICHARG=ICHARG-1
	DO 200 I=1,6
	IF(YDCLOC(I).LE.30) GOTO 210
200	CONTINUE
	CALL APNT(500.,500.,,-5)
	CALL TEXT('***ABORT***')
	STOP
210	IF(IHIT(I).EQ.0) GOTO 220
	IHIT(I)=0
	CALL OFF(50+I*2)
220	XDCLOC(I)=XLOC+32*(SIGN(-ODX)+1)
	YDCLOC(I)=YLOC+12
	YDCVEL(I)=5
	CALL CHANGE(I+7,FLOAT(XDCLOC(I)),FLOAT(YDCLOC(I)))
	CALL OFF(40+I)
	CALL ON(49+I*2)
	GOTO 10
C
C	NOW FOR THE ENDING ROUTINE
C
9999	CALL ON(999)
1000	CALL ON(200)
	IF(ISCORE.LE.IHSCOR) GOTO 1001
	CALL POINTR(20,71,5)
	CALL I5DIG(ISCORE)
	IHSCOR=ISCORE
1001	IF(ISUNK.LE.IMSUNK) GOTO 1002
	CALL POINTR(20,71,8)
	CALL I3DIG(ISUNK)
	IMSUNK=ISUNK
C	NOW WRITE THE HIGH SCORE TO DISC
1002	WRITE(7,1104) IHSCOR,IMSUNK
	REWIND 7
1104	FORMAT(1X,2I4)
	WRITE(5,1100)
1100	FORMAT($,' TYPE RETURN OR "R" IF YOU WISH TO RUN AGAIN:')
	READ(5,1110) I
1110	FORMAT(A1)
	IF(I.EQ.'R'.OR.I.EQ.'') GOTO 1999
	CLOSE(UNIT=7)
	STOP
	END

	SUBROUTINE SCORE(ISCOR)
	CALL POINTR(20,70,3)
	CALL I5DIG(ISCOR)
	RETURN
	END

	SUBROUTINE I5DIG(INUM)
	LOGICAL*1 STRNG(8)
	CALL IDIGIT(INUM,STRNG)
	CALL CHANGT(20,STRNG(3))
	RETURN
	END

	SUBROUTINE I3DIG(INUM)
	LOGICAL*1 STRNG(8)
	CALL IDIGIT(INUM,STRNG)
	CALL CHANGT(20,STRNG(4))
	RETURN
	END

	INTEGER FUNCTION SIGN(I)
	IF(I) 10,20,30
10	SIGN=-1
	RETURN
20	SIGN=0
	RETURN
30	SIGN=1
	RETURN
	END

	FUNCTION ISGN(I)
	IF(I) 20,20,30
20	ISGN=0
	RETURN
30	ISGN=1
	RETURN
	END
      