{$Title: 'Memory Test Program'}
{$Subtitle: 'Main Module Declarations'}
{$Linesize: 100}
{$Pagesize: 60}
{$Debug-, Indexck-, Mathck-, Nilck-, Rangeck-, Stackck-}

program Memory_Tester (input, output);

Const
    OneK      = 1024;  {1024 bytes in 1K}
    OneKPara  = 64;    {64 paragraphs in 1K}

    TestValue = #A5;

Var
    StartingK [public]: word;
    NumberK   [public]: word;

    TestedK     [public]: word;
    NumberRead  [public]: word;

    MemAddr   [public]: Ads of byte;

{$Page+}
{$Subtitle: 'Initialize'}

procedure Initialize [public];
{------------------------------------------------------
 Prompt the user for the starting K of memory to test
 and the number of K to test.
-------------------------------------------------------}

begin
    {--------------------------------------------------
    First get the starting K.  Note that the 8086
    address space (1Mb) is made up of 1K, 1K blocks.
    ---------------------------------------------------}
    repeat
        writeln;
        write ('What K would you like to start testing (0 -');
        write ((OneK - 1):4, ')? ');
        readln (StartingK)
    until (StartingK < OneK);

    {---------------------------------------------------
    Now get the number of K.  Make sure StartingK +
    NumberK does not go over the end of memory.
    ----------------------------------------------------}
    repeat
        write ('How many K would you like to test (1 -');
        write ((OneK - StartingK):4, ')? ');
        readln (NumberK);
    until (NumberK <> 0) and ((StartingK + NumberK) <= OneK);

    {----------------------------------------------------
    Now set MemAddr.S and MemAddr.R for start of test.
    -----------------------------------------------------}
    MemAddr.S := StartingK * OneKPara;
    MemAddr.R := 0;
end;

{$Page+}
{$Subtitle: 'TestMemory'}

procedure TestMemory [public];
{---------------------------------------------------------
 Start at MemAddr and test 1K blocks of memory for NumberK
 blocks.
----------------------------------------------------------}

begin
    {-----------------------------------------------------
    Test blocks OneK at a time.
    ------------------------------------------------------}
    TestedK := 0;
    while (TestedK < NumberK) do begin
        {-------------------------------------------------
        Test the OneK block.
        --------------------------------------------------}
        while (MemAddr.R < OneK) do begin

            MemAddr^   := TestValue;
            NumberRead := MemAddr^;

            if (NumberRead <> TestValue) then begin
                {------------------------------------------
                Error found.  Report it.
                -------------------------------------------}
                writeln ('Error found at ',
                         MemAddr.S:4:16, ':', MemAddr.R:4:16);
            end;

            MemAddr.R := MemAddr.R + 1;
        end;

        {--------------------------------------------------
        Move up to next K.
        ---------------------------------------------------}
        MemAddr.S := MemAddr.S + OneKPara;
        MemAddr.R := 0;

        TestedK := TestedK + 1;
    end;

    writeln;
    writeln ('Test completed.');
end;

{$Page+}
{$Subtitle: 'Main Program'}
{-----------------  Main Program  --------------------}
begin
    Initialize;
    TestMemory;
end.
