/*------------------------------------------------------------
Main test program for:

	Calculation of Fahrenheit to Celsius Table.

	Based on p.8 of the Kernighan and Ritchie text.
------------------------------------------------------------*/
extern Prompt ();
extern GetVal ();

typedef int temp;    /* temperatures are integers */

int lower, upper, step;
temp fahr, celsius;

main()
{
    /*-----------------------------------------------------
    Initialize lower bound, upper bound, and step.
    ------------------------------------------------------*/
    Init (&lower, &upper, &step);

    /*-----------------------------------------------------
    Print table header.
    -------------------------------------------------------*/
    printf ("   F     C\n");

    /*-----------------------------------------------------
    Print table.
    -------------------------------------------------------*/
    fahr = lower;
    while (fahr <= upper) {
        /*-------------------------------------------------
        Compute celsius temperature.
        ---------------------------------------------------*/
        Compute (fahr, &celsius);

        /*-------------------------------------------------
        Print line of table.
        ---------------------------------------------------*/
        printf("%5d %5d\n", fahr, celsius);

        /*-------------------------------------------------
        Go to next line of table.
        ---------------------------------------------------*/
        fahr = fahr + step;
    };

return;}
/**/
/*-----------------------------------------------------------
procedure name: Init

function:
    1) Initialize Lower bound, upper bound, and step.

inputs:
    l -- lower bound
    u -- upper bound
    s -- step

outputs:
    l, u, s set.

called:
    init (&l, &u, &s);
------------------------------------------------------------*/
Init (l, u, s)
int *l, *u, *s;
{
    /*-------------------------------------------
    Get lower limit.
    ---------------------------------------------*/
    Prompt ("\nFahrenheit lower limit? ");
    *l = GetVal ();

    /*-------------------------------------------
    Get upper limit
    ---------------------------------------------*/
    Prompt ("Fahrenheit upper limit? ");
    *u = GetVal ();

    /*--------------------------------------------
    Get step.
    ----------------------------------------------*/
    Prompt ("Fahrenheit step value?  ");
    *s = GetVal ();

return;}
/**/
/*------------------------------------------------------------
procedure name: Compute

function:
    1) Compute the celsius temperature from the input
       fahrenheit temperature.

inputs:
    f_temp -- fahrenheit temperature

outputs:
    c_temp -- equivalent celsius temperature

        c = (f-32) * (5/9)

called:
    Compute (f_temp, &c_temp);
--------------------------------------------------------------*/
Compute (f_temp, c_temp)
temp f_temp, *c_temp;
{
    *c_temp = f_temp - 32;
    *c_temp = *c_temp * 5;
    *c_temp = *c_temp / 9;
    
return;}
