%define prefix /usr

%define name cbm4linux
%define ver 0.2.4
Summary: CBM4Linux kernel module and utilities
Name: %{name}
Version: %{ver}
Release: 1
Group: Applications/System
Copyright: GPL
Source: http://www.lb.shuttle.de/puffin/cbm4linux/%{name}-%{ver}.tar.gz
Buildroot: /var/tmp/%{name}
Url: http://www.lb.shuttle.de/puffin/cbm4linux

Group: Applications/System

%description
The cbm4linux package is a linux kernel module and a few user space support
programs to control and use serial devices as used by most Commodore (CBM)
8-bit machines, such as disk drives and printers from your trusty C64.
A fast .d64 transfer program is included.

%prep
%setup

%build
make

%install
rm -rf $RPM_BUILD_ROOT
make install PREFIX=$RPM_BUILD_ROOT/%{prefix} MODDIR=$RPM_BUILD_ROOT/"`for d in /lib/modules/\`uname -r\`/{misc,kernel/drivers/char}; do test -d $d && echo $d; done`"
make dev CBMDEV=$RPM_BUILD_ROOT/dev/cbm

%files
%defattr(-,root,root)
%doc README COPYING
%doc docs/*
%{prefix}/bin/*
%{prefix}/include/*
%{prefix}/info/*
%{prefix}/lib/*
%{prefix}/man/*
/lib/modules
/dev/cbm

%clean
rm -rf $RPM_BUILD_ROOT
