/*
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *  Copyright 1999 Michael Klein <michael.klein@puffin.lb.shuttle.de>
*/

#include "cbm4linux.h"
#include "d64copy.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

static int drive = 0;

static int read_block(int tr, int se, char *block)
{
    char cmd[48];
    int rv = 1;

    sprintf(cmd, "U1:2 0 %d %d", tr, se);
    if(cbm_exec_command(fd_cbm, drive, cmd, 0) == 0) {
        rv = cbm_device_status(fd_cbm, drive, cmd, sizeof(cmd));
        if(rv == 0) {
            if(cbm_exec_command(fd_cbm, drive, "B-P2 0", 0) == 0) {
                if(cbm_talk(fd_cbm, drive, 2) == 0) {
                    rv = read(fd_cbm, block, BLOCKSIZE) != BLOCKSIZE;
                    cbm_untalk(fd_cbm);
                }
            }
        }
    }
    return rv;
}

static int write_block(int tr, int se, char *block, int size)
{
    char cmd[48];
    int  rv = 1;

    if(cbm_exec_command(fd_cbm, drive, "B-P2 0", 0) == 0) {
        if(cbm_listen(fd_cbm, drive, 2) == 0) {
            rv = write(fd_cbm, block, size) != size;
            cbm_unlisten(fd_cbm);
            if(rv == 0) {
                sprintf(cmd ,"U2:2 0 %d %d", tr, se);
                cbm_exec_command(fd_cbm, drive, cmd, 0);
                rv = cbm_device_status(fd_cbm, drive, cmd, sizeof(cmd));
            }
        }
    }
    return rv;
}

static int open_disk(char *drv, int for_writing, int ext, turbo_start start)
{
    char buf[48];
    int rv;

    if(ext) {
        fprintf(stderr, "standard transfer doesn't handle 40 track images\n");
        return 99;
    }

    drive = atoi(drv);

    cbm_open(fd_cbm, drive, 2);
    write(fd_cbm, "#", 1);
    cbm_unlisten(fd_cbm);

    rv = cbm_device_status(fd_cbm, drive, buf, sizeof(buf));
    if(rv) {
        fprintf(stderr, "drive %02d: %s\n", drive, buf);
    }
    return rv;
}

static void close_disk(void)
{
    cbm_close(fd_cbm, drive, 2);
}

DECLARE_TRANSFER_FUNCS(std_transfer, 1, 0);
