/*
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *  Copyright 1999 Michael Klein <michael.klein@puffin.lb.shuttle.de>
*/

#ifndef _CBM_MODULE_H
#define _CBM_MODULE_H

#include <linux/ioctl.h>
#include <linux/types.h>

#define CBMCTRL_BASE	0xcb

#define CBMCTRL_TALK	    _IOW(CBMCTRL_BASE, 0, void)
#define CBMCTRL_LISTEN	    _IOW(CBMCTRL_BASE, 1, void)
#define CBMCTRL_UNTALK      _IO (CBMCTRL_BASE, 2)
#define CBMCTRL_UNLISTEN    _IO (CBMCTRL_BASE, 3)
#define CBMCTRL_OPEN        _IOW(CBMCTRL_BASE, 4, void)
#define CBMCTRL_CLOSE       _IOW(CBMCTRL_BASE, 5, void)
#define CBMCTRL_RESET       _IO (CBMCTRL_BASE, 6)
#define CBMCTRL_GET_EOI     _IO (CBMCTRL_BASE, 7)

#define CBMCTRL_PP_READ     _IO (CBMCTRL_BASE, 10)
#define CBMCTRL_PP_WRITE    _IOW(CBMCTRL_BASE, 11, void)
#define CBMCTRL_IEC_POLL    _IO (CBMCTRL_BASE, 12)
#define CBMCTRL_IEC_SET     _IOW(CBMCTRL_BASE, 13, void)
#define CBMCTRL_IEC_RELEASE _IOW(CBMCTRL_BASE, 14, void)
#define CBMCTRL_IEC_WAIT    _IOW(CBMCTRL_BASE, 15, void)

#endif
