/* RWDOCS */
/* Stuff generic to all Ethernet controllers */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "timer.h"
#include "arp.h"
#include "enet.h"

char ether_bdcst[] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };

/* RWDOCE */
extern int memok();
/* RWDOCS */
/* Convert Ethernet header in host form to network mbuf */
struct mbuf *
htonether(ether,data)
struct ether *ether;
struct mbuf *data;
{

/* RWDOCE */
	struct mbuf *bp;
	register char *cp;

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	if((bp = pushdown(data,ETHERLEN)) == NULLBUF)
		return NULLBUF;

	cp = bp->data;

	memcpy(cp,ether->dest,EADDR_LEN);
	cp += EADDR_LEN;
	memcpy(cp,ether->source,EADDR_LEN);
	cp += EADDR_LEN;
	put16(cp,ether->type);

	if( (memok()) == 0 ) { printf( "%s: L.%d arena corrupt\n", 
		__FILE__, __LINE__  ); fflush(stdout); }
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

	return bp;
}
/* Extract Ethernet header */
int ntohether(ether,bpp)
struct ether *ether;
struct mbuf **bpp;
{
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	pullup(bpp,ether->dest,EADDR_LEN);
	pullup(bpp,ether->source,EADDR_LEN);
	ether->type = pull16(bpp);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return ETHERLEN;
}
/* RWDOCS */
/* Format an Ethernet address into a printable ascii string */
int pether(out,addr)
char *out,*addr;
{

/* RWDOCE */
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	sprintf(out,"%02x:%02x:%02x:%02x:%02x:%02x",
		(addr[0] & 0xff ),(addr[1] & 0xff ),
		(addr[2] & 0xff ),(addr[3] & 0xff ),
		(addr[4] & 0xff ),(addr[5] & 0xff ) );

	if( (memok()) == 0 ) { printf( "%s: L.%d arena corrupt\n", 
		__FILE__, __LINE__  ); fflush(stdout); }

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return 0;
}

/* RWDOCS */
/* Convert an Ethernet address from Hex/ASCII to binary */
int gether(out,cp)
register char *out;
register char *cp;
{

/* RWDOCE */
	register int i;
	int htoi();
	char * index();
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	for(i=6; i!=0; i--){
		*out++ = htoi(cp);
		if((cp = index(cp,':')) == NULLCHAR)	/* Find delimiter */
			break;
		cp++;			/* and skip over it */
	}

	if( (memok()) == 0 ) { printf( "%s: L.%d arena corrupt\n", 
		__FILE__, __LINE__  ); fflush(stdout); }
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return 0;
}
/* RWDOCS */
/* Version of gether for ARP, matches passed args */
int gaether(out,in,cnt)
char *out;
char *in[];
int cnt;
{

/* RWDOCE */
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	cnt=cnt;
	gether(out,in[0]);
	return 0;
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

}
/* RWDOCS */
/* Send an IP datagram on Ethernet */
int
enet_send(bp,interface,gateway,precedence,delay,throughput,reliability)
struct mbuf *bp;		/* Buffer to send */
struct interface *interface;	/* Pointer to interface control block */
int32 gateway;			/* IP address of next hop */
char precedence;
char delay;
char throughput;
char reliability;
{
	char *egate,*res_arp();
	precedence=precedence;delay=delay;throughput=throughput;reliability=reliability;

/* RWDOCE */
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	egate = res_arp(interface,ARP_ETHER,gateway,bp);

	if( (memok()) == 0 ) { printf( "%s: L.%d arena corrupt\n", 
		__FILE__, __LINE__  ); fflush(stdout); }

	if(egate != NULLCHAR)
		{
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

		return (*interface->output)(interface,egate,interface->hwaddr,IP_TYPE,bp);
		}
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

	return 0;
}
/* RWDOCS */
/* Send a packet with Ethernet header */
int
enet_output(interface,dest,source,type,data)
struct interface *interface;		/* Pointer to interface control block */
char dest[];		/* Destination Ethernet address */
char source[];		/* Source Ethernet address */
int16 type;		/* Type field */
struct mbuf *data;	/* Data field */
{

/* RWDOCE */
	struct ether ep;
	struct mbuf *bp;
	int n;

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

	memcpy(ep.dest,dest,EADDR_LEN);

	memcpy(ep.source,source,EADDR_LEN);
	ep.type = type;

	if( (memok()) == 0 ) { printf( "%s: L.%d arena corrupt\n", 
		__FILE__, __LINE__  ); fflush(stdout); }

	if((bp = htonether(&ep,data)) == NULLBUF){
	printf( "nullbuffer in enet\n" ); fflush(stdout);
		free_p(data);
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
		return -1;
	}

		/* send the packet */
	n = (*interface->raw)(interface,bp);

	if( (memok()) == 0 ) { printf( "%s: L.%d arena corrupt\n", 
		__FILE__, __LINE__  ); fflush(stdout); }

#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	return(n);

}
/* RWDOCS */
/* Process incoming Ethernet packets. Shared by all ethernet drivers. */
void
eproc(interface,bp)
struct interface *interface;
struct mbuf *bp;
{

/* RWDOCE */
	struct ether hdr;
	char multicast;
	void arp_input(), ip_route();
	
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif
	/* Remove Ethernet header and kick packet upstairs */
	ntohether(&hdr,&bp);
	if(hdr.dest[0] & 1)
		multicast = 1;
	else
		multicast = 0;

	if( (memok()) == 0 ) { printf( "%s: L.%d arena corrupt\n", 
		__FILE__, __LINE__  ); fflush(stdout); }

	switch(hdr.type){
	case ARP_TYPE:

		arp_input(interface,bp);
		break;
	case IP_TYPE:

		ip_route(bp,multicast);
		break;
	default:

		free_p(bp);
		break;
	}

	if( (memok()) == 0 ) { printf( "%s: L.%d arena corrupt\n", 
		__FILE__, __LINE__  ); fflush(stdout); }
#ifdef COHPROF
profile(__LINE__,__FILE__);
#endif

}

