/* RWDOCS */
#ifndef SLIP_H
#define SLIP_H

/* filename	: slip.h 
 * purpose	: SLIP definitions 
 *
 */

#define	SLIP_ALLOC	40	/* Receiver allocation increment */

#define	FR_END		0300	/* Frame End */
#define	FR_ESC		0333	/* Frame Escape */
#define	T_FR_END	0334	/* Transposed frame end */
#define	T_FR_ESC	0335	/* Transposed frame escape */

/* Slip protocol control structure */
struct slip {
	struct mbuf *sndq;	/* Encapsulated packets awaiting transmission */
	int32 sndcnt;		/* Number of datagrams on queue */
	int32 escaped;		/* Receiver State control flag */
	struct mbuf *rbp;	/* Head of mbuf chain being filled */
	struct mbuf *rbp1;	/* Pointer to mbuf currently being written */
	char *rcp;		/* Write pointer */
	int32 rcnt;		/* Length of mbuf chain */
	struct mbuf *tbp;	/* Transmit mbuf being sent */
	int32 errors;		/* Receiver input errors */
	void (*recv)();		/* Function to call with an incoming buffer */
};

extern struct slip slip[];

#endif /*  SLIP_H */
/* end of slip.h */
/* RWDOCS */
